/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.typing.types;

import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.time.format.FormatStyle;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DateTime {
    private static final Logger LOG = Logger.getLogger(DateTime.class.getName());
    public static final String TIME_FORMAT_STRING = "HH:mm:ss.SSS";
    public static final String DATETIME_FORMAT_STRING_DEFAULT = "yyyy-MM-dd HH:mm:ss.SSS Z";
    public static final String DATETIME_FORMAT_STRING_DEFAULT2 = "yyyy-MM-dd HH:mm:ss.SSS z";
    public static final String DATETIME_FORMAT_STRING_WITH_TIME_ZONE_OFFSET = "yyyy-MM-dd HH:mm:ssXXX";
    public static final String DATETIME_FORMAT_STRING_WITHOUT_TIME_ZONE_OFFSET = "yyyy-MM-dd HH:mm:ss.SSS";
    public static final String DATETIME_FORMAT_STRING_RFC3339 = "yyyy-MM-dd'T'HH:mm:ss.SSSX";
    public static final String SIMPLE_DATE_FORMAT_STRING = "yyyy-MM-dd HH:mm:ss.S Z";
    public static final String SIMPLE_DATE_FORMAT_STRING2 = "yyyy-MM-dd HH:mm:ss.SS Z";
    static final List<String> POSSIBLE_FORMATS = new ArrayList<String>(Arrays.asList("yyyy-MM-dd HH:mm:ss.SSS Z", "yyyy-MM-dd HH:mm:ss.SSS z", "yyyy-MM-dd HH:mm:ssXXX", "yyyy-MM-dd'T'HH:mm:ss.SSSX", "yyyy-MM-dd HH:mm:ss.S Z", "yyyy-MM-dd HH:mm:ss.SS Z"));
    static final List<String> POSSIBLE_FORMATS_WITHOUT_TIME_ZONE = new ArrayList<String>(Arrays.asList("yyyy-MM-dd HH:mm:ss.SSS"));
    private ZonedDateTime _date;

    public DateTime() {
        this._date = ZonedDateTime.now();
    }

    public DateTime(Date date) {
        this._date = ZonedDateTime.ofInstant(date.toInstant(), ZoneId.systemDefault());
    }

    public DateTime(ZonedDateTime date) {
        this._date = date;
    }

    public DateTime(long ticks) {
        this(ZonedDateTime.ofInstant(Instant.ofEpochMilli(ticks), ZoneId.systemDefault()));
    }

    public Date getDate() {
        return Date.from(this._date.toInstant());
    }

    public ZonedDateTime getZonedDateTime() {
        return this._date;
    }

    public void setDate(Date date) {
        this._date = ZonedDateTime.ofInstant(date.toInstant(), ZoneId.systemDefault());
    }

    public long getTime() {
        return this._date.toInstant().toEpochMilli();
    }

    public String toString() {
        return this.getZonedDateTime().format(DateTime.getDefaultFormatter());
    }

    public String toRFC3339String() {
        return DateTime.getRFC3339Format().format(this._date.withZoneSameInstant(ZoneId.of("UTC")));
    }

    public String toLocalString() {
        DateTimeFormatter formatter = DateTimeFormatter.ofLocalizedDateTime(FormatStyle.SHORT).withLocale(Locale.getDefault());
        return this._date.format(formatter);
    }

    public static DateTimeFormatter getDefaultFormatter() {
        return DateTimeFormatter.ofPattern(DATETIME_FORMAT_STRING_DEFAULT);
    }

    public static DateTimeFormatter getFormatter(String format) {
        return DateTimeFormatter.ofPattern(format);
    }

    public static DateTimeFormatter getRFC3339Format() {
        return DateTimeFormatter.ofPattern(DATETIME_FORMAT_STRING_RFC3339);
    }

    public static DateTime parse(String text) {
        DateTimeFormatter df;
        ZonedDateTime date = null;
        for (String format : POSSIBLE_FORMATS) {
            try {
                df = DateTime.getFormatter(format);
                date = ZonedDateTime.parse(text, df);
                break;
            }
            catch (DateTimeParseException ex) {
                LOG.log(Level.FINEST, "Could not convert string {0} to DateTime with format {1}", new Object[]{text, format});
            }
        }
        if (date == null) {
            for (String format : POSSIBLE_FORMATS_WITHOUT_TIME_ZONE) {
                try {
                    df = DateTime.getFormatter(format);
                    date = ZonedDateTime.parse(text, df.withZone(TimeZone.getTimeZone("Zulu").toZoneId()));
                    break;
                }
                catch (DateTimeParseException ex) {
                    LOG.log(Level.FINEST, "Could not convert string {0} to DateTime with format {1}", new Object[]{text, format});
                }
            }
        }
        if (date == null) {
            try {
                long millis = Long.parseLong(text);
                date = ZonedDateTime.ofInstant(Instant.ofEpochMilli(millis), ZoneId.systemDefault());
            }
            catch (Exception millis) {
                // empty catch block
            }
        }
        if (date == null) {
            LOG.log(Level.WARNING, "Could not convert string {0} to DateTime", text);
        }
        DateTime dateTime = null;
        if (date != null) {
            dateTime = new DateTime(date);
        }
        return dateTime;
    }

    public int hashCode() {
        int hash = 7;
        hash = 37 * hash + (this._date != null ? this._date.hashCode() : 0);
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DateTime other = (DateTime)obj;
        return this._date == other._date || this._date != null && this._date.equals(other._date);
    }
}

