/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.ui.graph.nodes;

import com.paterva.maltego.core.EntityID;
import com.paterva.maltego.core.GraphID;
import com.paterva.maltego.graph.store.GraphStore;
import com.paterva.maltego.graph.store.GraphStoreRegistry;
import com.paterva.maltego.graph.store.data.GraphStoreException;
import com.paterva.maltego.graph.store.structure.GraphStructureReader;
import com.paterva.maltego.ui.graph.nodes.CopyToNewGraphAction;
import com.paterva.maltego.ui.graph.nodes.NewGraphOrTempStructureChanges;
import java.util.HashSet;
import java.util.Set;
import org.openide.util.Exceptions;

public class CopyToNewGraphWithNeighboursAction
extends CopyToNewGraphAction {
    private int _depth;
    private Family _family;

    public int getDepth() {
        return this._depth;
    }

    public void setDepth(int depth) {
        this._depth = depth;
    }

    public Family getFamily() {
        return this._family;
    }

    public void setFamily(Family family) {
        this._family = family;
    }

    public static String getFamilyName(Family family) {
        switch (family) {
            case CHILDREN: {
                return "Children";
            }
            case PARENTS: {
                return "Parents";
            }
            case BOTH: {
                return "Any";
            }
        }
        return null;
    }

    public String getName() {
        return "Copy with Neighbours";
    }

    @Override
    protected void performCopy(GraphID srcGraphID, GraphID destGraphID, Set<EntityID> entityIDs) {
        try {
            entityIDs = this.addNeighbours(srcGraphID, entityIDs);
            NewGraphOrTempStructureChanges.addWithLinks(srcGraphID, destGraphID, entityIDs, true);
        }
        catch (GraphStoreException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    private Set<EntityID> addNeighbours(GraphID srcGraphID, Set<EntityID> entityIDs) throws GraphStoreException {
        GraphStore graphStore = GraphStoreRegistry.getDefault().forGraphID(srcGraphID);
        GraphStructureReader structureReader = graphStore.getGraphStructureStore().getStructureReader();
        HashSet<EntityID> withNeighbours = new HashSet<EntityID>(entityIDs);
        HashSet<EntityID> neighbours = new HashSet<EntityID>(withNeighbours);
        for (int i = 0; i < this._depth; ++i) {
            HashSet<EntityID> newNeighbours = new HashSet<EntityID>();
            for (EntityID entityID : neighbours) {
                newNeighbours.addAll(this.getNeighbours(structureReader, entityID));
            }
            withNeighbours.addAll(newNeighbours);
            neighbours = newNeighbours;
        }
        return withNeighbours;
    }

    private Set<EntityID> getNeighbours(GraphStructureReader structureReader, EntityID entityID) throws GraphStoreException {
        HashSet neighbours;
        switch (this._family) {
            case CHILDREN: {
                neighbours = structureReader.getChildren(entityID);
                break;
            }
            case PARENTS: {
                neighbours = structureReader.getParents(entityID);
                break;
            }
            default: {
                neighbours = new HashSet(structureReader.getChildren(entityID));
                neighbours.addAll(structureReader.getParents(entityID));
            }
        }
        return neighbours;
    }

    public static enum Family {
        BOTH,
        CHILDREN,
        PARENTS;

    }
}

