/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.tabular.transforms.run;

import com.paterva.maltego.graph.table.io.TabularGraphFileImporter;
import com.paterva.maltego.graph.table.io.TabularGraphFileImporterFactory;
import com.paterva.maltego.transform.runner.api.TransformResult;
import com.paterva.maltego.transform.runner.api.TransformRunContext;
import com.paterva.maltego.transforms.tabular.data.TabularTransformSource;
import com.paterva.maltego.util.Args;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.openide.util.Exceptions;

public class TabularTransformImporterFactory {
    private static final Logger LOG = Logger.getLogger(TabularTransformImporterFactory.class.getName());
    private final TransformRunContext ctx;

    public TabularTransformImporterFactory(TransformRunContext ctx) {
        Args.notNull((Object)ctx, (String)"ctx");
        this.ctx = ctx;
    }

    public Map<TabularTransformSource, List<TabularGraphFileImporter>> getImporters(List<TabularTransformSource> sources) throws IOException {
        Args.notNullOrEmpty(sources, (String)"sources");
        Map<TabularTransformSource, List<File>> files = this.getFiles(sources);
        return this.getImporters(files);
    }

    private Map<TabularTransformSource, List<TabularGraphFileImporter>> getImporters(Map<TabularTransformSource, List<File>> files) {
        return files.entrySet().stream().collect(Collectors.toMap(entry -> (TabularTransformSource)entry.getKey(), entry -> this.getImportersForFiles((List)entry.getValue())));
    }

    private Map<TabularTransformSource, List<File>> getFiles(List<TabularTransformSource> sources) throws IOException {
        return sources.stream().collect(Collectors.toMap(Function.identity(), source -> this.listFiles((TabularTransformSource)source)));
    }

    private List<File> listFiles(TabularTransformSource source) {
        List fileStrings = source.getSourceFiles();
        LinkedHashSet files = new LinkedHashSet();
        for (String fileString : fileStrings) {
            LOG.log(Level.FINE, "File string: {0}", fileString);
            String basePath = this.getBasePath(fileString);
            LOG.log(Level.FINE, "   Base path: {0}", basePath);
            if (fileString.equals(basePath) || !basePath.endsWith("\\") && !basePath.endsWith("/")) {
                this.warn("Invalid wildcard file path: " + fileString);
                continue;
            }
            Path baseDir = Paths.get(basePath, new String[0]);
            if (baseDir == null || !Files.isDirectory(baseDir, new LinkOption[0])) {
                this.warn("Invalid base path: " + basePath);
                continue;
            }
            String glob = fileString.substring(basePath.length()).replace('\\', '/');
            LOG.log(Level.FINE, "Glob: {0}", glob);
            PathMatcher pathMatcher = FileSystems.getDefault().getPathMatcher("glob:" + glob);
            try {
                Files.walk(baseDir, new FileVisitOption[0]).filter(path -> {
                    LOG.log(Level.FINER, "   Path: {0}", path);
                    Path relativePath = baseDir.relativize((Path)path);
                    LOG.log(Level.FINER, "   Relative path: {0}", relativePath);
                    return Files.isRegularFile(path, new LinkOption[0]) && pathMatcher.matches(relativePath);
                }).peek(path -> LOG.log(Level.FINE, "   Matched file: {0}", path)).forEachOrdered(path -> files.add(path.toFile()));
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
        return new ArrayList<File>(files);
    }

    private List<TabularGraphFileImporter> getImportersForFiles(List<File> files) {
        return TabularGraphFileImporterFactory.createImporters(files);
    }

    private String getBasePath(String fileString) {
        return fileString.replaceFirst("^([^\\*]+[\\\\/]).*$", "$1");
    }

    private void warn(String msg) {
        this.ctx.getCallback().resultReceived(TransformResult.warning((String)msg));
    }
}

