/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.transform.manager.nodes;

import com.paterva.maltego.entity.api.EntityRegistry;
import com.paterva.maltego.entity.api.MaltegoEntitySpec;
import com.paterva.maltego.seeds.api.HubSeedDescriptor;
import com.paterva.maltego.seeds.api.HubSeedUrl;
import com.paterva.maltego.seeds.api.registry.HubSeedRegistry;
import com.paterva.maltego.seeds.api.registry.HubSeedSettings;
import com.paterva.maltego.transform.descriptor.Constraint;
import com.paterva.maltego.transform.descriptor.StatusItem;
import com.paterva.maltego.transform.descriptor.TransformDefinition;
import com.paterva.maltego.transform.descriptor.TransformDescriptor;
import com.paterva.maltego.transform.descriptor.TransformPropertyDescriptor;
import com.paterva.maltego.transform.descriptor.TransformServerInfo;
import com.paterva.maltego.transform.descriptor.TransformServerRegistry;
import com.paterva.maltego.transform.descriptor.TransformSettings;
import com.paterva.maltego.transform.manager.nodes.HubTransformPropertyProxy;
import com.paterva.maltego.transform.manager.nodes.TransformPropertyProxy;
import com.paterva.maltego.typing.DataSource;
import com.paterva.maltego.typing.DisplayDescriptor;
import com.paterva.maltego.typing.DisplayDescriptorCollection;
import com.paterva.maltego.typing.editing.UnsupportedEditorException;
import com.paterva.maltego.typing.editing.propertygrid.PropertySheetFactory;
import com.paterva.maltego.util.StringUtilities;
import com.paterva.maltego.util.ui.outline.NodePropertySupport;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import javax.swing.ImageIcon;
import org.openide.nodes.Node;
import org.openide.nodes.Sheet;
import org.openide.util.Exceptions;

public class TransformProperties {
    private static final ImageIcon EMPTY_ICON = new ImageIcon();

    private TransformProperties() {
    }

    public static void addTransformInputs(Sheet sheet, TransformDefinition def) {
        DisplayDescriptorCollection hubProps = HubSeedSettings.getDefault().getGlobalTransformProperties(def);
        Sheet.Set inputs = PropertySheetFactory.getSet((Sheet)sheet, (String)"inputs", (String)"Transform Inputs", (String)"Transform inputs are user parameters that are sent to the transform and control its behaviour.");
        for (DisplayDescriptor dd : def.getProperties()) {
            TransformPropertyDescriptor tpd = (TransformPropertyDescriptor)dd;
            try {
                if (hubProps.contains(dd.getName())) continue;
                PropertySheetFactory.getDefault().addProperty(sheet, (DisplayDescriptor)new TransformPropertyProxy(tpd, (TransformSettings)def), (DataSource)def, null, inputs);
            }
            catch (UnsupportedEditorException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
    }

    public static void addHubSettings(Sheet sheet, TransformDefinition def) {
        HubSeedSettings settings = HubSeedSettings.getDefault();
        List hubSeeds = HubSeedRegistry.getDefault().getHubSeeds((TransformDescriptor)def);
        for (HubSeedDescriptor hubSeed : hubSeeds) {
            HubSeedUrl url = hubSeed.getGrantedHubSeedUrls().isEmpty() ? null : (HubSeedUrl)hubSeed.getGrantedHubSeedUrls().get(0);
            String setName = url != null ? url.getUrl() : hubSeed.getName();
            String setDisplayName = hubSeed.getDisplayName() + " (Maltego Data Hub Settings)";
            String setDescription = "Global Transform Inputs that come from the Maltego Data Hub.";
            Sheet.Set inputs = PropertySheetFactory.getSet((Sheet)sheet, (String)setName, (String)setDisplayName, (String)setDescription);
            DisplayDescriptorCollection props = settings.getGlobalTransformProperties(hubSeed, def, false);
            for (DisplayDescriptor dd : props) {
                TransformPropertyDescriptor tpd = (TransformPropertyDescriptor)dd;
                try {
                    DataSource dataSource = settings.getGlobalTransformSettings(hubSeed);
                    PropertySheetFactory.getDefault().addProperty(sheet, (DisplayDescriptor)new HubTransformPropertyProxy(tpd, def, hubSeed), dataSource, null, inputs);
                }
                catch (UnsupportedEditorException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
        }
    }

    public static Node.Property description() {
        return new Description(Node.EMPTY);
    }

    public static Node.Property location() {
        return new Location(Node.EMPTY);
    }

    public static Node.Property defaultSet() {
        return new DefaultSets(Node.EMPTY);
    }

    public static Node.Property status() {
        return new Status(Node.EMPTY);
    }

    public static Node.Property inputConstraint() {
        return new InputConstraint(Node.EMPTY);
    }

    public static Node.Property output() {
        return new Output(Node.EMPTY);
    }

    public static Node.Property hubItems() {
        return new HubItems(Node.EMPTY);
    }

    private static String getEntityDisplayName(String typeName) {
        MaltegoEntitySpec spec = (MaltegoEntitySpec)EntityRegistry.getDefault().get(typeName);
        if (spec == null) {
            return typeName;
        }
        return spec.getDisplayName() + " [" + typeName + "]";
    }

    static class HubItems
    extends NodePropertySupport.ReadOnly<String> {
        public HubItems(Node node) {
            super(node, "maltego.tas.hubitems", String.class, "Maltego Data Hub Item", "The Maltego Data Hub items this TAS is associated with");
            this.setValue("suppressCustomEditor", Boolean.TRUE);
            this.setValue("nameIcon", EMPTY_ICON);
        }

        public String getValue() throws IllegalAccessException, InvocationTargetException {
            TransformServerInfo server = (TransformServerInfo)this.getLookup().lookup(TransformServerInfo.class);
            StringBuilder sb = new StringBuilder();
            for (HubSeedDescriptor hubSeed : HubSeedRegistry.getDefault().getHubSeeds(server)) {
                sb.append(hubSeed.getDisplayName());
                sb.append(", ");
            }
            if (sb.length() > 1) {
                return sb.substring(0, sb.length() - 2);
            }
            return "<none>";
        }
    }

    static class Status
    extends NodePropertySupport.ReadOnly<String> {
        public Status(Node node) {
            super(node, "status", String.class, "Status", "Indicates whether this component is fully functional.");
            this.setValue("suppressCustomEditor", Boolean.TRUE);
            this.setValue("nameIcon", EMPTY_ICON);
        }

        public String getValue() throws IllegalAccessException, InvocationTargetException {
            return ((StatusItem)this.getLookup().lookup(StatusItem.class)).getStatus().toString();
        }
    }

    static class Description
    extends NodePropertySupport.ReadOnly<String> {
        public Description(Node node) {
            super(node, "description", String.class, "Description", "Description");
            this.setValue("suppressCustomEditor", Boolean.TRUE);
            this.setValue("nameIcon", EMPTY_ICON);
        }

        public String getValue() throws IllegalAccessException, InvocationTargetException {
            String desc;
            TransformDefinition transform = (TransformDefinition)this.getLookup().lookup(TransformDefinition.class);
            String description = "";
            if (transform != null && (desc = transform.getDescription()) != null) {
                return desc;
            }
            return description;
        }

        public void setValue(String value) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
            ((StatusItem)this.getLookup().lookup(StatusItem.class)).setDescription(value);
        }
    }

    static class DefaultSets
    extends NodePropertySupport.ReadOnly<String> {
        public DefaultSets(Node node) {
            super(node, "maltego.transformcategory", String.class, "Default set", "The default set of the transform");
            this.setValue("suppressCustomEditor", Boolean.TRUE);
            this.setValue("nameIcon", EMPTY_ICON);
        }

        public String getValue() throws IllegalAccessException, InvocationTargetException {
            String[] categories = ((TransformDefinition)this.getLookup().lookup(TransformDefinition.class)).getDefaultSets();
            String value = StringUtilities.toCommaList((String[])categories);
            if (value.isEmpty()) {
                return "<none>";
            }
            return value;
        }

        public void setValue(String value) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
            String[] values = StringUtilities.fromCommaList((String)value);
            ((TransformDefinition)this.getLookup().lookup(TransformDefinition.class)).setDefaultSets(values);
        }
    }

    static class Location
    extends NodePropertySupport.ReadOnly<String> {
        public Location(Node node) {
            super(node, "maltego.transform.location", String.class, "Location", "The TAS or local machine on which this transform is executed");
            this.setValue("suppressCustomEditor", Boolean.TRUE);
            this.setValue("nameIcon", EMPTY_ICON);
        }

        public String getValue() throws IllegalAccessException, InvocationTargetException {
            TransformDefinition def = (TransformDefinition)this.getLookup().lookup(TransformDefinition.class);
            if ("Remote".equals(def.getRepositoryName())) {
                StringBuffer buffer = new StringBuffer();
                for (TransformServerInfo server : TransformServerRegistry.getDefault().findServers(def.getName(), false)) {
                    buffer.append(server.getDisplayName());
                    buffer.append(", ");
                }
                if (buffer.length() > 1) {
                    return buffer.substring(0, buffer.length() - 2);
                }
                return "<none>";
            }
            return def.getRepositoryName();
        }
    }

    static class Output
    extends NodePropertySupport.ReadOnly<String> {
        public Output(Node node) {
            super(node, "maltego.transform.output", String.class, "Output", "Types of entities returned by this transform");
            this.setValue("suppressCustomEditor", Boolean.TRUE);
            this.setValue("nameIcon", EMPTY_ICON);
        }

        public String getValue() throws IllegalAccessException, InvocationTargetException {
            TransformDefinition def = (TransformDefinition)this.getLookup().lookup(TransformDefinition.class);
            StringBuilder builder = new StringBuilder();
            HashSet<String> output = def.getOutputEntities();
            if (output.isEmpty()) {
                builder.append("Any");
            } else {
                String value;
                int i = 0;
                if (output.size() == 1 && (value = (String)output.iterator().next()).contains(",")) {
                    output = new HashSet<String>(Arrays.asList(value.split(",")));
                }
                for (String e : output) {
                    builder.append(TransformProperties.getEntityDisplayName(e.trim()));
                    if (i < output.size() - 1) {
                        builder.append(", ");
                    }
                    ++i;
                }
            }
            return builder.toString();
        }
    }

    public static class InputConstraint
    extends NodePropertySupport.ReadOnly<String> {
        public InputConstraint(Node node) {
            super(node, "maltego.transform.inputContraint", String.class, "Input", "The entities and properties on which this transform can be run");
            this.setValue("suppressCustomEditor", Boolean.TRUE);
            this.setValue("nameIcon", EMPTY_ICON);
        }

        public String getValue() throws IllegalAccessException, InvocationTargetException {
            TransformDefinition def = (TransformDefinition)this.getLookup().lookup(TransformDefinition.class);
            Constraint input = def.getInputConstraint();
            return TransformProperties.getEntityDisplayName(input.getDisplay());
        }
    }
}

