/*
 * Decompiled with CFR 0.152.
 */
package com.maltego.cloud.ui.cases;

import com.maltego.cloud.data.Case;
import com.maltego.cloud.ui.analytics.CreateNewCaseEvent;
import com.maltego.cloud.ui.analytics.FinishCreateNewCaseEvent;
import com.maltego.cloud.ui.cases.CaseTableModel;
import com.maltego.cloud.ui.cases.NewCaseAction;
import com.maltego.cloud.ui.cases.NewCasePanel;
import com.maltego.cloud.ui.cases.NewCaseSelection;
import com.paterva.maltego.util.ui.table.ETableColumnSelectionDecorator;
import com.paterva.maltego.util.ui.table.IconTextRenderer;
import com.paterva.maltego.util.ui.table.PaddedTableCellRenderer;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import org.netbeans.swing.etable.ETable;
import org.openide.util.NbBundle;

public class CaseSelectionUI
extends JPanel {
    private final CaseTableModel _model;
    private final List<Case> cases = new ArrayList<Case>();
    private final NewCaseAction newCaseAction;
    private JButton _newButton;
    private ETable _table;
    private JPanel casePanel;
    private JLabel jLabel1;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JPanel jPanel4;
    private JScrollPane jScrollPane1;
    private JProgressBar progressBar;
    private JPanel progressPanel;

    public CaseSelectionUI(Case[] caseList, NewCaseAction newCaseAction) {
        this.initComponents();
        this.newCaseAction = newCaseAction;
        this._newButton.setBackground(new JPanel().getBackground());
        if (caseList != null) {
            this.cases.addAll(Arrays.asList(caseList));
        }
        boolean showInbox = true;
        this._model = new CaseTableModel(this.cases, showInbox);
        this._table.setModel((TableModel)((Object)this._model));
        this._table.setRowHeight(this.getRowHeight());
        this._table.getSelectionModel().setSelectionMode(0);
        if (this._table.getRowCount() > 0) {
            int row = 0;
            boolean inboxFound = false;
            for (Case aCase : ((CaseTableModel)((Object)this._table.getModel())).getRows()) {
                if (showInbox && aCase.isInbox()) {
                    inboxFound = true;
                    break;
                }
                ++row;
            }
            if (!inboxFound || row >= this._table.getRowCount()) {
                row = 0;
            }
            this._table.getSelectionModel().setSelectionInterval(row, row);
            Rectangle cellRect = this._table.getCellRect(row, 0, true);
            this._table.scrollRectToVisible(cellRect);
        }
        this._table.getTableHeader().setReorderingAllowed(false);
        TableColumnModel columns = this._table.getColumnModel();
        TableColumn col1 = columns.getColumn(1);
        col1.setPreferredWidth(100);
        TableColumn col2 = columns.getColumn(2);
        col2.setPreferredWidth(80);
        ETableColumnSelectionDecorator selectionDecorator = new ETableColumnSelectionDecorator();
        selectionDecorator.makeSelectable(this._table, CaseTableModel.Columns, new boolean[]{true, true, true, true}, new String[]{null, null, null, null});
        this._table.getColumnModel().getColumn(0).setCellRenderer((TableCellRenderer)new IconTextRenderer());
        this._table.getColumnModel().getColumn(2).setCellRenderer((TableCellRenderer)new IconTextRenderer(true));
        PaddedTableCellRenderer paddedRenderer = new PaddedTableCellRenderer();
        this._table.setDefaultRenderer(String.class, (TableCellRenderer)paddedRenderer);
        this._table.setAutoCreateColumnsFromModel(false);
    }

    private int getRowHeight() {
        int fontHeight = this._table.getFontMetrics(this._table.getFont()).getHeight();
        int iconSize = 24;
        return Math.max(fontHeight + 8, iconSize + 4);
    }

    public CaseTableModel getModel() {
        return this._model;
    }

    public ETable getCaseTable() {
        return this._table;
    }

    public void setCases(Case[] caseList) {
        this.cases.clear();
        if (caseList != null) {
            this.cases.addAll(Arrays.asList(caseList));
        }
        this._model.setCases(this.cases);
    }

    private void initComponents() {
        this.casePanel = new JPanel();
        this.jPanel1 = new JPanel();
        this._newButton = new JButton();
        this.jPanel3 = new JPanel();
        this.jLabel1 = new JLabel();
        this.jPanel2 = new JPanel();
        this.jScrollPane1 = new JScrollPane();
        this._table = new CaseETable();
        this.jPanel4 = new JPanel();
        this.progressPanel = new JPanel();
        this.progressBar = new JProgressBar();
        this.setLayout(new CardLayout());
        this.casePanel.setLayout(new GridBagLayout());
        this.jPanel1.setLayout(new GridBagLayout());
        this._newButton.setIcon(new ImageIcon(this.getClass().getResource("/com/maltego/cloud/ui/cases/NewCase.png")));
        this._newButton.setToolTipText(NbBundle.getMessage(CaseSelectionUI.class, (String)"CaseSelectionUI._newButton.toolTipText"));
        this._newButton.setPreferredSize(new Dimension(23, 23));
        this._newButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CaseSelectionUI.this._newButtonActionPerformed(evt);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(10, 15, 10, 0);
        this.jPanel1.add((Component)this._newButton, gridBagConstraints);
        GroupLayout jPanel3Layout = new GroupLayout(this.jPanel3);
        this.jPanel3.setLayout(jPanel3Layout);
        jPanel3Layout.setHorizontalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 0, Short.MAX_VALUE));
        jPanel3Layout.setVerticalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 43, Short.MAX_VALUE));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        this.jPanel1.add((Component)this.jPanel3, gridBagConstraints);
        this.jLabel1.setText(NbBundle.getMessage(CaseSelectionUI.class, (String)"CaseSelectionUI.jLabel1.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        this.jPanel1.add((Component)this.jLabel1, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 13, 0, 13);
        this.casePanel.add((Component)this.jPanel1, gridBagConstraints);
        this.jPanel2.setPreferredSize(new Dimension(700, 200));
        this.jPanel2.setLayout(new BorderLayout());
        this.jScrollPane1.setBorder(null);
        this._table.setModel((TableModel)new DefaultTableModel(new Object[][]{{null, null, null, null}, {null, null, null, null}, {null, null, null, null}, {null, null, null, null}}, new String[]{"Title 1", "Title 2", "Title 3", "Title 4"}));
        this.jScrollPane1.setViewportView((Component)this._table);
        this.jPanel2.add((Component)this.jScrollPane1, "Center");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 13, 13, 13);
        this.casePanel.add((Component)this.jPanel2, gridBagConstraints);
        this.jPanel4.setPreferredSize(new Dimension(1, 1));
        GroupLayout jPanel4Layout = new GroupLayout(this.jPanel4);
        this.jPanel4.setLayout(jPanel4Layout);
        jPanel4Layout.setHorizontalGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 0, Short.MAX_VALUE));
        jPanel4Layout.setVerticalGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 205, Short.MAX_VALUE));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.casePanel.add((Component)this.jPanel4, gridBagConstraints);
        this.add((Component)this.casePanel, "caseList");
        this.progressBar.setIndeterminate(true);
        this.progressBar.setString(NbBundle.getMessage(CaseSelectionUI.class, (String)"CaseSelectionUI.progressBar.string"));
        this.progressBar.setStringPainted(true);
        GroupLayout progressPanelLayout = new GroupLayout(this.progressPanel);
        this.progressPanel.setLayout(progressPanelLayout);
        progressPanelLayout.setHorizontalGroup(progressPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(progressPanelLayout.createSequentialGroup().addGap(25, 25, 25).addComponent(this.progressBar, -1, 656, Short.MAX_VALUE).addGap(25, 25, 25)));
        progressPanelLayout.setVerticalGroup(progressPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(progressPanelLayout.createSequentialGroup().addContainerGap(134, Short.MAX_VALUE).addComponent(this.progressBar, -2, -1, -2).addContainerGap(134, Short.MAX_VALUE)));
        this.add((Component)this.progressPanel, "progress");
    }

    private void _newButtonActionPerformed(ActionEvent evt) {
        CreateNewCaseEvent.send();
        String[] existingCases = this.cases.stream().map(c -> c.getName()).collect(Collectors.toList()).toArray(new String[0]);
        NewCaseSelection selection = NewCasePanel.show(existingCases);
        if (selection != null) {
            CardLayout layout = (CardLayout)this.getLayout();
            layout.show(this, "progress");
            this.newCaseAction.actionPerformed(selection, () -> {
                FinishCreateNewCaseEvent.send(selection.isEncrypted());
                layout.show(this, "caseList");
            });
        }
    }

    private static class CaseETable
    extends ETable {
        private CaseETable() {
        }

        protected boolean acceptByQuickFilter(TableModel model, int row) {
            int quickFilterColumn = this.getQuickFilterColumn();
            Object quickFilterObject = this.getQuickFilterObject();
            if (quickFilterColumn == -1 || quickFilterObject == null) {
                return true;
            }
            Object value = model.getValueAt(row, quickFilterColumn);
            if ((value = this.transformValue(value)) == null) {
                return false;
            }
            return value.equals(quickFilterObject);
        }
    }
}

