.\" dpkg manual page - dpkg-source(1)
.\"
.\" Copyright © 1995-1996 Ian Jackson <ijackson@chiark.greenend.org.uk>
.\" Copyright © 2000 Wichert Akkerman <wakkerma@debian.org>
.\" Copyright © 2006-2007 Frank Lichtenheld <djpig@debian.org>
.\" Copyright © 2006-2015 Guillem Jover <guillem@debian.org>
.\" Copyright © 2008-2011 Raphaël Hertzog <hertzog@debian.org>
.\" Copyright © 2010 Joey Hess <joeyh@debian.org>
.\"
.\" This is free software; you can redistribute it and/or modify
.\" it under the terms of the GNU General Public License as published by
.\" the Free Software Foundation; either version 2 of the License, or
.\" (at your option) any later version.
.\"
.\" This is distributed in the hope that it will be useful,
.\" but WITHOUT ANY WARRANTY; without even the implied warranty of
.\" MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
.\" GNU General Public License for more details.
.\"
.\" You should have received a copy of the GNU General Public License
.\" along with this program.  If not, see <https://www.gnu.org/licenses/>.
.
.\"*******************************************************************
.\"
.\" This file was generated with po4a. Translate the source file.
.\"
.\"*******************************************************************
.TH dpkg\-source 1 %RELEASE_DATE% %VERSION% dpkg\-suite
.nh
.SH NAAM
dpkg\-source \- gereedschap voor het manipuleren van een Debian broncodepakket
(.dsc)
.
.SH OVERZICHT
\fBdpkg\-source\fP [\fIoptie\fP...] \fIcommando\fP
.
.SH BESCHRIJVING
\fBdpkg\-source\fP pakt Debian broncodearchieven in en uit.

Bij geen enkel van deze commando's is het toegelaten om meerdere opties tot
één enkele optie te combineren of de waarde van een optie via een apart
argument op te geven.
.
.SH COMMANDO'S
.TP 
\fB\-x\fP, \fB\-\-extract\fP \fIbestandsnaam\fP.dsc [\fIuitvoermap\fP]
Extraheer een broncodepakket (\fB\-\-extract\fP sinds dpkg 1.17.14). Er moet één
argument dat geen optie is, opgegeven worden, namelijk de naam van het
controlebestand (\fB.dsc\fP) van de Debian broncode. Facultatief kan een tweede
argument dat geen optie is, opgegeven worden om de map op te geven waarin
het pakket geëxtraheerd moet worden. Die mag nog niet bestaan. Indien geen
uitvoermap opgegeven werd, zal het broncodepakket uitgepakt worden in een
map met als naam \fIbroncode\fP\-\fIversie\fP, die onder de huidige werkmap ligt.

\fBdpkg\-source\fP zal uit het controlebestand de namen van de andere bestanden
lezen die samen het broncodepakket vormen. Er wordt van uitgegaan dat ze
zich in dezelfde map bevinden als het \fB.dsc\fP\-bestand.

De permissies en het eigenaarschap van de bestanden uit het geëxtraheerde
pakket zullen zodanig ingesteld worden dat ze beantwoorden aan wat men zou
mogen verwachten mochten de bestanden en mappen gewoon aangemaakt zijn \-
mappen en uitvoerbare bestanden zullen 0777 zijn en gewone bestanden 0666 en
beide zullen aangepast worden op basis van het umask van degene die het
pakket uitpakt. Indien de bovenliggende map setgid is, zullen de
geëxtraheerde mappen dat ook zijn en al de bestanden en mappen zullen dit
groepseigenaarschap overerven.

Indien het broncodepakket een niet\-standaardindeling gebruikt (momenteel
betekent dit alle indelingen behalve “1.0”), dan zal de naam ervan
opgeslagen worden in \fBdebian/source/format\fP, zodat standaard deze indeling
gebruikt wordt bij de volgende malen dat het broncodepakket gebouwd wordt.

.TP 
\fB\-b\fP, \fB\-\-build\fP \fImap\fP [\fIindelingsspecifieke\-parameters\fP]
Bouw een broncodepakket (\fB\-\-build\fP sinds dpkg 1.17.14). Het eerste argument
dat geen optie is, wordt gebruikt als de naam van de map die de voor Debian
gereedgemaakte broncodeboom bevat (d.w.z. met een onderliggende map debian
en eventuele veranderingen aan de originele bestanden). Afhankelijk van de
broncodepakketindeling die men gebruikt om het broncodepakket te bouwen,
kunnen bijkomende parameters opgegeven worden.

\fBdpkg\-source\fP zal het broncodepakket bouwen volgens de eerste indeling die
gevonden wordt in de hierna volgende geordende lijst: de indeling opgegeven
met de commandoregeloptie \fI\-\-format\fP, de indeling aangegeven in
\fBdebian/source/format\fP, “1.0”. Het terugvallen op “1.0” word afgeschaft en
zal op een bepaald moment in de toekomst weggelaten worden. U zou de
gewenste broncode\-indeling steeds moeten documenteren in
\fBdebian/source/format\fP. Zie het onderdeel \fBINDELINGEN VAN
BRONCODEPAKKETTEN\fP voor een uitgebreide beschrijving van de verschillende
indelingen voor broncodepakketten.

.TP 
\fB\-\-print\-format\fP \fImap\fP
Geef weer welke indeling gebruikt zou worden om het broncodepakket te bouwen
indien \fBdpkg\-source \-\-build \fP\fImap\fP aangeroepen werd (in dezelfde condities
en met dezelfde parameters; sinds dpkg 1.15.5).

.TP 
\fB\-\-before\-build\fP \fImap\fP
Voer de overeenkomstige uitbreiding (hook) uit van de broncodepakketindeling
(sinds dpkg 1.15.8). Deze uitbreiding wordt telkens aangeroepen voor het
pakket gebouwd wordt (\fBdpkg\-buildpackage\fP roept ze zeer vroeg aan, zelfs
voor \fBdebian/rules clean\fP). Dit commando is idempotent en kan meermaals
aangeroepen worden. Niet alle broncode\-indelingen implementeren iets in deze
uitbreiding, en die welke dat wel doen bereiden gewoonlijk de broncodeboom
voor op het bouwproces, bijvoorbeeld door ervoor te zorgen dat de
Debian\-patches toegepast worden.

.TP 
\fB\-\-after\-build\fP \fImap\fP
Voer de overeenkomstige uitbreiding (hook) uit van de broncodepakketindeling
(sinds dpkg 1.15.8). Deze uitbreiding wordt telkens aangeroepen nadat het
pakket gebouwd werd (\fBdpkg\-buildpackage\fP roept ze als laatste aan). Dit
commando is idempotent en kan meermaals aangeroepen worden. Niet alle
broncode\-indelingen implementeren iets in deze uitbreiding, en die welke dat
wel doen gebruiken ze gewoonlijk om ongedaan te maken wat \fB\-\-before\-build\fP
gedaan heeft.

.TP 
\fB\-\-commit\fP [\fImap\fP] ...
Tekent veranderingen op in de broncodeboom die in \fImap\fP uitgepakt werd
(sinds dpkg 1.16.1). Aan dit commando kunnen afhankelijk van de
broncode\-indeling bijkomende parameters opgegeven worden. Het zal een
foutmelding geven bij indelingen waarvoor deze operatie geen betekenis
heeft.

.TP 
\fB\-?\fP, \fB\-\-help\fP
Toon de gebruiksaanwijzing en sluit af. Met de optie \fB\-\-format\fP kunnen de
indelingsspecifieke bouw\- en extractie\-opties getoond worden.
.TP 
\fB\-\-version\fP
Toon de versie en sluit af.
.
.SH OPTIES
.SS "Generieke bouwopties"
.TP 
\fB\-c\fP\fIcontrolebestand\fP
Duidt aan wat het belangrijkste controlebestand van de broncode is waaruit
informatie gelezen moet worden. Standaard is dat \fBdebian/control\fP. Indien
het opgegeven wordt met een relatieve padnaam, dan wordt die geïnterpreteerd
te beginnen bij de basismap van de broncodeboom.
.TP 
\fB\-l\fP\fIchangelog\-bestand\fP
Duidt het changelog\-bestand aan waaruit informatie gelezen moet
worden. Standaard is dat \fBdebian/changelog\fP. Indien het opgegeven wordt met
een relatieve padnaam, dan wordt die geïnterpreteerd te beginnen bij de
basismap van de broncodeboom.
.TP 
\fB\-F\fP\fIchangelog\-indeling\fP
Geeft de indeling van het bestand changelog aan. Zie
\fBdpkg\-parsechangelog\fP(1) voor informatie over alternatieve indelingen.
.TP 
\fB\-\-format=\fP\fIwaarde\fP
Gebruik de opgegeven indeling om het broncodepakket te bouwen (sinds dpkg
1.14.17). Het vervangt een eventuele in \fBdebian/source/format\fP opgegeven
indeling.
.TP 
\fB\-V\fP\fInaam\fP\fB=\fP\fIwaarde\fP
Stel een uitvoersubstitutievariabele in. Zie \fBdeb\-substvars\fP(5) voor een
bespreking van uitvoersubstitutie.
.TP 
\fB\-T\fP\fIsubstvars\-bestand\fP
Lees substitutievariabelen uit \fIsubstvars\-bestand\fP. De standaard is om geen
enkel bestand te lezen. Deze optie kan meermaals gebruikt worden om uit
verschillende bestanden substitutievariabelen te lezen (sinds dpkg 1.15.6).
.TP 
\fB\-D\fP\fIveld\fP\fB=\fP\fIwaarde\fP
Vervang in de uitvoer een veld uit het controlebestand of voeg er een toe.
.TP 
\fB\-U\fP\fIveld\fP
Verwijder in de uitvoer een veld uit het controlebestand.
.TP 
\fB\-Z\fP\fIcompressie\fP, \fB\-\-compression\fP=\fIcompressie\fP
Duidt het compressieniveau aan dat gebruikt wordt bij het maken van
tar\-archieven en diff\-bestanden (\fB\-\-compression\fP sinds dpkg 1.15.5). Merk
op dat deze optie niet tot effect heeft dat bestaande tar\-archieven opnieuw
gecomprimeerd worden. Ze heeft enkel invloed op nieuwe
bestanden. Ondersteunde waarden zijn: \fIgzip\fP, \fIbzip2\fP, \fIlzma\fP en
\fIxz\fP. De standaardwaarde is \fIxz\fP voor de indeling 2.0 en recentere
indelingen en \fIgzip\fP voor de indeling 1.0. \fIxz\fP wordt enkel sinds dpkg
1.15.5 ondersteund.
.TP 
\fB\-z\fP\fIniveau\fP, \fB\-\-compression\-level\fP=\fIniveau\fP
Het te gebruiken compressieniveau (\fB\-\-compression\-level\fP sinds dpkg
1.15.5). Zoals dit het geval is bij \fB\-Z\fP, beïnvloedt dit enkel nieuw
aangemaakte bestanden. Ondersteunde waarden zijn: \fI1\fP tot \fI9\fP, \fIbest\fP, en
\fIfast\fP. De standaardwaarde is \fI9\fP voor gzip en bzip2, \fI6\fP voor xz en
lzma.
.TP 
\fB\-i\fP[\fIregex\fP], \fB\-\-diff\-ignore\fP[=\fIregex\fP]
U kunt een perl reguliere expressie opgeven om bestanden die ermee
overeenkomen weg te houden uit de lijst bestanden waarover de gemaakte diff
(overzicht van ondergane wijzigingen) gaat (\fB\-\-diff\-ignore\fP sinds dpkg
1.15.6). (Deze lijst wordt gegenereerd door een find\-opdracht.) (Als het
broncodepakket gebouwd wordt als een versie 3 broncodepakket dat gebruik
maakt van een VCS (Version Control System \- versiebeheersysteem), kan dit
gebruikt worden om niet\-toegepaste wijzigingen aan specifieke bestanden te
laten negeren. Door \-i.* te gebruiken zullen ze allemaal genegeerd worden.)

De optie \fB\-i\fP zelf schakelt deze instelling in met een standaard reguliere
expressie (met behoud van eventuele wijzigingen aan de standaard reguliere
expressie onder invloed van een eerder gebruikt \fB\-\-extend\-diff\-ignore\fP) die
zorgt voor het uitfilteren van controlebestanden en \-mappen van de meest
courante versiebeheersystemen, van back\-upbestanden en wisselbestanden en
van bouwuitvoermappen van Libtool. Er kan slechts één reguliere expressie
actief zijn. Van meerdere \fB\-i\fP\-opties zal enkel de laatste uitwerking
hebben.

Dit is erg bruikbaar voor het wegknippen van vreemde bestanden die mee
opgenomen geraken in de diff, bijvoorbeeld als u de broncode onderhoudt in
een versiebeheersysteem en een werkkopie (checkout) wilt gebruiken om een
broncodepakket te bouwen, zonder dat daarin ook de extra bestanden en mappen
die ze meestal bevat (bijvoorbeeld CVS/, .cvsignore, .svn/), mee opgenomen
worden. De standaard reguliere expressie is reeds zeer exhaustief, maar
indien u ze moet vervangen, moet u ermee rekening houden dat ze standaard
een overeenkomst kan opleveren met elk onderdeel van een pad. Indien u dus
een overeenkomst zoekt met het begin van een bestandsnaam of enkel met
volledige bestandsnamen, zult u zelf de nodige ankers (bijvoorbeeld ‘(^|/)’,
‘($|/)’) moeten opgeven.
.TP 
\fB\-\-extend\-diff\-ignore\fP=\fIregex\fP
De opgegeven perl reguliere expressie breidt de standaardwaarde die door
\fB\-\-diff\-ignore\fP gebruikt wordt, uit en de huidige waarde ervan als die
ingesteld werd (sinds dpkg 1.15.6). Het doet dit door “\fB|\fP\fIregex\fP” samen
te voegen met de bestaande waarde. Deze optie is handig om te gebruiken in
\fBdebian/source/options\fP om bepaalde automatisch gegenereerde bestanden uit
te sluiten bij het automatisch genereren van patches.
.TP 
\fB\-I\fP[\fIbestandspatroon\fP], \fB\-\-tar\-ignore\fP[=\fIbestandspatroon\fP]
Indien deze optie opgegeven werd, wordt het patroon doorgegeven aan de optie
\fB\-\-exclude\fP van \fBtar\fP(1) wanneer dit commando ingeroepen wordt om een
bestand .orig.tar of .tar aan te maken (\fB\-\-tar\-ignore\fP sinds dpkg
1.15.6). Bijvoorbeeld, \fB\-I\fPCVS zal tar CVS\-mappen doen overslaan bij het
genereren van een .tar.gz\-bestand. Deze optie kan meermaals herhaald worden
om meerdere patronen die uitgesloten moeten worden op te sommen.

\fB\-I\fP zelf voegt standaard \fB\-\-exclude\fP\-opties toe die zorgen voor het
uitfilteren van controlebestanden en \-mappen van de meest courante
versiebeheersystemen, van back\-upbestanden en wisselbestanden en van
bouwuitvoermappen van Libtool.
.PP
\fBOpmerking:\fP hoewel zij vergelijkbare bedoelingen hebben, hebben \fB\-i\fP en
\fB\-I\fP een heel verschillende syntaxis en semantiek. \fB\-i\fP kan slechts
eenmaal opgegeven worden en verwacht een reguliere expressie die
perl\-compatibel is en die vergeleken wordt met het volledige relatieve pad
van elk bestand. \fB\-I\fP kan meermaals opgegeven worden en verwacht een
bestandsnaampatroon met shell\-jokertekens. Het patroon wordt toegepast op
het volledige relatieve pad maar ook op elk individueel onderdeel van het
pad. De exacte semantiek van de optie \fB\-\-exclude\fP van tar is enigszins
gecompliceerd. Zie voor een volledige documentatie
https://www.gnu.org/software/tar/manual/tar.html#wildcards.

De standaard reguliere expressies en patronen voor beide opties zijn te zien
in de uitvoer van het commando \fB\-\-help\fP.
.SS "Generieke extractieopties"
.TP 
\fB\-\-no\-copy\fP
Kopieer de originele tar\-archieven bij het geëxtraheerde broncodepakket niet
(sinds dpkg 1.14.17).
.TP 
\fB\-\-no\-check\fP
Controleer voor het uitpakken geen ondertekeningen en controlesommen (sinds
dpkg 1.14.17).
.TP 
\fB\-\-no\-overwrite\-dir\fP
Overschrijf de extractiemap niet als ze al bestaat (sinds dpkg 1.18.8).
.TP 
\fB\-\-require\-valid\-signature\fP
Weiger het broncodepakket uit te pakken als het geen OpenPGP\-ondertekening
bevat die kan gecontroleerd worden (sinds dpkg 1.15.0) met ofwel de
\fItrustedkeys.gpg\fP\-sleutelbos van de gebruiker, één van de
leveranciersspecifieke sleutelbossen of met één van de officiële
sleutelbossen van Debian (\fI/usr/share/keyrings/debian\-keyring.gpg\fP en
\fI/usr/share/keyrings/debian\-maintainers.gpg\fP).
.TP 
\fB\-\-require\-strong\-checksums\fP
Wijger het broncodepakket uit te pakken als het geen krachtige
controlesommen bevat (sinds dpkg 1.18.7). Momenteel is \fBSHA\-256\fP de enige
gekende controlesom die als krachtig aanzien wordt.
.TP 
\fB\-\-ignore\-bad\-version\fP
Als bij een controle het versienummer van het broncodepakket foutief blijkt
te zijn, maakt deze instelling dat de gegeven waarschuwing geen fataal
karakter heeft (sinds dpkg 1.17.7). Deze optie zou enkel nodig moeten zijn
bij het extraheren van oude broncodepakketten met een defecte versie om
neerwaartse compatibiliteit te verzekeren.

.SH "INDELINGEN VAN BRONCODEPAKKETTEN"
Indien u niet weet welke indeling te kiezen voor de broncode, zou u wellicht
ofwel “3.0 (quilt)” of “3.0 (native)” moeten kiezen. Zie
https://wiki.debian.org/Projects/DebSrc3.0 voor informatie over het in
gebruik nemen van deze indelingen binnen Debian.

.SS "Indeling: 1.0"
Een broncodepakket volgens deze indeling bestaat ofwel uit een
\&\fB.orig.tar.gz\fP gekoppeld aan een \fB.diff.gz\fP of één enkele \fB.tar.gz\fP (in
dat geval wordt van het pakket gezegd dat het \fInative\fP (eigen \- van
oorsprong van Debian) is). Optioneel mag bij het originele tar\-archief een
afzonderlijke handtekening van de toeleveraar \fB.orig.tar.gz.asc\fP gevoegd
zijn. De extractie ervan wordt ondersteund sinds dpkg 1.18.5.

\fBExtraheren\fP

Een Debian\-eigen (native) pakket extraheren is een eenvoudige extractie van
het enige tar\-archief in de doelmap. Een niet\-eigen pakket extraheren
bestaat eruit dat eerst \fB.orig.tar.gz\fP uitgepakt wordt en dat dan de patch
erop toegepast wordt uit het bestand \fB.diff.gz\fP. Voor alle bestanden waarop
een patch toegepast werd, wordt de tijdsaanduiding teruggezet op het
tijdstip van extraheren van het broncodepakket (dit vermijdt
scheeftrekkingen van de tijdsaanduiding hetgeen tot problemen kan leiden
wanneer automatisch gegenereerde bestanden gepatcht worden). Het
diff\-bestand kan nieuwe bestanden aanmaken (de volledige debian\-map wordt op
die manier aangemaakt), maar kan geen bestanden verwijderen (lege bestanden
blijven achter).

\fBBouwen\fP

Een Debian\-eigen (native) pakket bouwen is gewoon een enkel tar\-archief
maken met daarin de broncodemap. Een niet\-eigen pakket bouwen bestaat uit
het extraheren van het originele tar\-archief in een aparte map “.orig” en
het opnieuw aanmaken van het bestand \fB.diff.gz\fP door de \fImap\fP van het
broncodepakket te vergelijken met de .orig\-map.

\fBBouwopties (met \-\-build):\fP

Indien een tweede argument opgegeven wordt dat geen optie is, moet het de
naam van de originele broncodemap zijn of van het tar\-archief of een lege
tekenreeks als het pakket Debian\-specifiek is en dus geen diffs bevat in
verband met de debianisering. Indien geen tweede argument opgegeven werd,
zal \fBdpkg\-source\fP zoeken naar het tar\-bestand met de originele broncode
\fIpakket\fP\fB_\fP\fItoeleveraarsversie\fP\fB.orig.tar.gz\fP of naar de map met de
originele broncode \fImap\fP\fB.orig\fP, afhankelijk van de argumenten \fB\-sX\fP.

\fB\-sa\fP, \fB\-sp\fP, \fB\-sk\fP, \fB\-su\fP en \fB\-sr\fP zullen geen bestaande tar\-bestanden
of \-mappen overschrijven. Indien dat wel gewenst wordt, dan moeten in de
plaats daarvan \fB\-sA\fP, \fB\-sP\fP, \fB\-sK\fP, \fB\-sU\fP en \fB\-sR\fP gebruikt worden.
.PP
.TP 
\fB\-sk\fP
Geeft aan dat verwacht mag worden dat de originele broncode in de vorm van
een tar\-bestand kan aangetroffen worden, wat standaard
\fIpakket\fP\fB_\fP\fItoeleveraarsversie\fP\fB.orig.tar.\fP\fIextensie\fP is. Het zal deze
originele broncode als een tar\-bestand laten staan of ze naar de huidige map
kopiëren als ze zich daar nog niet bevindt. Het tar\-archief zal uitgepakt
worden in \fImap\fP\fB.orig\fP met het oog op het genereren van het diff\-bestand.
.TP 
\fB\-sp\fP
Zoals \fB\-sk\fP maar dit zal naderhand de map weer verwijderen.
.TP 
\fB\-su\fP
Geeft aan dat verwacht mag worden dat de originele broncode in de vorm van
een map kan aangetroffen worden, wat standaard
\fIpakket\fP\fB\-\fP\fItoeleveraarsversie\fP\fB.orig\fP is, en \fBdpkg\-source\fP zal er een
nieuw archief met de originele broncode mee maken.
.TP 
\fB\-sr\fP
Zoals \fB\-su\fP, maar het zal die map na gebruik verwijderen.
.TP 
\fB\-ss\fP
Geeft aan dat de originele broncode zowel als een map als in de vorm van een
tar\-bestand te vinden is. \fBdpkg\-source\fP zal de map gebruiken om het
diff\-bestand te creëren, maar het tar\-bestand om het \fB.dsc\fP\-bestand te
maken. Gebruik deze optie met zorg \- indien de map en het tar\-bestand niet
overeenkomen zal er een slecht broncodearchief gegenereerd worden.
.TP 
\fB\-sn\fP
Geeft aan dat er niet naar een originele broncode gezocht moet worden en dat
er geen diff\-bestand aangemaakt moet worden. Als er een tweede argument
opgegeven wordt, moet het de lege tekenreeks zijn. Dit wordt gebruikt voor
Debian\-specifieke pakketten die geen afzonderlijke toeleveraarsbroncode
hebben en om die reden ook geen debianiserings\-diffs.
.TP 
\fB\-sa\fP of \fB\-sA\fP
Specifies to look for the original source archive as a tarfile or as a
directory \- the second argument, if any, may be either, or the empty string
(this is equivalent to using \fB\-sn\fP).  If a tarfile is found it will unpack
it to create the diff and remove it afterwards (this is equivalent to
\fB\-sp\fP); if a directory is found it will pack it to create the original
source and remove it afterwards (this is equivalent to \fB\-sr\fP); if neither
is found it will assume that the package has no debianization diffs, only a
straightforward source archive (this is equivalent to \fB\-sn\fP).  If both are
found then \fBdpkg\-source\fP will ignore the directory, overwriting it, if
\fB\-sA\fP was specified (this is equivalent to \fB\-sP\fP)  or raise an error if
\fB\-sa\fP was specified.  \fB\-sa\fP is the default.
.TP 
\fB\-\-abort\-on\-upstream\-changes\fP
Het proces mislukt als het gegenereerde diff\-bestand wijzigingen aan
bestanden buiten de onderliggende debian\-map bevat (sinds dpkg 1.15.8). Deze
optie is in  \fBdebian/source/options\fP niet toegestaan, maar ze kan wel
gebruikt worden in \fBdebian/source/local\-options\fP.
.PP

\fBExtractieopties (met \-\-extract):\fP

In alle gevallen zal een eventuele bestaande originele broncodeboom
verwijderd worden.
.TP 
\fB\-sp\fP
Als dit bij het extraheren gebruikt wordt, dan zal het de (eventuele)
originele broncode in zijn vorm van tar\-bestand laten. Indien dit zich nog
niet in de huidige map bevindt, of indien er zich een bestaand maar
verschillend bestand bevindt, zal het naar daar gekopieerd worden. (\fBDit is
de standaard\fP).
.TP 
\fB\-su\fP
Pakt de originele broncodeboom uit.
.TP 
\fB\-sn\fP
Zorgt ervoor dat de originele broncode noch naar de huidige map gekopieerd
wordt noch uitgepakt wordt. Een eventuele originele broncodeboom die zich in
de huidige map bevond, wordt nog steeds verwijderd.
.PP
Al de \fB\-s\fP\fIX\fP\-opties sluiten elkaar wederzijds uit. Indien u er meer dan
één opgeeft, dan zal enkel de laatste gebruikt worden.
.TP 
\fB\-\-skip\-debianization\fP
Slaat het toepassen van de debian diff bovenop de broncode van de
toeleveraar over (sinds dpkg 1.15.1).
.
.SS "Indeling: 2.0"
Extraheren wordt sinds dpkg 1.13.9 ondersteund, bouwen sinds dpkg
1.14.8. Ook gekend als wig&pen. Deze indeling wordt niet aangeraden voor
massaal gebruik, de indeling “3.0 (quilt)” vervangt ze. Wig&pen was de
eerste specificatie van een broncodepakketindeling van de nieuwe generatie.

Het gedrag van deze indeling is hetzelfde als bij de indeling “3.0 (quilt)”,
behalve dat het geen gebruik maakt van een expliciete lijst van
patches. Alle bestanden in \fBdebian/patches/\fP die beantwoorden aan de
reguliere expressie \fB[\ew\-]+\fP moeten geldige patches zijn: zij worden op
het moment van extraheren toegepast.

Bij het bouwen van een nieuw broncodepakket worden eventuele wijzigingen aan
de broncode van de toeleveraar opgeslagen in een patch met als naam
\fBzz_debian\-diff\-auto\fP.
.
.SS "Indeling: 3.0 (native) (d.w.z. debian\-eigen)"
Wordt ondersteund sinds dpkg 1.14.17. Deze indeling is een uitbreiding van
de native pakketindeling, zoals gedefinieerd in de indeling 1.0. Ze
ondersteunt alle compressiemethodes en negeert standaard eventuele
VCS\-specifieke bestanden en mappen (bestanden en mappen die verband houden
met het versiebeheersysteem) evenals vele tijdelijke bestanden (zie de
uitvoer van de optie \fB\-\-help\fP voor de standaardwaarde van de optie \fB\-I\fP).
.
.SS "Indeling: 3.0 (quilt)"
Wordt ondersteund sinds dpkg 1.14.17. Een broncodepakket volgens deze
indeling bevat minstens een origineel tar\-archief (\fB.orig.tar.\fP\fIext\fP
waarbij \fIext\fP \fBgz\fP, \fBbz2\fP, \fBlzma\fP en \fBxz\fP kan zijn) en een debian
tar\-archief (\fB.debian.tar.\fP\fIext\fP). Het kan ook bijkomende originele
tar\-archieven bevatten (\fB.orig\-\fP\fIcomponent\fP\fB.tar.\fP\fIext\fP). \fIcomponent\fP
mag enkel alfanumerieke tekens (‘a\-zA\-Z0\-9’) en koppeltekens (‘\-’)
bevatten. Optioneel mag bij elk origineel tar\-archief een afzonderlijke
handtekening van de toeleveraar (\fB.orig.tar.\fP\fIext\fP\fB.asc\fP en
\&\fB.orig\-\fP\fIcomponent\fP\fB.tar.\fP\fIext\fP\fB.asc\fP), gevoegd worden. De extractie
ervan wordt ondersteund sinds dpkg 1.17.20 en het bouwen sinds dpkg 1.18.5.

.PP
\fBExtraheren\fP
.PP
Eerst wordt het belangrijkste originele tar\-archief uitgepakt en nadien
worden alle bijkomende originele tar\-archieven uitgepakt in onderliggende
mappen die genoemd worden naar het \fIcomponent\fP\-gedeelte van hun
bestandsnaam (een eventuele reeds bestaande map wordt vervangen). Het debian
tar\-archief wordt bovenop de broncodemap geëxtraheerd nadat eerst een
eventuele reeds bestaande \fBdebian\fP\-map verwijderd werd. Merk op dat het
debian tar\-archief een onderliggende map \fBdebian\fP moet bevatten, maar dat
het ook binaire bestanden kan bevatten buiten die map (zie de optie
\fB\-\-include\-binaries\fP).
.PP
Vervolgens worden alle patches toegepast die vermeld zijn in
\fBdebian/patches/\fP\fIleverancier\fP\fB.series\fP of \fBdebian/patches/series\fP,
waarbij \fIleverancier\fP de naam is in kleine letters van de huidige
leverancier, of \fBdebian\fP als geen leverancier gedefinieerd is. Indien het
eerste bestand gebruikt wordt en het laatste niet bestaat (of een
symbolische koppeling is), dan zal het laatste vervangen worden door een
symbolische koppeling naar het eerste. Dit is bedoeld om het gebruik van
\fBquilt\fP bij het beheer van het geheel van patches te
vereenvoudigen. Leveranciersspecifieke series\-bestanden hebben tot doel het
serialiseren van meerdere leveranciersgebonden ontwikkelingstakken op een
declaratieve manier mogelijk te maken, wat verkieslijker is boven een open
codering van deze manipulatie in \fBdebian/rules\fP. Dit is in het bijzonder
nuttig wanneer de broncode voorwaardelijk gepatched moet worden omdat de
betrokken bestanden geen ingebouwde ondersteuning hebben voor conditionele
occlusie. Merk nochtans op dat hoewel \fBdpkg\-source\fP op correcte wijze de
ontleding uitvoert van series\-bestanden met expliciete opties die gebruikt
worden voor het toepassen van patches (op elke regel opgeslagen na de
bestandsnaam van de patch en één of meer spaties), het deze opties negeert
en steeds patches verwacht die kunnen toegepast worden met de optie \fB\-p1\fP
van \fBpatch\fP. Het zal dus een waarschuwing geven als het dergelijke opties
tegenkomt en het bouwen zal waarschijnlijk mislukken.
.PP
Note that \fBlintian\fP(1) will emit unconditional warnings when using vendor
series due to a controversial Debian specific ruling, which should not
affect any external usage; to silence these, the dpkg lintian profile can be
used by passing «\fB\-\-profile dpkg\fP» to \fBlintian\fP(1).
.PP
Voor alle bestanden waarop een patch toegepast werd, wordt de
tijdsaanduiding teruggezet op het tijdstip van extraheren van het
broncodepakket (dit vermijdt scheeftrekkingen van de tijdsaanduiding hetgeen
tot problemen kan leiden wanneer automatisch gegenereerde bestanden gepatcht
worden).
.PP
In tegenstelling tot het standaardgedrag van \fBquilt\fP wordt verwacht dat
patches zonder gedoe toegepast kunnen worden. Indien dat niet het geval is,
zou u de patches moeten verversen met \fBquilt\fP, anders zal \fBdpkg\-source\fP
met een foutmelding afbreken terwijl het probeert ze toe te passen.
.PP
Analoog aan het standaardgedrag van \fBquilt\fP kunnen patches ook bestanden
verwijderen.
.PP
Als tijdens het extraheren patches werden toegepast, wordt het bestand
\&\fB.pc/applied\-patches\fP aangemaakt.
.PP
\fBBouwen\fP
.PP
Alle originele tar\-archieven die in de huidige map gevonden worden, worden
geëxtraheerd in een tijdelijke map en daarbij wordt dezelfde logica gevolgd
als bij het uitpakken. De debian\-map wordt naar de tijdelijke map gekopieerd
en alle patches worden toegepast, behalve de automatische patch
(\fBdebian\-changes\-\fP\fIversie\fP of \fBdebian\-changes\fP, afhankelijk van
\fB\-\-single\-debian\-patch\fP). De tijdelijke map wordt vergeleken met de map van
het broncodepakket. Indien de diff niet leeg is, zal het bouwen mislukken,
tenzij \fB\-\-single\-debian\-patch\fP of \fB\-\-auto\-commit\fP gebruikt werden en in
dat geval wordt de diff opgeslagen in de automatische patch. Indien de
automatische patch aangemaakt/verwijderd wordt, wordt hij toegevoegd
aan/verwijderd van het bestand series en van de metadata van \fBquilt\fP.

Een eventuele wijziging aan een binair bestand kan niet weergegeven worden
in een diff en zal dus tot een mislukking leiden, tenzij de onderhouder
bewust besloot dat gewijzigd binair bestand toe te voegen aan het Debian
tar\-archief (door het op te sommen in
\fBdebian/source/include\-binaries\fP). Het bouwen zal ook mislukken als er
binaire bestanden aangetroffen worden in de onderliggende map debian, tenzij
zij op de witte lijst gezet werden via \fBdebian/source/include\-binaries\fP.

De bijgewerkte map debian en de lijst van gewijzigde binaire bestanden wordt
dan gebruikt om het Debian tar\-archief te genereren.

De automatisch gegenereerde diff bevat geen wijzigingen aan VCS\-specifieke
bestanden (d.w.z. bestanden eigen aan het versiebeheersysteem) en aan veel
tijdelijke bestanden (kijk in de uitvoer van \fB\-\-help\fP voor de
standaardwaarde die met de optie \fB\-i\fP) verbonden is. In het bijzonder wordt
de map \fB.pc\fP die door \fBquilt\fP gebruikt wordt, genegeerd tijdens het
genereren van de automatische patch.

Opmerking: \fBdpkg\-source\fP \fB\-\-before\-build\fP (en \fB\-\-build\fP) zal ervoor
zorgen dat alle patches die in het bestand series opgesomd zijn, toegepast
worden, zodat bij het bouwen van een pakket steeds alle patches toegepast
zijn. Het doet dit door te zoeken naar niet\-toegepaste patches (ze worden
opgesomd in het bestand \fBseries\fP maar niet in \fB.pc/applied\-patches\fP) en
indien de eerste patch uit die reeks foutloos toegepast kan worden, zal het
ze allemaal toepassen. De optie \fB\-\-no\-preparation\fP kan gebruikt worden om
dit gedrag uit te schakelen.

.PP
\fBWijzigingen optekenen\fP
.TP 
\fB\-\-commit\fP [\fImap\fP] [\fIpatchnaam\fP] [\fIpatchbestand\fP]
Genereert een patch in verband met de lokale wijzigingen die niet door het
patchsysteem van \fBquilt\fP beheerd worden en integreert die in het
patchsysteem onder de naam \fIpatchnaam\fP. Indien de naam ontbreekt, zal er
interactief om gevraagd worden. Indien \fIpatchbestand\fP opgegeven werd, wordt
dat gebruikt als de te integreren patch in verband met de lokale
wijzigingen. Na de integratie wordt een editor opgestart, zodat u de
meta\-informatie in de koptekst van de patch kunt bewerken.

Een \fIpatchbestand\fP opgeven is vooral nuttig na een mislukte bouwpoging die
dat bestand vooraf aanmaakte. Op grond daarvan wordt dat bestand na
integratie verwijderd. Merk ook op dat de wijzigingen die het patch\-bestand
bevat, reeds toegepast moeten zijn op de boom en dat de bestanden die door
de patch aangepast werden geen bijkomende niet\-opgetekende wijzigingen mogen
bevatten.

Indien het genereren van de patch gewijzigde binaire bestanden opmerkt,
zullen die automatisch toegevoegd worden aan
\fBdebian/source/include\-binaries\fP, zodat die terecht komen in het debian
tar\-archief (exact op dezelfde manier als \fBdpkg\-source \-\-include\-binaries
\-\-build\fP zou doen).
.PP
\fBBouwopties\fP
.TP 
\fB\-\-allow\-version\-of\-quilt\-db=\fP\fIversie\fP
Laat \fBdpkg\-source\fP toe het broncodepakket te bouwen als de versie van de
metadata van \fBquilt\fP de opgegeven versie is, zelfs al kent \fBdpkg\-source\fP
die niet (sinds dpkg 1.15.5.4). Dit zegt effectief dat de opgegeven versie
van de \fBquilt\fP\-metadata compatibel is met versie 2 die momenteel door
\fBdpkg\-source\fP ondersteund wordt. De versie van de metadata van \fBquilt\fP
wordt opgeslagen in \fB.pc/.version\fP.
.TP 
\fB\-\-include\-removal\fP
Negeer verwijderde bestanden niet en neem ze op in de automatisch
gegenereerde patch.
.TP 
\fB\-\-include\-timestamp\fP
Voeg de tijdsaanduiding toe in de automatisch gegenereerde patch.
.TP 
\fB\-\-include\-binaries\fP
Voeg alle gewijzigde binaire bestanden toe aan het debian tar\-archief. Voeg
ze ook toe in \fBdebian/source/include\-binaries\fP: in erop volgende
bouwactiviteiten zullen ze standaard toegevoegd worden en is deze optie dus
niet meer nodig.
.TP 
\fB\-\-no\-preparation\fP
Tracht de bouwboom niet voor te bereiden door patches toe te passen die
blijkbaar niet toegepast zijn (sinds dpkg 1.14.18).
.TP 
\fB\-\-single\-debian\-patch\fP
Gebruik \fBdebian/patches/debian\-changes\fP in plaats van
\fBdebian/patches/debian\-changes\-\fP\fIversie\fP voor de naam van de tijdens het
bouwen automatisch gegenereerde patch (sinds dpkg 1.15.5.4). Deze optie is
in het bijzonder nuttig als het pakket wordt onderhouden in een VCS
(versiebeheersysteem) en een reeks patches niet op een betrouwbare manier
gegenereerd kan worden. De huidige verschillen (de diff) met de
toeleveraarsversie moeten dan eerder in een enkele patch opgeslagen
worden. Deze optie wordt geplaatst in \fBdebian/source/local\-options\fP en gaat
samen met een bestand \fBdebian/source/local\-patch\-header\fP waarin uitgelegd
wordt hoe de door Debian aangebrachte wijzigingen best herzien kunnen
worden, bijvoorbeeld in het versiebeheersysteem dat gebruikt wordt.
.TP 
\fB\-\-create\-empty\-orig\fP
Creëer automatisch een leeg primair origineel tar\-archief als dat ontbreekt
en er wel bijkomende originele tar\-archieven zijn (sinds dpkg 1.15.6). Deze
optie is bedoeld om gebruikt te worden als het broncodepakket slechts een
bundel is van samengestelde toegeleverde software zonder een “centraal”
programma.
.TP 
\fB\-\-no\-unapply\-patches, \-\-unapply\-patches\fP
Standaard zal \fBdpkg\-source\fP de patches uit de uitbreiding (hook)
\fB\-\-after\-build\fP automatisch terugdraaien als het die tijdens
\fB\-\-before\-build\fP heeft toegepast (\fB\-\-unapply\-patches\fP sinds dpkg 1.15.8,
\fB\-\-no\-unapply\-patches\fP sinds dpkg 1.16.5). Deze opties laten u toe om het
proces van automatisch terugdraaien van patches uitdrukkelijk in of uit te
schakelen. Deze opties mogen enkel in \fBdebian/source/local\-options\fP
gebruikt worden, zodat alle gegenereerde broncodepakketten standaard
hetzelfde gedrag vertonen.
.TP 
\fB\-\-abort\-on\-upstream\-changes\fP
Het proces mislukt als een automatische patch gegenereerd werd (sinds dpkg
1.15.8). Deze optie kan gebruikt worden om te verzekeren dat alle
wijzigingen terdege geregistreerd worden in aparte \fBquilt\fP\-patches
vooraleer het broncodepakket gegenereerd wordt. Deze optie is niet
toegestaan in \fBdebian/source/options\fP, maar mag gebruikt worden in
\fBdebian/source/local\-options\fP.
.TP 
\fB\-\-auto\-commit\fP
Het proces mislukt niet als een automatische patch gegenereerd werd. In de
plaats daarvan wordt hij onmiddellijk opgetekend in het bestand series van
\fBquilt\fP.

.PP
\fBExtractieopties\fP
.TP 
\fB\-\-skip\-debianization\fP
Slaat het extraheren van het debian tar\-archief bovenop de broncode van de
toeleveraar over (sinds dpkg 1.15.1).
.TP 
\fB\-\-skip\-patches\fP
Pas op het einde van de extractie geen patches toe (sinds dpkg 1.14.18).
.
.SS "Indeling: 3.0 (custom) (d.w.z. aangepast)"
Ondersteund sinds dpkg 1.14.17. Deze indeling is bijzonder. Ze stelt
eigenlijk geen echte broncodepakketindeling voor, maar kan gebruikt worden
om broncodepakketten met arbitraire bestanden te maken.
.PP
\fBBouwopties\fP
.PP
Alle argumenten die geen opties zijn, worden geïnterpreteerd als bestanden
die geïntegreerd moeten worden in het gegenereerde broncodepakket. Ze moeten
bestaan en zich bij voorkeur in de huidige map bevinden. Tenminste één
bestand moet opgegeven worden.
.TP 
\fB\-\-target\-format=\fP\fIwaarde\fP
\fBVerplicht\fP. Definieert de echte indeling van het gegenereerde
broncodepakket. Het gegenereerde .dsc\-bestand zal in het veld \fBFormat\fP deze
waarde bevatten en niet “3.0 (custom)”.
.
.SS "Indeling: 3.0 (git)"
Ondersteund sinds dpkg 1.14.17. Dit is een experimentele indeling.
.PP
Een broncodepakket volgens deze indeling bestaat uit een eenvoudige
bundeling van een git\-depot \fB.git\fP die de broncode van het pakket bevat. Er
kan ook een bestand \fB.gitshallow\fP bestaan die de revisies vermeldt van een
git shallow clone (een summiere kloon van een git\-depot).
.PP
\fBExtraheren\fP
.PP
De bundel wordt gekloond in de doelmap als een git\-depot. Als er een bestand
gitshallow bestaat, wordt het als \fI.git/shallow\fP geïnstalleerd binnenin het
gekloonde git\-depot.
.PP
Merk op dat standaard het nieuwe depot dezelfde tak zal binnengehaald hebben
die binnengehaald was in de originele broncode. (Meestal is dat “master”,
maar dat kan om het even wat zijn). Eventuele andere takken zullen
beschikbaar zijn onder \fIremotes/origin/\fP.
.PP
\fBBouwen\fP
.PP
Vooraleer voort te gaan, worden een aantal controles uitgevoerd om zeker te
zijn dat er geen niet\-vastgelegde wijzigingen zijn die niet mogen genegeerd
worden.
.PP
\fBgit\-bundle\fP(1) wordt gebruikt om een bundel te genereren van het
git\-depot. Standaard worden alle takken en tags uit het depot in de bundel
opgenomen.
.PP
\fBBouwopties\fP
.TP 
\fB\-\-git\-ref=\fP\fIref\fP
Laat toe om een git\-referentie op te geven die in de bundel opgenomen moet
worden. Daar gebruik van maken schakelt het standaardgedrag om alle takken
en tags op te nemen uit. Kan meermaals vermeld worden. De \fIreferentie\fP kan
de naam van een tak of een tag zijn die opgenomen moet worden. Het kan ook
een parameter zijn die doorgegeven kan worden aan
\fBgit\-rev\-list\fP(1). Gebruik bijvoorbeeld \fB\-\-git\-ref=\fPmaster om enkel de
master\-tak op te nemen. Om alle takken en tags, behalve de tak persoonlijk
op te nemen, gebruikt u \fB\-\-git\-ref=\fP\-\-all \fB\-\-git\-ref=\fP^persoonlijk.
.TP 
\fB\-\-git\-depth=\fP\fIaantal\fP
Creëert een summiere (shallow) kloon met een geschiedenis die afgekapt werd
bij het opgegeven aantal revisies.
.SS "Indeling: 3.0 (bzr)"
Ondersteund sinds dpkg 1.14.17. Dit is een experimentele indeling. Ze
genereert één enkel tar\-archief met daarin het bzr\-depot.
.PP
\fBExtraheren\fP
.PP
Het tar\-archief wordt uitgepakt en daarna wordt bzr gebruikt om een
werkkopie van de huidige tak te maken.
.PP
\fBBouwen\fP
.PP
Vooraleer voort te gaan, worden een aantal controles uitgevoerd om zeker te
zijn dat er geen niet\-vastgelegde wijzigingen zijn die niet mogen genegeerd
worden.
.PP
Daarna wordt het versiebeheerspecifieke deel van de broncodemap gekopieerd
naar een tijdelijke map. Vooraleer deze tijdelijke map in een tar\-archief
ingepakt wordt, worden verschillende opruimtaken verricht om plaats te
winnen.
.SH DIAGNOSTIEK
.SS "geen broncode\-indeling opgegeven in debian/source/format"
Het bestand \fBdebian/source/format\fP moet altijd bestaan en de gewenste
broncode\-indeling aangeven. Met het oog op neerwaartse compatibiliteit wordt
indeling “1.0” verondersteld als het bestand niet bestaat, maar u zou hierop
niet moeten betrouwen: ergens in de toekomst zal \fBdpkg\-source\fP aangepast
worden, zodat het zal mislukken als het bestand niet bestaat.

De verantwoording is dat indeling “1.0” niet langer de aanbevolen indeling
is. U zou gewoonlijk één van de recentere indelingen (“3.0 (quilt)”, “3.0
(native)”) moeten kiezen, maar \fBdpkg\-source\fP zal dit niet automatisch voor
u doen. Indien u de oude indeling wilt blijven gebruiken, moet u dat
expliciet aangeven en “1.0” plaatsen in \fBdebian/source/format\fP.
.SS "de diff wijzigt de volgende bestanden van de toeleveraar"
Als u broncode\-indeling “1.0” gebruikt, is het meestal geen goed idee om
rechtstreeks wijzigingen aan te brengen in bestanden van de toeleveraar,
vermits de wijzigingen verborgen en grotendeels niet\-gedocumenteerd belanden
in het bestand .diff.gz. U zou uw wijzigingen dan beter opslaan als patches
in de map debian en ze dan op het ogenblik van het bouwen toepassen. Om deze
complexe werkwijze te vermijden, kunt u ook de indeling “3.0 (quilt)”
gebruiken, die dit geïntegreerd aanbiedt.
.SS "kan wijziging aan \fIbestand\fP niet representeren"
Wijzigingen aan de broncode van de toeleveraar worden gewoonlijk met
patch\-bestanden opgeslagen, maar niet alle wijzigingen kunnen met patches
gerepresenteerd worden, omdat die enkel de inhoud van gewone tekstbestanden
kunnen aanpassen. Indien u een bestand tracht te vervangen door iets van een
ander type (bijvoorbeeld een gewoon bestand vervangen door een symbolische
koppeling of een map), zult u deze foutmelding krijgen.
.SS "nieuw gecreëerd leeg bestand \fIbestand\fP zal niet gerepresenteerd worden in de diff"
Lege bestanden kunnen niet met behulp van patch\-bestanden aangemaakt
worden. Deze wijziging wordt dus niet geregistreerd in het broncodepakket en
u wordt daarover ingelicht.
.SS "\fItoegangsrechten\fP uitvoerbare modus van \fIbestand\fP zullen niet gerepresenteerd worden in de diff"
Patch\-bestanden registreren geen toegangsrechten van bestanden en dus wordt
het feit dat een bestand uitvoerbaar is, niet in het broncodepakket
opgeslagen. Deze waarschuwing brengt dit feit in herinnering.
.SS "\fItoegangsrechten\fP bijzondere modus van \fIbestand\fP zullen niet gerepresenteerd worden in de diff"
Patch\-bestanden registreren geen toegangsrechten van bestanden en dus worden
wijzigingen aan toegangsrechten niet opgeslagen in het broncodepakket. Deze
waarschuwing brengt dit feit in herinnering.
.
.SH OMGEVING
.TP 
\fBDPKG_COLORS\fP
Stelt de kleurmodus in (sinds dpkg 1.18.5). Waarden die momenteel gebruikt
mogen worden zijn: \fBauto\fP (standaard), \fBalways\fP en \fBnever\fP.
.TP 
\fBDPKG_NLS\fP
Indien dit ingesteld is, zal het gebruikt worden om te beslissen over het
activeren van moedertaalondersteuning, ook gekend als
internationaliseringsondersteuning (of i18n) (sinds dpkg 1.19.0). Geldige
waarden zijn: \fB0\fP and \fB1\fP (standaard).
.TP 
\fBSOURCE_DATE_EPOCH\fP
Indien dit ingesteld werd, zal het gebruikt worden als de tijdsaanduiding
(timestamp) (in seconden sinds de epoch) om de mtime vast te zetten op de
items uit het \fBtar\fP(5)\-bestand.
.TP 
\fBVISUAL\fP
.TQ
\fBEDITOR\fP
Gebruikt door de broncode\-indelingmodules “2.0” en “3.0 (quilt)”.
.TP 
\fBGIT_DIR\fP
.TQ
\fBGIT_INDEX_FILE\fP
.TQ
\fBGIT_OBJECT_DIRECTORY\fP
.TQ
\fBGIT_ALTERNATE_OBJECT_DIRECTORIES\fP
.TQ
\fBGIT_WORK_TREE\fP
Gebruikt door de broncode\-indelingmodules “3.0 (git)”.
.
.SH BESTANDEN
.SS debian/source/format
Dit bestand bevat op één enkele regel de indeling die gebruikt moet worden
om het broncodepakket te bouwen (mogelijke indelingen werden hierboven
beschreven). Voorafgaande of nakomende witruimte is niet toegelaten.
.SS debian/source/include\-binaries
Dit bestand bevat een lijst van binaire bestanden (één per regel) die
opgenomen moeten worden in het debian tar\-archief. Voorafgaande of nakomende
spaties worden gestript. Regels die beginnen met ‘\fB#\fP’ zijn commentaar en
worden overgeslagen. Lege regels worden genegeerd.
.SS debian/source/options
Dit bestand bevat een lijst met lange opties die automatisch voorgevoegd
moeten worden aan de reeks commandoregelopties die gebruikt worden bij het
inroepen van het commando \fBdpkg\-source \-\-build\fP of \fBdpkg\-source
\-\-print\-format\fP. Opties zoals \fB\-\-compression\fP en \fB\-\-compression\-level\fP
zijn zeer geschikt voor dit bestand.
.P
Elke optie moet op een aparte regel geplaatst worden. Lege regels en regels
die beginnen met ‘\fB#\fP’ worden genegeerd. De ‘\fB\-\-\fP’ vooraan moeten
weggelaten worden en korte opties zijn niet toegelaten. Facultatieve
witruimte rond het symbool ‘\fB=\fP’ en facultatieve aanhalingstekens rond de
waarde zijn toegelaten. Hierna volgt een voorbeeld van een dergelijk
bestand:
.P
  # laat dpkg\-source een bestand debian.tar.bz2 aanmaken met maximale compressie
  compression = "bzip2"
  compression\-level = 9
  # gebruik debian/patches/debian\-changes als automatische patch
  single\-debian\-patch
  # negeer wijzigingen aan config.{sub,guess}
  extend\-diff\-ignore = "(^|/)(config.sub|config.guess)$"
.P
Opmerking: \fB\-\-format\fP\-opties worden niet aanvaard in dit bestand. U moet
daarvoor eerder \fBdebian/source/format\fP gebruiken.
.SS debian/source/local\-options
Precies zoals \fBdebian/source/options\fP, behalve dat het bestand niet
opgenomen wordt in het gegenereerde broncodepakket. Dit kan nuttig zijn om
een voorkeur op te slaan die eigen is aan de onderhouder of aan een bepaald
depot van een versiebeheersysteem waarin het pakket onderhouden wordt.
.SS "debian/source/local\-patch\-header \fRen\fP debian/source/patch\-header"
Vrij opgemaakte tekst die geplaatst wordt bovenaan de automatische patch die
gegenereerd wordt bij de indelingen “2.0” en “3.0
(quilt)”. \fBlocal\-patch\-header\fP wordt niet toegevoegd aan het gegenereerde
broncodepakket, terwijl dat met \fBpatch\-header\fP wel het geval is.
.SS debian/patches/\fIleverancier\fP.series
.SS debian/patches/series
Dit bestand somt alle patches op die toegepast moeten worden (in de
opgegeven volgorde) bovenop het broncodepakket van de toeleveraar. Spaties
vooraan en achteraan worden weggehaald. \fIleverancier\fP is de naam in kleine
letters van de huidige leverancier of \fBdebian\fP als geen leverancier
gedefinieerd werd. Indien het leveranciersspecifieke series\-bestand niet
bestaat, zal het leveranciersloze series\-bestand gebruikt worden. Regels die
beginnen met ‘\fB#\fP’ zijn commentaar en worden overgeslagen. Lege regels
worden genegeerd. De overige regels beginnen met de bestandsnaam van een
patch (relatief ten opzichte van de map \fBdebian/patches/\fP) tot aan de
eerste spatie of het einde van de regel. Facultatieve \fBquilt\fP\-opties kunnen
daarna komen tot aan het einde van de regel of tot aan het eerste
‘\fB#\fP’\-teken dat voorafgegaan wordt door één of meer spaties (hetgeen het
begin van een commentaarstuk aangeeft dat doorloopt tot het einde van de
regel).
.SH BUGS
Het punt waarop de vervanging van velden plaats vindt, vergeleken met
bepaalde standaardinstellingen voor uitvoervelden, is eerder onduidelijk.
.SH "ZIE OOK"
.ad l
\fBdeb\-src\-control\fP(5), \fBdeb\-changelog\fP(5), \fBdsc\fP(5).
