/* client functions auto-generated by pidl */

#include "includes.h"
#include <tevent.h>
#include "lib/util/tevent_ntstatus.h"
#include "librpc/gen_ndr/ndr_wbint.h"
#include "librpc/gen_ndr/ndr_wbint_c.h"

/* wbint - client functions generated by pidl */

struct dcerpc_wbint_Ping_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_wbint_Ping_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_wbint_Ping_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct wbint_Ping *r)
{
	struct tevent_req *req;
	struct dcerpc_wbint_Ping_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_wbint_Ping_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_wbint,
			NDR_WBINT_PING, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_wbint_Ping_r_done, req);

	return req;
}

static void dcerpc_wbint_Ping_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_wbint_Ping_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_wbint_Ping_r_state *state =
		tevent_req_data(req,
		struct dcerpc_wbint_Ping_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_wbint_Ping_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct wbint_Ping *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_wbint,
			NDR_WBINT_PING, mem_ctx, r);

	return status;
}

struct dcerpc_wbint_Ping_state {
	struct wbint_Ping orig;
	struct wbint_Ping tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_wbint_Ping_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_wbint_Ping_send(TALLOC_CTX *mem_ctx,
					  struct tevent_context *ev,
					  struct dcerpc_binding_handle *h,
					  uint32_t _in_data /* [in]  */,
					  uint32_t *_out_data /* [out] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_wbint_Ping_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_wbint_Ping_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.in_data = _in_data;

	/* Out parameters */
	state->orig.out.out_data = _out_data;

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_wbint_Ping_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_wbint_Ping_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_wbint_Ping_done, req);
	return req;
}

static void dcerpc_wbint_Ping_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_wbint_Ping_state *state = tevent_req_data(
		req, struct dcerpc_wbint_Ping_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_wbint_Ping_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */
	*state->orig.out.out_data = *state->tmp.out.out_data;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_wbint_Ping_recv(struct tevent_req *req,
				TALLOC_CTX *mem_ctx)
{
	struct dcerpc_wbint_Ping_state *state = tevent_req_data(
		req, struct dcerpc_wbint_Ping_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_wbint_Ping(struct dcerpc_binding_handle *h,
			   TALLOC_CTX *mem_ctx,
			   uint32_t _in_data /* [in]  */,
			   uint32_t *_out_data /* [out] [ref] */)
{
	struct wbint_Ping r;
	NTSTATUS status;

	/* In parameters */
	r.in.in_data = _in_data;

	status = dcerpc_wbint_Ping_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_out_data = *r.out.out_data;

	/* Return result */

	return NT_STATUS_OK;
}

struct dcerpc_wbint_LookupSid_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_wbint_LookupSid_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_wbint_LookupSid_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct wbint_LookupSid *r)
{
	struct tevent_req *req;
	struct dcerpc_wbint_LookupSid_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_wbint_LookupSid_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_wbint,
			NDR_WBINT_LOOKUPSID, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_wbint_LookupSid_r_done, req);

	return req;
}

static void dcerpc_wbint_LookupSid_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_wbint_LookupSid_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_wbint_LookupSid_r_state *state =
		tevent_req_data(req,
		struct dcerpc_wbint_LookupSid_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_wbint_LookupSid_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct wbint_LookupSid *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_wbint,
			NDR_WBINT_LOOKUPSID, mem_ctx, r);

	return status;
}

struct dcerpc_wbint_LookupSid_state {
	struct wbint_LookupSid orig;
	struct wbint_LookupSid tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_wbint_LookupSid_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_wbint_LookupSid_send(TALLOC_CTX *mem_ctx,
					       struct tevent_context *ev,
					       struct dcerpc_binding_handle *h,
					       struct dom_sid *_sid /* [in] [ref] */,
					       enum lsa_SidType *_type /* [out] [ref] */,
					       const char **_domain /* [out] [charset(UTF8),ref] */,
					       const char **_name /* [out] [charset(UTF8),ref] */)
{
	struct tevent_req *req;
	struct dcerpc_wbint_LookupSid_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_wbint_LookupSid_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.sid = _sid;

	/* Out parameters */
	state->orig.out.type = _type;
	state->orig.out.domain = _domain;
	state->orig.out.name = _name;

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_wbint_LookupSid_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_wbint_LookupSid_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_wbint_LookupSid_done, req);
	return req;
}

static void dcerpc_wbint_LookupSid_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_wbint_LookupSid_state *state = tevent_req_data(
		req, struct dcerpc_wbint_LookupSid_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_wbint_LookupSid_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */
	*state->orig.out.type = *state->tmp.out.type;
	*state->orig.out.domain = *state->tmp.out.domain;
	*state->orig.out.name = *state->tmp.out.name;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_wbint_LookupSid_recv(struct tevent_req *req,
				     TALLOC_CTX *mem_ctx,
				     NTSTATUS *result)
{
	struct dcerpc_wbint_LookupSid_state *state = tevent_req_data(
		req, struct dcerpc_wbint_LookupSid_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_wbint_LookupSid(struct dcerpc_binding_handle *h,
				TALLOC_CTX *mem_ctx,
				struct dom_sid *_sid /* [in] [ref] */,
				enum lsa_SidType *_type /* [out] [ref] */,
				const char **_domain /* [out] [charset(UTF8),ref] */,
				const char **_name /* [out] [charset(UTF8),ref] */,
				NTSTATUS *result)
{
	struct wbint_LookupSid r;
	NTSTATUS status;

	/* In parameters */
	r.in.sid = _sid;

	status = dcerpc_wbint_LookupSid_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_type = *r.out.type;
	*_domain = *r.out.domain;
	*_name = *r.out.name;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_wbint_LookupSids_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_wbint_LookupSids_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_wbint_LookupSids_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct wbint_LookupSids *r)
{
	struct tevent_req *req;
	struct dcerpc_wbint_LookupSids_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_wbint_LookupSids_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_wbint,
			NDR_WBINT_LOOKUPSIDS, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_wbint_LookupSids_r_done, req);

	return req;
}

static void dcerpc_wbint_LookupSids_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_wbint_LookupSids_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_wbint_LookupSids_r_state *state =
		tevent_req_data(req,
		struct dcerpc_wbint_LookupSids_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_wbint_LookupSids_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct wbint_LookupSids *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_wbint,
			NDR_WBINT_LOOKUPSIDS, mem_ctx, r);

	return status;
}

struct dcerpc_wbint_LookupSids_state {
	struct wbint_LookupSids orig;
	struct wbint_LookupSids tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_wbint_LookupSids_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_wbint_LookupSids_send(TALLOC_CTX *mem_ctx,
						struct tevent_context *ev,
						struct dcerpc_binding_handle *h,
						struct lsa_SidArray *_sids /* [in] [ref] */,
						struct lsa_RefDomainList *_domains /* [out] [ref] */,
						struct lsa_TransNameArray *_names /* [out] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_wbint_LookupSids_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_wbint_LookupSids_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.sids = _sids;

	/* Out parameters */
	state->orig.out.domains = _domains;
	state->orig.out.names = _names;

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_wbint_LookupSids_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_wbint_LookupSids_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_wbint_LookupSids_done, req);
	return req;
}

static void dcerpc_wbint_LookupSids_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_wbint_LookupSids_state *state = tevent_req_data(
		req, struct dcerpc_wbint_LookupSids_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_wbint_LookupSids_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */
	*state->orig.out.domains = *state->tmp.out.domains;
	*state->orig.out.names = *state->tmp.out.names;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_wbint_LookupSids_recv(struct tevent_req *req,
				      TALLOC_CTX *mem_ctx,
				      NTSTATUS *result)
{
	struct dcerpc_wbint_LookupSids_state *state = tevent_req_data(
		req, struct dcerpc_wbint_LookupSids_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_wbint_LookupSids(struct dcerpc_binding_handle *h,
				 TALLOC_CTX *mem_ctx,
				 struct lsa_SidArray *_sids /* [in] [ref] */,
				 struct lsa_RefDomainList *_domains /* [out] [ref] */,
				 struct lsa_TransNameArray *_names /* [out] [ref] */,
				 NTSTATUS *result)
{
	struct wbint_LookupSids r;
	NTSTATUS status;

	/* In parameters */
	r.in.sids = _sids;

	status = dcerpc_wbint_LookupSids_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_domains = *r.out.domains;
	*_names = *r.out.names;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_wbint_LookupName_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_wbint_LookupName_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_wbint_LookupName_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct wbint_LookupName *r)
{
	struct tevent_req *req;
	struct dcerpc_wbint_LookupName_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_wbint_LookupName_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_wbint,
			NDR_WBINT_LOOKUPNAME, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_wbint_LookupName_r_done, req);

	return req;
}

static void dcerpc_wbint_LookupName_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_wbint_LookupName_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_wbint_LookupName_r_state *state =
		tevent_req_data(req,
		struct dcerpc_wbint_LookupName_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_wbint_LookupName_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct wbint_LookupName *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_wbint,
			NDR_WBINT_LOOKUPNAME, mem_ctx, r);

	return status;
}

struct dcerpc_wbint_LookupName_state {
	struct wbint_LookupName orig;
	struct wbint_LookupName tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_wbint_LookupName_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_wbint_LookupName_send(TALLOC_CTX *mem_ctx,
						struct tevent_context *ev,
						struct dcerpc_binding_handle *h,
						const char *_domain /* [in] [charset(UTF8),ref] */,
						const char *_name /* [in] [ref,charset(UTF8)] */,
						uint32_t _flags /* [in]  */,
						enum lsa_SidType *_type /* [out] [ref] */,
						struct dom_sid *_sid /* [out] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_wbint_LookupName_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_wbint_LookupName_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.domain = _domain;
	state->orig.in.name = _name;
	state->orig.in.flags = _flags;

	/* Out parameters */
	state->orig.out.type = _type;
	state->orig.out.sid = _sid;

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_wbint_LookupName_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_wbint_LookupName_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_wbint_LookupName_done, req);
	return req;
}

static void dcerpc_wbint_LookupName_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_wbint_LookupName_state *state = tevent_req_data(
		req, struct dcerpc_wbint_LookupName_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_wbint_LookupName_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */
	*state->orig.out.type = *state->tmp.out.type;
	*state->orig.out.sid = *state->tmp.out.sid;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_wbint_LookupName_recv(struct tevent_req *req,
				      TALLOC_CTX *mem_ctx,
				      NTSTATUS *result)
{
	struct dcerpc_wbint_LookupName_state *state = tevent_req_data(
		req, struct dcerpc_wbint_LookupName_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_wbint_LookupName(struct dcerpc_binding_handle *h,
				 TALLOC_CTX *mem_ctx,
				 const char *_domain /* [in] [charset(UTF8),ref] */,
				 const char *_name /* [in] [ref,charset(UTF8)] */,
				 uint32_t _flags /* [in]  */,
				 enum lsa_SidType *_type /* [out] [ref] */,
				 struct dom_sid *_sid /* [out] [ref] */,
				 NTSTATUS *result)
{
	struct wbint_LookupName r;
	NTSTATUS status;

	/* In parameters */
	r.in.domain = _domain;
	r.in.name = _name;
	r.in.flags = _flags;

	status = dcerpc_wbint_LookupName_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_type = *r.out.type;
	*_sid = *r.out.sid;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_wbint_Sid2Uid_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_wbint_Sid2Uid_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_wbint_Sid2Uid_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct wbint_Sid2Uid *r)
{
	struct tevent_req *req;
	struct dcerpc_wbint_Sid2Uid_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_wbint_Sid2Uid_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_wbint,
			NDR_WBINT_SID2UID, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_wbint_Sid2Uid_r_done, req);

	return req;
}

static void dcerpc_wbint_Sid2Uid_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_wbint_Sid2Uid_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_wbint_Sid2Uid_r_state *state =
		tevent_req_data(req,
		struct dcerpc_wbint_Sid2Uid_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_wbint_Sid2Uid_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct wbint_Sid2Uid *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_wbint,
			NDR_WBINT_SID2UID, mem_ctx, r);

	return status;
}

struct dcerpc_wbint_Sid2Uid_state {
	struct wbint_Sid2Uid orig;
	struct wbint_Sid2Uid tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_wbint_Sid2Uid_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_wbint_Sid2Uid_send(TALLOC_CTX *mem_ctx,
					     struct tevent_context *ev,
					     struct dcerpc_binding_handle *h,
					     const char *_dom_name /* [in] [charset(UTF8),unique] */,
					     struct dom_sid *_sid /* [in] [ref] */,
					     uint64_t *_uid /* [out] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_wbint_Sid2Uid_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_wbint_Sid2Uid_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.dom_name = _dom_name;
	state->orig.in.sid = _sid;

	/* Out parameters */
	state->orig.out.uid = _uid;

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_wbint_Sid2Uid_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_wbint_Sid2Uid_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_wbint_Sid2Uid_done, req);
	return req;
}

static void dcerpc_wbint_Sid2Uid_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_wbint_Sid2Uid_state *state = tevent_req_data(
		req, struct dcerpc_wbint_Sid2Uid_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_wbint_Sid2Uid_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */
	*state->orig.out.uid = *state->tmp.out.uid;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_wbint_Sid2Uid_recv(struct tevent_req *req,
				   TALLOC_CTX *mem_ctx,
				   NTSTATUS *result)
{
	struct dcerpc_wbint_Sid2Uid_state *state = tevent_req_data(
		req, struct dcerpc_wbint_Sid2Uid_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_wbint_Sid2Uid(struct dcerpc_binding_handle *h,
			      TALLOC_CTX *mem_ctx,
			      const char *_dom_name /* [in] [charset(UTF8),unique] */,
			      struct dom_sid *_sid /* [in] [ref] */,
			      uint64_t *_uid /* [out] [ref] */,
			      NTSTATUS *result)
{
	struct wbint_Sid2Uid r;
	NTSTATUS status;

	/* In parameters */
	r.in.dom_name = _dom_name;
	r.in.sid = _sid;

	status = dcerpc_wbint_Sid2Uid_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_uid = *r.out.uid;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_wbint_Sid2Gid_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_wbint_Sid2Gid_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_wbint_Sid2Gid_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct wbint_Sid2Gid *r)
{
	struct tevent_req *req;
	struct dcerpc_wbint_Sid2Gid_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_wbint_Sid2Gid_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_wbint,
			NDR_WBINT_SID2GID, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_wbint_Sid2Gid_r_done, req);

	return req;
}

static void dcerpc_wbint_Sid2Gid_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_wbint_Sid2Gid_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_wbint_Sid2Gid_r_state *state =
		tevent_req_data(req,
		struct dcerpc_wbint_Sid2Gid_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_wbint_Sid2Gid_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct wbint_Sid2Gid *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_wbint,
			NDR_WBINT_SID2GID, mem_ctx, r);

	return status;
}

struct dcerpc_wbint_Sid2Gid_state {
	struct wbint_Sid2Gid orig;
	struct wbint_Sid2Gid tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_wbint_Sid2Gid_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_wbint_Sid2Gid_send(TALLOC_CTX *mem_ctx,
					     struct tevent_context *ev,
					     struct dcerpc_binding_handle *h,
					     const char *_dom_name /* [in] [charset(UTF8),unique] */,
					     struct dom_sid *_sid /* [in] [ref] */,
					     uint64_t *_gid /* [out] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_wbint_Sid2Gid_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_wbint_Sid2Gid_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.dom_name = _dom_name;
	state->orig.in.sid = _sid;

	/* Out parameters */
	state->orig.out.gid = _gid;

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_wbint_Sid2Gid_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_wbint_Sid2Gid_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_wbint_Sid2Gid_done, req);
	return req;
}

static void dcerpc_wbint_Sid2Gid_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_wbint_Sid2Gid_state *state = tevent_req_data(
		req, struct dcerpc_wbint_Sid2Gid_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_wbint_Sid2Gid_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */
	*state->orig.out.gid = *state->tmp.out.gid;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_wbint_Sid2Gid_recv(struct tevent_req *req,
				   TALLOC_CTX *mem_ctx,
				   NTSTATUS *result)
{
	struct dcerpc_wbint_Sid2Gid_state *state = tevent_req_data(
		req, struct dcerpc_wbint_Sid2Gid_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_wbint_Sid2Gid(struct dcerpc_binding_handle *h,
			      TALLOC_CTX *mem_ctx,
			      const char *_dom_name /* [in] [charset(UTF8),unique] */,
			      struct dom_sid *_sid /* [in] [ref] */,
			      uint64_t *_gid /* [out] [ref] */,
			      NTSTATUS *result)
{
	struct wbint_Sid2Gid r;
	NTSTATUS status;

	/* In parameters */
	r.in.dom_name = _dom_name;
	r.in.sid = _sid;

	status = dcerpc_wbint_Sid2Gid_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_gid = *r.out.gid;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_wbint_Sids2UnixIDs_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_wbint_Sids2UnixIDs_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_wbint_Sids2UnixIDs_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct wbint_Sids2UnixIDs *r)
{
	struct tevent_req *req;
	struct dcerpc_wbint_Sids2UnixIDs_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_wbint_Sids2UnixIDs_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_wbint,
			NDR_WBINT_SIDS2UNIXIDS, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_wbint_Sids2UnixIDs_r_done, req);

	return req;
}

static void dcerpc_wbint_Sids2UnixIDs_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_wbint_Sids2UnixIDs_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_wbint_Sids2UnixIDs_r_state *state =
		tevent_req_data(req,
		struct dcerpc_wbint_Sids2UnixIDs_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_wbint_Sids2UnixIDs_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct wbint_Sids2UnixIDs *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_wbint,
			NDR_WBINT_SIDS2UNIXIDS, mem_ctx, r);

	return status;
}

struct dcerpc_wbint_Sids2UnixIDs_state {
	struct wbint_Sids2UnixIDs orig;
	struct wbint_Sids2UnixIDs tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_wbint_Sids2UnixIDs_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_wbint_Sids2UnixIDs_send(TALLOC_CTX *mem_ctx,
						  struct tevent_context *ev,
						  struct dcerpc_binding_handle *h,
						  struct lsa_RefDomainList *_domains /* [in] [ref] */,
						  struct wbint_TransIDArray *_ids /* [in,out] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_wbint_Sids2UnixIDs_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_wbint_Sids2UnixIDs_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.domains = _domains;
	state->orig.in.ids = _ids;

	/* Out parameters */
	state->orig.out.ids = _ids;

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_wbint_Sids2UnixIDs_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_wbint_Sids2UnixIDs_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_wbint_Sids2UnixIDs_done, req);
	return req;
}

static void dcerpc_wbint_Sids2UnixIDs_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_wbint_Sids2UnixIDs_state *state = tevent_req_data(
		req, struct dcerpc_wbint_Sids2UnixIDs_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_wbint_Sids2UnixIDs_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */
	*state->orig.out.ids = *state->tmp.out.ids;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_wbint_Sids2UnixIDs_recv(struct tevent_req *req,
					TALLOC_CTX *mem_ctx,
					NTSTATUS *result)
{
	struct dcerpc_wbint_Sids2UnixIDs_state *state = tevent_req_data(
		req, struct dcerpc_wbint_Sids2UnixIDs_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_wbint_Sids2UnixIDs(struct dcerpc_binding_handle *h,
				   TALLOC_CTX *mem_ctx,
				   struct lsa_RefDomainList *_domains /* [in] [ref] */,
				   struct wbint_TransIDArray *_ids /* [in,out] [ref] */,
				   NTSTATUS *result)
{
	struct wbint_Sids2UnixIDs r;
	NTSTATUS status;

	/* In parameters */
	r.in.domains = _domains;
	r.in.ids = _ids;

	status = dcerpc_wbint_Sids2UnixIDs_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_ids = *r.out.ids;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_wbint_Uid2Sid_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_wbint_Uid2Sid_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_wbint_Uid2Sid_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct wbint_Uid2Sid *r)
{
	struct tevent_req *req;
	struct dcerpc_wbint_Uid2Sid_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_wbint_Uid2Sid_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_wbint,
			NDR_WBINT_UID2SID, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_wbint_Uid2Sid_r_done, req);

	return req;
}

static void dcerpc_wbint_Uid2Sid_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_wbint_Uid2Sid_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_wbint_Uid2Sid_r_state *state =
		tevent_req_data(req,
		struct dcerpc_wbint_Uid2Sid_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_wbint_Uid2Sid_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct wbint_Uid2Sid *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_wbint,
			NDR_WBINT_UID2SID, mem_ctx, r);

	return status;
}

struct dcerpc_wbint_Uid2Sid_state {
	struct wbint_Uid2Sid orig;
	struct wbint_Uid2Sid tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_wbint_Uid2Sid_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_wbint_Uid2Sid_send(TALLOC_CTX *mem_ctx,
					     struct tevent_context *ev,
					     struct dcerpc_binding_handle *h,
					     const char *_dom_name /* [in] [unique,charset(UTF8)] */,
					     uint64_t _uid /* [in]  */,
					     struct dom_sid *_sid /* [out] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_wbint_Uid2Sid_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_wbint_Uid2Sid_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.dom_name = _dom_name;
	state->orig.in.uid = _uid;

	/* Out parameters */
	state->orig.out.sid = _sid;

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_wbint_Uid2Sid_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_wbint_Uid2Sid_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_wbint_Uid2Sid_done, req);
	return req;
}

static void dcerpc_wbint_Uid2Sid_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_wbint_Uid2Sid_state *state = tevent_req_data(
		req, struct dcerpc_wbint_Uid2Sid_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_wbint_Uid2Sid_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */
	*state->orig.out.sid = *state->tmp.out.sid;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_wbint_Uid2Sid_recv(struct tevent_req *req,
				   TALLOC_CTX *mem_ctx,
				   NTSTATUS *result)
{
	struct dcerpc_wbint_Uid2Sid_state *state = tevent_req_data(
		req, struct dcerpc_wbint_Uid2Sid_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_wbint_Uid2Sid(struct dcerpc_binding_handle *h,
			      TALLOC_CTX *mem_ctx,
			      const char *_dom_name /* [in] [unique,charset(UTF8)] */,
			      uint64_t _uid /* [in]  */,
			      struct dom_sid *_sid /* [out] [ref] */,
			      NTSTATUS *result)
{
	struct wbint_Uid2Sid r;
	NTSTATUS status;

	/* In parameters */
	r.in.dom_name = _dom_name;
	r.in.uid = _uid;

	status = dcerpc_wbint_Uid2Sid_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_sid = *r.out.sid;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_wbint_Gid2Sid_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_wbint_Gid2Sid_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_wbint_Gid2Sid_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct wbint_Gid2Sid *r)
{
	struct tevent_req *req;
	struct dcerpc_wbint_Gid2Sid_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_wbint_Gid2Sid_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_wbint,
			NDR_WBINT_GID2SID, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_wbint_Gid2Sid_r_done, req);

	return req;
}

static void dcerpc_wbint_Gid2Sid_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_wbint_Gid2Sid_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_wbint_Gid2Sid_r_state *state =
		tevent_req_data(req,
		struct dcerpc_wbint_Gid2Sid_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_wbint_Gid2Sid_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct wbint_Gid2Sid *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_wbint,
			NDR_WBINT_GID2SID, mem_ctx, r);

	return status;
}

struct dcerpc_wbint_Gid2Sid_state {
	struct wbint_Gid2Sid orig;
	struct wbint_Gid2Sid tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_wbint_Gid2Sid_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_wbint_Gid2Sid_send(TALLOC_CTX *mem_ctx,
					     struct tevent_context *ev,
					     struct dcerpc_binding_handle *h,
					     const char *_dom_name /* [in] [unique,charset(UTF8)] */,
					     uint64_t _gid /* [in]  */,
					     struct dom_sid *_sid /* [out] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_wbint_Gid2Sid_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_wbint_Gid2Sid_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.dom_name = _dom_name;
	state->orig.in.gid = _gid;

	/* Out parameters */
	state->orig.out.sid = _sid;

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_wbint_Gid2Sid_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_wbint_Gid2Sid_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_wbint_Gid2Sid_done, req);
	return req;
}

static void dcerpc_wbint_Gid2Sid_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_wbint_Gid2Sid_state *state = tevent_req_data(
		req, struct dcerpc_wbint_Gid2Sid_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_wbint_Gid2Sid_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */
	*state->orig.out.sid = *state->tmp.out.sid;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_wbint_Gid2Sid_recv(struct tevent_req *req,
				   TALLOC_CTX *mem_ctx,
				   NTSTATUS *result)
{
	struct dcerpc_wbint_Gid2Sid_state *state = tevent_req_data(
		req, struct dcerpc_wbint_Gid2Sid_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_wbint_Gid2Sid(struct dcerpc_binding_handle *h,
			      TALLOC_CTX *mem_ctx,
			      const char *_dom_name /* [in] [unique,charset(UTF8)] */,
			      uint64_t _gid /* [in]  */,
			      struct dom_sid *_sid /* [out] [ref] */,
			      NTSTATUS *result)
{
	struct wbint_Gid2Sid r;
	NTSTATUS status;

	/* In parameters */
	r.in.dom_name = _dom_name;
	r.in.gid = _gid;

	status = dcerpc_wbint_Gid2Sid_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_sid = *r.out.sid;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_wbint_AllocateUid_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_wbint_AllocateUid_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_wbint_AllocateUid_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct wbint_AllocateUid *r)
{
	struct tevent_req *req;
	struct dcerpc_wbint_AllocateUid_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_wbint_AllocateUid_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_wbint,
			NDR_WBINT_ALLOCATEUID, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_wbint_AllocateUid_r_done, req);

	return req;
}

static void dcerpc_wbint_AllocateUid_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_wbint_AllocateUid_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_wbint_AllocateUid_r_state *state =
		tevent_req_data(req,
		struct dcerpc_wbint_AllocateUid_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_wbint_AllocateUid_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct wbint_AllocateUid *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_wbint,
			NDR_WBINT_ALLOCATEUID, mem_ctx, r);

	return status;
}

struct dcerpc_wbint_AllocateUid_state {
	struct wbint_AllocateUid orig;
	struct wbint_AllocateUid tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_wbint_AllocateUid_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_wbint_AllocateUid_send(TALLOC_CTX *mem_ctx,
						 struct tevent_context *ev,
						 struct dcerpc_binding_handle *h,
						 uint64_t *_uid /* [out] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_wbint_AllocateUid_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_wbint_AllocateUid_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */

	/* Out parameters */
	state->orig.out.uid = _uid;

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_wbint_AllocateUid_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_wbint_AllocateUid_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_wbint_AllocateUid_done, req);
	return req;
}

static void dcerpc_wbint_AllocateUid_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_wbint_AllocateUid_state *state = tevent_req_data(
		req, struct dcerpc_wbint_AllocateUid_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_wbint_AllocateUid_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */
	*state->orig.out.uid = *state->tmp.out.uid;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_wbint_AllocateUid_recv(struct tevent_req *req,
				       TALLOC_CTX *mem_ctx,
				       NTSTATUS *result)
{
	struct dcerpc_wbint_AllocateUid_state *state = tevent_req_data(
		req, struct dcerpc_wbint_AllocateUid_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_wbint_AllocateUid(struct dcerpc_binding_handle *h,
				  TALLOC_CTX *mem_ctx,
				  uint64_t *_uid /* [out] [ref] */,
				  NTSTATUS *result)
{
	struct wbint_AllocateUid r;
	NTSTATUS status;

	/* In parameters */

	status = dcerpc_wbint_AllocateUid_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_uid = *r.out.uid;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_wbint_AllocateGid_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_wbint_AllocateGid_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_wbint_AllocateGid_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct wbint_AllocateGid *r)
{
	struct tevent_req *req;
	struct dcerpc_wbint_AllocateGid_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_wbint_AllocateGid_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_wbint,
			NDR_WBINT_ALLOCATEGID, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_wbint_AllocateGid_r_done, req);

	return req;
}

static void dcerpc_wbint_AllocateGid_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_wbint_AllocateGid_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_wbint_AllocateGid_r_state *state =
		tevent_req_data(req,
		struct dcerpc_wbint_AllocateGid_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_wbint_AllocateGid_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct wbint_AllocateGid *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_wbint,
			NDR_WBINT_ALLOCATEGID, mem_ctx, r);

	return status;
}

struct dcerpc_wbint_AllocateGid_state {
	struct wbint_AllocateGid orig;
	struct wbint_AllocateGid tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_wbint_AllocateGid_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_wbint_AllocateGid_send(TALLOC_CTX *mem_ctx,
						 struct tevent_context *ev,
						 struct dcerpc_binding_handle *h,
						 uint64_t *_gid /* [out] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_wbint_AllocateGid_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_wbint_AllocateGid_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */

	/* Out parameters */
	state->orig.out.gid = _gid;

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_wbint_AllocateGid_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_wbint_AllocateGid_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_wbint_AllocateGid_done, req);
	return req;
}

static void dcerpc_wbint_AllocateGid_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_wbint_AllocateGid_state *state = tevent_req_data(
		req, struct dcerpc_wbint_AllocateGid_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_wbint_AllocateGid_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */
	*state->orig.out.gid = *state->tmp.out.gid;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_wbint_AllocateGid_recv(struct tevent_req *req,
				       TALLOC_CTX *mem_ctx,
				       NTSTATUS *result)
{
	struct dcerpc_wbint_AllocateGid_state *state = tevent_req_data(
		req, struct dcerpc_wbint_AllocateGid_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_wbint_AllocateGid(struct dcerpc_binding_handle *h,
				  TALLOC_CTX *mem_ctx,
				  uint64_t *_gid /* [out] [ref] */,
				  NTSTATUS *result)
{
	struct wbint_AllocateGid r;
	NTSTATUS status;

	/* In parameters */

	status = dcerpc_wbint_AllocateGid_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_gid = *r.out.gid;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_wbint_QueryUser_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_wbint_QueryUser_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_wbint_QueryUser_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct wbint_QueryUser *r)
{
	struct tevent_req *req;
	struct dcerpc_wbint_QueryUser_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_wbint_QueryUser_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_wbint,
			NDR_WBINT_QUERYUSER, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_wbint_QueryUser_r_done, req);

	return req;
}

static void dcerpc_wbint_QueryUser_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_wbint_QueryUser_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_wbint_QueryUser_r_state *state =
		tevent_req_data(req,
		struct dcerpc_wbint_QueryUser_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_wbint_QueryUser_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct wbint_QueryUser *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_wbint,
			NDR_WBINT_QUERYUSER, mem_ctx, r);

	return status;
}

struct dcerpc_wbint_QueryUser_state {
	struct wbint_QueryUser orig;
	struct wbint_QueryUser tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_wbint_QueryUser_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_wbint_QueryUser_send(TALLOC_CTX *mem_ctx,
					       struct tevent_context *ev,
					       struct dcerpc_binding_handle *h,
					       struct dom_sid *_sid /* [in] [ref] */,
					       struct wbint_userinfo *_info /* [out] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_wbint_QueryUser_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_wbint_QueryUser_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.sid = _sid;

	/* Out parameters */
	state->orig.out.info = _info;

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_wbint_QueryUser_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_wbint_QueryUser_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_wbint_QueryUser_done, req);
	return req;
}

static void dcerpc_wbint_QueryUser_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_wbint_QueryUser_state *state = tevent_req_data(
		req, struct dcerpc_wbint_QueryUser_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_wbint_QueryUser_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */
	*state->orig.out.info = *state->tmp.out.info;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_wbint_QueryUser_recv(struct tevent_req *req,
				     TALLOC_CTX *mem_ctx,
				     NTSTATUS *result)
{
	struct dcerpc_wbint_QueryUser_state *state = tevent_req_data(
		req, struct dcerpc_wbint_QueryUser_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_wbint_QueryUser(struct dcerpc_binding_handle *h,
				TALLOC_CTX *mem_ctx,
				struct dom_sid *_sid /* [in] [ref] */,
				struct wbint_userinfo *_info /* [out] [ref] */,
				NTSTATUS *result)
{
	struct wbint_QueryUser r;
	NTSTATUS status;

	/* In parameters */
	r.in.sid = _sid;

	status = dcerpc_wbint_QueryUser_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_info = *r.out.info;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_wbint_LookupUserAliases_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_wbint_LookupUserAliases_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_wbint_LookupUserAliases_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct wbint_LookupUserAliases *r)
{
	struct tevent_req *req;
	struct dcerpc_wbint_LookupUserAliases_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_wbint_LookupUserAliases_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_wbint,
			NDR_WBINT_LOOKUPUSERALIASES, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_wbint_LookupUserAliases_r_done, req);

	return req;
}

static void dcerpc_wbint_LookupUserAliases_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_wbint_LookupUserAliases_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_wbint_LookupUserAliases_r_state *state =
		tevent_req_data(req,
		struct dcerpc_wbint_LookupUserAliases_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_wbint_LookupUserAliases_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct wbint_LookupUserAliases *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_wbint,
			NDR_WBINT_LOOKUPUSERALIASES, mem_ctx, r);

	return status;
}

struct dcerpc_wbint_LookupUserAliases_state {
	struct wbint_LookupUserAliases orig;
	struct wbint_LookupUserAliases tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_wbint_LookupUserAliases_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_wbint_LookupUserAliases_send(TALLOC_CTX *mem_ctx,
						       struct tevent_context *ev,
						       struct dcerpc_binding_handle *h,
						       struct wbint_SidArray *_sids /* [in] [ref] */,
						       struct wbint_RidArray *_rids /* [out] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_wbint_LookupUserAliases_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_wbint_LookupUserAliases_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.sids = _sids;

	/* Out parameters */
	state->orig.out.rids = _rids;

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_wbint_LookupUserAliases_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_wbint_LookupUserAliases_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_wbint_LookupUserAliases_done, req);
	return req;
}

static void dcerpc_wbint_LookupUserAliases_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_wbint_LookupUserAliases_state *state = tevent_req_data(
		req, struct dcerpc_wbint_LookupUserAliases_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_wbint_LookupUserAliases_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */
	*state->orig.out.rids = *state->tmp.out.rids;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_wbint_LookupUserAliases_recv(struct tevent_req *req,
					     TALLOC_CTX *mem_ctx,
					     NTSTATUS *result)
{
	struct dcerpc_wbint_LookupUserAliases_state *state = tevent_req_data(
		req, struct dcerpc_wbint_LookupUserAliases_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_wbint_LookupUserAliases(struct dcerpc_binding_handle *h,
					TALLOC_CTX *mem_ctx,
					struct wbint_SidArray *_sids /* [in] [ref] */,
					struct wbint_RidArray *_rids /* [out] [ref] */,
					NTSTATUS *result)
{
	struct wbint_LookupUserAliases r;
	NTSTATUS status;

	/* In parameters */
	r.in.sids = _sids;

	status = dcerpc_wbint_LookupUserAliases_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_rids = *r.out.rids;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_wbint_LookupUserGroups_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_wbint_LookupUserGroups_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_wbint_LookupUserGroups_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct wbint_LookupUserGroups *r)
{
	struct tevent_req *req;
	struct dcerpc_wbint_LookupUserGroups_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_wbint_LookupUserGroups_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_wbint,
			NDR_WBINT_LOOKUPUSERGROUPS, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_wbint_LookupUserGroups_r_done, req);

	return req;
}

static void dcerpc_wbint_LookupUserGroups_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_wbint_LookupUserGroups_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_wbint_LookupUserGroups_r_state *state =
		tevent_req_data(req,
		struct dcerpc_wbint_LookupUserGroups_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_wbint_LookupUserGroups_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct wbint_LookupUserGroups *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_wbint,
			NDR_WBINT_LOOKUPUSERGROUPS, mem_ctx, r);

	return status;
}

struct dcerpc_wbint_LookupUserGroups_state {
	struct wbint_LookupUserGroups orig;
	struct wbint_LookupUserGroups tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_wbint_LookupUserGroups_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_wbint_LookupUserGroups_send(TALLOC_CTX *mem_ctx,
						      struct tevent_context *ev,
						      struct dcerpc_binding_handle *h,
						      struct dom_sid *_sid /* [in] [ref] */,
						      struct wbint_SidArray *_sids /* [out] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_wbint_LookupUserGroups_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_wbint_LookupUserGroups_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.sid = _sid;

	/* Out parameters */
	state->orig.out.sids = _sids;

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_wbint_LookupUserGroups_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_wbint_LookupUserGroups_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_wbint_LookupUserGroups_done, req);
	return req;
}

static void dcerpc_wbint_LookupUserGroups_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_wbint_LookupUserGroups_state *state = tevent_req_data(
		req, struct dcerpc_wbint_LookupUserGroups_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_wbint_LookupUserGroups_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */
	*state->orig.out.sids = *state->tmp.out.sids;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_wbint_LookupUserGroups_recv(struct tevent_req *req,
					    TALLOC_CTX *mem_ctx,
					    NTSTATUS *result)
{
	struct dcerpc_wbint_LookupUserGroups_state *state = tevent_req_data(
		req, struct dcerpc_wbint_LookupUserGroups_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_wbint_LookupUserGroups(struct dcerpc_binding_handle *h,
				       TALLOC_CTX *mem_ctx,
				       struct dom_sid *_sid /* [in] [ref] */,
				       struct wbint_SidArray *_sids /* [out] [ref] */,
				       NTSTATUS *result)
{
	struct wbint_LookupUserGroups r;
	NTSTATUS status;

	/* In parameters */
	r.in.sid = _sid;

	status = dcerpc_wbint_LookupUserGroups_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_sids = *r.out.sids;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_wbint_QuerySequenceNumber_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_wbint_QuerySequenceNumber_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_wbint_QuerySequenceNumber_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct wbint_QuerySequenceNumber *r)
{
	struct tevent_req *req;
	struct dcerpc_wbint_QuerySequenceNumber_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_wbint_QuerySequenceNumber_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_wbint,
			NDR_WBINT_QUERYSEQUENCENUMBER, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_wbint_QuerySequenceNumber_r_done, req);

	return req;
}

static void dcerpc_wbint_QuerySequenceNumber_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_wbint_QuerySequenceNumber_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_wbint_QuerySequenceNumber_r_state *state =
		tevent_req_data(req,
		struct dcerpc_wbint_QuerySequenceNumber_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_wbint_QuerySequenceNumber_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct wbint_QuerySequenceNumber *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_wbint,
			NDR_WBINT_QUERYSEQUENCENUMBER, mem_ctx, r);

	return status;
}

struct dcerpc_wbint_QuerySequenceNumber_state {
	struct wbint_QuerySequenceNumber orig;
	struct wbint_QuerySequenceNumber tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_wbint_QuerySequenceNumber_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_wbint_QuerySequenceNumber_send(TALLOC_CTX *mem_ctx,
							 struct tevent_context *ev,
							 struct dcerpc_binding_handle *h,
							 uint32_t *_sequence /* [out] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_wbint_QuerySequenceNumber_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_wbint_QuerySequenceNumber_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */

	/* Out parameters */
	state->orig.out.sequence = _sequence;

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_wbint_QuerySequenceNumber_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_wbint_QuerySequenceNumber_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_wbint_QuerySequenceNumber_done, req);
	return req;
}

static void dcerpc_wbint_QuerySequenceNumber_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_wbint_QuerySequenceNumber_state *state = tevent_req_data(
		req, struct dcerpc_wbint_QuerySequenceNumber_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_wbint_QuerySequenceNumber_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */
	*state->orig.out.sequence = *state->tmp.out.sequence;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_wbint_QuerySequenceNumber_recv(struct tevent_req *req,
					       TALLOC_CTX *mem_ctx,
					       NTSTATUS *result)
{
	struct dcerpc_wbint_QuerySequenceNumber_state *state = tevent_req_data(
		req, struct dcerpc_wbint_QuerySequenceNumber_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_wbint_QuerySequenceNumber(struct dcerpc_binding_handle *h,
					  TALLOC_CTX *mem_ctx,
					  uint32_t *_sequence /* [out] [ref] */,
					  NTSTATUS *result)
{
	struct wbint_QuerySequenceNumber r;
	NTSTATUS status;

	/* In parameters */

	status = dcerpc_wbint_QuerySequenceNumber_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_sequence = *r.out.sequence;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_wbint_LookupGroupMembers_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_wbint_LookupGroupMembers_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_wbint_LookupGroupMembers_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct wbint_LookupGroupMembers *r)
{
	struct tevent_req *req;
	struct dcerpc_wbint_LookupGroupMembers_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_wbint_LookupGroupMembers_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_wbint,
			NDR_WBINT_LOOKUPGROUPMEMBERS, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_wbint_LookupGroupMembers_r_done, req);

	return req;
}

static void dcerpc_wbint_LookupGroupMembers_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_wbint_LookupGroupMembers_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_wbint_LookupGroupMembers_r_state *state =
		tevent_req_data(req,
		struct dcerpc_wbint_LookupGroupMembers_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_wbint_LookupGroupMembers_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct wbint_LookupGroupMembers *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_wbint,
			NDR_WBINT_LOOKUPGROUPMEMBERS, mem_ctx, r);

	return status;
}

struct dcerpc_wbint_LookupGroupMembers_state {
	struct wbint_LookupGroupMembers orig;
	struct wbint_LookupGroupMembers tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_wbint_LookupGroupMembers_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_wbint_LookupGroupMembers_send(TALLOC_CTX *mem_ctx,
							struct tevent_context *ev,
							struct dcerpc_binding_handle *h,
							struct dom_sid *_sid /* [in] [ref] */,
							enum lsa_SidType _type /* [in]  */,
							struct wbint_Principals *_members /* [out] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_wbint_LookupGroupMembers_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_wbint_LookupGroupMembers_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.sid = _sid;
	state->orig.in.type = _type;

	/* Out parameters */
	state->orig.out.members = _members;

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_wbint_LookupGroupMembers_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_wbint_LookupGroupMembers_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_wbint_LookupGroupMembers_done, req);
	return req;
}

static void dcerpc_wbint_LookupGroupMembers_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_wbint_LookupGroupMembers_state *state = tevent_req_data(
		req, struct dcerpc_wbint_LookupGroupMembers_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_wbint_LookupGroupMembers_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */
	*state->orig.out.members = *state->tmp.out.members;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_wbint_LookupGroupMembers_recv(struct tevent_req *req,
					      TALLOC_CTX *mem_ctx,
					      NTSTATUS *result)
{
	struct dcerpc_wbint_LookupGroupMembers_state *state = tevent_req_data(
		req, struct dcerpc_wbint_LookupGroupMembers_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_wbint_LookupGroupMembers(struct dcerpc_binding_handle *h,
					 TALLOC_CTX *mem_ctx,
					 struct dom_sid *_sid /* [in] [ref] */,
					 enum lsa_SidType _type /* [in]  */,
					 struct wbint_Principals *_members /* [out] [ref] */,
					 NTSTATUS *result)
{
	struct wbint_LookupGroupMembers r;
	NTSTATUS status;

	/* In parameters */
	r.in.sid = _sid;
	r.in.type = _type;

	status = dcerpc_wbint_LookupGroupMembers_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_members = *r.out.members;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_wbint_QueryUserList_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_wbint_QueryUserList_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_wbint_QueryUserList_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct wbint_QueryUserList *r)
{
	struct tevent_req *req;
	struct dcerpc_wbint_QueryUserList_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_wbint_QueryUserList_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_wbint,
			NDR_WBINT_QUERYUSERLIST, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_wbint_QueryUserList_r_done, req);

	return req;
}

static void dcerpc_wbint_QueryUserList_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_wbint_QueryUserList_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_wbint_QueryUserList_r_state *state =
		tevent_req_data(req,
		struct dcerpc_wbint_QueryUserList_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_wbint_QueryUserList_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct wbint_QueryUserList *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_wbint,
			NDR_WBINT_QUERYUSERLIST, mem_ctx, r);

	return status;
}

struct dcerpc_wbint_QueryUserList_state {
	struct wbint_QueryUserList orig;
	struct wbint_QueryUserList tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_wbint_QueryUserList_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_wbint_QueryUserList_send(TALLOC_CTX *mem_ctx,
						   struct tevent_context *ev,
						   struct dcerpc_binding_handle *h,
						   struct wbint_userinfos *_users /* [out] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_wbint_QueryUserList_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_wbint_QueryUserList_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */

	/* Out parameters */
	state->orig.out.users = _users;

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_wbint_QueryUserList_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_wbint_QueryUserList_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_wbint_QueryUserList_done, req);
	return req;
}

static void dcerpc_wbint_QueryUserList_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_wbint_QueryUserList_state *state = tevent_req_data(
		req, struct dcerpc_wbint_QueryUserList_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_wbint_QueryUserList_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */
	*state->orig.out.users = *state->tmp.out.users;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_wbint_QueryUserList_recv(struct tevent_req *req,
					 TALLOC_CTX *mem_ctx,
					 NTSTATUS *result)
{
	struct dcerpc_wbint_QueryUserList_state *state = tevent_req_data(
		req, struct dcerpc_wbint_QueryUserList_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_wbint_QueryUserList(struct dcerpc_binding_handle *h,
				    TALLOC_CTX *mem_ctx,
				    struct wbint_userinfos *_users /* [out] [ref] */,
				    NTSTATUS *result)
{
	struct wbint_QueryUserList r;
	NTSTATUS status;

	/* In parameters */

	status = dcerpc_wbint_QueryUserList_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_users = *r.out.users;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_wbint_QueryGroupList_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_wbint_QueryGroupList_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_wbint_QueryGroupList_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct wbint_QueryGroupList *r)
{
	struct tevent_req *req;
	struct dcerpc_wbint_QueryGroupList_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_wbint_QueryGroupList_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_wbint,
			NDR_WBINT_QUERYGROUPLIST, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_wbint_QueryGroupList_r_done, req);

	return req;
}

static void dcerpc_wbint_QueryGroupList_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_wbint_QueryGroupList_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_wbint_QueryGroupList_r_state *state =
		tevent_req_data(req,
		struct dcerpc_wbint_QueryGroupList_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_wbint_QueryGroupList_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct wbint_QueryGroupList *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_wbint,
			NDR_WBINT_QUERYGROUPLIST, mem_ctx, r);

	return status;
}

struct dcerpc_wbint_QueryGroupList_state {
	struct wbint_QueryGroupList orig;
	struct wbint_QueryGroupList tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_wbint_QueryGroupList_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_wbint_QueryGroupList_send(TALLOC_CTX *mem_ctx,
						    struct tevent_context *ev,
						    struct dcerpc_binding_handle *h,
						    struct wbint_Principals *_groups /* [out] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_wbint_QueryGroupList_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_wbint_QueryGroupList_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */

	/* Out parameters */
	state->orig.out.groups = _groups;

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_wbint_QueryGroupList_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_wbint_QueryGroupList_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_wbint_QueryGroupList_done, req);
	return req;
}

static void dcerpc_wbint_QueryGroupList_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_wbint_QueryGroupList_state *state = tevent_req_data(
		req, struct dcerpc_wbint_QueryGroupList_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_wbint_QueryGroupList_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */
	*state->orig.out.groups = *state->tmp.out.groups;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_wbint_QueryGroupList_recv(struct tevent_req *req,
					  TALLOC_CTX *mem_ctx,
					  NTSTATUS *result)
{
	struct dcerpc_wbint_QueryGroupList_state *state = tevent_req_data(
		req, struct dcerpc_wbint_QueryGroupList_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_wbint_QueryGroupList(struct dcerpc_binding_handle *h,
				     TALLOC_CTX *mem_ctx,
				     struct wbint_Principals *_groups /* [out] [ref] */,
				     NTSTATUS *result)
{
	struct wbint_QueryGroupList r;
	NTSTATUS status;

	/* In parameters */

	status = dcerpc_wbint_QueryGroupList_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_groups = *r.out.groups;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_wbint_DsGetDcName_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_wbint_DsGetDcName_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_wbint_DsGetDcName_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct wbint_DsGetDcName *r)
{
	struct tevent_req *req;
	struct dcerpc_wbint_DsGetDcName_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_wbint_DsGetDcName_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_wbint,
			NDR_WBINT_DSGETDCNAME, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_wbint_DsGetDcName_r_done, req);

	return req;
}

static void dcerpc_wbint_DsGetDcName_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_wbint_DsGetDcName_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_wbint_DsGetDcName_r_state *state =
		tevent_req_data(req,
		struct dcerpc_wbint_DsGetDcName_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_wbint_DsGetDcName_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct wbint_DsGetDcName *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_wbint,
			NDR_WBINT_DSGETDCNAME, mem_ctx, r);

	return status;
}

struct dcerpc_wbint_DsGetDcName_state {
	struct wbint_DsGetDcName orig;
	struct wbint_DsGetDcName tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_wbint_DsGetDcName_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_wbint_DsGetDcName_send(TALLOC_CTX *mem_ctx,
						 struct tevent_context *ev,
						 struct dcerpc_binding_handle *h,
						 const char *_domain_name /* [in] [ref,charset(UTF8)] */,
						 struct GUID *_domain_guid /* [in] [unique] */,
						 const char *_site_name /* [in] [unique,charset(UTF8)] */,
						 uint32_t _flags /* [in]  */,
						 struct netr_DsRGetDCNameInfo **_dc_info /* [out] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_wbint_DsGetDcName_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_wbint_DsGetDcName_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.domain_name = _domain_name;
	state->orig.in.domain_guid = _domain_guid;
	state->orig.in.site_name = _site_name;
	state->orig.in.flags = _flags;

	/* Out parameters */
	state->orig.out.dc_info = _dc_info;

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_wbint_DsGetDcName_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_wbint_DsGetDcName_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_wbint_DsGetDcName_done, req);
	return req;
}

static void dcerpc_wbint_DsGetDcName_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_wbint_DsGetDcName_state *state = tevent_req_data(
		req, struct dcerpc_wbint_DsGetDcName_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_wbint_DsGetDcName_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */
	*state->orig.out.dc_info = *state->tmp.out.dc_info;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_wbint_DsGetDcName_recv(struct tevent_req *req,
				       TALLOC_CTX *mem_ctx,
				       NTSTATUS *result)
{
	struct dcerpc_wbint_DsGetDcName_state *state = tevent_req_data(
		req, struct dcerpc_wbint_DsGetDcName_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_wbint_DsGetDcName(struct dcerpc_binding_handle *h,
				  TALLOC_CTX *mem_ctx,
				  const char *_domain_name /* [in] [ref,charset(UTF8)] */,
				  struct GUID *_domain_guid /* [in] [unique] */,
				  const char *_site_name /* [in] [unique,charset(UTF8)] */,
				  uint32_t _flags /* [in]  */,
				  struct netr_DsRGetDCNameInfo **_dc_info /* [out] [ref] */,
				  NTSTATUS *result)
{
	struct wbint_DsGetDcName r;
	NTSTATUS status;

	/* In parameters */
	r.in.domain_name = _domain_name;
	r.in.domain_guid = _domain_guid;
	r.in.site_name = _site_name;
	r.in.flags = _flags;

	status = dcerpc_wbint_DsGetDcName_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_dc_info = *r.out.dc_info;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_wbint_LookupRids_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_wbint_LookupRids_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_wbint_LookupRids_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct wbint_LookupRids *r)
{
	struct tevent_req *req;
	struct dcerpc_wbint_LookupRids_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_wbint_LookupRids_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_wbint,
			NDR_WBINT_LOOKUPRIDS, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_wbint_LookupRids_r_done, req);

	return req;
}

static void dcerpc_wbint_LookupRids_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_wbint_LookupRids_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_wbint_LookupRids_r_state *state =
		tevent_req_data(req,
		struct dcerpc_wbint_LookupRids_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_wbint_LookupRids_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct wbint_LookupRids *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_wbint,
			NDR_WBINT_LOOKUPRIDS, mem_ctx, r);

	return status;
}

struct dcerpc_wbint_LookupRids_state {
	struct wbint_LookupRids orig;
	struct wbint_LookupRids tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_wbint_LookupRids_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_wbint_LookupRids_send(TALLOC_CTX *mem_ctx,
						struct tevent_context *ev,
						struct dcerpc_binding_handle *h,
						struct dom_sid *_domain_sid /* [in] [ref] */,
						struct wbint_RidArray *_rids /* [in] [ref] */,
						const char **_domain_name /* [out] [ref,charset(UTF8)] */,
						struct wbint_Principals *_names /* [out] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_wbint_LookupRids_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_wbint_LookupRids_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.domain_sid = _domain_sid;
	state->orig.in.rids = _rids;

	/* Out parameters */
	state->orig.out.domain_name = _domain_name;
	state->orig.out.names = _names;

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_wbint_LookupRids_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_wbint_LookupRids_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_wbint_LookupRids_done, req);
	return req;
}

static void dcerpc_wbint_LookupRids_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_wbint_LookupRids_state *state = tevent_req_data(
		req, struct dcerpc_wbint_LookupRids_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_wbint_LookupRids_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */
	*state->orig.out.domain_name = *state->tmp.out.domain_name;
	*state->orig.out.names = *state->tmp.out.names;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_wbint_LookupRids_recv(struct tevent_req *req,
				      TALLOC_CTX *mem_ctx,
				      NTSTATUS *result)
{
	struct dcerpc_wbint_LookupRids_state *state = tevent_req_data(
		req, struct dcerpc_wbint_LookupRids_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_wbint_LookupRids(struct dcerpc_binding_handle *h,
				 TALLOC_CTX *mem_ctx,
				 struct dom_sid *_domain_sid /* [in] [ref] */,
				 struct wbint_RidArray *_rids /* [in] [ref] */,
				 const char **_domain_name /* [out] [ref,charset(UTF8)] */,
				 struct wbint_Principals *_names /* [out] [ref] */,
				 NTSTATUS *result)
{
	struct wbint_LookupRids r;
	NTSTATUS status;

	/* In parameters */
	r.in.domain_sid = _domain_sid;
	r.in.rids = _rids;

	status = dcerpc_wbint_LookupRids_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_domain_name = *r.out.domain_name;
	*_names = *r.out.names;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_wbint_CheckMachineAccount_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_wbint_CheckMachineAccount_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_wbint_CheckMachineAccount_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct wbint_CheckMachineAccount *r)
{
	struct tevent_req *req;
	struct dcerpc_wbint_CheckMachineAccount_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_wbint_CheckMachineAccount_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = NULL;

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_wbint,
			NDR_WBINT_CHECKMACHINEACCOUNT, state, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_wbint_CheckMachineAccount_r_done, req);

	return req;
}

static void dcerpc_wbint_CheckMachineAccount_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_wbint_CheckMachineAccount_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_wbint_CheckMachineAccount_r_state *state =
		tevent_req_data(req,
		struct dcerpc_wbint_CheckMachineAccount_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_wbint_CheckMachineAccount_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct wbint_CheckMachineAccount *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_wbint,
			NDR_WBINT_CHECKMACHINEACCOUNT, mem_ctx, r);

	return status;
}

struct dcerpc_wbint_CheckMachineAccount_state {
	struct wbint_CheckMachineAccount orig;
	struct wbint_CheckMachineAccount tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_wbint_CheckMachineAccount_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_wbint_CheckMachineAccount_send(TALLOC_CTX *mem_ctx,
							 struct tevent_context *ev,
							 struct dcerpc_binding_handle *h)
{
	struct tevent_req *req;
	struct dcerpc_wbint_CheckMachineAccount_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_wbint_CheckMachineAccount_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */

	/* Out parameters */

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_wbint_CheckMachineAccount_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_wbint_CheckMachineAccount_done, req);
	return req;
}

static void dcerpc_wbint_CheckMachineAccount_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_wbint_CheckMachineAccount_state *state = tevent_req_data(
		req, struct dcerpc_wbint_CheckMachineAccount_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_wbint_CheckMachineAccount_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_wbint_CheckMachineAccount_recv(struct tevent_req *req,
					       TALLOC_CTX *mem_ctx,
					       NTSTATUS *result)
{
	struct dcerpc_wbint_CheckMachineAccount_state *state = tevent_req_data(
		req, struct dcerpc_wbint_CheckMachineAccount_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_wbint_CheckMachineAccount(struct dcerpc_binding_handle *h,
					  TALLOC_CTX *mem_ctx,
					  NTSTATUS *result)
{
	struct wbint_CheckMachineAccount r;
	NTSTATUS status;

	/* In parameters */

	status = dcerpc_wbint_CheckMachineAccount_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_wbint_ChangeMachineAccount_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_wbint_ChangeMachineAccount_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_wbint_ChangeMachineAccount_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct wbint_ChangeMachineAccount *r)
{
	struct tevent_req *req;
	struct dcerpc_wbint_ChangeMachineAccount_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_wbint_ChangeMachineAccount_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = NULL;

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_wbint,
			NDR_WBINT_CHANGEMACHINEACCOUNT, state, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_wbint_ChangeMachineAccount_r_done, req);

	return req;
}

static void dcerpc_wbint_ChangeMachineAccount_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_wbint_ChangeMachineAccount_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_wbint_ChangeMachineAccount_r_state *state =
		tevent_req_data(req,
		struct dcerpc_wbint_ChangeMachineAccount_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_wbint_ChangeMachineAccount_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct wbint_ChangeMachineAccount *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_wbint,
			NDR_WBINT_CHANGEMACHINEACCOUNT, mem_ctx, r);

	return status;
}

struct dcerpc_wbint_ChangeMachineAccount_state {
	struct wbint_ChangeMachineAccount orig;
	struct wbint_ChangeMachineAccount tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_wbint_ChangeMachineAccount_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_wbint_ChangeMachineAccount_send(TALLOC_CTX *mem_ctx,
							  struct tevent_context *ev,
							  struct dcerpc_binding_handle *h)
{
	struct tevent_req *req;
	struct dcerpc_wbint_ChangeMachineAccount_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_wbint_ChangeMachineAccount_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */

	/* Out parameters */

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_wbint_ChangeMachineAccount_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_wbint_ChangeMachineAccount_done, req);
	return req;
}

static void dcerpc_wbint_ChangeMachineAccount_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_wbint_ChangeMachineAccount_state *state = tevent_req_data(
		req, struct dcerpc_wbint_ChangeMachineAccount_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_wbint_ChangeMachineAccount_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_wbint_ChangeMachineAccount_recv(struct tevent_req *req,
						TALLOC_CTX *mem_ctx,
						NTSTATUS *result)
{
	struct dcerpc_wbint_ChangeMachineAccount_state *state = tevent_req_data(
		req, struct dcerpc_wbint_ChangeMachineAccount_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_wbint_ChangeMachineAccount(struct dcerpc_binding_handle *h,
					   TALLOC_CTX *mem_ctx,
					   NTSTATUS *result)
{
	struct wbint_ChangeMachineAccount r;
	NTSTATUS status;

	/* In parameters */

	status = dcerpc_wbint_ChangeMachineAccount_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_wbint_PingDc_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_wbint_PingDc_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_wbint_PingDc_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct wbint_PingDc *r)
{
	struct tevent_req *req;
	struct dcerpc_wbint_PingDc_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_wbint_PingDc_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = NULL;

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_wbint,
			NDR_WBINT_PINGDC, state, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_wbint_PingDc_r_done, req);

	return req;
}

static void dcerpc_wbint_PingDc_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_wbint_PingDc_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_wbint_PingDc_r_state *state =
		tevent_req_data(req,
		struct dcerpc_wbint_PingDc_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_wbint_PingDc_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct wbint_PingDc *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_wbint,
			NDR_WBINT_PINGDC, mem_ctx, r);

	return status;
}

struct dcerpc_wbint_PingDc_state {
	struct wbint_PingDc orig;
	struct wbint_PingDc tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_wbint_PingDc_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_wbint_PingDc_send(TALLOC_CTX *mem_ctx,
					    struct tevent_context *ev,
					    struct dcerpc_binding_handle *h)
{
	struct tevent_req *req;
	struct dcerpc_wbint_PingDc_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_wbint_PingDc_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */

	/* Out parameters */

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_wbint_PingDc_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_wbint_PingDc_done, req);
	return req;
}

static void dcerpc_wbint_PingDc_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_wbint_PingDc_state *state = tevent_req_data(
		req, struct dcerpc_wbint_PingDc_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_wbint_PingDc_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_wbint_PingDc_recv(struct tevent_req *req,
				  TALLOC_CTX *mem_ctx,
				  NTSTATUS *result)
{
	struct dcerpc_wbint_PingDc_state *state = tevent_req_data(
		req, struct dcerpc_wbint_PingDc_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_wbint_PingDc(struct dcerpc_binding_handle *h,
			     TALLOC_CTX *mem_ctx,
			     NTSTATUS *result)
{
	struct wbint_PingDc r;
	NTSTATUS status;

	/* In parameters */

	status = dcerpc_wbint_PingDc_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

