/*
 *  Unix SMB/CIFS implementation.
 *  RPC Pipe client / server routines
 *
 *  Copyright (C) Luke Kenneth Casson Leighton 1997-2001.
 *  Copyright (C) Andrew Bartlett
 *  Copyright (C) Andrew Tridgell
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, see <http://www.gnu.org/licenses/>.
 */

/* NT error codes.  please read nterr.h */

#include "includes.h"
#include "../libcli/ldap/ldap_errors.h"
#undef strcasecmp

#if !defined(N_)
#define N_(string) string
#endif

#define DOS_CODE(class, code) { #class ":" #code, NT_STATUS_DOS(class, code) }
#define LDAP_CODE(code) { #code, NT_STATUS_LDAP(code) }

const nt_err_code_struct nt_errs[] =
{
	{ "NT_STATUS_OK", NT_STATUS_OK },
	{ "STATUS_NO_MORE_FILES", STATUS_NO_MORE_FILES },
	{ "STATUS_STOPPED_ON_SYMLINK", STATUS_STOPPED_ON_SYMLINK },
	{ "STATUS_NO_MORE_EAS", STATUS_NO_MORE_EAS },
	{ "STATUS_INVALID_EA_NAME", STATUS_INVALID_EA_NAME },
	{ "STATUS_EA_LIST_INCONSISTENT", STATUS_EA_LIST_INCONSISTENT },
	{ "STATUS_INVALID_EA_FLAG", STATUS_INVALID_EA_FLAG },
	{ "NT_STATUS_UNSUCCESSFUL", NT_STATUS_UNSUCCESSFUL },
	{ "NT_STATUS_NOT_IMPLEMENTED", NT_STATUS_NOT_IMPLEMENTED },
	{ "NT_STATUS_INVALID_INFO_CLASS", NT_STATUS_INVALID_INFO_CLASS },
	{ "NT_STATUS_INFO_LENGTH_MISMATCH", NT_STATUS_INFO_LENGTH_MISMATCH },
	{ "NT_STATUS_ACCESS_VIOLATION", NT_STATUS_ACCESS_VIOLATION },
	{ "STATUS_BUFFER_OVERFLOW", STATUS_BUFFER_OVERFLOW },
	{ "NT_STATUS_IN_PAGE_ERROR", NT_STATUS_IN_PAGE_ERROR },
	{ "NT_STATUS_PAGEFILE_QUOTA", NT_STATUS_PAGEFILE_QUOTA },
	{ "NT_STATUS_INVALID_HANDLE", NT_STATUS_INVALID_HANDLE },
	{ "NT_STATUS_BAD_INITIAL_STACK", NT_STATUS_BAD_INITIAL_STACK },
	{ "NT_STATUS_BAD_INITIAL_PC", NT_STATUS_BAD_INITIAL_PC },
	{ "NT_STATUS_INVALID_CID", NT_STATUS_INVALID_CID },
	{ "NT_STATUS_TIMER_NOT_CANCELED", NT_STATUS_TIMER_NOT_CANCELED },
	{ "NT_STATUS_INVALID_PARAMETER", NT_STATUS_INVALID_PARAMETER },
	{ "NT_STATUS_NO_SUCH_DEVICE", NT_STATUS_NO_SUCH_DEVICE },
	{ "NT_STATUS_NO_SUCH_FILE", NT_STATUS_NO_SUCH_FILE },
	{ "NT_STATUS_INVALID_DEVICE_REQUEST", NT_STATUS_INVALID_DEVICE_REQUEST },
	{ "NT_STATUS_END_OF_FILE", NT_STATUS_END_OF_FILE },
	{ "NT_STATUS_WRONG_VOLUME", NT_STATUS_WRONG_VOLUME },
	{ "NT_STATUS_NO_MEDIA_IN_DEVICE", NT_STATUS_NO_MEDIA_IN_DEVICE },
	{ "NT_STATUS_UNRECOGNIZED_MEDIA", NT_STATUS_UNRECOGNIZED_MEDIA },
	{ "NT_STATUS_NONEXISTENT_SECTOR", NT_STATUS_NONEXISTENT_SECTOR },
	{ "NT_STATUS_MORE_PROCESSING_REQUIRED", NT_STATUS_MORE_PROCESSING_REQUIRED },
	{ "NT_STATUS_NO_MEMORY", NT_STATUS_NO_MEMORY },
	{ "NT_STATUS_CONFLICTING_ADDRESSES", NT_STATUS_CONFLICTING_ADDRESSES },
	{ "NT_STATUS_NOT_MAPPED_VIEW", NT_STATUS_NOT_MAPPED_VIEW },
	{ "NT_STATUS_UNABLE_TO_FREE_VM", NT_STATUS_UNABLE_TO_FREE_VM },
	{ "NT_STATUS_UNABLE_TO_DELETE_SECTION", NT_STATUS_UNABLE_TO_DELETE_SECTION },
	{ "NT_STATUS_INVALID_SYSTEM_SERVICE", NT_STATUS_INVALID_SYSTEM_SERVICE },
	{ "NT_STATUS_ILLEGAL_INSTRUCTION", NT_STATUS_ILLEGAL_INSTRUCTION },
	{ "NT_STATUS_INVALID_LOCK_SEQUENCE", NT_STATUS_INVALID_LOCK_SEQUENCE },
	{ "NT_STATUS_INVALID_VIEW_SIZE", NT_STATUS_INVALID_VIEW_SIZE },
	{ "NT_STATUS_INVALID_FILE_FOR_SECTION", NT_STATUS_INVALID_FILE_FOR_SECTION },
	{ "NT_STATUS_ALREADY_COMMITTED", NT_STATUS_ALREADY_COMMITTED },
	{ "NT_STATUS_ACCESS_DENIED", NT_STATUS_ACCESS_DENIED },
	{ "NT_STATUS_BUFFER_TOO_SMALL", NT_STATUS_BUFFER_TOO_SMALL },
	{ "NT_STATUS_OBJECT_TYPE_MISMATCH", NT_STATUS_OBJECT_TYPE_MISMATCH },
	{ "NT_STATUS_NONCONTINUABLE_EXCEPTION", NT_STATUS_NONCONTINUABLE_EXCEPTION },
	{ "NT_STATUS_INVALID_DISPOSITION", NT_STATUS_INVALID_DISPOSITION },
	{ "NT_STATUS_UNWIND", NT_STATUS_UNWIND },
	{ "NT_STATUS_BAD_STACK", NT_STATUS_BAD_STACK },
	{ "NT_STATUS_INVALID_UNWIND_TARGET", NT_STATUS_INVALID_UNWIND_TARGET },
	{ "NT_STATUS_NOT_LOCKED", NT_STATUS_NOT_LOCKED },
	{ "NT_STATUS_PARITY_ERROR", NT_STATUS_PARITY_ERROR },
	{ "NT_STATUS_UNABLE_TO_DECOMMIT_VM", NT_STATUS_UNABLE_TO_DECOMMIT_VM },
	{ "NT_STATUS_NOT_COMMITTED", NT_STATUS_NOT_COMMITTED },
	{ "NT_STATUS_INVALID_PORT_ATTRIBUTES", NT_STATUS_INVALID_PORT_ATTRIBUTES },
	{ "NT_STATUS_PORT_MESSAGE_TOO_LONG", NT_STATUS_PORT_MESSAGE_TOO_LONG },
	{ "NT_STATUS_INVALID_PARAMETER_MIX", NT_STATUS_INVALID_PARAMETER_MIX },
	{ "NT_STATUS_INVALID_QUOTA_LOWER", NT_STATUS_INVALID_QUOTA_LOWER },
	{ "NT_STATUS_DISK_CORRUPT_ERROR", NT_STATUS_DISK_CORRUPT_ERROR },
	{ "NT_STATUS_OBJECT_NAME_INVALID", NT_STATUS_OBJECT_NAME_INVALID },
	{ "NT_STATUS_OBJECT_NAME_NOT_FOUND", NT_STATUS_OBJECT_NAME_NOT_FOUND },
	{ "NT_STATUS_OBJECT_NAME_COLLISION", NT_STATUS_OBJECT_NAME_COLLISION },
	{ "NT_STATUS_HANDLE_NOT_WAITABLE", NT_STATUS_HANDLE_NOT_WAITABLE },
	{ "NT_STATUS_PORT_DISCONNECTED", NT_STATUS_PORT_DISCONNECTED },
	{ "NT_STATUS_DEVICE_ALREADY_ATTACHED", NT_STATUS_DEVICE_ALREADY_ATTACHED },
	{ "NT_STATUS_OBJECT_PATH_INVALID", NT_STATUS_OBJECT_PATH_INVALID },
	{ "NT_STATUS_OBJECT_PATH_NOT_FOUND", NT_STATUS_OBJECT_PATH_NOT_FOUND },
	{ "NT_STATUS_OBJECT_PATH_SYNTAX_BAD", NT_STATUS_OBJECT_PATH_SYNTAX_BAD },
	{ "NT_STATUS_DATA_OVERRUN", NT_STATUS_DATA_OVERRUN },
	{ "NT_STATUS_DATA_LATE_ERROR", NT_STATUS_DATA_LATE_ERROR },
	{ "NT_STATUS_DATA_ERROR", NT_STATUS_DATA_ERROR },
	{ "NT_STATUS_CRC_ERROR", NT_STATUS_CRC_ERROR },
	{ "NT_STATUS_SECTION_TOO_BIG", NT_STATUS_SECTION_TOO_BIG },
	{ "NT_STATUS_PORT_CONNECTION_REFUSED", NT_STATUS_PORT_CONNECTION_REFUSED },
	{ "NT_STATUS_INVALID_PORT_HANDLE", NT_STATUS_INVALID_PORT_HANDLE },
	{ "NT_STATUS_SHARING_VIOLATION", NT_STATUS_SHARING_VIOLATION },
	{ "NT_STATUS_QUOTA_EXCEEDED", NT_STATUS_QUOTA_EXCEEDED },
	{ "NT_STATUS_INVALID_PAGE_PROTECTION", NT_STATUS_INVALID_PAGE_PROTECTION },
	{ "NT_STATUS_MUTANT_NOT_OWNED", NT_STATUS_MUTANT_NOT_OWNED },
	{ "NT_STATUS_SEMAPHORE_LIMIT_EXCEEDED", NT_STATUS_SEMAPHORE_LIMIT_EXCEEDED },
	{ "NT_STATUS_PORT_ALREADY_SET", NT_STATUS_PORT_ALREADY_SET },
	{ "NT_STATUS_SECTION_NOT_IMAGE", NT_STATUS_SECTION_NOT_IMAGE },
	{ "NT_STATUS_SUSPEND_COUNT_EXCEEDED", NT_STATUS_SUSPEND_COUNT_EXCEEDED },
	{ "NT_STATUS_THREAD_IS_TERMINATING", NT_STATUS_THREAD_IS_TERMINATING },
	{ "NT_STATUS_BAD_WORKING_SET_LIMIT", NT_STATUS_BAD_WORKING_SET_LIMIT },
	{ "NT_STATUS_INCOMPATIBLE_FILE_MAP", NT_STATUS_INCOMPATIBLE_FILE_MAP },
	{ "NT_STATUS_SECTION_PROTECTION", NT_STATUS_SECTION_PROTECTION },
	{ "NT_STATUS_EAS_NOT_SUPPORTED", NT_STATUS_EAS_NOT_SUPPORTED },
	{ "NT_STATUS_EA_TOO_LARGE", NT_STATUS_EA_TOO_LARGE },
	{ "NT_STATUS_NONEXISTENT_EA_ENTRY", NT_STATUS_NONEXISTENT_EA_ENTRY },
	{ "NT_STATUS_NO_EAS_ON_FILE", NT_STATUS_NO_EAS_ON_FILE },
	{ "NT_STATUS_EA_CORRUPT_ERROR", NT_STATUS_EA_CORRUPT_ERROR },
	{ "NT_STATUS_FILE_LOCK_CONFLICT", NT_STATUS_FILE_LOCK_CONFLICT },
	{ "NT_STATUS_LOCK_NOT_GRANTED", NT_STATUS_LOCK_NOT_GRANTED },
	{ "NT_STATUS_DELETE_PENDING", NT_STATUS_DELETE_PENDING },
	{ "NT_STATUS_CTL_FILE_NOT_SUPPORTED", NT_STATUS_CTL_FILE_NOT_SUPPORTED },
	{ "NT_STATUS_UNKNOWN_REVISION", NT_STATUS_UNKNOWN_REVISION },
	{ "NT_STATUS_REVISION_MISMATCH", NT_STATUS_REVISION_MISMATCH },
	{ "NT_STATUS_INVALID_OWNER", NT_STATUS_INVALID_OWNER },
	{ "NT_STATUS_INVALID_PRIMARY_GROUP", NT_STATUS_INVALID_PRIMARY_GROUP },
	{ "NT_STATUS_NO_IMPERSONATION_TOKEN", NT_STATUS_NO_IMPERSONATION_TOKEN },
	{ "NT_STATUS_CANT_DISABLE_MANDATORY", NT_STATUS_CANT_DISABLE_MANDATORY },
	{ "NT_STATUS_NO_LOGON_SERVERS", NT_STATUS_NO_LOGON_SERVERS },
	{ "NT_STATUS_NO_SUCH_LOGON_SESSION", NT_STATUS_NO_SUCH_LOGON_SESSION },
	{ "NT_STATUS_NO_SUCH_PRIVILEGE", NT_STATUS_NO_SUCH_PRIVILEGE },
	{ "NT_STATUS_PRIVILEGE_NOT_HELD", NT_STATUS_PRIVILEGE_NOT_HELD },
	{ "NT_STATUS_INVALID_ACCOUNT_NAME", NT_STATUS_INVALID_ACCOUNT_NAME },
	{ "NT_STATUS_USER_EXISTS", NT_STATUS_USER_EXISTS },
	{ "NT_STATUS_NO_SUCH_USER", NT_STATUS_NO_SUCH_USER },
	{ "NT_STATUS_GROUP_EXISTS", NT_STATUS_GROUP_EXISTS },
	{ "NT_STATUS_NO_SUCH_GROUP", NT_STATUS_NO_SUCH_GROUP },
	{ "NT_STATUS_MEMBER_IN_GROUP", NT_STATUS_MEMBER_IN_GROUP },
	{ "NT_STATUS_MEMBER_NOT_IN_GROUP", NT_STATUS_MEMBER_NOT_IN_GROUP },
	{ "NT_STATUS_LAST_ADMIN", NT_STATUS_LAST_ADMIN },
	{ "NT_STATUS_WRONG_PASSWORD", NT_STATUS_WRONG_PASSWORD },
	{ "NT_STATUS_ILL_FORMED_PASSWORD", NT_STATUS_ILL_FORMED_PASSWORD },
	{ "NT_STATUS_PASSWORD_RESTRICTION", NT_STATUS_PASSWORD_RESTRICTION },
	{ "NT_STATUS_LOGON_FAILURE", NT_STATUS_LOGON_FAILURE },
	{ "NT_STATUS_ACCOUNT_RESTRICTION", NT_STATUS_ACCOUNT_RESTRICTION },
	{ "NT_STATUS_INVALID_LOGON_HOURS", NT_STATUS_INVALID_LOGON_HOURS },
	{ "NT_STATUS_INVALID_WORKSTATION", NT_STATUS_INVALID_WORKSTATION },
	{ "NT_STATUS_PASSWORD_EXPIRED", NT_STATUS_PASSWORD_EXPIRED },
	{ "NT_STATUS_ACCOUNT_DISABLED", NT_STATUS_ACCOUNT_DISABLED },
	{ "NT_STATUS_NONE_MAPPED", NT_STATUS_NONE_MAPPED },
	{ "NT_STATUS_TOO_MANY_LUIDS_REQUESTED", NT_STATUS_TOO_MANY_LUIDS_REQUESTED },
	{ "NT_STATUS_LUIDS_EXHAUSTED", NT_STATUS_LUIDS_EXHAUSTED },
	{ "NT_STATUS_INVALID_SUB_AUTHORITY", NT_STATUS_INVALID_SUB_AUTHORITY },
	{ "NT_STATUS_INVALID_ACL", NT_STATUS_INVALID_ACL },
	{ "NT_STATUS_INVALID_SID", NT_STATUS_INVALID_SID },
	{ "NT_STATUS_INVALID_SECURITY_DESCR", NT_STATUS_INVALID_SECURITY_DESCR },
	{ "NT_STATUS_PROCEDURE_NOT_FOUND", NT_STATUS_PROCEDURE_NOT_FOUND },
	{ "NT_STATUS_INVALID_IMAGE_FORMAT", NT_STATUS_INVALID_IMAGE_FORMAT },
	{ "NT_STATUS_NO_TOKEN", NT_STATUS_NO_TOKEN },
	{ "NT_STATUS_BAD_INHERITANCE_ACL", NT_STATUS_BAD_INHERITANCE_ACL },
	{ "NT_STATUS_RANGE_NOT_LOCKED", NT_STATUS_RANGE_NOT_LOCKED },
	{ "NT_STATUS_DISK_FULL", NT_STATUS_DISK_FULL },
	{ "NT_STATUS_SERVER_DISABLED", NT_STATUS_SERVER_DISABLED },
	{ "NT_STATUS_SERVER_NOT_DISABLED", NT_STATUS_SERVER_NOT_DISABLED },
	{ "NT_STATUS_TOO_MANY_GUIDS_REQUESTED", NT_STATUS_TOO_MANY_GUIDS_REQUESTED },
	{ "NT_STATUS_GUIDS_EXHAUSTED", NT_STATUS_GUIDS_EXHAUSTED },
	{ "NT_STATUS_INVALID_ID_AUTHORITY", NT_STATUS_INVALID_ID_AUTHORITY },
	{ "NT_STATUS_AGENTS_EXHAUSTED", NT_STATUS_AGENTS_EXHAUSTED },
	{ "NT_STATUS_INVALID_VOLUME_LABEL", NT_STATUS_INVALID_VOLUME_LABEL },
	{ "NT_STATUS_SECTION_NOT_EXTENDED", NT_STATUS_SECTION_NOT_EXTENDED },
	{ "NT_STATUS_NOT_MAPPED_DATA", NT_STATUS_NOT_MAPPED_DATA },
	{ "NT_STATUS_RESOURCE_DATA_NOT_FOUND", NT_STATUS_RESOURCE_DATA_NOT_FOUND },
	{ "NT_STATUS_RESOURCE_TYPE_NOT_FOUND", NT_STATUS_RESOURCE_TYPE_NOT_FOUND },
	{ "NT_STATUS_RESOURCE_NAME_NOT_FOUND", NT_STATUS_RESOURCE_NAME_NOT_FOUND },
	{ "NT_STATUS_ARRAY_BOUNDS_EXCEEDED", NT_STATUS_ARRAY_BOUNDS_EXCEEDED },
	{ "NT_STATUS_FLOAT_DENORMAL_OPERAND", NT_STATUS_FLOAT_DENORMAL_OPERAND },
	{ "NT_STATUS_FLOAT_DIVIDE_BY_ZERO", NT_STATUS_FLOAT_DIVIDE_BY_ZERO },
	{ "NT_STATUS_FLOAT_INEXACT_RESULT", NT_STATUS_FLOAT_INEXACT_RESULT },
	{ "NT_STATUS_FLOAT_INVALID_OPERATION", NT_STATUS_FLOAT_INVALID_OPERATION },
	{ "NT_STATUS_FLOAT_OVERFLOW", NT_STATUS_FLOAT_OVERFLOW },
	{ "NT_STATUS_FLOAT_STACK_CHECK", NT_STATUS_FLOAT_STACK_CHECK },
	{ "NT_STATUS_FLOAT_UNDERFLOW", NT_STATUS_FLOAT_UNDERFLOW },
	{ "NT_STATUS_INTEGER_DIVIDE_BY_ZERO", NT_STATUS_INTEGER_DIVIDE_BY_ZERO },
	{ "NT_STATUS_INTEGER_OVERFLOW", NT_STATUS_INTEGER_OVERFLOW },
	{ "NT_STATUS_PRIVILEGED_INSTRUCTION", NT_STATUS_PRIVILEGED_INSTRUCTION },
	{ "NT_STATUS_TOO_MANY_PAGING_FILES", NT_STATUS_TOO_MANY_PAGING_FILES },
	{ "NT_STATUS_FILE_INVALID", NT_STATUS_FILE_INVALID },
	{ "NT_STATUS_ALLOTTED_SPACE_EXCEEDED", NT_STATUS_ALLOTTED_SPACE_EXCEEDED },
	{ "NT_STATUS_INSUFFICIENT_RESOURCES", NT_STATUS_INSUFFICIENT_RESOURCES },
	{ "NT_STATUS_DFS_EXIT_PATH_FOUND", NT_STATUS_DFS_EXIT_PATH_FOUND },
	{ "NT_STATUS_DEVICE_DATA_ERROR", NT_STATUS_DEVICE_DATA_ERROR },
	{ "NT_STATUS_DEVICE_NOT_CONNECTED", NT_STATUS_DEVICE_NOT_CONNECTED },
	{ "NT_STATUS_DEVICE_POWER_FAILURE", NT_STATUS_DEVICE_POWER_FAILURE },
	{ "NT_STATUS_FREE_VM_NOT_AT_BASE", NT_STATUS_FREE_VM_NOT_AT_BASE },
	{ "NT_STATUS_MEMORY_NOT_ALLOCATED", NT_STATUS_MEMORY_NOT_ALLOCATED },
	{ "NT_STATUS_WORKING_SET_QUOTA", NT_STATUS_WORKING_SET_QUOTA },
	{ "NT_STATUS_MEDIA_WRITE_PROTECTED", NT_STATUS_MEDIA_WRITE_PROTECTED },
	{ "NT_STATUS_DEVICE_NOT_READY", NT_STATUS_DEVICE_NOT_READY },
	{ "NT_STATUS_INVALID_GROUP_ATTRIBUTES", NT_STATUS_INVALID_GROUP_ATTRIBUTES },
	{ "NT_STATUS_BAD_IMPERSONATION_LEVEL", NT_STATUS_BAD_IMPERSONATION_LEVEL },
	{ "NT_STATUS_CANT_OPEN_ANONYMOUS", NT_STATUS_CANT_OPEN_ANONYMOUS },
	{ "NT_STATUS_BAD_VALIDATION_CLASS", NT_STATUS_BAD_VALIDATION_CLASS },
	{ "NT_STATUS_BAD_TOKEN_TYPE", NT_STATUS_BAD_TOKEN_TYPE },
	{ "NT_STATUS_BAD_MASTER_BOOT_RECORD", NT_STATUS_BAD_MASTER_BOOT_RECORD },
	{ "NT_STATUS_INSTRUCTION_MISALIGNMENT", NT_STATUS_INSTRUCTION_MISALIGNMENT },
	{ "NT_STATUS_INSTANCE_NOT_AVAILABLE", NT_STATUS_INSTANCE_NOT_AVAILABLE },
	{ "NT_STATUS_PIPE_NOT_AVAILABLE", NT_STATUS_PIPE_NOT_AVAILABLE },
	{ "NT_STATUS_INVALID_PIPE_STATE", NT_STATUS_INVALID_PIPE_STATE },
	{ "NT_STATUS_PIPE_BUSY", NT_STATUS_PIPE_BUSY },
	{ "NT_STATUS_ILLEGAL_FUNCTION", NT_STATUS_ILLEGAL_FUNCTION },
	{ "NT_STATUS_PIPE_DISCONNECTED", NT_STATUS_PIPE_DISCONNECTED },
	{ "NT_STATUS_PIPE_CLOSING", NT_STATUS_PIPE_CLOSING },
	{ "NT_STATUS_PIPE_CONNECTED", NT_STATUS_PIPE_CONNECTED },
	{ "NT_STATUS_PIPE_LISTENING", NT_STATUS_PIPE_LISTENING },
	{ "NT_STATUS_INVALID_READ_MODE", NT_STATUS_INVALID_READ_MODE },
	{ "NT_STATUS_IO_TIMEOUT", NT_STATUS_IO_TIMEOUT },
	{ "NT_STATUS_FILE_FORCED_CLOSED", NT_STATUS_FILE_FORCED_CLOSED },
	{ "NT_STATUS_PROFILING_NOT_STARTED", NT_STATUS_PROFILING_NOT_STARTED },
	{ "NT_STATUS_PROFILING_NOT_STOPPED", NT_STATUS_PROFILING_NOT_STOPPED },
	{ "NT_STATUS_COULD_NOT_INTERPRET", NT_STATUS_COULD_NOT_INTERPRET },
	{ "NT_STATUS_FILE_IS_A_DIRECTORY", NT_STATUS_FILE_IS_A_DIRECTORY },
	{ "NT_STATUS_NOT_SUPPORTED", NT_STATUS_NOT_SUPPORTED },
	{ "NT_STATUS_REMOTE_NOT_LISTENING", NT_STATUS_REMOTE_NOT_LISTENING },
	{ "NT_STATUS_DUPLICATE_NAME", NT_STATUS_DUPLICATE_NAME },
	{ "NT_STATUS_BAD_NETWORK_PATH", NT_STATUS_BAD_NETWORK_PATH },
	{ "NT_STATUS_NETWORK_BUSY", NT_STATUS_NETWORK_BUSY },
	{ "NT_STATUS_DEVICE_DOES_NOT_EXIST", NT_STATUS_DEVICE_DOES_NOT_EXIST },
	{ "NT_STATUS_TOO_MANY_COMMANDS", NT_STATUS_TOO_MANY_COMMANDS },
	{ "NT_STATUS_ADAPTER_HARDWARE_ERROR", NT_STATUS_ADAPTER_HARDWARE_ERROR },
	{ "NT_STATUS_INVALID_NETWORK_RESPONSE", NT_STATUS_INVALID_NETWORK_RESPONSE },
	{ "NT_STATUS_UNEXPECTED_NETWORK_ERROR", NT_STATUS_UNEXPECTED_NETWORK_ERROR },
	{ "NT_STATUS_BAD_REMOTE_ADAPTER", NT_STATUS_BAD_REMOTE_ADAPTER },
	{ "NT_STATUS_PRINT_QUEUE_FULL", NT_STATUS_PRINT_QUEUE_FULL },
	{ "NT_STATUS_NO_SPOOL_SPACE", NT_STATUS_NO_SPOOL_SPACE },
	{ "NT_STATUS_PRINT_CANCELLED", NT_STATUS_PRINT_CANCELLED },
	{ "NT_STATUS_NETWORK_NAME_DELETED", NT_STATUS_NETWORK_NAME_DELETED },
	{ "NT_STATUS_NETWORK_ACCESS_DENIED", NT_STATUS_NETWORK_ACCESS_DENIED },
	{ "NT_STATUS_BAD_DEVICE_TYPE", NT_STATUS_BAD_DEVICE_TYPE },
	{ "NT_STATUS_BAD_NETWORK_NAME", NT_STATUS_BAD_NETWORK_NAME },
	{ "NT_STATUS_TOO_MANY_NAMES", NT_STATUS_TOO_MANY_NAMES },
	{ "NT_STATUS_TOO_MANY_SESSIONS", NT_STATUS_TOO_MANY_SESSIONS },
	{ "NT_STATUS_SHARING_PAUSED", NT_STATUS_SHARING_PAUSED },
	{ "NT_STATUS_REQUEST_NOT_ACCEPTED", NT_STATUS_REQUEST_NOT_ACCEPTED },
	{ "NT_STATUS_REDIRECTOR_PAUSED", NT_STATUS_REDIRECTOR_PAUSED },
	{ "NT_STATUS_NET_WRITE_FAULT", NT_STATUS_NET_WRITE_FAULT },
	{ "NT_STATUS_PROFILING_AT_LIMIT", NT_STATUS_PROFILING_AT_LIMIT },
	{ "NT_STATUS_NOT_SAME_DEVICE", NT_STATUS_NOT_SAME_DEVICE },
	{ "NT_STATUS_FILE_RENAMED", NT_STATUS_FILE_RENAMED },
	{ "NT_STATUS_VIRTUAL_CIRCUIT_CLOSED", NT_STATUS_VIRTUAL_CIRCUIT_CLOSED },
	{ "NT_STATUS_NO_SECURITY_ON_OBJECT", NT_STATUS_NO_SECURITY_ON_OBJECT },
	{ "NT_STATUS_CANT_WAIT", NT_STATUS_CANT_WAIT },
	{ "NT_STATUS_PIPE_EMPTY", NT_STATUS_PIPE_EMPTY },
	{ "NT_STATUS_CANT_ACCESS_DOMAIN_INFO", NT_STATUS_CANT_ACCESS_DOMAIN_INFO },
	{ "NT_STATUS_CANT_TERMINATE_SELF", NT_STATUS_CANT_TERMINATE_SELF },
	{ "NT_STATUS_INVALID_SERVER_STATE", NT_STATUS_INVALID_SERVER_STATE },
	{ "NT_STATUS_INVALID_DOMAIN_STATE", NT_STATUS_INVALID_DOMAIN_STATE },
	{ "NT_STATUS_INVALID_DOMAIN_ROLE", NT_STATUS_INVALID_DOMAIN_ROLE },
	{ "NT_STATUS_NO_SUCH_DOMAIN", NT_STATUS_NO_SUCH_DOMAIN },
	{ "NT_STATUS_DOMAIN_EXISTS", NT_STATUS_DOMAIN_EXISTS },
	{ "NT_STATUS_DOMAIN_LIMIT_EXCEEDED", NT_STATUS_DOMAIN_LIMIT_EXCEEDED },
	{ "NT_STATUS_OPLOCK_NOT_GRANTED", NT_STATUS_OPLOCK_NOT_GRANTED },
	{ "NT_STATUS_INVALID_OPLOCK_PROTOCOL", NT_STATUS_INVALID_OPLOCK_PROTOCOL },
	{ "NT_STATUS_INTERNAL_DB_CORRUPTION", NT_STATUS_INTERNAL_DB_CORRUPTION },
	{ "NT_STATUS_INTERNAL_ERROR", NT_STATUS_INTERNAL_ERROR },
	{ "NT_STATUS_GENERIC_NOT_MAPPED", NT_STATUS_GENERIC_NOT_MAPPED },
	{ "NT_STATUS_BAD_DESCRIPTOR_FORMAT", NT_STATUS_BAD_DESCRIPTOR_FORMAT },
	{ "NT_STATUS_INVALID_USER_BUFFER", NT_STATUS_INVALID_USER_BUFFER },
	{ "NT_STATUS_UNEXPECTED_IO_ERROR", NT_STATUS_UNEXPECTED_IO_ERROR },
	{ "NT_STATUS_UNEXPECTED_MM_CREATE_ERR", NT_STATUS_UNEXPECTED_MM_CREATE_ERR },
	{ "NT_STATUS_UNEXPECTED_MM_MAP_ERROR", NT_STATUS_UNEXPECTED_MM_MAP_ERROR },
	{ "NT_STATUS_UNEXPECTED_MM_EXTEND_ERR", NT_STATUS_UNEXPECTED_MM_EXTEND_ERR },
	{ "NT_STATUS_NOT_LOGON_PROCESS", NT_STATUS_NOT_LOGON_PROCESS },
	{ "NT_STATUS_LOGON_SESSION_EXISTS", NT_STATUS_LOGON_SESSION_EXISTS },
	{ "NT_STATUS_INVALID_PARAMETER_1", NT_STATUS_INVALID_PARAMETER_1 },
	{ "NT_STATUS_INVALID_PARAMETER_2", NT_STATUS_INVALID_PARAMETER_2 },
	{ "NT_STATUS_INVALID_PARAMETER_3", NT_STATUS_INVALID_PARAMETER_3 },
	{ "NT_STATUS_INVALID_PARAMETER_4", NT_STATUS_INVALID_PARAMETER_4 },
	{ "NT_STATUS_INVALID_PARAMETER_5", NT_STATUS_INVALID_PARAMETER_5 },
	{ "NT_STATUS_INVALID_PARAMETER_6", NT_STATUS_INVALID_PARAMETER_6 },
	{ "NT_STATUS_INVALID_PARAMETER_7", NT_STATUS_INVALID_PARAMETER_7 },
	{ "NT_STATUS_INVALID_PARAMETER_8", NT_STATUS_INVALID_PARAMETER_8 },
	{ "NT_STATUS_INVALID_PARAMETER_9", NT_STATUS_INVALID_PARAMETER_9 },
	{ "NT_STATUS_INVALID_PARAMETER_10", NT_STATUS_INVALID_PARAMETER_10 },
	{ "NT_STATUS_INVALID_PARAMETER_11", NT_STATUS_INVALID_PARAMETER_11 },
	{ "NT_STATUS_INVALID_PARAMETER_12", NT_STATUS_INVALID_PARAMETER_12 },
	{ "NT_STATUS_REDIRECTOR_NOT_STARTED", NT_STATUS_REDIRECTOR_NOT_STARTED },
	{ "NT_STATUS_REDIRECTOR_STARTED", NT_STATUS_REDIRECTOR_STARTED },
	{ "NT_STATUS_STACK_OVERFLOW", NT_STATUS_STACK_OVERFLOW },
	{ "NT_STATUS_NO_SUCH_PACKAGE", NT_STATUS_NO_SUCH_PACKAGE },
	{ "NT_STATUS_BAD_FUNCTION_TABLE", NT_STATUS_BAD_FUNCTION_TABLE },
	{ "NT_STATUS_DIRECTORY_NOT_EMPTY", NT_STATUS_DIRECTORY_NOT_EMPTY },
	{ "NT_STATUS_FILE_CORRUPT_ERROR", NT_STATUS_FILE_CORRUPT_ERROR },
	{ "NT_STATUS_NOT_A_DIRECTORY", NT_STATUS_NOT_A_DIRECTORY },
	{ "NT_STATUS_BAD_LOGON_SESSION_STATE", NT_STATUS_BAD_LOGON_SESSION_STATE },
	{ "NT_STATUS_LOGON_SESSION_COLLISION", NT_STATUS_LOGON_SESSION_COLLISION },
	{ "NT_STATUS_NAME_TOO_LONG", NT_STATUS_NAME_TOO_LONG },
	{ "NT_STATUS_FILES_OPEN", NT_STATUS_FILES_OPEN },
	{ "NT_STATUS_CONNECTION_IN_USE", NT_STATUS_CONNECTION_IN_USE },
	{ "NT_STATUS_MESSAGE_NOT_FOUND", NT_STATUS_MESSAGE_NOT_FOUND },
	{ "NT_STATUS_PROCESS_IS_TERMINATING", NT_STATUS_PROCESS_IS_TERMINATING },
	{ "NT_STATUS_INVALID_LOGON_TYPE", NT_STATUS_INVALID_LOGON_TYPE },
	{ "NT_STATUS_NO_GUID_TRANSLATION", NT_STATUS_NO_GUID_TRANSLATION },
	{ "NT_STATUS_CANNOT_IMPERSONATE", NT_STATUS_CANNOT_IMPERSONATE },
	{ "NT_STATUS_IMAGE_ALREADY_LOADED", NT_STATUS_IMAGE_ALREADY_LOADED },
	{ "NT_STATUS_ABIOS_NOT_PRESENT", NT_STATUS_ABIOS_NOT_PRESENT },
	{ "NT_STATUS_ABIOS_LID_NOT_EXIST", NT_STATUS_ABIOS_LID_NOT_EXIST },
	{ "NT_STATUS_ABIOS_LID_ALREADY_OWNED", NT_STATUS_ABIOS_LID_ALREADY_OWNED },
	{ "NT_STATUS_ABIOS_NOT_LID_OWNER", NT_STATUS_ABIOS_NOT_LID_OWNER },
	{ "NT_STATUS_ABIOS_INVALID_COMMAND", NT_STATUS_ABIOS_INVALID_COMMAND },
	{ "NT_STATUS_ABIOS_INVALID_LID", NT_STATUS_ABIOS_INVALID_LID },
	{ "NT_STATUS_ABIOS_SELECTOR_NOT_AVAILABLE", NT_STATUS_ABIOS_SELECTOR_NOT_AVAILABLE },
	{ "NT_STATUS_ABIOS_INVALID_SELECTOR", NT_STATUS_ABIOS_INVALID_SELECTOR },
	{ "NT_STATUS_NO_LDT", NT_STATUS_NO_LDT },
	{ "NT_STATUS_INVALID_LDT_SIZE", NT_STATUS_INVALID_LDT_SIZE },
	{ "NT_STATUS_INVALID_LDT_OFFSET", NT_STATUS_INVALID_LDT_OFFSET },
	{ "NT_STATUS_INVALID_LDT_DESCRIPTOR", NT_STATUS_INVALID_LDT_DESCRIPTOR },
	{ "NT_STATUS_INVALID_IMAGE_NE_FORMAT", NT_STATUS_INVALID_IMAGE_NE_FORMAT },
	{ "NT_STATUS_RXACT_INVALID_STATE", NT_STATUS_RXACT_INVALID_STATE },
	{ "NT_STATUS_RXACT_COMMIT_FAILURE", NT_STATUS_RXACT_COMMIT_FAILURE },
	{ "NT_STATUS_MAPPED_FILE_SIZE_ZERO", NT_STATUS_MAPPED_FILE_SIZE_ZERO },
	{ "NT_STATUS_TOO_MANY_OPENED_FILES", NT_STATUS_TOO_MANY_OPENED_FILES },
	{ "NT_STATUS_CANCELLED", NT_STATUS_CANCELLED },
	{ "NT_STATUS_CANNOT_DELETE", NT_STATUS_CANNOT_DELETE },
	{ "NT_STATUS_INVALID_COMPUTER_NAME", NT_STATUS_INVALID_COMPUTER_NAME },
	{ "NT_STATUS_FILE_DELETED", NT_STATUS_FILE_DELETED },
	{ "NT_STATUS_SPECIAL_ACCOUNT", NT_STATUS_SPECIAL_ACCOUNT },
	{ "NT_STATUS_SPECIAL_GROUP", NT_STATUS_SPECIAL_GROUP },
	{ "NT_STATUS_SPECIAL_USER", NT_STATUS_SPECIAL_USER },
	{ "NT_STATUS_MEMBERS_PRIMARY_GROUP", NT_STATUS_MEMBERS_PRIMARY_GROUP },
	{ "NT_STATUS_FILE_CLOSED", NT_STATUS_FILE_CLOSED },
	{ "NT_STATUS_TOO_MANY_THREADS", NT_STATUS_TOO_MANY_THREADS },
	{ "NT_STATUS_THREAD_NOT_IN_PROCESS", NT_STATUS_THREAD_NOT_IN_PROCESS },
	{ "NT_STATUS_TOKEN_ALREADY_IN_USE", NT_STATUS_TOKEN_ALREADY_IN_USE },
	{ "NT_STATUS_PAGEFILE_QUOTA_EXCEEDED", NT_STATUS_PAGEFILE_QUOTA_EXCEEDED },
	{ "NT_STATUS_COMMITMENT_LIMIT", NT_STATUS_COMMITMENT_LIMIT },
	{ "NT_STATUS_INVALID_IMAGE_LE_FORMAT", NT_STATUS_INVALID_IMAGE_LE_FORMAT },
	{ "NT_STATUS_INVALID_IMAGE_NOT_MZ", NT_STATUS_INVALID_IMAGE_NOT_MZ },
	{ "NT_STATUS_INVALID_IMAGE_PROTECT", NT_STATUS_INVALID_IMAGE_PROTECT },
	{ "NT_STATUS_INVALID_IMAGE_WIN_16", NT_STATUS_INVALID_IMAGE_WIN_16 },
	{ "NT_STATUS_LOGON_SERVER_CONFLICT", NT_STATUS_LOGON_SERVER_CONFLICT },
	{ "NT_STATUS_TIME_DIFFERENCE_AT_DC", NT_STATUS_TIME_DIFFERENCE_AT_DC },
	{ "NT_STATUS_SYNCHRONIZATION_REQUIRED", NT_STATUS_SYNCHRONIZATION_REQUIRED },
	{ "NT_STATUS_DLL_NOT_FOUND", NT_STATUS_DLL_NOT_FOUND },
	{ "NT_STATUS_OPEN_FAILED", NT_STATUS_OPEN_FAILED },
	{ "NT_STATUS_IO_PRIVILEGE_FAILED", NT_STATUS_IO_PRIVILEGE_FAILED },
	{ "NT_STATUS_ORDINAL_NOT_FOUND", NT_STATUS_ORDINAL_NOT_FOUND },
	{ "NT_STATUS_ENTRYPOINT_NOT_FOUND", NT_STATUS_ENTRYPOINT_NOT_FOUND },
	{ "NT_STATUS_CONTROL_C_EXIT", NT_STATUS_CONTROL_C_EXIT },
	{ "NT_STATUS_LOCAL_DISCONNECT", NT_STATUS_LOCAL_DISCONNECT },
	{ "NT_STATUS_REMOTE_DISCONNECT", NT_STATUS_REMOTE_DISCONNECT },
	{ "NT_STATUS_REMOTE_RESOURCES", NT_STATUS_REMOTE_RESOURCES },
	{ "NT_STATUS_LINK_FAILED", NT_STATUS_LINK_FAILED },
	{ "NT_STATUS_LINK_TIMEOUT", NT_STATUS_LINK_TIMEOUT },
	{ "NT_STATUS_INVALID_CONNECTION", NT_STATUS_INVALID_CONNECTION },
	{ "NT_STATUS_INVALID_ADDRESS", NT_STATUS_INVALID_ADDRESS },
	{ "NT_STATUS_DLL_INIT_FAILED", NT_STATUS_DLL_INIT_FAILED },
	{ "NT_STATUS_MISSING_SYSTEMFILE", NT_STATUS_MISSING_SYSTEMFILE },
	{ "NT_STATUS_UNHANDLED_EXCEPTION", NT_STATUS_UNHANDLED_EXCEPTION },
	{ "NT_STATUS_APP_INIT_FAILURE", NT_STATUS_APP_INIT_FAILURE },
	{ "NT_STATUS_PAGEFILE_CREATE_FAILED", NT_STATUS_PAGEFILE_CREATE_FAILED },
	{ "NT_STATUS_NO_PAGEFILE", NT_STATUS_NO_PAGEFILE },
	{ "NT_STATUS_INVALID_LEVEL", NT_STATUS_INVALID_LEVEL },
	{ "NT_STATUS_WRONG_PASSWORD_CORE", NT_STATUS_WRONG_PASSWORD_CORE },
	{ "NT_STATUS_ILLEGAL_FLOAT_CONTEXT", NT_STATUS_ILLEGAL_FLOAT_CONTEXT },
	{ "NT_STATUS_PIPE_BROKEN", NT_STATUS_PIPE_BROKEN },
	{ "NT_STATUS_REGISTRY_CORRUPT", NT_STATUS_REGISTRY_CORRUPT },
	{ "NT_STATUS_REGISTRY_IO_FAILED", NT_STATUS_REGISTRY_IO_FAILED },
	{ "NT_STATUS_NO_EVENT_PAIR", NT_STATUS_NO_EVENT_PAIR },
	{ "NT_STATUS_UNRECOGNIZED_VOLUME", NT_STATUS_UNRECOGNIZED_VOLUME },
	{ "NT_STATUS_SERIAL_NO_DEVICE_INITED", NT_STATUS_SERIAL_NO_DEVICE_INITED },
	{ "NT_STATUS_NO_SUCH_ALIAS", NT_STATUS_NO_SUCH_ALIAS },
	{ "NT_STATUS_MEMBER_NOT_IN_ALIAS", NT_STATUS_MEMBER_NOT_IN_ALIAS },
	{ "NT_STATUS_MEMBER_IN_ALIAS", NT_STATUS_MEMBER_IN_ALIAS },
	{ "NT_STATUS_ALIAS_EXISTS", NT_STATUS_ALIAS_EXISTS },
	{ "NT_STATUS_LOGON_NOT_GRANTED", NT_STATUS_LOGON_NOT_GRANTED },
	{ "NT_STATUS_TOO_MANY_SECRETS", NT_STATUS_TOO_MANY_SECRETS },
	{ "NT_STATUS_SECRET_TOO_LONG", NT_STATUS_SECRET_TOO_LONG },
	{ "NT_STATUS_INTERNAL_DB_ERROR", NT_STATUS_INTERNAL_DB_ERROR },
	{ "NT_STATUS_FULLSCREEN_MODE", NT_STATUS_FULLSCREEN_MODE },
	{ "NT_STATUS_TOO_MANY_CONTEXT_IDS", NT_STATUS_TOO_MANY_CONTEXT_IDS },
	{ "NT_STATUS_LOGON_TYPE_NOT_GRANTED", NT_STATUS_LOGON_TYPE_NOT_GRANTED },
	{ "NT_STATUS_NOT_REGISTRY_FILE", NT_STATUS_NOT_REGISTRY_FILE },
	{ "NT_STATUS_NT_CROSS_ENCRYPTION_REQUIRED", NT_STATUS_NT_CROSS_ENCRYPTION_REQUIRED },
	{ "NT_STATUS_DOMAIN_CTRLR_CONFIG_ERROR", NT_STATUS_DOMAIN_CTRLR_CONFIG_ERROR },
	{ "NT_STATUS_FT_MISSING_MEMBER", NT_STATUS_FT_MISSING_MEMBER },
	{ "NT_STATUS_ILL_FORMED_SERVICE_ENTRY", NT_STATUS_ILL_FORMED_SERVICE_ENTRY },
	{ "NT_STATUS_ILLEGAL_CHARACTER", NT_STATUS_ILLEGAL_CHARACTER },
	{ "NT_STATUS_UNMAPPABLE_CHARACTER", NT_STATUS_UNMAPPABLE_CHARACTER },
	{ "NT_STATUS_UNDEFINED_CHARACTER", NT_STATUS_UNDEFINED_CHARACTER },
	{ "NT_STATUS_FLOPPY_VOLUME", NT_STATUS_FLOPPY_VOLUME },
	{ "NT_STATUS_FLOPPY_ID_MARK_NOT_FOUND", NT_STATUS_FLOPPY_ID_MARK_NOT_FOUND },
	{ "NT_STATUS_FLOPPY_WRONG_CYLINDER", NT_STATUS_FLOPPY_WRONG_CYLINDER },
	{ "NT_STATUS_FLOPPY_UNKNOWN_ERROR", NT_STATUS_FLOPPY_UNKNOWN_ERROR },
	{ "NT_STATUS_FLOPPY_BAD_REGISTERS", NT_STATUS_FLOPPY_BAD_REGISTERS },
	{ "NT_STATUS_DISK_RECALIBRATE_FAILED", NT_STATUS_DISK_RECALIBRATE_FAILED },
	{ "NT_STATUS_DISK_OPERATION_FAILED", NT_STATUS_DISK_OPERATION_FAILED },
	{ "NT_STATUS_DISK_RESET_FAILED", NT_STATUS_DISK_RESET_FAILED },
	{ "NT_STATUS_SHARED_IRQ_BUSY", NT_STATUS_SHARED_IRQ_BUSY },
	{ "NT_STATUS_FT_ORPHANING", NT_STATUS_FT_ORPHANING },
	{ "NT_STATUS_PARTITION_FAILURE", NT_STATUS_PARTITION_FAILURE },
	{ "NT_STATUS_INVALID_BLOCK_LENGTH", NT_STATUS_INVALID_BLOCK_LENGTH },
	{ "NT_STATUS_DEVICE_NOT_PARTITIONED", NT_STATUS_DEVICE_NOT_PARTITIONED },
	{ "NT_STATUS_UNABLE_TO_LOCK_MEDIA", NT_STATUS_UNABLE_TO_LOCK_MEDIA },
	{ "NT_STATUS_UNABLE_TO_UNLOAD_MEDIA", NT_STATUS_UNABLE_TO_UNLOAD_MEDIA },
	{ "NT_STATUS_EOM_OVERFLOW", NT_STATUS_EOM_OVERFLOW },
	{ "NT_STATUS_NO_MEDIA", NT_STATUS_NO_MEDIA },
	{ "NT_STATUS_NO_SUCH_MEMBER", NT_STATUS_NO_SUCH_MEMBER },
	{ "NT_STATUS_INVALID_MEMBER", NT_STATUS_INVALID_MEMBER },
	{ "NT_STATUS_KEY_DELETED", NT_STATUS_KEY_DELETED },
	{ "NT_STATUS_NO_LOG_SPACE", NT_STATUS_NO_LOG_SPACE },
	{ "NT_STATUS_TOO_MANY_SIDS", NT_STATUS_TOO_MANY_SIDS },
	{ "NT_STATUS_LM_CROSS_ENCRYPTION_REQUIRED", NT_STATUS_LM_CROSS_ENCRYPTION_REQUIRED },
	{ "NT_STATUS_KEY_HAS_CHILDREN", NT_STATUS_KEY_HAS_CHILDREN },
	{ "NT_STATUS_CHILD_MUST_BE_VOLATILE", NT_STATUS_CHILD_MUST_BE_VOLATILE },
	{ "NT_STATUS_DEVICE_CONFIGURATION_ERROR", NT_STATUS_DEVICE_CONFIGURATION_ERROR },
	{ "NT_STATUS_DRIVER_INTERNAL_ERROR", NT_STATUS_DRIVER_INTERNAL_ERROR },
	{ "NT_STATUS_INVALID_DEVICE_STATE", NT_STATUS_INVALID_DEVICE_STATE },
	{ "NT_STATUS_IO_DEVICE_ERROR", NT_STATUS_IO_DEVICE_ERROR },
	{ "NT_STATUS_DEVICE_PROTOCOL_ERROR", NT_STATUS_DEVICE_PROTOCOL_ERROR },
	{ "NT_STATUS_BACKUP_CONTROLLER", NT_STATUS_BACKUP_CONTROLLER },
	{ "NT_STATUS_LOG_FILE_FULL", NT_STATUS_LOG_FILE_FULL },
	{ "NT_STATUS_TOO_LATE", NT_STATUS_TOO_LATE },
	{ "NT_STATUS_NO_TRUST_LSA_SECRET", NT_STATUS_NO_TRUST_LSA_SECRET },
	{ "NT_STATUS_NO_TRUST_SAM_ACCOUNT", NT_STATUS_NO_TRUST_SAM_ACCOUNT },
	{ "NT_STATUS_TRUSTED_DOMAIN_FAILURE", NT_STATUS_TRUSTED_DOMAIN_FAILURE },
	{ "NT_STATUS_TRUSTED_RELATIONSHIP_FAILURE", NT_STATUS_TRUSTED_RELATIONSHIP_FAILURE },
	{ "NT_STATUS_EVENTLOG_FILE_CORRUPT", NT_STATUS_EVENTLOG_FILE_CORRUPT },
	{ "NT_STATUS_EVENTLOG_CANT_START", NT_STATUS_EVENTLOG_CANT_START },
	{ "NT_STATUS_TRUST_FAILURE", NT_STATUS_TRUST_FAILURE },
	{ "NT_STATUS_MUTANT_LIMIT_EXCEEDED", NT_STATUS_MUTANT_LIMIT_EXCEEDED },
	{ "NT_STATUS_NETLOGON_NOT_STARTED", NT_STATUS_NETLOGON_NOT_STARTED },
	{ "NT_STATUS_ACCOUNT_EXPIRED", NT_STATUS_ACCOUNT_EXPIRED },
	{ "NT_STATUS_POSSIBLE_DEADLOCK", NT_STATUS_POSSIBLE_DEADLOCK },
	{ "NT_STATUS_NETWORK_CREDENTIAL_CONFLICT", NT_STATUS_NETWORK_CREDENTIAL_CONFLICT },
	{ "NT_STATUS_REMOTE_SESSION_LIMIT", NT_STATUS_REMOTE_SESSION_LIMIT },
	{ "NT_STATUS_EVENTLOG_FILE_CHANGED", NT_STATUS_EVENTLOG_FILE_CHANGED },
	{ "NT_STATUS_NOLOGON_INTERDOMAIN_TRUST_ACCOUNT", NT_STATUS_NOLOGON_INTERDOMAIN_TRUST_ACCOUNT },
	{ "NT_STATUS_NOLOGON_WORKSTATION_TRUST_ACCOUNT", NT_STATUS_NOLOGON_WORKSTATION_TRUST_ACCOUNT },
	{ "NT_STATUS_NOLOGON_SERVER_TRUST_ACCOUNT", NT_STATUS_NOLOGON_SERVER_TRUST_ACCOUNT },
	{ "NT_STATUS_DOMAIN_TRUST_INCONSISTENT", NT_STATUS_DOMAIN_TRUST_INCONSISTENT },
	{ "NT_STATUS_FS_DRIVER_REQUIRED", NT_STATUS_FS_DRIVER_REQUIRED },
	{ "NT_STATUS_NO_USER_SESSION_KEY", NT_STATUS_NO_USER_SESSION_KEY },
	{ "NT_STATUS_USER_SESSION_DELETED", NT_STATUS_USER_SESSION_DELETED },
	{ "NT_STATUS_RESOURCE_LANG_NOT_FOUND", NT_STATUS_RESOURCE_LANG_NOT_FOUND },
	{ "NT_STATUS_INSUFF_SERVER_RESOURCES", NT_STATUS_INSUFF_SERVER_RESOURCES },
	{ "NT_STATUS_INVALID_BUFFER_SIZE", NT_STATUS_INVALID_BUFFER_SIZE },
	{ "NT_STATUS_INVALID_ADDRESS_COMPONENT", NT_STATUS_INVALID_ADDRESS_COMPONENT },
	{ "NT_STATUS_INVALID_ADDRESS_WILDCARD", NT_STATUS_INVALID_ADDRESS_WILDCARD },
	{ "NT_STATUS_TOO_MANY_ADDRESSES", NT_STATUS_TOO_MANY_ADDRESSES },
	{ "NT_STATUS_ADDRESS_ALREADY_EXISTS", NT_STATUS_ADDRESS_ALREADY_EXISTS },
	{ "NT_STATUS_ADDRESS_CLOSED", NT_STATUS_ADDRESS_CLOSED },
	{ "NT_STATUS_CONNECTION_DISCONNECTED", NT_STATUS_CONNECTION_DISCONNECTED },
	{ "NT_STATUS_CONNECTION_RESET", NT_STATUS_CONNECTION_RESET },
	{ "NT_STATUS_TOO_MANY_NODES", NT_STATUS_TOO_MANY_NODES },
	{ "NT_STATUS_TRANSACTION_ABORTED", NT_STATUS_TRANSACTION_ABORTED },
	{ "NT_STATUS_TRANSACTION_TIMED_OUT", NT_STATUS_TRANSACTION_TIMED_OUT },
	{ "NT_STATUS_TRANSACTION_NO_RELEASE", NT_STATUS_TRANSACTION_NO_RELEASE },
	{ "NT_STATUS_TRANSACTION_NO_MATCH", NT_STATUS_TRANSACTION_NO_MATCH },
	{ "NT_STATUS_TRANSACTION_RESPONDED", NT_STATUS_TRANSACTION_RESPONDED },
	{ "NT_STATUS_TRANSACTION_INVALID_ID", NT_STATUS_TRANSACTION_INVALID_ID },
	{ "NT_STATUS_TRANSACTION_INVALID_TYPE", NT_STATUS_TRANSACTION_INVALID_TYPE },
	{ "NT_STATUS_NOT_SERVER_SESSION", NT_STATUS_NOT_SERVER_SESSION },
	{ "NT_STATUS_NOT_CLIENT_SESSION", NT_STATUS_NOT_CLIENT_SESSION },
	{ "NT_STATUS_CANNOT_LOAD_REGISTRY_FILE", NT_STATUS_CANNOT_LOAD_REGISTRY_FILE },
	{ "NT_STATUS_DEBUG_ATTACH_FAILED", NT_STATUS_DEBUG_ATTACH_FAILED },
	{ "NT_STATUS_SYSTEM_PROCESS_TERMINATED", NT_STATUS_SYSTEM_PROCESS_TERMINATED },
	{ "NT_STATUS_DATA_NOT_ACCEPTED", NT_STATUS_DATA_NOT_ACCEPTED },
	{ "NT_STATUS_NO_BROWSER_SERVERS_FOUND", NT_STATUS_NO_BROWSER_SERVERS_FOUND },
	{ "NT_STATUS_VDM_HARD_ERROR", NT_STATUS_VDM_HARD_ERROR },
	{ "NT_STATUS_DRIVER_CANCEL_TIMEOUT", NT_STATUS_DRIVER_CANCEL_TIMEOUT },
	{ "NT_STATUS_REPLY_MESSAGE_MISMATCH", NT_STATUS_REPLY_MESSAGE_MISMATCH },
	{ "NT_STATUS_MAPPED_ALIGNMENT", NT_STATUS_MAPPED_ALIGNMENT },
	{ "NT_STATUS_IMAGE_CHECKSUM_MISMATCH", NT_STATUS_IMAGE_CHECKSUM_MISMATCH },
	{ "NT_STATUS_LOST_WRITEBEHIND_DATA", NT_STATUS_LOST_WRITEBEHIND_DATA },
	{ "NT_STATUS_CLIENT_SERVER_PARAMETERS_INVALID", NT_STATUS_CLIENT_SERVER_PARAMETERS_INVALID },
	{ "NT_STATUS_PASSWORD_MUST_CHANGE", NT_STATUS_PASSWORD_MUST_CHANGE },
	{ "NT_STATUS_NOT_FOUND", NT_STATUS_NOT_FOUND },
	{ "NT_STATUS_NOT_TINY_STREAM", NT_STATUS_NOT_TINY_STREAM },
	{ "NT_STATUS_RECOVERY_FAILURE", NT_STATUS_RECOVERY_FAILURE },
	{ "NT_STATUS_STACK_OVERFLOW_READ", NT_STATUS_STACK_OVERFLOW_READ },
	{ "NT_STATUS_FAIL_CHECK", NT_STATUS_FAIL_CHECK },
	{ "NT_STATUS_DUPLICATE_OBJECTID", NT_STATUS_DUPLICATE_OBJECTID },
	{ "NT_STATUS_OBJECTID_EXISTS", NT_STATUS_OBJECTID_EXISTS },
	{ "NT_STATUS_CONVERT_TO_LARGE", NT_STATUS_CONVERT_TO_LARGE },
	{ "NT_STATUS_RETRY", NT_STATUS_RETRY },
	{ "NT_STATUS_FOUND_OUT_OF_SCOPE", NT_STATUS_FOUND_OUT_OF_SCOPE },
	{ "NT_STATUS_ALLOCATE_BUCKET", NT_STATUS_ALLOCATE_BUCKET },
	{ "NT_STATUS_PROPSET_NOT_FOUND", NT_STATUS_PROPSET_NOT_FOUND },
	{ "NT_STATUS_MARSHALL_OVERFLOW", NT_STATUS_MARSHALL_OVERFLOW },
	{ "NT_STATUS_INVALID_VARIANT", NT_STATUS_INVALID_VARIANT },
	{ "NT_STATUS_DOMAIN_CONTROLLER_NOT_FOUND", NT_STATUS_DOMAIN_CONTROLLER_NOT_FOUND },
	{ "NT_STATUS_ACCOUNT_LOCKED_OUT", NT_STATUS_ACCOUNT_LOCKED_OUT },
	{ "NT_STATUS_HANDLE_NOT_CLOSABLE", NT_STATUS_HANDLE_NOT_CLOSABLE },
	{ "NT_STATUS_CONNECTION_REFUSED", NT_STATUS_CONNECTION_REFUSED },
	{ "NT_STATUS_GRACEFUL_DISCONNECT", NT_STATUS_GRACEFUL_DISCONNECT },
	{ "NT_STATUS_ADDRESS_ALREADY_ASSOCIATED", NT_STATUS_ADDRESS_ALREADY_ASSOCIATED },
	{ "NT_STATUS_ADDRESS_NOT_ASSOCIATED", NT_STATUS_ADDRESS_NOT_ASSOCIATED },
	{ "NT_STATUS_CONNECTION_INVALID", NT_STATUS_CONNECTION_INVALID },
	{ "NT_STATUS_CONNECTION_ACTIVE", NT_STATUS_CONNECTION_ACTIVE },
	{ "NT_STATUS_NETWORK_UNREACHABLE", NT_STATUS_NETWORK_UNREACHABLE },
	{ "NT_STATUS_HOST_UNREACHABLE", NT_STATUS_HOST_UNREACHABLE },
	{ "NT_STATUS_PROTOCOL_UNREACHABLE", NT_STATUS_PROTOCOL_UNREACHABLE },
	{ "NT_STATUS_PORT_UNREACHABLE", NT_STATUS_PORT_UNREACHABLE },
	{ "NT_STATUS_REQUEST_ABORTED", NT_STATUS_REQUEST_ABORTED },
	{ "NT_STATUS_CONNECTION_ABORTED", NT_STATUS_CONNECTION_ABORTED },
	{ "NT_STATUS_BAD_COMPRESSION_BUFFER", NT_STATUS_BAD_COMPRESSION_BUFFER },
	{ "NT_STATUS_USER_MAPPED_FILE", NT_STATUS_USER_MAPPED_FILE },
	{ "NT_STATUS_AUDIT_FAILED", NT_STATUS_AUDIT_FAILED },
	{ "NT_STATUS_TIMER_RESOLUTION_NOT_SET", NT_STATUS_TIMER_RESOLUTION_NOT_SET },
	{ "NT_STATUS_CONNECTION_COUNT_LIMIT", NT_STATUS_CONNECTION_COUNT_LIMIT },
	{ "NT_STATUS_LOGIN_TIME_RESTRICTION", NT_STATUS_LOGIN_TIME_RESTRICTION },
	{ "NT_STATUS_LOGIN_WKSTA_RESTRICTION", NT_STATUS_LOGIN_WKSTA_RESTRICTION },
	{ "NT_STATUS_IMAGE_MP_UP_MISMATCH", NT_STATUS_IMAGE_MP_UP_MISMATCH },
	{ "NT_STATUS_INSUFFICIENT_LOGON_INFO", NT_STATUS_INSUFFICIENT_LOGON_INFO },
	{ "NT_STATUS_BAD_DLL_ENTRYPOINT", NT_STATUS_BAD_DLL_ENTRYPOINT },
	{ "NT_STATUS_BAD_SERVICE_ENTRYPOINT", NT_STATUS_BAD_SERVICE_ENTRYPOINT },
	{ "NT_STATUS_LPC_REPLY_LOST", NT_STATUS_LPC_REPLY_LOST },
	{ "NT_STATUS_IP_ADDRESS_CONFLICT1", NT_STATUS_IP_ADDRESS_CONFLICT1 },
	{ "NT_STATUS_IP_ADDRESS_CONFLICT2", NT_STATUS_IP_ADDRESS_CONFLICT2 },
	{ "NT_STATUS_REGISTRY_QUOTA_LIMIT", NT_STATUS_REGISTRY_QUOTA_LIMIT },
	{ "NT_STATUS_PATH_NOT_COVERED", NT_STATUS_PATH_NOT_COVERED },
	{ "NT_STATUS_NO_CALLBACK_ACTIVE", NT_STATUS_NO_CALLBACK_ACTIVE },
	{ "NT_STATUS_LICENSE_QUOTA_EXCEEDED", NT_STATUS_LICENSE_QUOTA_EXCEEDED },
	{ "NT_STATUS_PWD_TOO_SHORT", NT_STATUS_PWD_TOO_SHORT },
	{ "NT_STATUS_PWD_TOO_RECENT", NT_STATUS_PWD_TOO_RECENT },
	{ "NT_STATUS_PWD_HISTORY_CONFLICT", NT_STATUS_PWD_HISTORY_CONFLICT },
	{ "NT_STATUS_PLUGPLAY_NO_DEVICE", NT_STATUS_PLUGPLAY_NO_DEVICE },
	{ "NT_STATUS_UNSUPPORTED_COMPRESSION", NT_STATUS_UNSUPPORTED_COMPRESSION },
	{ "NT_STATUS_INVALID_HW_PROFILE", NT_STATUS_INVALID_HW_PROFILE },
	{ "NT_STATUS_INVALID_PLUGPLAY_DEVICE_PATH", NT_STATUS_INVALID_PLUGPLAY_DEVICE_PATH },
	{ "NT_STATUS_DRIVER_ORDINAL_NOT_FOUND", NT_STATUS_DRIVER_ORDINAL_NOT_FOUND },
	{ "NT_STATUS_DRIVER_ENTRYPOINT_NOT_FOUND", NT_STATUS_DRIVER_ENTRYPOINT_NOT_FOUND },
	{ "NT_STATUS_RESOURCE_NOT_OWNED", NT_STATUS_RESOURCE_NOT_OWNED },
	{ "NT_STATUS_TOO_MANY_LINKS", NT_STATUS_TOO_MANY_LINKS },
	{ "NT_STATUS_QUOTA_LIST_INCONSISTENT", NT_STATUS_QUOTA_LIST_INCONSISTENT },
	{ "NT_STATUS_FILE_IS_OFFLINE", NT_STATUS_FILE_IS_OFFLINE },
	{ "NT_STATUS_DS_NO_MORE_RIDS", NT_STATUS_DS_NO_MORE_RIDS },
	{ "NT_STATUS_IO_REPARSE_DATA_INVALID",
	  NT_STATUS_IO_REPARSE_DATA_INVALID },
	{ "NT_STATUS_IO_REPARSE_TAG_NOT_HANDLED",
	  NT_STATUS_IO_REPARSE_TAG_NOT_HANDLED },
	{ "NT_STATUS_NOT_A_REPARSE_POINT", NT_STATUS_NOT_A_REPARSE_POINT },
	{ "NT_STATUS_NO_MORE_ENTRIES", NT_STATUS_NO_MORE_ENTRIES },
	{ "NT_STATUS_FILE_NOT_AVAILABLE", NT_STATUS_FILE_NOT_AVAILABLE },
	{ "NT_STATUS_RPC_PROTSEQ_NOT_SUPPORTED", NT_STATUS_RPC_PROTSEQ_NOT_SUPPORTED },
	{ "NT_STATUS_RPC_UNSUPPORTED_NAME_SYNTAX", NT_STATUS_RPC_UNSUPPORTED_NAME_SYNTAX },
	{ "NT_STATUS_RPC_UNKNOWN_IF", NT_STATUS_RPC_UNKNOWN_IF },
	{ "NT_STATUS_RPC_CALL_FAILED", NT_STATUS_RPC_CALL_FAILED },
	{ "NT_STATUS_RPC_PROTOCOL_ERROR", NT_STATUS_RPC_PROTOCOL_ERROR },
	{ "NT_STATUS_RPC_PROCNUM_OUT_OF_RANGE", NT_STATUS_RPC_PROCNUM_OUT_OF_RANGE },
	{ "NT_STATUS_RPC_CANNOT_SUPPORT", NT_STATUS_RPC_CANNOT_SUPPORT },
	{ "NT_STATUS_RPC_SEC_PKG_ERROR", NT_STATUS_RPC_SEC_PKG_ERROR },
	{ "NT_STATUS_RPC_SS_CONTEXT_MISMATCH", NT_STATUS_RPC_SS_CONTEXT_MISMATCH },
	{ "NT_STATUS_RPC_ENUM_VALUE_OUT_OF_RANGE", NT_STATUS_RPC_ENUM_VALUE_OUT_OF_RANGE },
	{ "NT_STATUS_RPC_BAD_STUB_DATA", NT_STATUS_RPC_BAD_STUB_DATA },
	{ "NT_STATUS_RPC_INVALID_PIPE_OBJECT", NT_STATUS_RPC_INVALID_PIPE_OBJECT },
	{ "NT_STATUS_RPC_INVALID_PIPE_OPERATION", NT_STATUS_RPC_INVALID_PIPE_OPERATION },
	{ "NT_STATUS_RPC_WRONG_PIPE_VERSION", NT_STATUS_RPC_WRONG_PIPE_VERSION },
	{ "NT_STATUS_RPC_PIPE_CLOSED", NT_STATUS_RPC_PIPE_CLOSED },
	{ "NT_STATUS_RPC_PIPE_DISCIPLINE_ERROR", NT_STATUS_RPC_PIPE_DISCIPLINE_ERROR },
	{ "NT_STATUS_RPC_PIPE_EMPTY", NT_STATUS_RPC_PIPE_EMPTY },
	{ "NT_STATUS_CURRENT_DOMAIN_NOT_ALLOWED", NT_STATUS_CURRENT_DOMAIN_NOT_ALLOWED },
	{ "NT_STATUS_OBJECTID_NOT_FOUND", NT_STATUS_OBJECTID_NOT_FOUND },
	{ "NT_STATUS_NETWORK_SESSION_EXPIRED", NT_STATUS_NETWORK_SESSION_EXPIRED },
	{ "NT_STATUS_ALL_SIDS_FILTERED", NT_STATUS_ALL_SIDS_FILTERED },
	{ "NT_STATUS_DOWNGRADE_DETECTED", NT_STATUS_DOWNGRADE_DETECTED },
	{ "NT_STATUS_NO_S4U_PROT_SUPPORT", NT_STATUS_NO_S4U_PROT_SUPPORT },
	{ "NT_STATUS_CROSSREALM_DELEGATION_FAILURE", NT_STATUS_CROSSREALM_DELEGATION_FAILURE },
	{ "NT_STATUS_INVALID_LOCK_RANGE", NT_STATUS_INVALID_LOCK_RANGE },
	{ "NT_STATUS_ERROR_DS_OBJ_STRING_NAME_EXISTS", NT_STATUS_ERROR_DS_OBJ_STRING_NAME_EXISTS },
	{ "NT_STATUS_ERROR_DS_INCOMPATIBLE_VERSION", NT_STATUS_ERROR_DS_INCOMPATIBLE_VERSION },
	{ "STATUS_MORE_ENTRIES", STATUS_MORE_ENTRIES },
	{ "STATUS_SOME_UNMAPPED", STATUS_SOME_UNMAPPED },
	{ "STATUS_NOTIFY_CLEANUP", STATUS_NOTIFY_CLEANUP },
	{ "STATUS_NOTIFY_ENUM_DIR", STATUS_NOTIFY_ENUM_DIR },

	DOS_CODE(ERRDOS, ERRsuccess),
	DOS_CODE(ERRDOS, ERRbadfunc),
	DOS_CODE(ERRDOS, ERRbadfile),
	DOS_CODE(ERRDOS, ERRbadpath),
	DOS_CODE(ERRDOS, ERRnofids),
	DOS_CODE(ERRDOS, ERRnoaccess),
	DOS_CODE(ERRDOS, ERRbadfid),
	DOS_CODE(ERRDOS, ERRbadmcb),
	DOS_CODE(ERRDOS, ERRnomem),
	DOS_CODE(ERRDOS, ERRbadmem),
	DOS_CODE(ERRDOS, ERRbadenv),
	DOS_CODE(ERRDOS, ERRbadaccess),
	DOS_CODE(ERRDOS, ERRbaddata),
	DOS_CODE(ERRDOS, ERRres),
	DOS_CODE(ERRDOS, ERRbaddrive),
	DOS_CODE(ERRDOS, ERRremcd),
	DOS_CODE(ERRDOS, ERRdiffdevice),
	DOS_CODE(ERRDOS, ERRnofiles),
	DOS_CODE(ERRDOS, ERRgeneral),
	DOS_CODE(ERRDOS, ERRbadshare),
	DOS_CODE(ERRDOS, ERRlock),
	DOS_CODE(ERRDOS, ERRunsup),
	DOS_CODE(ERRDOS, ERRnetnamedel),
	DOS_CODE(ERRDOS, ERRnosuchshare),
	DOS_CODE(ERRDOS, ERRfilexists),
	DOS_CODE(ERRDOS, ERRinvalidparam),
	DOS_CODE(ERRDOS, ERRcannotopen),
	DOS_CODE(ERRDOS, ERRinsufficientbuffer),
	DOS_CODE(ERRDOS, ERRinvalidname),
	DOS_CODE(ERRDOS, ERRunknownlevel),
	DOS_CODE(ERRDOS, ERRnotlocked),
	DOS_CODE(ERRDOS, ERRinvalidpath),
	DOS_CODE(ERRDOS, ERRcancelviolation),
	DOS_CODE(ERRDOS, ERRnoatomiclocks),
	DOS_CODE(ERRDOS, ERRrename),
	DOS_CODE(ERRDOS, ERRbadpipe),
	DOS_CODE(ERRDOS, ERRpipebusy),
	DOS_CODE(ERRDOS, ERRpipeclosing),
	DOS_CODE(ERRDOS, ERRnotconnected),
	DOS_CODE(ERRDOS, ERRmoredata),
	DOS_CODE(ERRDOS, ERRnomoreitems),
	DOS_CODE(ERRDOS, ERRbaddirectory),
	DOS_CODE(ERRDOS, ERReasnotsupported),
	DOS_CODE(ERRDOS, ERRlogonfailure),
	DOS_CODE(ERRDOS, ERRbuftoosmall),
	DOS_CODE(ERRDOS, ERRunknownipc),
	DOS_CODE(ERRDOS, ERRnosuchprintjob),
	DOS_CODE(ERRDOS, ERRinvgroup),
	DOS_CODE(ERRDOS, ERRnoipc),
	DOS_CODE(ERRDOS, ERRdriveralreadyinstalled),
	DOS_CODE(ERRDOS, ERRunknownprinterport),
	DOS_CODE(ERRDOS, ERRunknownprinterdriver),
	DOS_CODE(ERRDOS, ERRunknownprintprocessor),
	DOS_CODE(ERRDOS, ERRinvalidseparatorfile),
	DOS_CODE(ERRDOS, ERRinvalidjobpriority),
	DOS_CODE(ERRDOS, ERRinvalidprintername),
	DOS_CODE(ERRDOS, ERRprinteralreadyexists),
	DOS_CODE(ERRDOS, ERRinvalidprintercommand),
	DOS_CODE(ERRDOS, ERRinvaliddatatype),
	DOS_CODE(ERRDOS, ERRinvalidenvironment),
	DOS_CODE(ERRDOS, ERRunknownprintmonitor),
	DOS_CODE(ERRDOS, ERRprinterdriverinuse),
	DOS_CODE(ERRDOS, ERRspoolfilenotfound),
	DOS_CODE(ERRDOS, ERRnostartdoc),
	DOS_CODE(ERRDOS, ERRnoaddjob),
	DOS_CODE(ERRDOS, ERRprintprocessoralreadyinstalled),
	DOS_CODE(ERRDOS, ERRprintmonitoralreadyinstalled),
	DOS_CODE(ERRDOS, ERRinvalidprintmonitor),
	DOS_CODE(ERRDOS, ERRprintmonitorinuse),
	DOS_CODE(ERRDOS, ERRprinterhasjobsqueued),
	DOS_CODE(ERRDOS, ERReainconsistent),

	DOS_CODE(ERRSRV, ERRerror),
	DOS_CODE(ERRSRV, ERRbadpw),
	DOS_CODE(ERRSRV, ERRbadtype),
	DOS_CODE(ERRSRV, ERRaccess),
	DOS_CODE(ERRSRV, ERRinvnid),
	DOS_CODE(ERRSRV, ERRinvnetname),
	DOS_CODE(ERRSRV, ERRinvdevice),
	DOS_CODE(ERRSRV, ERRqfull),
	DOS_CODE(ERRSRV, ERRqtoobig),
	DOS_CODE(ERRSRV, ERRinvpfid),
	DOS_CODE(ERRSRV, ERRsmbcmd),
	DOS_CODE(ERRSRV, ERRsrverror),
	DOS_CODE(ERRSRV, ERRfilespecs),
	DOS_CODE(ERRSRV, ERRbadlink),
	DOS_CODE(ERRSRV, ERRbadpermits),
	DOS_CODE(ERRSRV, ERRbadpid),
	DOS_CODE(ERRSRV, ERRsetattrmode),
	DOS_CODE(ERRSRV, ERRpaused),
	DOS_CODE(ERRSRV, ERRmsgoff),
	DOS_CODE(ERRSRV, ERRnoroom),
	DOS_CODE(ERRSRV, ERRrmuns),
	DOS_CODE(ERRSRV, ERRtimeout),
	DOS_CODE(ERRSRV, ERRnoresource),
	DOS_CODE(ERRSRV, ERRtoomanyuids),
	DOS_CODE(ERRSRV, ERRbaduid),
	DOS_CODE(ERRSRV, ERRuseMPX),
	DOS_CODE(ERRSRV, ERRuseSTD),
	DOS_CODE(ERRSRV, ERRcontMPX),
	DOS_CODE(ERRSRV, ERRnosupport),
	DOS_CODE(ERRSRV, ERRunknownsmb),

	DOS_CODE(ERRHRD, ERRnowrite),
	DOS_CODE(ERRHRD, ERRbadunit),
	DOS_CODE(ERRHRD, ERRnotready),
	DOS_CODE(ERRHRD, ERRbadcmd),
	DOS_CODE(ERRHRD, ERRdata),
	DOS_CODE(ERRHRD, ERRbadreq),
	DOS_CODE(ERRHRD, ERRseek),
	DOS_CODE(ERRHRD, ERRbadmedia),
	DOS_CODE(ERRHRD, ERRbadsector),
	DOS_CODE(ERRHRD, ERRnopaper),
	DOS_CODE(ERRHRD, ERRwrite),
	DOS_CODE(ERRHRD, ERRread),
	DOS_CODE(ERRHRD, ERRgeneral),
	DOS_CODE(ERRHRD, ERRwrongdisk),
	DOS_CODE(ERRHRD, ERRFCBunavail),
	DOS_CODE(ERRHRD, ERRsharebufexc),
	DOS_CODE(ERRHRD, ERRdiskfull),

	LDAP_CODE(LDAP_SUCCESS),
	LDAP_CODE(LDAP_OPERATIONS_ERROR),
	LDAP_CODE(LDAP_PROTOCOL_ERROR),
	LDAP_CODE(LDAP_TIME_LIMIT_EXCEEDED),
	LDAP_CODE(LDAP_SIZE_LIMIT_EXCEEDED),
	LDAP_CODE(LDAP_COMPARE_FALSE),
	LDAP_CODE(LDAP_COMPARE_TRUE),
	LDAP_CODE(LDAP_AUTH_METHOD_NOT_SUPPORTED),
	LDAP_CODE(LDAP_STRONG_AUTH_REQUIRED),
	LDAP_CODE(LDAP_REFERRAL),
	LDAP_CODE(LDAP_ADMIN_LIMIT_EXCEEDED),
	LDAP_CODE(LDAP_UNAVAILABLE_CRITICAL_EXTENSION),
	LDAP_CODE(LDAP_CONFIDENTIALITY_REQUIRED),
	LDAP_CODE(LDAP_SASL_BIND_IN_PROGRESS),
	LDAP_CODE(LDAP_NO_SUCH_ATTRIBUTE),
	LDAP_CODE(LDAP_UNDEFINED_ATTRIBUTE_TYPE),
	LDAP_CODE(LDAP_INAPPROPRIATE_MATCHING),
	LDAP_CODE(LDAP_CONSTRAINT_VIOLATION),
	LDAP_CODE(LDAP_ATTRIBUTE_OR_VALUE_EXISTS),
	LDAP_CODE(LDAP_INVALID_ATTRIBUTE_SYNTAX),
	LDAP_CODE(LDAP_NO_SUCH_OBJECT),
	LDAP_CODE(LDAP_ALIAS_PROBLEM),
	LDAP_CODE(LDAP_INVALID_DN_SYNTAX),
	LDAP_CODE(LDAP_ALIAS_DEREFERENCING_PROBLEM),
	LDAP_CODE(LDAP_INAPPROPRIATE_AUTHENTICATION),
	LDAP_CODE(LDAP_INVALID_CREDENTIALS),
	LDAP_CODE(LDAP_INSUFFICIENT_ACCESS_RIGHTS),
	LDAP_CODE(LDAP_BUSY),
	LDAP_CODE(LDAP_UNAVAILABLE),
	LDAP_CODE(LDAP_UNWILLING_TO_PERFORM),
	LDAP_CODE(LDAP_LOOP_DETECT),
	LDAP_CODE(LDAP_NAMING_VIOLATION),
	LDAP_CODE(LDAP_OBJECT_CLASS_VIOLATION),
	LDAP_CODE(LDAP_NOT_ALLOWED_ON_NON_LEAF),
	LDAP_CODE(LDAP_NOT_ALLOWED_ON_RDN),
	LDAP_CODE(LDAP_ENTRY_ALREADY_EXISTS),
	LDAP_CODE(LDAP_OBJECT_CLASS_MODS_PROHIBITED),
	LDAP_CODE(LDAP_AFFECTS_MULTIPLE_DSAS),
	LDAP_CODE(LDAP_OTHER),

	{ NULL, NT_STATUS(0) }
};

/* These need sorting..... */

const nt_err_code_struct nt_err_desc[] =
{
	{ N_("Success"), 				NT_STATUS_OK },
	{ N_("Undetermined error"), 		NT_STATUS_UNSUCCESSFUL },
	{ N_("Access denied"), 			NT_STATUS_ACCESS_DENIED },
	{ N_("Account locked out"), 		NT_STATUS_ACCOUNT_LOCKED_OUT },
	{ N_("Must change password"), 		NT_STATUS_PASSWORD_MUST_CHANGE },
	{ N_("Password is too short"), 		NT_STATUS_PWD_TOO_SHORT },
	{ N_("Password is too recent"), 		NT_STATUS_PWD_TOO_RECENT },
	{ N_("Password history conflict"), 		NT_STATUS_PWD_HISTORY_CONFLICT },
	{ N_("No logon servers"), 			NT_STATUS_NO_LOGON_SERVERS },
	{ N_("Improperly formed account name"), 	NT_STATUS_INVALID_ACCOUNT_NAME },
	{ N_("User exists"), 			NT_STATUS_USER_EXISTS },
	{ N_("No such user"), 			NT_STATUS_NO_SUCH_USER },
	{ N_("Group exists"), 			NT_STATUS_GROUP_EXISTS },
	{ N_("No such group"), 			NT_STATUS_NO_SUCH_GROUP },
	{ N_("Member not in group"), 		NT_STATUS_MEMBER_NOT_IN_GROUP },
	{ N_("Wrong Password"), 			NT_STATUS_WRONG_PASSWORD },
	{ N_("Ill formed password"), 		NT_STATUS_ILL_FORMED_PASSWORD },
	{ N_("Password restriction"), 		NT_STATUS_PASSWORD_RESTRICTION },
	{ N_("Logon failure"), 			NT_STATUS_LOGON_FAILURE },
	{ N_("Account restriction"), 		NT_STATUS_ACCOUNT_RESTRICTION },
	{ N_("Invalid logon hours"), 		NT_STATUS_INVALID_LOGON_HOURS },
	{ N_("Invalid workstation"), 		NT_STATUS_INVALID_WORKSTATION },
	{ N_("Password expired"), 			NT_STATUS_PASSWORD_EXPIRED },
	{ N_("Account disabled"), 			NT_STATUS_ACCOUNT_DISABLED },
	{ N_("Unexpected information received"), 	NT_STATUS_INVALID_PARAMETER },
	{ N_("Memory allocation error"), 		NT_STATUS_NO_MEMORY },
	{ N_("No domain controllers located"), 	NT_STATUS_DOMAIN_CONTROLLER_NOT_FOUND },
	{ N_("Account locked out"), 		NT_STATUS_ACCOUNT_LOCKED_OUT },
	{ N_("Named pipe not available"), 		NT_STATUS_PIPE_NOT_AVAILABLE },
	{ N_("Not implemented"), 			NT_STATUS_NOT_IMPLEMENTED },
	{ N_("Invalid information class"), 		NT_STATUS_INVALID_INFO_CLASS },
	{ N_("Information length mismatch"), 	NT_STATUS_INFO_LENGTH_MISMATCH },
	{ N_("Access violation"), 			NT_STATUS_ACCESS_VIOLATION },
	{ N_("Invalid handle"), 			NT_STATUS_INVALID_HANDLE },
	{ N_("Invalid parameter"), 			NT_STATUS_INVALID_PARAMETER },
	{ N_("No memory"), 				NT_STATUS_NO_MEMORY },
	{ N_("Buffer too small"), 			NT_STATUS_BUFFER_TOO_SMALL },
	{ N_("Revision mismatch"), 			NT_STATUS_REVISION_MISMATCH },
	{ N_("No logon servers"), 			NT_STATUS_NO_LOGON_SERVERS },
	{ N_("No such logon session"), 		NT_STATUS_NO_SUCH_LOGON_SESSION },
	{ N_("No such privilege"), 			NT_STATUS_NO_SUCH_PRIVILEGE },
	{ N_("Procedure not found"), 		NT_STATUS_PROCEDURE_NOT_FOUND },
	{ N_("Server disabled"), 			NT_STATUS_SERVER_DISABLED },
	{ N_("Invalid pipe state"), 		NT_STATUS_INVALID_PIPE_STATE },
	{ N_("Named pipe busy"), 			NT_STATUS_PIPE_BUSY },
	{ N_("Illegal function"),		 	NT_STATUS_ILLEGAL_FUNCTION },
	{ N_("Named pipe disconnected"), 		NT_STATUS_PIPE_DISCONNECTED },
	{ N_("Named pipe closing"), 		NT_STATUS_PIPE_CLOSING },
	{ N_("Remote host not listening"), 		NT_STATUS_REMOTE_NOT_LISTENING },
	{ N_("Duplicate name on network"), 		NT_STATUS_DUPLICATE_NAME },
	{ N_("Print queue is full"), 		NT_STATUS_PRINT_QUEUE_FULL },
	{ N_("No print spool space available"), 	NT_STATUS_NO_SPOOL_SPACE },
	{ N_("The network name cannot be found"),   NT_STATUS_BAD_NETWORK_NAME },
	{ N_("The connection was refused"),         NT_STATUS_CONNECTION_REFUSED },
	{ N_("Too many names"), 			NT_STATUS_TOO_MANY_NAMES },
	{ N_("Too many sessions"), 			NT_STATUS_TOO_MANY_SESSIONS },
	{ N_("Invalid server state"), 		NT_STATUS_INVALID_SERVER_STATE },
	{ N_("Invalid domain state"), 		NT_STATUS_INVALID_DOMAIN_STATE },
	{ N_("Invalid domain role"), 		NT_STATUS_INVALID_DOMAIN_ROLE },
	{ N_("No such domain"), 			NT_STATUS_NO_SUCH_DOMAIN },
	{ N_("Domain exists"), 			NT_STATUS_DOMAIN_EXISTS },
	{ N_("Domain limit exceeded"), 		NT_STATUS_DOMAIN_LIMIT_EXCEEDED },
	{ N_("Bad logon session state"), 		NT_STATUS_BAD_LOGON_SESSION_STATE },
	{ N_("Logon session collision"), 		NT_STATUS_LOGON_SESSION_COLLISION },
	{ N_("Invalid logon type"), 		NT_STATUS_INVALID_LOGON_TYPE },
	{ N_("Cancelled"), 				NT_STATUS_CANCELLED },
	{ N_("Invalid computer name"), 		NT_STATUS_INVALID_COMPUTER_NAME },
	{ N_("Logon server conflict"), 		NT_STATUS_LOGON_SERVER_CONFLICT },
	{ N_("Time difference at domain controller"), NT_STATUS_TIME_DIFFERENCE_AT_DC },
	{ N_("Pipe broken"), 			NT_STATUS_PIPE_BROKEN },
	{ N_("Registry corrupt"), 			NT_STATUS_REGISTRY_CORRUPT },
	{ N_("Too many secrets"), 			NT_STATUS_TOO_MANY_SECRETS },
	{ N_("Too many SIDs"), 			NT_STATUS_TOO_MANY_SIDS },
	{ N_("Lanmanager cross encryption required"), NT_STATUS_LM_CROSS_ENCRYPTION_REQUIRED },
	{ N_("Log file full"), 			NT_STATUS_LOG_FILE_FULL },
	{ N_("No trusted LSA secret"), 		NT_STATUS_NO_TRUST_LSA_SECRET },
	{ N_("No trusted SAM account"), 		NT_STATUS_NO_TRUST_SAM_ACCOUNT },
	{ N_("Trusted domain failure"), 		NT_STATUS_TRUSTED_DOMAIN_FAILURE },
	{ N_("Trust relationship failure"), 	NT_STATUS_TRUSTED_RELATIONSHIP_FAILURE },
	{ N_("Trust failure"), 			NT_STATUS_TRUST_FAILURE },
	{ N_("Netlogon service not started"), 	NT_STATUS_NETLOGON_NOT_STARTED },
	{ N_("Account expired"), 			NT_STATUS_ACCOUNT_EXPIRED },
	{ N_("Network credential conflict"), 	NT_STATUS_NETWORK_CREDENTIAL_CONFLICT },
	{ N_("Remote session limit"), 		NT_STATUS_REMOTE_SESSION_LIMIT },
	{ N_("No logon interdomain trust account"), NT_STATUS_NOLOGON_INTERDOMAIN_TRUST_ACCOUNT },
	{ N_("No logon workstation trust account"), NT_STATUS_NOLOGON_WORKSTATION_TRUST_ACCOUNT },
	{ N_("No logon server trust account"), 	NT_STATUS_NOLOGON_SERVER_TRUST_ACCOUNT },
	{ N_("Domain trust inconsistent"), 		NT_STATUS_DOMAIN_TRUST_INCONSISTENT },
	{ N_("No user session key available"), 	NT_STATUS_NO_USER_SESSION_KEY },
	{ N_("User session deleted"), 		NT_STATUS_USER_SESSION_DELETED },
	{ N_("Insufficient server resources"), 	NT_STATUS_INSUFF_SERVER_RESOURCES },
	{ N_("Insufficient logon information"), 	NT_STATUS_INSUFFICIENT_LOGON_INFO },

	{ N_("License quota exceeded"), 		NT_STATUS_LICENSE_QUOTA_EXCEEDED },
	{ N_("No more files"),			STATUS_NO_MORE_FILES },

	{ NULL, NT_STATUS(0) }
};

/*****************************************************************************
 Returns an NT_STATUS constant as a string for inclusion in autogen C code.
 *****************************************************************************/

const char *get_nt_error_c_code(TALLOC_CTX *mem_ctx, NTSTATUS nt_code)
{
	char *result;
	int idx = 0;

	while (nt_errs[idx].nt_errstr != NULL) {
		if (NT_STATUS_V(nt_errs[idx].nt_errcode) ==
		    NT_STATUS_V(nt_code)) {
			result = talloc_strdup(mem_ctx, nt_errs[idx].nt_errstr);
			return result;
		}
		idx++;
	}

	result = talloc_asprintf(mem_ctx, "NT_STATUS(0x%08x)",
				 NT_STATUS_V(nt_code));
	return result;
}

/*****************************************************************************
 Returns the NT_STATUS constant matching the string supplied (as an NTSTATUS)
 *****************************************************************************/

NTSTATUS nt_status_string_to_code(const char *nt_status_str)
{
	int idx = 0;

	while (nt_errs[idx].nt_errstr != NULL) {
		if (strcasecmp(nt_errs[idx].nt_errstr, nt_status_str) == 0) {
			return nt_errs[idx].nt_errcode;
		}
		idx++;
	}
	return NT_STATUS_UNSUCCESSFUL;
}

/**
 * Squash an NT_STATUS in line with security requirements.
 * In an attempt to avoid giving the whole game away when users
 * are authenticating, NT replaces both NT_STATUS_NO_SUCH_USER and
 * NT_STATUS_WRONG_PASSWORD with NT_STATUS_LOGON_FAILURE in certain situations
 * (session setups in particular).
 *
 * @param nt_status NTSTATUS input for squashing.
 * @return the 'squashed' nt_status
 **/

NTSTATUS nt_status_squash(NTSTATUS nt_status)
{
	if NT_STATUS_IS_OK(nt_status) {
		return nt_status;
	} else if NT_STATUS_EQUAL(nt_status, NT_STATUS_NO_SUCH_USER) {
		/* Match WinXP and don't give the game away */
		return NT_STATUS_LOGON_FAILURE;

	} else if NT_STATUS_EQUAL(nt_status, NT_STATUS_WRONG_PASSWORD) {
		/* Match WinXP and don't give the game away */
		return NT_STATUS_LOGON_FAILURE;
	} else {
		return nt_status;
	}
}

/*****************************************************************************
 Returns an NT error message.  not amazingly helpful, but better than a number.
 *****************************************************************************/

const char *nt_errstr(NTSTATUS nt_code)
{
	int idx = 0;
	char *result;

	while (nt_errs[idx].nt_errstr != NULL) {
		if (NT_STATUS_V(nt_errs[idx].nt_errcode) ==
		    NT_STATUS_V(nt_code)) {
			return nt_errs[idx].nt_errstr;
		}
		idx++;
	}

	if (!talloc_stackframe_exists()) {
		/* prevent memory leaks from talloc_tos() by using a
		 * static area. This means the caller will overwrite
		 * the string with subsequent calls, which can cause
		 * display of the wrong error. If that happens the
		 * caller should have a talloc stackframe
		 */
		static char msg[20];
		snprintf(msg, sizeof(msg), "NT code 0x%08x", NT_STATUS_V(nt_code));
		return msg;
	}

	result = talloc_asprintf(talloc_tos(), "NT code 0x%08x",
				 NT_STATUS_V(nt_code));
	SMB_ASSERT(result != NULL);
	return result;
}

/************************************************************************
 Print friendler version fo NT error code
 ***********************************************************************/

const char *get_friendly_nt_error_msg(NTSTATUS nt_code)
{
	int idx = 0;

	while (nt_err_desc[idx].nt_errstr != NULL) {
		if (NT_STATUS_V(nt_err_desc[idx].nt_errcode) == NT_STATUS_V(nt_code)) {
			return nt_err_desc[idx].nt_errstr;
		}
		idx++;
	}

	/* fall back to NT_STATUS_XXX string */

	return nt_errstr(nt_code);
}
