# Copyright (C) 2003 Konstantin Korikov

#  This program is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 2 of the License, or
#  (at your option) any later version.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program; if not, write to the Free Software
#  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

import signal
import time
import sys
import chestnut_dialer
import chestnut_dialer.application
from chestnut_dialer import _

class Application(chestnut_dialer.application.Application):
  _none_ui_mast_exit = 0
  _none_ui_ex_status = chestnut_dialer.EX_OK
  display_messages = 1
  def __init__(self, params):
    chestnut_dialer.application.Application.__init__(self)
    if params.has_key("quiet"): self.display_messages = 0
  def run(self):
    while not self._none_ui_mast_exit:
      if self.is_connection_setup():
        time.sleep(self.config.monitor_period)
      else:
        time.sleep(0.3)
      self.connection_monitor_signal()
    return self._none_ui_ex_status
  def exit(self):
    self._none_ui_mast_exit = 1
  def on_connection_stop(self, reason):
    reson_msg = (
        _("normal termination"),
	_("unknown termination"),
	_("no dialtone"),
        _("busy"),
	_("no carrier"),
	_("authentication failed"))[reason]
    print _("Connection terminated. Reason: %s.") % reson_msg
    self._none_ui_ex_status = (
        chestnut_dialer.EX_OK,
        chestnut_dialer.EX_UNKNOWN,
        chestnut_dialer.EX_NODIALTONE,
        chestnut_dialer.EX_BUSY,
        chestnut_dialer.EX_NOCARRIER,
        chestnut_dialer.EX_AUTHFAIL)[reason]
    self.exit()
  def on_connection_debug_msg(self, msg):
    if self.display_messages: 
      sys.stdout.write(msg)
      sys.stdout.flush()
  def ask_password(self):
    try: return (raw_input(_("Password: ")), 0)
    except EOFError:
      self._none_ui_mast_exit = 1
      return ("", 1)
