/*****************************************************************************
 * users.h
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston,
 * MA 02111-1307, USA.
 *
 * Copyright (C) 2003-2005, Erica Andrews
 * (Phrozensmoke ['at'] yahoo.com)
 * http://phpaint.sourceforge.net/pyvoicechat/
 * 
 * Copyright (C) 2000-2002 Chris Pinkham
 * cpinkham@corp.infi.net, cpinkham@bc2va.org
 * http://www4.infi.net/~cpinkham/gyach/
 * 
 * Released under the terms of the GPL.
 * *NO WARRANTY*
 *
 * cpinkham@infi.net, cpinkham@bc2va.org
 * http://www4.infi.net/~cpinkham/gyach/
 *****************************************************************************/


#ifndef _USERS_H_
#define _USERS_H_

#include "gyachi_notebook.h"

struct _PHOTOSHARE;

/* Effective 1.1.71, the buddy image has been moved to the yahoo_friend
 * structure. This was necessary in order to support buddy images on the
 * buddy panel list. In order to add buddy-list images, I need to have
 * the buddy image in the yahoo_friend list structure (which exists even
 * when the pm_session doesn't -- the pm_session struct only exists when
 * there is a pm session going for that particular buddy/friend).
 * Note that temp friends don't have a yahoo_friend buddy structure
 * (because they're NOT a yahoo buddy)... So now temporary friend lose
 * their entitlement to a buddy image... 
 */

struct pm_session {
	GYACHI_NOTEBOOK_INTERFACE *pm_notebook;
	GtkWidget *pm_window;
	GtkWidget *pm_text;
	char *pm_user;
	int typing;
	int encryption_type;  /* added, PhrozeSmoke */
	int encrypted_myway;  /* added, PhrozeSmoke */
	int encrypted_theirway;  /* added, PhrozeSmoke */
	int my_gpg_passphrase;
	int their_gpg_passphrase;
 	int sms;
 	int window_style;
	int buddy_image_size;
	int buddy_image_share;
	int buddy_image_visible;

	GtkWidget *bimage_panel;
	GtkWidget *bimage_me;
	GtkWidget *bimage_them;
 	struct _PHOTOSHARE *photoshare;
};

extern GList *user_list;
extern GList *left_list;
extern GList *full_list;

extern GtkTreeView *chat_users;
extern GtkTreeIter chat_user_iter;
extern GtkTreeModel *chat_user_model;
extern int chat_user_count;
extern int igg_count_in_room;
extern int mutey_count_in_room;

extern GtkWidget *chat_user_menu;
extern char *user_selected;
extern char *follow_user;

extern GtkWidget * pm_entry;
extern GtkWidget * pm_user;
extern GList *pm_list;

extern GtkWidget * profile_window;
extern char *prof_text;
extern char *prof_pic;

/* generic user/userlist routines */
extern int  find_user_row( char *user );
extern void user_add( char *user );
extern void user_remove( char *user );
extern void chatter_list_populate( char *list, int clear_first );
extern void chatter_list_add( char *user );
extern void chatter_list_remove( char *user );
extern void chatter_list_status( char *user, const char *stat, char *status );
extern void clear_chat_list_members();
extern const char *choose_pixmap(char *user);

typedef struct {
  char *user;
  GtkWidget *parent;
} PROFILE_STRUCT;
void *fetch_profile( gpointer arg );

extern int  set_last_comment( char *user, char *comment );
extern char *get_last_comment( char *user );
extern void show_last_comments();
extern void reset_user_list();
extern void reset_screenname_aliases();
extern void clear_quick_profiles();

/* pm sessions */
extern struct pm_session *find_pm_session( char *user );
extern struct pm_session *find_pm_session_from_widget( GtkWidget *widget, char *name );

extern void display_profile(GtkWidget *parent);
extern int set_quick_profile( char *user, char *prof_info );

/* added: PhrozenSmoke */
extern void parse_screenname_aliases( int clear_it );
extern int  set_screenname_alias( char *user, char *useralias );
extern char *get_screenname_alias(char *user);
extern int  update_screenname_alias( char *user, char *useralias ) ;

#endif /* #ifndef _USERS_H_ */
