/*****************************************************************************
 * sound_plugin.c
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston,
 * MA 02111-1307, USA.
 *
 * Copyright (C) 2008, Greg Hosler
 * (ghosler ['at'] users.sourceforge.net)
 * 
 * Released under the terms of the GPL.
 * *NO WARRANTY*
 *****************************************************************************/

#include <string.h>
#include <gtk/gtk.h>

#include "spellcheck_plugin.h"

/* This code allows for multiple spellcheck plugins,
 * which, presumably, would be selectable from the
 * setup menu.
 *
 * At present there is only the gtk_spellcheck plugin,
 * but should there ever come an alternate plugin (e.g. libsexy?)
 * then gyachi could easily make use if it.
 */

static GYACHI_SPELLCHECK_PLUGIN *selected_spellcheck_plugin = NULL;
static GList *spellcheck_plugins = NULL;

int register_spellcheck_plugin(GYACHI_SPELLCHECK_PLUGIN *plugin)
{
	GList *element;
	GYACHI_SPELLCHECK_PLUGIN *item;

	if (!plugin->description ||
	    !plugin->name        ||
	    !plugin->activate) {
		/* must have a description, name & activate callback */
		return(-1);
	}

	for (element=spellcheck_plugins; element; element=element->next) {
		item = (GYACHI_SPELLCHECK_PLUGIN *)element->data;
		if (!strcmp(plugin->description, item->description)) {
			/* already registered... */
			return(-1);
		}
	}

	spellcheck_plugins = g_list_append(spellcheck_plugins, plugin);
	return(0);
}

int select_spellcheck_plugin(const char *name)
{
	GList *element;
	GYACHI_SPELLCHECK_PLUGIN *item;

	for (element=spellcheck_plugins; element; element=element->next) {
		item = (GYACHI_SPELLCHECK_PLUGIN *)element->data;
		if (!strcmp(item->name, name)) {
			/* found */
			selected_spellcheck_plugin = item;
			return TRUE;
		}
		if (!strcmp(item->description, name)) {
			/* found */
			selected_spellcheck_plugin = item;
			return TRUE;
		}
	}

	return FALSE;
}

const char *spellcheck_plugin_description(const char *name)
{
	GList *element;
	GYACHI_SPELLCHECK_PLUGIN *item;

	for (element=spellcheck_plugins; element; element=element->next) {
		item = (GYACHI_SPELLCHECK_PLUGIN *)element->data;
		if (!strcmp(item->name, name)) {
			/* found */
			return(item->description);
		}
	}
	return("");
}

const char *spellcheck_plugin_name(const char *description)
{
	GList *element;
	GYACHI_SPELLCHECK_PLUGIN *item;

	for (element=spellcheck_plugins; element; element=element->next) {
		item = (GYACHI_SPELLCHECK_PLUGIN *)element->data;
		if (!strcmp(item->description, description)) {
			/* found */
			return(item->name);
		}
	}
	return("");
}

GList *gyachi_spellcheck_plugins_available()
{
	GList *spellcheck_plugin_list = NULL;
	GList *element;
	GYACHI_SPELLCHECK_PLUGIN *item;

	for (element=spellcheck_plugins; element; element=element->next) {
		item = (GYACHI_SPELLCHECK_PLUGIN *)element->data;
		spellcheck_plugin_list = g_list_prepend(spellcheck_plugin_list, strdup(item->description));
	}

	spellcheck_plugin_list = g_list_sort(spellcheck_plugin_list, (GCompareFunc)g_utf8_collate);
	return(spellcheck_plugin_list);
}

int is_spellcheck_available()
{
	return(selected_spellcheck_plugin != 0);
}

void spellcheck_activate(GtkTextView *text_view, int activate, GtkWidget *parent)
{
	if (selected_spellcheck_plugin) {
		selected_spellcheck_plugin->activate(text_view, activate, parent);
	}
}
