/* most of this ripped from gaim */
/*****************************************************************************
 * trayicon.c
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston,
 * MA 02111-1307, USA.
 *
 * Copyright (C) 2003-2005, Erica Andrews
 * (Phrozensmoke ['at'] yahoo.com)
 * http://phpaint.sourceforge.net/pyvoicechat/
 * 
 * Released under the terms of the GPL.
 * *NO WARRANTY*
 *
 * Support for FreeDesktop (Gnome/KDE/IceWM) system tray icons
 *****************************************************************************/

#include <string.h>
#include <stdio.h>

#include <gtk/gtk.h>
#include <gdk/gdkx.h>

#include "config.h"

#include "gyach.h"
#include "callbacks.h"
#include "users.h"
#include "util.h"
#include "trayicon.h"
#include "ignore.h"
#include "interface.h"

#include "gy_config.h"
#include "theme_support.h"
#include "gyachi_lib.h"

/* prototypes */
/* global locals within this module */
static GtkStatusIcon *systray_icon = NULL;
static int tray_have_mail=0;
static int tray_current_status=0;
static int tray_connected=0;
static char tray_budcount[56]="";
static char tray_mailcount[32]="";
static char menbuf[56]="";
static GtkWidget *menu = NULL;

void tray_cb1 (GtkMenuItem *menuitem, gpointer  user_data) {
	enable_sound_events=gtk_check_menu_item_get_active(GTK_CHECK_MENU_ITEM(menuitem));
	write_config();
}
void tray_cb2 (GtkMenuItem *menuitem, gpointer  user_data) {
	enable_sound_events_pm=gtk_check_menu_item_get_active(GTK_CHECK_MENU_ITEM(menuitem));
	write_config();
}
void tray_cb3 (GtkMenuItem *menuitem, gpointer  user_data) {
	show_emoticons=gtk_check_menu_item_get_active(GTK_CHECK_MENU_ITEM(menuitem));
	write_config();
}
void tray_cb4 (GtkMenuItem *menuitem, gpointer  user_data) {
	enable_animations=gtk_check_menu_item_get_active(GTK_CHECK_MENU_ITEM(menuitem));
	write_config();
}
void tray_cb5 (GtkMenuItem *menuitem, gpointer  user_data) {
	show_blended_colors=gtk_check_menu_item_get_active(GTK_CHECK_MENU_ITEM(menuitem));
	write_config();
}
void tray_cb6 (GtkMenuItem *menuitem, gpointer  user_data) {
	enable_tuxvironments=gtk_check_menu_item_get_active(GTK_CHECK_MENU_ITEM(menuitem));
	write_config();
}
void tray_cb7 (GtkMenuItem *menuitem, gpointer  user_data) {
	show_avatars=gtk_check_menu_item_get_active(GTK_CHECK_MENU_ITEM(menuitem));
	write_config();
}
void tray_cb8 (GtkMenuItem *menuitem, gpointer  user_data) {
	pm_from_friends=gtk_check_menu_item_get_active(GTK_CHECK_MENU_ITEM(menuitem));
	write_config();
}

void tray_cb9 (GtkMenuItem *menuitem, gpointer  user_data) {
	pm_from_users=gtk_check_menu_item_get_active(GTK_CHECK_MENU_ITEM(menuitem));
	write_config();
}
void tray_cb10 (GtkMenuItem *menuitem, gpointer  user_data) {
	pm_from_all=gtk_check_menu_item_get_active(GTK_CHECK_MENU_ITEM(menuitem));
	write_config();
}
void tray_cb11 (GtkMenuItem *menuitem, gpointer  user_data) {
	enable_chat_spam_filter=gtk_check_menu_item_get_active(GTK_CHECK_MENU_ITEM(menuitem));
	if (enable_chat_spam_filter) {ignore_guests=1;}
	write_config();
}
void tray_cb12 (GtkMenuItem *menuitem, gpointer  user_data) {
	disallow_random_friend_add=gtk_check_menu_item_get_active(GTK_CHECK_MENU_ITEM(menuitem));
	write_config();
}
void tray_cb13 (GtkMenuItem *menuitem, gpointer  user_data) {
	allow_no_sent_files=gtk_check_menu_item_get_active(GTK_CHECK_MENU_ITEM(menuitem));
	write_config();
}

void tray_cb14 (GtkMenuItem *menuitem, gpointer  user_data) {
	enable_audibles=gtk_check_menu_item_get_active(GTK_CHECK_MENU_ITEM(menuitem));
	write_config();
}
void tray_cb15 (GtkMenuItem *menuitem, gpointer  user_data) {
	show_bimages=gtk_check_menu_item_get_active(GTK_CHECK_MENU_ITEM(menuitem));
	write_config();
}
void tray_cb16 (GtkMenuItem *menuitem, gpointer  user_data) {
	show_yavatars=gtk_check_menu_item_get_active(GTK_CHECK_MENU_ITEM(menuitem));
	write_config();
	refresh_buddy_clist();
}
void tray_cb17 (GtkMenuItem *menuitem, gpointer  user_data) {
	auto_reject_invitations=gtk_check_menu_item_get_active(GTK_CHECK_MENU_ITEM(menuitem));
	write_config();
}

void tray_disable_cb (GtkMenuItem *menuitem, gpointer  user_data) {
	enable_trayicon=0;
	write_config();
	trayicon_destroy ();
}



static void systray_menu(GtkStatusIcon *status_icon, guint button, guint activate_time, gpointer user_data)  
{
  GtkWidget *submenu = NULL;
  GSList *status_group = NULL;
  GtkWidget *entry;

  if (menu) {
  	gtk_widget_show_all(menu);
  	gtk_menu_popup (GTK_MENU(menu), NULL, NULL, NULL, NULL, button, activate_time);
	return; 
  }

  menu = gtk_menu_new ();

  entry =  gtk_menu_item_new_with_label (_("Status"));
  gtk_menu_shell_append (GTK_MENU_SHELL (menu), entry);
  /* gtk_widget_set_sensitive(entry,tray_connected); */

  submenu= gtk_menu_new ();
  gtk_menu_item_set_submenu (GTK_MENU_ITEM (entry), submenu);
  gtk_widget_set_sensitive(submenu,tray_connected);

  entry = gtk_radio_menu_item_new_with_label (status_group, _("Here"));
  status_group = gtk_radio_menu_item_get_group (GTK_RADIO_MENU_ITEM (entry));
  if (my_status==0) {gtk_check_menu_item_set_active( GTK_CHECK_MENU_ITEM(entry), 1 );}
  g_signal_connect (G_OBJECT (entry), "activate", G_CALLBACK(on_status_here_activate), NULL);
  gtk_menu_shell_append (GTK_MENU_SHELL (submenu), entry);

  entry = gtk_radio_menu_item_new_with_label (status_group, _("Be Right Back"));
  status_group = gtk_radio_menu_item_get_group (GTK_RADIO_MENU_ITEM (entry));
  if (my_status==1) {gtk_check_menu_item_set_active( GTK_CHECK_MENU_ITEM(entry), 1 );}
  g_signal_connect (G_OBJECT (entry), "activate", G_CALLBACK(on_status_be_right_back_activate), NULL);
  gtk_menu_shell_append (GTK_MENU_SHELL (submenu), entry);

  entry = gtk_radio_menu_item_new_with_label (status_group, _("Busy"));
  status_group = gtk_radio_menu_item_get_group (GTK_RADIO_MENU_ITEM (entry));
  if (my_status==2) {gtk_check_menu_item_set_active( GTK_CHECK_MENU_ITEM(entry), 1 );}
  g_signal_connect (G_OBJECT (entry), "activate", G_CALLBACK(on_status_busy_activate), NULL);
  gtk_menu_shell_append (GTK_MENU_SHELL (submenu), entry);

  entry = gtk_radio_menu_item_new_with_label (status_group, _("Not At Home"));
  status_group = gtk_radio_menu_item_get_group (GTK_RADIO_MENU_ITEM (entry));
  if (my_status==3) {gtk_check_menu_item_set_active( GTK_CHECK_MENU_ITEM(entry), 1 );}
  g_signal_connect (G_OBJECT (entry), "activate", G_CALLBACK(on_status_not_at_home_activate), NULL);
  gtk_menu_shell_append (GTK_MENU_SHELL (submenu), entry);

  entry = gtk_radio_menu_item_new_with_label (status_group, _("Not At My Desk"));
  status_group = gtk_radio_menu_item_get_group (GTK_RADIO_MENU_ITEM (entry));
  if (my_status==4) {gtk_check_menu_item_set_active( GTK_CHECK_MENU_ITEM(entry), 1 );}
  g_signal_connect (G_OBJECT (entry), "activate", G_CALLBACK(on_status_not_at_my_desk_activate), NULL);
  gtk_menu_shell_append (GTK_MENU_SHELL (submenu), entry);

  entry = gtk_radio_menu_item_new_with_label (status_group, _("Not In The Office"));
  status_group = gtk_radio_menu_item_get_group (GTK_RADIO_MENU_ITEM (entry));
  if (my_status==5) {gtk_check_menu_item_set_active( GTK_CHECK_MENU_ITEM(entry), 1 );}
  g_signal_connect (G_OBJECT (entry), "activate", G_CALLBACK(on_status_not_in_the_office_activate), NULL);
  gtk_menu_shell_append (GTK_MENU_SHELL (submenu), entry);

  entry = gtk_radio_menu_item_new_with_label (status_group, _("On The Phone"));
  status_group = gtk_radio_menu_item_get_group (GTK_RADIO_MENU_ITEM (entry));
  if (my_status==6) {gtk_check_menu_item_set_active( GTK_CHECK_MENU_ITEM(entry), 1 );}
  g_signal_connect (G_OBJECT (entry), "activate", G_CALLBACK(on_status_on_the_phone_activate), NULL);
  gtk_menu_shell_append (GTK_MENU_SHELL (submenu), entry);

  entry = gtk_radio_menu_item_new_with_label (status_group, _("On Vacation"));
  status_group = gtk_radio_menu_item_get_group (GTK_RADIO_MENU_ITEM (entry));
  if (my_status==7) {gtk_check_menu_item_set_active( GTK_CHECK_MENU_ITEM(entry), 1 );}
  g_signal_connect (G_OBJECT (entry), "activate", G_CALLBACK(on_status_on_vacation_activate), NULL);
  gtk_menu_shell_append (GTK_MENU_SHELL (submenu), entry);

  entry = gtk_radio_menu_item_new_with_label (status_group, _("Out To Lunch"));
  status_group = gtk_radio_menu_item_get_group (GTK_RADIO_MENU_ITEM (entry));
  if (my_status==8) {gtk_check_menu_item_set_active( GTK_CHECK_MENU_ITEM(entry), 1 );}
  g_signal_connect (G_OBJECT (entry), "activate", G_CALLBACK(on_status_out_to_lunch_activate), NULL);
  gtk_menu_shell_append (GTK_MENU_SHELL (submenu), entry);

  entry = gtk_radio_menu_item_new_with_label (status_group, _("Stepped Out"));
  status_group = gtk_radio_menu_item_get_group (GTK_RADIO_MENU_ITEM (entry));
  if (my_status==9) {gtk_check_menu_item_set_active( GTK_CHECK_MENU_ITEM(entry), 1 );}
  g_signal_connect (G_OBJECT (entry), "activate", G_CALLBACK(on_status_stepped_out_activate), NULL);
  gtk_menu_shell_append (GTK_MENU_SHELL (submenu), entry);

  entry = gtk_radio_menu_item_new_with_label (status_group, _("Invisible"));
  status_group = gtk_radio_menu_item_get_group (GTK_RADIO_MENU_ITEM (entry));
  if (my_status==12) {gtk_check_menu_item_set_active( GTK_CHECK_MENU_ITEM(entry), 1 );}
  g_signal_connect (G_OBJECT (entry), "activate", G_CALLBACK(on_status_invisible_activate), NULL);
  gtk_menu_shell_append (GTK_MENU_SHELL (submenu), entry);

  entry = gtk_radio_menu_item_new_with_label (status_group, _("Auto-Away"));
  status_group = gtk_radio_menu_item_get_group (GTK_RADIO_MENU_ITEM (entry));
  if (my_status==11) {gtk_check_menu_item_set_active( GTK_CHECK_MENU_ITEM(entry), 1 );}
  g_signal_connect (G_OBJECT (entry), "activate", G_CALLBACK(on_status_autoaway_activate), NULL);
  gtk_menu_shell_append (GTK_MENU_SHELL (submenu), entry);

  entry = gtk_radio_menu_item_new_with_label (status_group, _("Idle"));
  status_group = gtk_radio_menu_item_get_group (GTK_RADIO_MENU_ITEM (entry));
  if (my_status==999) {gtk_check_menu_item_set_active( GTK_CHECK_MENU_ITEM(entry), 1 );}
  g_signal_connect (G_OBJECT (entry), "activate", G_CALLBACK(on_status_idle_activate), NULL);
  gtk_menu_shell_append (GTK_MENU_SHELL (submenu), entry);

  entry = gtk_radio_menu_item_new_with_label (status_group, _("Custom Message"));
  status_group = gtk_radio_menu_item_get_group (GTK_RADIO_MENU_ITEM (entry));
  if (my_status==10) {gtk_check_menu_item_set_active( GTK_CHECK_MENU_ITEM(entry), 1 );}
  g_signal_connect (G_OBJECT (entry), "activate", G_CALLBACK(on_status_custom_activate), NULL);
  gtk_menu_shell_append (GTK_MENU_SHELL (submenu), entry);

  entry = gtk_separator_menu_item_new ();
  gtk_menu_shell_append (GTK_MENU_SHELL (submenu), entry);

  entry = gtk_menu_item_new_with_label (_("New Custom Message..."));
  g_signal_connect (G_OBJECT (entry), "activate", G_CALLBACK(on_make_custom_away), NULL);
  gtk_menu_shell_append (GTK_MENU_SHELL (submenu), entry);

  entry = gtk_separator_menu_item_new ();
  gtk_menu_shell_append (GTK_MENU_SHELL (menu), entry);



  entry =  gtk_menu_item_new_with_label (_("Protection"));
  gtk_menu_shell_append (GTK_MENU_SHELL (menu), entry);
  /* gtk_widget_set_sensitive(entry,tray_connected); */ /* should always be sensitive */

  submenu= gtk_menu_new ();
  gtk_menu_item_set_submenu (GTK_MENU_ITEM (entry), submenu);
  /* gtk_widget_set_sensitive(submenu,tray_connected); */ /* should always be sensitive */


  entry =  gtk_menu_item_new_with_label (_("Accept Private Messages,\nInvitations, and Files From:"));
  gtk_menu_shell_append (GTK_MENU_SHELL (submenu), entry);

  entry =  gtk_check_menu_item_new_with_label (_("Friends/Buddies"));
  gtk_check_menu_item_set_active( GTK_CHECK_MENU_ITEM(entry), pm_from_friends);
  g_signal_connect (G_OBJECT (entry), "activate", G_CALLBACK(tray_cb8), NULL);
  gtk_menu_shell_append (GTK_MENU_SHELL (submenu), entry);

  entry =  gtk_check_menu_item_new_with_label (_("Users in current room"));
  gtk_check_menu_item_set_active( GTK_CHECK_MENU_ITEM(entry), pm_from_users);
  g_signal_connect (G_OBJECT (entry), "activate", G_CALLBACK(tray_cb9), NULL);
  gtk_menu_shell_append (GTK_MENU_SHELL (submenu), entry);

  entry =  gtk_check_menu_item_new_with_label (_("All Yahoo! users"));
  gtk_check_menu_item_set_active( GTK_CHECK_MENU_ITEM(entry), pm_from_all);
  g_signal_connect (G_OBJECT (entry), "activate", G_CALLBACK(tray_cb10), NULL);
  gtk_menu_shell_append (GTK_MENU_SHELL (submenu), entry);

  entry = gtk_separator_menu_item_new ();
  gtk_menu_shell_append (GTK_MENU_SHELL (submenu), entry);

  entry =  gtk_check_menu_item_new_with_label (_("Enable spam protection (PM & Chat)"));
  gtk_check_menu_item_set_active( GTK_CHECK_MENU_ITEM(entry), enable_chat_spam_filter);
  g_signal_connect (G_OBJECT (entry), "activate", G_CALLBACK(tray_cb11), NULL);
  gtk_menu_shell_append (GTK_MENU_SHELL (submenu), entry);

  entry = gtk_separator_menu_item_new ();
  gtk_menu_shell_append (GTK_MENU_SHELL (submenu), entry);

  entry =  gtk_check_menu_item_new_with_label (_("Do not allow anyone who\nis not a friend to add me\nto their friend's list"));
  gtk_check_menu_item_set_active( GTK_CHECK_MENU_ITEM(entry), disallow_random_friend_add);
  g_signal_connect (G_OBJECT (entry), "activate", G_CALLBACK(tray_cb12), NULL);
  gtk_menu_shell_append (GTK_MENU_SHELL (submenu), entry);

  entry = gtk_separator_menu_item_new ();
  gtk_menu_shell_append (GTK_MENU_SHELL (submenu), entry);

  entry =  gtk_check_menu_item_new_with_label (_("Do not accept any sent files"));
  gtk_check_menu_item_set_active( GTK_CHECK_MENU_ITEM(entry), allow_no_sent_files);
  g_signal_connect (G_OBJECT (entry), "activate", G_CALLBACK(tray_cb13), NULL);
  gtk_menu_shell_append (GTK_MENU_SHELL (submenu), entry);

  entry =  gtk_check_menu_item_new_with_label (_("Automatically reject all invitations"));
  gtk_check_menu_item_set_active( GTK_CHECK_MENU_ITEM(entry), auto_reject_invitations);
  g_signal_connect (G_OBJECT (entry), "activate", G_CALLBACK(tray_cb17), NULL);
  gtk_menu_shell_append (GTK_MENU_SHELL (submenu), entry);

  entry = gtk_separator_menu_item_new ();
  gtk_menu_shell_append (GTK_MENU_SHELL (submenu), entry);

  entry =  gtk_image_menu_item_new_with_label (_(" Gyach Enhanced Ignore List... "));
  gtk_image_menu_item_set_image(GTK_IMAGE_MENU_ITEM(entry), 
	GTK_WIDGET(gtk_image_new_from_stock(GTK_STOCK_DIALOG_ERROR, GTK_ICON_SIZE_MENU) ));
  g_signal_connect (G_OBJECT (entry), "activate", G_CALLBACK(open_ignore_editor), NULL);
  gtk_menu_shell_append (GTK_MENU_SHELL (submenu), entry);

  entry =  gtk_image_menu_item_new_with_label (_(" Yahoo! Ignore List... "));
  gtk_image_menu_item_set_image(GTK_IMAGE_MENU_ITEM(entry), 
	GTK_WIDGET(gtk_image_new_from_stock(GTK_STOCK_DIALOG_ERROR, GTK_ICON_SIZE_MENU) ));
  g_signal_connect (G_OBJECT (entry), "activate", G_CALLBACK(open_perm_ignore), NULL);
  gtk_menu_shell_append (GTK_MENU_SHELL (submenu), entry);
  gtk_widget_set_sensitive(entry,tray_connected);

  entry =  gtk_image_menu_item_new_with_label (_(" Flooders/Booters... "));
  gtk_image_menu_item_set_image(GTK_IMAGE_MENU_ITEM(entry), 
	GTK_WIDGET(gtk_image_new_from_stock(GTK_STOCK_PREFERENCES, GTK_ICON_SIZE_MENU) ));
  g_signal_connect (G_OBJECT (entry), "activate", G_CALLBACK(open_flooder_editor), NULL);
  gtk_menu_shell_append (GTK_MENU_SHELL (submenu), entry);

  entry =  gtk_image_menu_item_new_with_label (_(" Temporary Friends... "));
  gtk_image_menu_item_set_image(GTK_IMAGE_MENU_ITEM(entry), 
	GTK_WIDGET(gtk_image_new_from_stock(GTK_STOCK_PREFERENCES, GTK_ICON_SIZE_MENU) ));
  g_signal_connect (G_OBJECT (entry), "activate", G_CALLBACK(open_temp_friend_editor), NULL);
  gtk_menu_shell_append (GTK_MENU_SHELL (submenu), entry);




  entry =  gtk_menu_item_new_with_label (_("Options"));
  gtk_menu_shell_append (GTK_MENU_SHELL (menu), entry);
  /* gtk_widget_set_sensitive(entry,tray_connected); */ /* should always be sensitive */

  submenu= gtk_menu_new ();
  gtk_menu_item_set_submenu (GTK_MENU_ITEM (entry), submenu);
  /* gtk_widget_set_sensitive(submenu,tray_connected); */ /* should always be sensitive */

  entry =  gtk_check_menu_item_new_with_label (_("Enable sound events"));
  gtk_check_menu_item_set_active( GTK_CHECK_MENU_ITEM(entry), enable_sound_events);
  g_signal_connect (G_OBJECT (entry), "activate", G_CALLBACK(tray_cb1), NULL);
  gtk_menu_shell_append (GTK_MENU_SHELL (submenu), entry);

  entry =  gtk_check_menu_item_new_with_label (_("Enable PM sound events"));
  gtk_check_menu_item_set_active( GTK_CHECK_MENU_ITEM(entry), enable_sound_events_pm);
  g_signal_connect (G_OBJECT (entry), "activate", G_CALLBACK(tray_cb2), NULL);
  gtk_menu_shell_append (GTK_MENU_SHELL (submenu), entry);

  entry =  gtk_check_menu_item_new_with_label (_("Enable Audibles"));
  gtk_check_menu_item_set_active( GTK_CHECK_MENU_ITEM(entry), enable_audibles);
  g_signal_connect (G_OBJECT (entry), "activate", G_CALLBACK(tray_cb14), NULL);
  gtk_menu_shell_append (GTK_MENU_SHELL (submenu), entry);

  entry = gtk_separator_menu_item_new ();
  gtk_menu_shell_append (GTK_MENU_SHELL (submenu), entry);

  entry =  gtk_check_menu_item_new_with_label (_("Show smileys"));
  gtk_check_menu_item_set_active( GTK_CHECK_MENU_ITEM(entry), show_emoticons);
  g_signal_connect (G_OBJECT (entry), "activate", G_CALLBACK(tray_cb3), NULL);
  gtk_menu_shell_append (GTK_MENU_SHELL (submenu), entry);

  entry =  gtk_check_menu_item_new_with_label (_("Show animated smileys"));
  gtk_check_menu_item_set_active( GTK_CHECK_MENU_ITEM(entry), enable_animations );
  g_signal_connect (G_OBJECT (entry), "activate", G_CALLBACK(tray_cb4), NULL);
  gtk_menu_shell_append (GTK_MENU_SHELL (submenu), entry);


  entry =  gtk_check_menu_item_new_with_label (_("Show Buddy Images"));
  gtk_check_menu_item_set_active( GTK_CHECK_MENU_ITEM(entry), show_bimages);
  g_signal_connect (G_OBJECT (entry), "activate", G_CALLBACK(tray_cb15), NULL);
  gtk_menu_shell_append (GTK_MENU_SHELL (submenu), entry);

  entry = gtk_separator_menu_item_new ();
  gtk_menu_shell_append (GTK_MENU_SHELL (submenu), entry);

  entry =  gtk_check_menu_item_new_with_label (_("Faders"));
  gtk_check_menu_item_set_active( GTK_CHECK_MENU_ITEM(entry), show_blended_colors);
  g_signal_connect (G_OBJECT (entry), "activate", G_CALLBACK(tray_cb5), NULL);
  gtk_menu_shell_append (GTK_MENU_SHELL (submenu), entry);

  entry =  gtk_check_menu_item_new_with_label (_("Enable TUXVironments"));
  gtk_check_menu_item_set_active( GTK_CHECK_MENU_ITEM(entry), enable_tuxvironments);
  g_signal_connect (G_OBJECT (entry), "activate", G_CALLBACK(tray_cb6), NULL);
  gtk_menu_shell_append (GTK_MENU_SHELL (submenu), entry);

  entry =  gtk_check_menu_item_new_with_label (_("Show Avatars"));
  gtk_check_menu_item_set_active( GTK_CHECK_MENU_ITEM(entry), show_avatars);
  g_signal_connect (G_OBJECT (entry), "activate", G_CALLBACK(tray_cb7), NULL);
  gtk_menu_shell_append (GTK_MENU_SHELL (submenu), entry);


  entry =  gtk_check_menu_item_new_with_label (_("Show buddy list avatars"));
  gtk_check_menu_item_set_active( GTK_CHECK_MENU_ITEM(entry), show_yavatars);
  g_signal_connect (G_OBJECT (entry), "activate", G_CALLBACK(tray_cb16), NULL);
  gtk_menu_shell_append (GTK_MENU_SHELL (submenu), entry);

  entry = gtk_separator_menu_item_new ();
  gtk_menu_shell_append (GTK_MENU_SHELL (submenu), entry);

  entry =  gtk_image_menu_item_new_with_label (_("Disable Tray Icon"));
  gtk_image_menu_item_set_image(GTK_IMAGE_MENU_ITEM(entry), 
	GTK_WIDGET(gtk_image_new_from_stock(GTK_STOCK_DIALOG_ERROR, GTK_ICON_SIZE_MENU) ));
  g_signal_connect (G_OBJECT (entry), "activate", G_CALLBACK(tray_disable_cb), NULL);
  gtk_menu_shell_append (GTK_MENU_SHELL (submenu), entry);



  entry =  gtk_menu_item_new_with_label (_("Rooms"));
  gtk_menu_shell_append (GTK_MENU_SHELL (menu), entry);
  /* gtk_widget_set_sensitive(entry,tray_connected);  */

  submenu= gtk_menu_new ();
  gtk_menu_item_set_submenu (GTK_MENU_ITEM (entry), submenu);
  gtk_widget_set_sensitive(submenu,tray_connected);

  entry =  gtk_image_menu_item_new_with_label (_("Rejoin Current Chat Room"));
  conf_invite6 = entry;
  gtk_image_menu_item_set_image(GTK_IMAGE_MENU_ITEM(entry), 
	GTK_WIDGET(gtk_image_new_from_stock(GTK_STOCK_UNDO, GTK_ICON_SIZE_MENU) ));
  g_signal_connect (G_OBJECT (entry), "activate", G_CALLBACK(on_rejoin_room), NULL);
  gtk_menu_shell_append (GTK_MENU_SHELL (submenu), entry);

  entry =  gtk_image_menu_item_new_with_label (_("Leave Room or Conference"));
  conf_invite7 = entry;
  gtk_image_menu_item_set_image(GTK_IMAGE_MENU_ITEM(entry), 
	GTK_WIDGET(gtk_image_new_from_stock(GTK_STOCK_QUIT, GTK_ICON_SIZE_MENU) ));
  g_signal_connect (G_OBJECT (entry), "activate", G_CALLBACK(on_leave_room_or_conf), NULL);
  gtk_menu_shell_append (GTK_MENU_SHELL (submenu), entry);

  entry =  gtk_image_menu_item_new_with_label (_("Favorites"));
  gtk_image_menu_item_set_image(GTK_IMAGE_MENU_ITEM(entry), 
	GTK_WIDGET(gtk_image_new_from_stock(GTK_STOCK_OPEN, GTK_ICON_SIZE_MENU) ));
  g_signal_connect (G_OBJECT (entry), "activate", G_CALLBACK(on_favorites_activate), NULL);
  gtk_menu_shell_append (GTK_MENU_SHELL (submenu), entry);

  entry =  gtk_image_menu_item_new_with_label (_("Room List"));
  gtk_image_menu_item_set_image(GTK_IMAGE_MENU_ITEM(entry), 
  GTK_WIDGET(gtk_image_new_from_stock(GTK_STOCK_FIND_AND_REPLACE, GTK_ICON_SIZE_MENU) ));
  g_signal_connect (G_OBJECT (entry), "activate", G_CALLBACK(on_room_list_activate), NULL);
  gtk_menu_shell_append (GTK_MENU_SHELL (submenu), entry);

  entry = gtk_separator_menu_item_new ();
  gtk_menu_shell_append (GTK_MENU_SHELL (submenu), entry);

  entry =  gtk_image_menu_item_new_with_label (_("Voice Chat"));
  gtk_image_menu_item_set_image(GTK_IMAGE_MENU_ITEM(entry), 
	GTK_WIDGET(gtk_image_new_from_stock(GTK_STOCK_EXECUTE, GTK_ICON_SIZE_MENU) ));
  g_signal_connect (G_OBJECT (entry), "activate", G_CALLBACK(on_activate_voice_chat), NULL);
  gtk_menu_shell_append (GTK_MENU_SHELL (submenu), entry);


  entry = gtk_separator_menu_item_new ();
  gtk_menu_shell_append (GTK_MENU_SHELL (menu), entry);

  snprintf(menbuf,53, "%s...",_(" Instant Message "));
  entry =  gtk_image_menu_item_new_with_label (menbuf);
  gtk_image_menu_item_set_image(GTK_IMAGE_MENU_ITEM(entry), 
	GTK_WIDGET(gtk_image_new_from_stock(GTK_STOCK_NEW, GTK_ICON_SIZE_MENU) ));
  g_signal_connect (G_OBJECT (entry), "activate", G_CALLBACK(on_blank_pm_window), NULL);
  gtk_menu_shell_append (GTK_MENU_SHELL (menu), entry);
  gtk_widget_set_sensitive(entry,tray_connected);

  entry =  gtk_image_menu_item_new_with_label (_(" Get Profile... "));
  gtk_image_menu_item_set_image(GTK_IMAGE_MENU_ITEM(entry), 
	GTK_WIDGET(gtk_image_new_from_stock(GTK_STOCK_DIALOG_INFO, GTK_ICON_SIZE_MENU) ));
  g_signal_connect (G_OBJECT (entry), "activate", G_CALLBACK(on_open_profile_clicked), NULL);
  gtk_menu_shell_append (GTK_MENU_SHELL (menu), entry);
  gtk_widget_set_sensitive(entry,tray_connected);


  entry =  gtk_image_menu_item_new_with_label (_(" Yahoo! Mail "));
  gtk_image_menu_item_set_image(GTK_IMAGE_MENU_ITEM(entry), 
	GTK_WIDGET(gtk_image_new_from_stock(GTK_STOCK_FIND, GTK_ICON_SIZE_MENU) ));
  g_signal_connect (G_OBJECT (entry), "activate", G_CALLBACK(on_yahoo_mail_act), NULL);
  gtk_menu_shell_append (GTK_MENU_SHELL (menu), entry);

  snprintf(menbuf,53, "%s...",_("Setup"));
  entry =  gtk_image_menu_item_new_with_label (menbuf);
  gtk_image_menu_item_set_image(GTK_IMAGE_MENU_ITEM(entry), 
	GTK_WIDGET(gtk_image_new_from_stock(GTK_STOCK_PREFERENCES, GTK_ICON_SIZE_MENU) ));
  g_signal_connect (G_OBJECT (entry), "activate", G_CALLBACK(on_setup_activate), NULL);
  gtk_menu_shell_append (GTK_MENU_SHELL (menu), entry);



  entry = gtk_separator_menu_item_new ();
  gtk_menu_shell_append (GTK_MENU_SHELL (menu), entry);

  snprintf(menbuf,53, "%s...",_("Connect"));
  entry =  gtk_image_menu_item_new_with_label (menbuf);
  gtk_image_menu_item_set_image(GTK_IMAGE_MENU_ITEM(entry), 
	GTK_WIDGET(gtk_image_new_from_stock(GTK_STOCK_YES, GTK_ICON_SIZE_MENU) ));
  g_signal_connect (G_OBJECT (entry), "activate", G_CALLBACK(on_connect_activate), NULL);
  gtk_menu_shell_append (GTK_MENU_SHELL (menu), entry);
  if (tray_connected) {gtk_widget_set_sensitive(entry,0);}

  entry =  gtk_image_menu_item_new_with_label (_("Disconnect"));
  gtk_image_menu_item_set_image(GTK_IMAGE_MENU_ITEM(entry), 
	GTK_WIDGET(gtk_image_new_from_stock(GTK_STOCK_NO, GTK_ICON_SIZE_MENU) ));
  g_signal_connect (G_OBJECT (entry), "activate", G_CALLBACK(on_disconnect_activate), NULL);
  gtk_widget_set_sensitive(entry,tray_connected);
  gtk_menu_shell_append (GTK_MENU_SHELL (menu), entry);

  entry = gtk_separator_menu_item_new ();
  gtk_menu_shell_append (GTK_MENU_SHELL (menu), entry);

  entry =  gtk_image_menu_item_new_with_label (_("Quit"));
  gtk_image_menu_item_set_image(GTK_IMAGE_MENU_ITEM(entry), 
	GTK_WIDGET(gtk_image_new_from_stock(GTK_STOCK_QUIT, GTK_ICON_SIZE_MENU) ));
  g_signal_connect (G_OBJECT (entry), "activate", G_CALLBACK(on_quit_activate), NULL);
  gtk_menu_shell_append (GTK_MENU_SHELL (menu), entry);


  entry = gtk_separator_menu_item_new ();
  gtk_menu_shell_append (GTK_MENU_SHELL (menu), entry);

  entry =  gtk_menu_item_new_with_label (tray_mailcount);
  gtk_widget_set_sensitive(entry,tray_connected);
  gtk_menu_shell_append (GTK_MENU_SHELL (menu), entry);

  entry =  gtk_menu_item_new_with_label (tray_budcount);
  gtk_widget_set_sensitive(entry,tray_connected);
  gtk_menu_shell_append (GTK_MENU_SHELL (menu), entry);

  if (user_list) {
	gtk_widget_set_sensitive(conf_invite6, TRUE);
	gtk_widget_set_sensitive(conf_invite7, TRUE);    
  }
  else {
	gtk_widget_set_sensitive(conf_invite6, FALSE);
	gtk_widget_set_sensitive(conf_invite7, FALSE);    
  }
  gtk_widget_show_all (menu);
  gtk_menu_popup (GTK_MENU (menu), NULL, NULL, NULL, NULL, button, activate_time);
}

static void systray_clicked(GtkStatusIcon *status_icon, void *data)
{
	GtkWidget *w;
	GdkWindow *W; 
	w = (GtkWidget *)gtk_window_list_toplevels()->data;
	W = GTK_WIDGET(w)->window;
	if (W) {
		GdkWindowState s = gdk_window_get_state(W);
		if ((s && (GDK_WINDOW_STATE_WITHDRAWN)) ||
		    (s && (GDK_WINDOW_STATE_ICONIFIED))) {
			gtk_window_present(GTK_WINDOW(w));
		}
		else {
			gtk_widget_hide(w);
		}
	}
	else {
		if (GTK_WIDGET_VISIBLE (w)) {
			gtk_widget_hide(w);
		} else {
			gtk_window_present(GTK_WINDOW(w));
		}
	}
}

static void systray_update_icon ()
{
	static GdkPixbuf *imbuf=NULL;
	const char *picon=NULL;

	if (!systray_icon) {return;}

	switch (tray_current_status) {
	case TRAY_ICON_OFFLINE:
		picon=GYACHI_PM_TUX;
		break;
	case TRAY_ICON_ONLINE_AVAILABLE:
		picon=GYACHI_BUDDY_ONLINE;
		break;
	case TRAY_ICON_INVISIBLE:
		picon=GYACHI_BUDDY_OFFLINE;
		break;
	case TRAY_ICON_IDLE:
		picon=GYACHI_BUDDY_IDLE;
		break;
	case TRAY_ICON_BUSY:
		picon=GYACHI_BUDDY_AWAY;
		break;
	default:
		picon=GYACHI_PM_TUX;
	}

	if (tray_have_mail) {
		picon=GYACHI_MAIL;
	}
//	gtk_status_icon_set_from_stock(systray_icon, picon);
	imbuf=get_pixbuf_from_stock_id(GTK_WIDGET(chat_window), picon, tray_have_mail ? GYACHI_ICON_SIZE_MAIL: GTK_ICON_SIZE_LARGE_TOOLBAR);
//	gtk_image_set_from_pixbuf (GTK_IMAGE(trayimage), imbuf);
	gtk_status_icon_set_from_pixbuf(systray_icon, imbuf);
	g_object_unref(imbuf);
}

void trayicon_destroy (void)
{
	if (systray_icon) {
		g_object_unref(systray_icon);
	}
	return;
}


void update_tray_tooltips()  {	
	char tray_tooltip[160];
  	if (!enable_trayicon) {return ;}
	if (!systray_icon) {return;}
	snprintf(tray_tooltip, 158, "Gyach-E: %s\n%s\n%s",
		tray_connected? _("Online"): _("Offline"), 
		tray_mailcount, tray_budcount);

	gtk_status_icon_set_tooltip(systray_icon, tray_tooltip);
}


GtkStatusIcon *systray_get_status_icon()
{
	return(systray_icon);
}


void trayicon_create (void)
{
	if (!enable_trayicon) {
		return;
	}

	if (systray_icon) {
		/* printf ("Systray: Already created!\n");   */
		return;
	}

	systray_icon = gtk_status_icon_new();

	g_signal_connect(G_OBJECT(systray_icon), "activate",   G_CALLBACK(systray_clicked), NULL);
	g_signal_connect(G_OBJECT(systray_icon), "popup-menu", G_CALLBACK(systray_menu),    NULL);

	gtk_status_icon_set_visible(systray_icon, TRUE);

	systray_update_icon ();

	if (strlen(tray_budcount)<2) {
		snprintf(tray_budcount,53, " %s: %d      %s: %d", 
			 _("Friends"), 0, _("Online"), 0);
	}

	if (strlen(tray_mailcount)<2) {
		snprintf(tray_mailcount,30, " %s:  %d", _("E-mail Messages"), 0	);
	}
	
	update_tray_tooltips();

	return;
}


/* Turn mail alerts off after 90 seconds, and go back to whatever our
    regular tray icon was */

int tray_mail_alert_off(guint data) {
	tray_have_mail=0; 
	systray_update_icon ();
	update_tray_tooltips();
	return 0;
}

void tray_mail_alert_timeout() {
	g_timeout_add( 75000, (void *)tray_mail_alert_off, NULL );
}

void trayicon_mail_alert() { 
	tray_have_mail=1; 
	systray_update_icon ();
	update_tray_tooltips();
	tray_mail_alert_timeout(); 
}

void trayicon_mail_count(char *mailcount) {
	snprintf(tray_mailcount,30, " %s:  %s", _("E-mail Messages"),mailcount);
	if (menu) {
		gtk_widget_destroy (menu);  /* we need to rebuild menu */
		menu=NULL;
		conf_invite6 = NULL;
		conf_invite7 = NULL;
	}
	update_tray_tooltips();
}

void trayicon_buddy_count(int buddycount, int buddyonline) { 
	snprintf(tray_budcount,53, " %s: %d      %s: %d", 
		_("Friends"), buddycount, _("Online"), buddyonline);
	if (menu) {
		gtk_widget_destroy (menu);  /* we need to rebuild menu */
		menu=NULL;
		conf_invite6 = NULL;
		conf_invite7 = NULL;
	}
	update_tray_tooltips();	
}

void trayicon_set_connected(int connected) {
	tray_connected=connected; 

	/* We only need to rebuild the menu when our connection status changes...
	    since the sensitivity of some menu widgets changes based on whether 
            we are connected, otherwise, we can re-use an existing menu */

	if (menu) {
		gtk_widget_destroy (menu);  /* we need to rebuild menu */
		menu=NULL;
		conf_invite6 = NULL;
		conf_invite7 = NULL;
	}
	if (!connected) {
		trayicon_set_status(TRAY_ICON_OFFLINE);
		snprintf(tray_budcount,53, " %s: %d      %s: %d", _("Friends"), 0, _("Online"), 0);
		snprintf(tray_mailcount,30, " %s:  %d", _("E-mail Messages"), 0	);
	}
	update_tray_tooltips();
}

void trayicon_set_status(int tray_status) {
	if (tray_current_status==tray_status) {return;}
	tray_current_status= tray_status;
	systray_update_icon ();
}



