/*
 * BAYER2RGB24 ROUTINE TAKEN FROM:
 *
 * Sonix SN9C101 based webcam basic I/F routines
 * Copyright (C) 2004 Takafumi Mizuno <taka-qce@ls-a.jp>
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

#include <stdint.h>

void bayer2rgb24 (unsigned char *dst, unsigned char *src, 
							long int WIDTH, long int HEIGHT);

void yuv420p_to_rgb (unsigned char *pIn0, unsigned char *pOut0, 
							int bits, int width, int height);
	
// faster version, needs testing!
void yuv420p_to_rgb24(uint32_t width, uint32_t height, 
							unsigned char *dst, void *src);

/* this function needs to be rewritten to libjpeg or libjasper
void jpeg_to_rgb24(uint32_t width, uint32_t height, 
							unsigned char *dst, void *src, size_t framelen);
*/

void rgb32_to_rgb24(uint32_t width, uint32_t height, 
							unsigned char *dst, void *src);
							
void rgb24_to_rgb24(uint32_t width, uint32_t height, 
							unsigned char *dst, void *src);
							
void rgb565_to_rgb24(uint32_t width, uint32_t height,
							unsigned char *dst, void *src);
							
void rgb555_to_rgb24(uint32_t width, uint32_t height, 
							unsigned char *dst, void *src);
void yuv422p_to_rgb24(uint32_t width, uint32_t height, 
							unsigned char *dst, void *src);
					
void grey_to_rgb24(uint32_t width, uint32_t height, unsigned char *dst, void *src);
