/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is Lightning code.
 *
 * The Initial Developer of the Original Code is Oracle Corporation
 * Portions created by the Initial Developer are Copyright (C) 2005
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s):
 *   Mike Shaver <shaver@mozilla.org>
 *   Vladimir Vukicevic <vladimir@pobox.com>
 *   Stuart Parmenter <stuart.parmenter@oracle.com>
 *   Dan Mosedale <dmose@mozilla.org>
 *   Joey Minta <jminta@gmail.com>
 *   Simon Paquet <bugzilla@babylonsounds.com>
 *   Stefan Sitter <ssitter@googlemail.com>
 *   Thomas Benisch <thomas.benisch@sun.com>
 *   Michael Buettner <michael.buettner@sun.com>
 *   Philipp Kewisch <mozilla@kewis.ch>
 *   Berend Cornelius <berend.cornelius@sun.com>
 *   Prasad Sunkari <prasad@synovel.com>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ***** END LICENSE BLOCK ***** */

var gLastShownCalendarView = null;

function yesterday()
{
    var d = now();
    d.day--;
    return d;
}

function nextMonth(dt)
{
    var d = new Date(dt);
    d.setDate(1); // make sure we avoid "June 31" when we bump the month

    var mo = d.getMonth();
    if (mo == 11) {
        d.setMonth(0);
        d.setYear(d.getYear() + 1);
    } else {
        d.setMonth(mo + 1);
    }

    return d;
}

var gMiniMonthLoading = false;
function ltnMinimonthPick(minimonth) {
    if (gMiniMonthLoading) {
        return;
    }
    // In Spicebird, there is no deck any more and calendar views
    // don't need to change
    /*
    if (document.getElementById("applications-deck").selectedPanel !=
        document.getElementById("calendar-view-box")) {
        ltnShowCalendarView(gLastShownCalendarView);
    }
    */
    var jsDate = minimonth.value;
    var cdt = jsDateToDateTime(jsDate, currentView().timezone);
    cdt.isDate = true;
    currentView().goToDay(cdt);
}

function prepareCalendarToDoUnifinder()
{
    // Spicebird needs this empty function!
    //
    // This function is available in calendar-unifinder-todo.js and needs
    // calendar-unifinder-todo.xul to overlay the main window.
    // However, we don't have a today-pane and the overlay would not happen
}

function ltnOnLoad(event) {

    // In Spicebird, we directly jump to commonInitCalendar
    // the rest of the switching stuff is taken care of by the
    // base framework
    commonInitCalendar();

    // nuke the onload, or we get called every time there's
    // any load that occurs
    document.removeEventListener("load", ltnOnLoad, true);

    // Add an unload function to the window so we don't leak any listeners
    window.addEventListener("unload", ltnFinish, false);

    // Set up invitations manager
    scheduleInvitationsUpdate(FIRST_DELAY_STARTUP, REPEAT_DELAY);
    getCalendarManager().addObserver(gInvitationsCalendarManagerObserver);

    var filter = document.getElementById("task-tree-filtergroup");
    filter.value = filter.value || "all";
    document.getElementById("modeBroadcaster").setAttribute("mode", gCurrentMode);

    // Spicebird does not have a today-pane
    // ltnInitTodayPane();
    
    // If the "view-box" is collapsed on startup,
    // it means we were in the list-view before close, persist it!
    if (getViewDeck().hasAttribute("collapsed"))
      switchToCalendarListView();
}

/* Called at midnight to tell us to redraw date-specific widgets.  Do NOT call
 * this for normal refresh, since it also calls scheduleMidnightRefresh.
 */
function refreshUIBits() {
    try {
        getMinimonth().refreshDisplay();

        // refresh the current view, if it has ever been shown
        var cView = currentView();
        if (cView.initialized) {
            cView.goToDay(cView.selectedDay);
        }

        if (!TodayPane.showsToday()) {
            TodayPane.setDay(now());
        }

        // update the unifinder
        refreshEventTree();
    } catch (exc) {
        ASSERT(false, exc);
    }

    // schedule our next update...
    scheduleMidnightUpdate(refreshUIBits);
}

/**
 * Select the calendar view in the background, not switching to calendar mode if
 * in mail mode.
 */
function ltnSelectCalendarView(type) {
    if (type == 'list')
        return;
    
    gLastShownCalendarView = type;

    // Sunbird/Lightning Common view switching code
    switchToView(type);
}

function toggleControlDisplay(aCommandId, aControlId) {
  // Not used in Spicebird
}

function toggleControlinMode(aCommandId, aControlId) {
  // Not used in Spicebird
}

function toggleToolbar(aCommandId, aToolbarId) {
  // Not used in Spicebird
 }

// Copied partially from switchToView() in calendar-views.js
// switchToCalendarView along with the modified ltnShowCalendarView and
// ltnSelectCalendarView implement the list view.
function switchToCalendarListView() {
    var viewDeck = getViewDeck();
    var aViewType = 'list';

    // Set up the view commands
    var views = viewDeck.childNodes;
    for (var i = 0; i < views.length; i++) {
        var view = views[i];
        var commandId = "calendar_" + view.id + "_command";
        var command = document.getElementById(commandId);
        if (view.id == aViewType + "-view") {
            command.setAttribute("checked", "true");
        } else {
            command.removeAttribute("checked");
        }
    }
    showCalendarView('list');
}

/**
 * Show the calendar view, also switching to calendar mode if in mail mode
 */
function ltnShowCalendarView(type)
{
    if (type == 'list') {
        showUnifinderListView();
        getViewDeck().setAttribute('collapsed', 'true');
    } else if (gLastShownCalendarView == 'list') {
        hideUnifinderListView();
        getViewDeck().removeAttribute('collapsed');
    }

    gLastShownCalendarView = type;

    if (gCurrentMode != 'calendar') {
        // This function in turn calls showCalendarView(), so return afterwards.
        ltnSwitch2Calendar();
        return;
    }

    ltnSelectCalendarView(type);
    document.commandDispatcher.updateCommands('calendar_view_commands');
}

function ltnFinish() {
    getCalendarManager().removeObserver(gInvitationsCalendarManagerObserver);
    unloadTasksCalendarManager();
    // Common finish steps
    commonFinishCalendar();
}

function findMailSearchBox() {
  // Not used in Spicebird
}

function ltnInitializeMenus(){
    // Not used in Spicebird
    // All this is taken care of by the platform
}

function removeMenuElementsInSection(aElement, aExcludeMode) {
  // Not used in Spicebird
}

function removeElements(aElementList) {
  // Not used in Spicebird
}

function addToPopupList(aMenuElement, aNewPopupMenu, aPopupList, aExcludedModes, aClone, aRemovePopupShowing) {
  // Not used in Spicebird
}

function copyPopupMenus() {
  // Not used in Spicebird
}

function removeNeedlessSeparators(aMenuPopupList) {
  // Not used in Spicebird
}

function ltnRemoveMailOnlyItems(aMenuPopupList, aExcludeMode) {
  // Not used in Spicebird
}

function swapPopupMenus() {
  // Not used in Spicebird
}

function removeMenuElements(aRoot, aModeValue) {
  // Not used in Spicebird
}

// == invitations link
const FIRST_DELAY_STARTUP = 100;
const FIRST_DELAY_RESCHEDULE = 100;
const FIRST_DELAY_REGISTER = 10000;
const FIRST_DELAY_UNREGISTER = 0;
const REPEAT_DELAY = 180000;

var gInvitationsOperationListener = {
    mCount: 0,

    onOperationComplete: function sBOL_onOperationComplete(aCalendar,
                                                           aStatus,
                                                           aOperationType,
                                                           aId,
                                                           aDetail) {
        if (Components.isSuccessCode(aStatus) && this.mCount) {
            var invitationsBox = document.getElementById("invitations");
            var value = invitationsLabel + " (" + this.mCount + ")"; // XXX l10n-unfriendly
            invitationsBox.setAttribute("value", value);
            invitationsBox.removeAttribute("hidden");
        } else {
            var invitationsBox = document.getElementById("invitations");
            invitationsBox.setAttribute("hidden", "true");
        }
        this.mCount = 0;
    },

    onGetResult: function sBOL_onGetResult(aCalendar,
                                           aStatus,
                                           aItemType,
                                           aDetail,
                                           aCount,
                                           aItems) {
        if (Components.isSuccessCode(aStatus)) {
            this.mCount += aCount;
        }
    }
};

var gInvitationsCalendarManagerObserver = {
    mSideBar: this,

    onCalendarRegistered: function cMO_onCalendarRegistered(aCalendar) {
        this.mSideBar.rescheduleInvitationsUpdate(FIRST_DELAY_REGISTER,
                                                  REPEAT_DELAY);
    },

    onCalendarUnregistering: function cMO_onCalendarUnregistering(aCalendar) {
        this.mSideBar.rescheduleInvitationsUpdate(FIRST_DELAY_UNREGISTER,
                                                  REPEAT_DELAY);
    },

    onCalendarDeleting: function cMO_onCalendarDeleting(aCalendar) {
    }
};

function scheduleInvitationsUpdate(firstDelay, repeatDelay) {
    gInvitationsCalendarManagerObserver.mCount = 0;
    getInvitationsManager().scheduleInvitationsUpdate(firstDelay,
                                                      repeatDelay,
                                                      gInvitationsOperationListener);
}

function rescheduleInvitationsUpdate(firstDelay, repeatDelay) {
    getInvitationsManager().cancelInvitationsUpdate();
    scheduleInvitationsUpdate(firstDelay, repeatDelay);
}

function openInvitationsDialog() {
    getInvitationsManager().cancelInvitationsUpdate();
    gInvitationsCalendarManagerObserver.mCount = 0;
    getInvitationsManager().openInvitationsDialog(
        gInvitationsOperationListener,
        function oiD_callback() {
            scheduleInvitationsUpdate(FIRST_DELAY_RESCHEDULE,
                                      REPEAT_DELAY);
        });
}

