#!/usr/bin/env python

# MintDesktop
#	No Copyright (What for?) 
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; Version 2
# of the License.

try:
	import os
	import commands
	import sys
	import string
	import pygtk
	pygtk.require("2.0")
except Exception, detail:
	print detail
	pass
try:
	import gtk
	import gtk.glade
	import gettext
except Exception, detail:
	print detail
	sys.exit(1)


# i18n
gettext.install("messages", "/usr/lib/linuxmint/xfcemintDesktop/locale") 
os.system("/usr/lib/linuxmint/xfcemintDesktop/desktopeffects/compiz_check.sh")
os.system("/usr/lib/linuxmint/xfcemintDesktop/tweaks/icons/icon_check.sh")
os.system("/usr/lib/linuxmint/xfcemintDesktop/thumbnail/thumbnail_check.sh")
os.system("/usr/lib/linuxmint/xfcemintDesktop/tweaks/numlock/numlockx_check.sh")

class MintDesktop:
	"""MintDesktop"""

	def __init__(self):
		# vars
		self.gladefile = '/usr/lib/linuxmint/xfcemintDesktop/xfcemintDesktop_frontend.glade'

		self.appName = "Xfce 4 mintDesktop"
		self.appVersion = "3.0"
		
		gtk.glade.bindtextdomain(APPDOMAIN, LANGDIR)
		gtk.glade.textdomain(APPDOMAIN)

		# setup glade widget tree
		self.wTree = gtk.glade.XML(self.gladefile, domain='mintDesktop') 
		
		# create signal dictionary and connect
		self.wTree.get_widget("main_window").connect("destroy", gtk.main_quit)
		self.wTree.get_widget("button_cancel").connect("clicked", gtk.main_quit)
		# set app title
		self.wTree.get_widget("main_window").set_title(self.appName)
		self.wTree.get_widget("compiz_toggle").connect("clicked", self.restore_splash, "toggle")
		self.wTree.get_widget("font_tweak").connect("clicked", self.restore_splash, "font")
		self.wTree.get_widget("white_button").connect("clicked", self.restore_splash, "icon")
		self.wTree.get_widget("black_button").connect("clicked", self.restore_splash, "icon2")
		self.wTree.get_widget("compiz2_toggle").connect("clicked", self.restore_splash, "compiz2")
		self.wTree.get_widget("compiz_check_button").connect("clicked", self.restore_splash, "compiz_check")
		self.wTree.get_widget("cab_toggle").connect("clicked", self.restore_splash, "cab_toggle")
		self.wTree.get_widget("thumb_toggle").connect("clicked", self.restore_splash, "thumb_toggle")
		self.wTree.get_widget("numlock_toggle").connect("clicked", self.restore_splash, "numlock_toggle")

		# i18n
		self.wTree.get_widget("label0").set_text(_("<big><b>Configure your desktop</b></big>"))
		self.wTree.get_widget("label0").set_use_markup(True)

		self.wTree.get_widget("label7").set_text(_("<b>Main</b>"))
		self.wTree.get_widget("label7").set_use_markup(True)

		self.wTree.get_widget("label2").set_text(_("<b>Compiz Fusion</b>"))
		self.wTree.get_widget("label2").set_use_markup(True)

		self.wTree.get_widget("label8").set_text(_("<b>System Tweaks</b>"))
		self.wTree.get_widget("label8").set_use_markup(True)

		self.wTree.get_widget("label1").set_text(_("Restart X shortcut on login"))

                self.wTree.get_widget("label3").set_text(_("Mplayer Video thumbnails settings for Thunar."))

		self.wTree.get_widget("numlock_label").set_text(_("Num Lock on boot"))

		numlock_toggle = self.wTree.get_widget("numlock_toggle")

		tooltips = gtk.Tooltips()

		tooltips.set_tip(numlock_toggle, _("Enable/Disable for all users!"))

		label1 = self.wTree.get_widget("label1")

		tooltips = gtk.Tooltips()

		tooltips.set_tip(label1, _("Ctrl+Alt+Backspace"))
		
		self.wTree.get_widget("label11").set_text(_("LCD System Font(Requires logout to Reset)."))

		label11 = self.wTree.get_widget("label11")

		tooltips = gtk.Tooltips()

		tooltips.set_tip(label11, _("Overwrites ~/.fonts.conf & No Backups"))
		
		self.wTree.get_widget("label12").set_text(_("<b>Remove Border around Desktop icons:</b>"))

		self.wTree.get_widget("label12").set_use_markup(True)
		
		self.wTree.get_widget("compiz_check").set_text(_("Compiz System Check"))

		self.wTree.get_widget("white_icon").set_text(_("Use white for the font color."))

		self.wTree.get_widget("black_icon").set_text(_("Use black for the font color."))

		self.wTree.get_widget("compiz_check").set_text(_("Check Sytem"))	
		
		self.wTree.get_widget("cab_toggle").set_label(_("Enable/Disable"))

		cab_toggle = self.wTree.get_widget("cab_toggle")

		tooltips = gtk.Tooltips()

		tooltips.set_tip(cab_toggle, _("Need to logout to Disable"))

		self.wTree.get_widget("thumb_toggle").set_label(_("Enable/Disable"))

		thumb_toggle = self.wTree.get_widget("thumb_toggle")

		tooltips = gtk.Tooltips()

		tooltips.set_tip(thumb_toggle, _("Clears thumbnail cache"))

		label3 = self.wTree.get_widget("label3")

		tooltips = gtk.Tooltips()

		tooltips.set_tip(label3, _("Needs Mplayer"))

		self.wTree.get_widget("label5").set_text(_("Compiz Fusion"))

		self.wTree.get_widget("compiz_toggle").set_label(_("Enable/Disable"))

		self.wTree.get_widget("label15").set_text(_("Compiz Fusion on Login"))

		self.wTree.get_widget("compiz2_toggle").set_label(_("Enable/Disable"))

		self.wTree.get_widget("font_tweak").set_label(_("Enable/Disable"))

		font_tweak = self.wTree.get_widget("font_tweak")

		tooltips = gtk.Tooltips()

		tooltips.set_tip(font_tweak, _("Overwrites ~/.fonts.conf & No Backups"))

		self.wTree.get_widget("black_button").set_label(_("Enable/Disable"))

		self.wTree.get_widget("white_button").set_label(_("Enable/Disable"))

		self.wTree.get_widget("compiz_check").set_text(_("Compiz System Check"))

		self.wTree.get_widget("compiz_check_button").set_label(_("Check System"))

		self.wTree.get_widget("numlock_toggle").set_label(_("Enable/Disable"))
		
		# Get the current configuration
		confCompiz = commands.getoutput("gconftool-2 --get /apps/mintdesktop-xfce/compiz_fusion")
		if (confCompiz == "true"):
			self.wTree.get_widget("compiz_text").set_text(_("<b>Enabled</b>"))
			self.wTree.get_widget("compiz_text").set_use_markup(True)
		else:
			self.wTree.get_widget("compiz_text").set_text(_("<b>Disabled</b>"))			
			self.wTree.get_widget("compiz_text").set_use_markup(True)
		confLogon = commands.getoutput("gconftool-2 --get /apps/mintdesktop-xfce/compiz_auto")
		if (confLogon == "true"):
			self.wTree.get_widget("auto_text").set_text(_("<b>Enabled</b>"))
			self.wTree.get_widget("auto_text").set_use_markup(True)
		else:
			self.wTree.get_widget("auto_text").set_text(_("<b>Disabled</b>"))
			self.wTree.get_widget("auto_text").set_use_markup(True)

		confText_white = commands.getoutput("gconftool-2 --get /apps/mintdesktop-xfce/text_white")
		if (confText_white == "true"):
			self.wTree.get_widget("text_white").set_text(_("<b>Enabled</b>"))
			self.wTree.get_widget("text_white").set_use_markup(True)
		else:
			self.wTree.get_widget("text_white").set_text(_("<b>Disabled</b>"))
			self.wTree.get_widget("text_white").set_use_markup(True)
		confText_black = commands.getoutput("gconftool-2 --get /apps/mintdesktop-xfce/text_black")
		if (confText_black == "true"):
			self.wTree.get_widget("text_black").set_text(_("<b>Enabled</b>"))
			self.wTree.get_widget("text_black").set_use_markup(True)
		else:
			self.wTree.get_widget("text_black").set_text(_("<b>Disabled</b>"))
			self.wTree.get_widget("text_black").set_use_markup(True)		

		confCab_text = commands.getoutput("gconftool-2 --get /apps/mintdesktop-xfce/cab_toggle")
		if (confCab_text == "true"):
			self.wTree.get_widget("cab_text").set_text(_("<b>Enabled</b>"))
			self.wTree.get_widget("cab_text").set_use_markup(True)
		else:
			self.wTree.get_widget("cab_text").set_text(_("<b>Disabled</b>"))
			self.wTree.get_widget("cab_text").set_use_markup(True)
	
		confThumb_text = commands.getoutput("gconftool-2 --get /apps/mintdesktop-xfce/thumbnails")
		if (confThumb_text == "true"):
			self.wTree.get_widget("thumb_text").set_text(_("<b>Enabled</b>"))
			self.wTree.get_widget("thumb_text").set_use_markup(True)
		else:
			self.wTree.get_widget("thumb_text").set_text(_("<b>Disabled</b>"))
			self.wTree.get_widget("thumb_text").set_use_markup(True)

		confThumb_text = commands.getoutput("gconftool-2 --get /apps/mintdesktop-xfce/numlockx")
		if (confThumb_text == "true"):
			self.wTree.get_widget("numlock_text").set_text(_("<b>Enabled</b>"))
			self.wTree.get_widget("numlock_text").set_use_markup(True)
		else:
			self.wTree.get_widget("numlock_text").set_text(_("<b>Disabled</b>"))
			self.wTree.get_widget("numlock_text").set_use_markup(True)

		#home = os.environ.get("HOME")
		#if (os.path.exists(home + "/.linuxmint/mintDesktop_smb_browsing")):
		#	self.wTree.get_widget("checkbox_smb_browsing").set_active(1)
		#if (os.path.exists(home + "/.linuxmint/mintDesktop_smb_sharing")):
		#	self.wTree.get_widget("checkbox_smb_sharing").set_active(1)
		#	config_file = open(home + "/.linuxmint/mintDesktop_smb_sharing")
		#	for config_item in config_file.readlines():
		#		if (string.find(config_item, "workgroup") == 0):
		#			array = string.split(config_item)
		#			if (len(array) == 2):
		#				(waste, workgroup) = string.split(config_item)
		#				self.wTree.get_widget("txt_workgroup").set_text(workgroup)
		
	def exitApp(self):
		gtk.main_quit()
		sys.exit(0)

	def applyChanges(self, widget): 		
		

		home = os.environ.get("HOME")
		#smb_browsing_selected = self.wTree.get_widget("checkbox_smb_browsing").get_active()
		#if (smb_browsing_selected == True):
		#	os.system("touch " + home + "/.linuxmint/mintDesktop_smb_browsing")
		#else:
		#	os.system("rm " + home + "/.linuxmint/mintDesktop_smb_browsing")
		#smb_sharing_selected = self.wTree.get_widget("checkbox_smb_sharing").get_active()
		#if (smb_sharing_selected == True):
		#	os.system("touch " + home + "/.linuxmint/mintDesktop_smb_sharing")
		#	workgroup = self.wTree.get_widget("txt_workgroup").get_text() 
		#	os.system("echo 'workgroup " + workgroup + "' > " + home + "/.linuxmint/mintDesktop_smb_sharing")
		#else:
		#	os.system("rm " + home + "/.linuxmint/mintDesktop_smb_sharing")
		gtk.main_quit()		
		sys.exit(0)	
	def restore_splash(self, widget, application):
		if (application == "font"):
			os.system("/usr/lib/linuxmint/xfcemintDesktop/tweaks/fonts/fonttoggle.sh") 
			self.wTree.get_widget("font_tweak").set_sensitive(True)	
		if (application == "icon"):
			os.system("/usr/lib/linuxmint/xfcemintDesktop/tweaks/icons/iconstoggle.sh")
			os.system("/usr/lib/linuxmint/xfcemintDesktop/tweaks/icons/icon_check.sh")
			confText_white = commands.getoutput("gconftool-2 --get /apps/mintdesktop-xfce/text_white")
			if (confText_white == "true"):
				self.wTree.get_widget("text_white").set_text(_("<b>Enabled</b>"))
				self.wTree.get_widget("text_white").set_use_markup(True)
			else:
				self.wTree.get_widget("text_white").set_text(_("<b>Disabled</b>"))
				self.wTree.get_widget("text_white").set_use_markup(True)
		if (application == "icon2"):
			os.system("/usr/lib/linuxmint/xfcemintDesktop/tweaks/icons/iconstoggle-black.sh") 
			os.system("/usr/lib/linuxmint/xfcemintDesktop/tweaks/icons/icon_check.sh")
			confText_black = commands.getoutput("gconftool-2 --get /apps/mintdesktop-xfce/text_black")
			if (confText_black == "true"):
				self.wTree.get_widget("text_black").set_text(_("<b>Enabled</b>"))
				self.wTree.get_widget("text_black").set_use_markup(True)
			else:
				self.wTree.get_widget("text_black").set_text(_("<b>Disabled</b>"))
				self.wTree.get_widget("text_black").set_use_markup(True)	
		if (application == "toggle"):
			os.system("/usr/lib/linuxmint/xfcemintDesktop/desktopeffects/compiztoggle.sh")
			self.wTree.get_widget("compiz_toggle").set_sensitive(True)	
			confCompiz = commands.getoutput("gconftool-2 --get /apps/mintdesktop-xfce/compiz_fusion")
			if (confCompiz == "true"):
				self.wTree.get_widget("compiz_text").set_text(_("<b>Enabled</b>"))
				self.wTree.get_widget("compiz_text").set_use_markup(True)
			else:
				self.wTree.get_widget("compiz_text").set_text(_("<b>Disabled</b>"))
				self.wTree.get_widget("compiz_text").set_use_markup(True)	

		if (application == "compiz2"):
			os.system("/usr/lib/linuxmint/xfcemintDesktop/desktopeffects/compizautologin.sh")
			os.system("/usr/lib/linuxmint/xfcemintDesktop/desktopeffects/compiz_check.sh")
			self.wTree.get_widget("compiz2_toggle").set_sensitive(True)
			confLogin = commands.getoutput("gconftool-2 --get /apps/mintdesktop-xfce/compiz_auto")
			if (confLogin == "true"):
				self.wTree.get_widget("auto_text").set_text(_("<b>Enabled</b>"))
				self.wTree.get_widget("auto_text").set_use_markup(True)
			else:
				self.wTree.get_widget("auto_text").set_text(_("<b>Disabled</b>"))
				self.wTree.get_widget("auto_text").set_use_markup(True)

		if (application == "compiz_check"):
			os.system("/usr/lib/linuxmint/xfcemintDesktop/desktopeffects/compiz-check.py") 
			self.wTree.get_widget("compiz_check_button").set_sensitive(True)

		if (application == "cab_toggle"):
			os.system("/usr/lib/linuxmint/xfcemintDesktop/tweaks/restartx/restartx.sh")
			self.wTree.get_widget("cab_toggle").set_sensitive(True)
			confLogin = commands.getoutput("gconftool-2 --get /apps/mintdesktop-xfce/cab_toggle")
			if (confLogin == "true"):
				self.wTree.get_widget("cab_text").set_text(_("<b>Enabled</b>"))
				self.wTree.get_widget("cab_text").set_use_markup(True)
			else:
				self.wTree.get_widget("cab_text").set_text(_("<b>Disabled</b>"))
				self.wTree.get_widget("cab_text").set_use_markup(True)

		if (application == "thumb_toggle"):
			os.system("/usr/lib/linuxmint/xfcemintDesktop/thumbnail/thumbnail_toggle.sh")
			self.wTree.get_widget("thumb_toggle").set_sensitive(True)
			confLogin = commands.getoutput("gconftool-2 --get /apps/mintdesktop-xfce/thumbnails")
			if (confLogin == "true"):
				self.wTree.get_widget("thumb_text").set_text(_("<b>Enabled</b>"))
				self.wTree.get_widget("thumb_text").set_use_markup(True)
			else:
				self.wTree.get_widget("thumb_text").set_text(_("<b>Disabled</b>"))
				self.wTree.get_widget("thumb_text").set_use_markup(True)
	
		if (application == "numlock_toggle"):
			os.system("/usr/lib/linuxmint/xfcemintDesktop/tweaks/numlock/numlockx.sh")
			self.wTree.get_widget("numlock_toggle").set_sensitive(True)
			confLogin = commands.getoutput("gconftool-2 --get /apps/mintdesktop-xfce/numlockx")
			if (confLogin == "true"):
				self.wTree.get_widget("numlock_text").set_text(_("<b>Enabled</b>"))
				self.wTree.get_widget("numlock_text").set_use_markup(True)
			else:
				self.wTree.get_widget("numlock_text").set_text(_("<b>Disabled</b>"))
				self.wTree.get_widget("numlock_text").set_use_markup(True)
	
# ---------- MAIN ----------

if __name__ == "__main__":
	APPDOMAIN='mintDesktop'
	LANGDIR='lang'
	# locale
	gtk.glade.bindtextdomain(APPDOMAIN, LANGDIR)
	gtk.glade.textdomain(APPDOMAIN)
	rec = MintDesktop()
	# run gui
	gtk.main()
