#!/usr/bin/perl -w

eval 'exec /usr/bin/perl  -S $0 ${1+"$@"}'
    if 0; # not running under some shell

#----IMPORTANT--------------------------------------------------------

# This script may contain bugs so use with caution.
# If you find bugs or have improvement suggestions, please drop me an email :)

#----Information-------------------------------------------------------

#This script is part of the Root Actions -servicemenu for kde.
#Written by kubicle <mail.kubicle@gmail.com>


#----Disclaimer-------------------------------------------------------  

# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2, or (at your option)
# any later version.

# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.

# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
# 02110-1301, USA.

#----Instructions-----------------------------------------------------

#This script should be placed along your $PATH for the servicemenu to work, some possible locations are:
#  /usr/local/bin and /usr/bin.

#Also make sure the script is executable for the users that shall use the servicemenu.
#---------------------------------------------------------------------

########### DIALOG MESSAGES, TRANSLATABLE STRINGS #############

sub copy_dialog_msgs {
	&get_kde_language;
	%COPYTITLE = (
	   "cs" => "Kopírovat",
	   "en_US" => "Copy",
	   "fi" => "Kopioi",
	   "fr" => "Copier",
	   "hu" => "Másolás",
	   "it" => "Copia",
	   "lt" => "Kopijuoti",
	   "nb" => "Kopier",
	   "nn" => "Kopier",
	   "pl" => "Kopiuj",
	   "pt" => "Copiar",
	   "pt_PT" => "Copiar",
	   "ru" => "Копировать",
	   "sr" => "Копирај",
	   "sr\@latin" => "Kopiraj",
	   "tr" => "Kopyala",
	   "xx" => "Your string, xx is the country abbreviation"
	);
	%COPYMSG = (
	   "cs" => "Název souboru:",
	   "en_US" => "Filename:",
	   "fi" => "Tiedoston nimi",
	   "fr" => "Nom du fichier:",
	   "hu" => "Fájl neve:",
	   "it" => "Nome del file:",
	   "lt" => "Failo pavadinimas:",
	   "nb" => "Filnavn:",
	   "nn" => "Filnamn:",
	   "pl" => "Nazwa pliku:",
	   "pt" => "Nome do ficheiro:",
	   "pt_PT" => "Nome do ficheiro:",
	   "ru" => "Имя файла:",
	   "sr" => "Име фајла:",
	   "sr\@latin" => "Ime fajla:",
	   "tr" => "Dosya adı:",
	   "xx" => "Your string, xx is the country abbreviation"
	);
	$COPYTITLE = ($COPYTITLE{"$KDELANG"} or $COPYTITLE{"$KDELANGSHT"} or $COPYTITLE{"en_US"});
	$COPYMSG = ($COPYMSG{"$KDELANG"} or $COPYMSG{"$KDELANGSHT"} or $COPYMSG{"en_US"});
	return 0;
}

sub rename_dialog_msgs {
	&get_kde_language;
	%RENAMETITLE = (
	   "cs" => "Přesunout/Přejmenovat",
	   "en_US" => "Move/Rename",
	   "de" => "Umbenennen",
	   "es" => "Renombrar",
	   "fi" => "Nimeä uudelleen",
	   "fr" => "Renommer",
	   "hu" => "Mozgatás/Átnevezés",
	   "it" => "Muovi/Rinomina",
	   "lt" => "Perkelti/pervadinti",
	   "nb" => "Flytt/Omdøp",
	   "nl" => "Hernoemen",
	   "nn" => "Flytt/Omdøyp",
	   "pl" => "Przenieś/Zmień nazwę",
	   "pt" => "Mudar o nome",
	   "pt_PT" => "Mudar o nome",
	   "ru" => "Переместить/переименовать",
	   "sr" => "Премести/преименуј",
	   "sr\@latin" => "Premesti/preimenuj",
	   "tr" => "Taşı/Yeniden İsimlendir",
	   "xx" => "Your string, xx is the country abbreviation"
	);
	%RENAMEMSG = (
	   "cs" => "Nové jméno:",
	   "en_US" => "New name:",
	   "de" => "Neuer Name:",
	   "es" => "Nombre nuevo:",
	   "fi" => "Uusi nimi:",
	   "fr" => "Nouveau nom :",
	   "hu" => "Új név:",
	   "it" => "Nuovo nome:",
	   "lt" => "Naujas pavadinimas:",
	   "nb" => "Nytt navn:",
	   "nl" => "Nieuwe naam:",
	   "nn" => "Nytt namn:",
	   "pl" => "Nowa nazwa:",
	   "pt" => "Novo nome:",
	   "pt_PT" => "Novo nome:",
	   "ru" => "Новое имя:",
	   "sr" => "Ново име:",
	   "sr\@latin" => "Novo ime:",
	   "tr" => "Yeni isim:",
	   "xx" => "Your string, xx is the country abbreviation"
	);
	$RENAMETITLE = ($RENAMETITLE{"$KDELANG"} or $RENAMETITLE{"$KDELANGSHT"} or $RENAMETITLE{"en_US"});
	$RENAMEMSG = ($RENAMEMSG{"$KDELANG"} or $RENAMEMSG{"$KDELANGSHT"} or $RENAMEMSG{"en_US"});
	return 0;
}

sub delete_dialog_msgs {
	&get_kde_language;
	%DELETETITLE = (
	   "cs" => "Varování",
	   "en_US" => "Warning",
	   "de" => "Achtung",
	   "es" => "Aviso",
	   "fi" => "Varoitus",
	   "fr" => "Attention",
	   "hu" => "Figyelem",
	   "it" => "Attenzione",
	   "lt" => "Perspėjimas",
	   "nb" => "Advarsel",
	   "nl" => "Waarschuwing",
	   "nn" => "Advarsel",
	   "pl" => "Ostrzeżenie",
	   "pt" => "Atenção",
	   "pt_PT" => "Atenção",
	   "ru" => "Внимание",
	   "sr" => "Упозорење",
	   "sr\@latin" => "Upozorenje",
	   "tr" => "Uyarı",
	   "xx" => "Your string, xx is the country abbreviation"
	);

	%DELETEMSG = (
	   "cs" => "Jste si jisti, že chcete nenávratně smazat: ",
	   "en_US" => "Are you sure you wish to permanently delete: ", 
	   "de" => "Möchten Sie die folgenden Dateien dauerhaft löschen: ",
	   "es" => "¿Estas seguro de querer borrarlo por completo?",
	   "fi" => "Haluatko varmasti kokonaan poistaa: ",
	   "fr" => "Êtes-vous sûr de vouloir supprimer définitivement :",
	   "hu" => "Biztosan törölni akarod?",
	   "it" => "Sei sicuro di voler eliminare in modo definitivo: ",
	   "lt" => "Ar tikrai norite galutinai ištrinti: ",
	   "nb" => "Er du sikker på at du vil slette permanent: ",
	   "nl" => "Bent u zeker dat u permanent wil verwijderen: ",
	   "nn" => "Er du sikker på at du vil slette permanent: ",
	   "pl" => "Czy na pewno chcesz nieodwracalnie usunąć: ",
	   "pt" => "Tem a certeza que quer apagar definitivamente? ",
	   "pt_PT" => "Tem a certeza que quer apagar definitivamente? ",
	   "ru" => "Вы уверены, что хотите удалить:",
	   "sr" => "Желите ли заиста да обришете: ",
	   "sr\@latin" => "Želite li zaista da obrišete: ",
	   "tr" => "Bu dosyayı kalıcı olarak silmek istediğinize emin misiniz: ",
	   "xx" => "Your string, xx is the country abbreviation"
	);
	$DELETETITLE = ($DELETETITLE{"$KDELANG"} or $DELETETITLE{"$KDELANGSHT"} or $DELETETITLE{"en_US"});
	$DELETEMSG = ($DELETEMSG{"$KDELANG"} or $DELETEMSG{"$KDELANGSHT"} or $DELETEMSG{"en_US"});
	return 0;
}

sub ownership_dialog_msgs {
	&get_kde_language;
	%OWNERTITLE = (
	   "cs" => "Nastavit UID:GIG",
	   "en_US" => "Set UID:GID", 
	   "de" => "Eigentümer ändern",
	   "es" => "Establecer UID:GID",
	   "fi" => "Anna UID:GID",
	   "fr" => "Modifier UID:GID",
	   "hu" => "UID:GID beállítása",
	   "it" => "Cambia UID:GID",
	   "lt" => "Nustatyti UID:GID",
	   "nb" => "Sett UID:GID",
	   "nl" => "Wijzig UID:GID",
	   "nn" => "Set UID:GID",
	   "pl" => "Ustawienie UID:GID",
	   "pt" => "Atribuir UID:GID",
	   "pt_PT" => "Atribuir UID:GID",
	   "ru" => "Установить UID:GID",
	   "sr" => "Постави УИД:ГИД",
	   "sr\@latin" => "Postavi UID:GID",
	   "tr" => "UID:GID'i ayarla",
	   "xx" => "Your string, xx is the country abbreviation"
	);

	%OWNERMSG = (
	   "cs" => "Změnit vlastníka na: ",
	   "en_US" => "Change ownership to: ", 
	   "de" => "Neuer Eigentümer: ",
	   "es" => "Cambiar propietario a: ",
	   "fi" => "Vaihda omistajaksi: ",
	   "fr" => "Attribuer à : ",
	   "hu" => "Fájl tulajdonosának megváltoztatása: ",
	   "it" => "Cambia proprietario: ",
	   "lt" => "Pakeisti nuosavybę į: ",
	   "nb" => "Sett eierskap til: ",
	   "nl" => "Wijzig eigenaar in: ",
	   "nn" => "Set eigarskap til: ",
	   "pl" => "Zmień własność na: ",
	   "pt" => "Alterar dono para: ",
	   "pt_PT" => "Alterar dono para: ",
	   "ru" => "Сменить владельца на:",
	   "sr" => "Промени власника: ",
	   "sr\@latin" => "Promeni vlasnika: ",
	   "tr" => "Dosyanın sahibini değiştir: ",
	   "xx" => "Your string, xx is the country abbreviation"
	);
	$OWNERTITLE = ($OWNERTITLE{"$KDELANG"} or $OWNERTITLE{"$KDELANGSHT"} or $OWNERTITLE{"en_US"});
	$OWNERMSG = ($OWNERMSG{"$KDELANG"} or $OWNERMSG{"$KDELANGSHT"} or $OWNERMSG{"en_US"});
	return 0;
}

sub recursion_dialog_msgs {
	&get_kde_language;
	%RECURSIONTITLE = (
	   "cs" => "Aplikovat změny na všechny?",
	   "en_US" => "Apply changes recursively?",
	   "fi" => "Toteutetaanko muutokset rekursiivisesti?",
	   "fr" => "Appliquer récursivement les modifications ?",
	   "hu" => "A változások az alkönyvtár(ak)ra is kiterjedjenek?",
	   "it" => "Applico i cambiamenti?",
	   "lt" => "Taikyti pakeitimus rekursyviai?",
	   "nb" => "Endre rekursivt?",
	   "nn" => "Endra rekursivt?",
	   "pl" => "Wprowadzić zmiany rekursywnie?",
	   "pt" => "Aplicar alterações recursivamente?",
	   "pt_PT" => "Aplicar alterações recursivamente?",
	   "ru" => "Применить изменения рекурсивно?",
	   "sr" => "Да применим измене рекурзивно?",
	   "sr\@latin" => "Da primenim izmene rekurzivno?",
	   "tr" => "Değişiklikler özyinelemeli olarak uygulansın mı?",
	   "xx" => "Your string, xx is the country abbreviation"
	);

	%RECURSIONMSG = (
	   "cs" => "Jste si jisti, že chcete změny aplikovat na všechny soubory a podsložky? \n(Používejte z rozmyslem)",
	   "en_US" => "Do you wish to apply the changes recursively to all sub-folders and files? \n(Use with caution)",
	   "fi" => "Haluatko ulottaa muutokset rekursiivisesti alikansioihin ja tiedostoihin? \n(Käytä varoen)",
	   "fr" => "Voulez-vous appliquer les modifications récursivement à tous les répertoires et fichiers ? \n(À utiliser avec précaution)",
	   "hu" => "Szeretnéd, ha a változtatások minden alkönyvtárra és az ott lévő fájlokra is kiterjedjenek? \n(Légy óvatos)",
	   "it" => "Vuoi applicare i cambiamenti a tutte le sottocartelle e ai files? \n(Da utilizzare con cautela)",
	   "lt" => "Ar norite pritaikyti pakeitums rekursyviai visiems paaplankiams ir failams? \n(Naudoti atsargiai)",
	   "nb" => "Vil du gjøre endringene gjeldende rekursivt i alle undermapper og filer? \n(Vær forsiktig)",
	   "nn" => "Vil du gjere endringane gjeldande rekursivt i alle undermapper og filer? \n(Vér forsiktig)",
	   "pl" => "Czy chcesz wprowadzić zmiany rekursywnie dla wszystkich podfolderów i plików? \n(Używaj z ostrożnością)",
	   "pt" => "Deseja aplicar as alterações recursivamente a todos os sub-directórios e ficheiros? \n(Usar com cuidado)",
	   "pt_PT" => "Deseja aplicar as alterações recursivamente a todos os sub-directórios e ficheiros? \n(Usar com cuidado)",
	   "ru" => "Вы хотите применить изменения рекурсивно для всех подпапок и файлов",
	   "sr" => "Желите ли да примените измене рекурзивно на све потфасцикле и фајлове? \n(Користите ово пажљиво)",
	   "sr\@latin" => "Želite li da primenite izmene rekurzivno na sve potfascikle i fajlove? \n(Koristite ovo pažljivo)",
	   "tr" => "Değişiklikleri tüm altdizinlere ve dosyalara özyinelemeli olarak uygulamak istiyor musunuz? \n(Dikkatli kullanın",
	   "xx" => "Your string, xx is the country abbreviation"
	);
	$RECURSIONTITLE = ($RECURSIONTITLE{"$KDELANG"} or $RECURSIONTITLE{"$KDELANGSHT"} or $RECURSIONTITLE{"en_US"});
	$RECURSIONMSG = ($RECURSIONMSG{"$KDELANG"} or $RECURSIONMSG{"$KDELANGSHT"} or $RECURSIONMSG{"en_US"});
	return 0;
}

sub root_reminder_msgs {
	&get_kde_language;
	%ROOTREMINDER = (
	   "cs" => "OTEVŘENO JAKO ROOT",
	   "en_US" => "OPENED AS ROOT",
	   "fi" => "AVATTU PÄÄKÄYTTÄJÄNÄ",
	   "fr" => "OUVERT EN ROOT",
	   "hu" => "RENDSZERGAZDAKÉNT MEGNYITVA",
	   "it" => "APERTO COME ROOT",
	   "lt" => "ATVERTA ROOT TEISĖMIS",
	   "nb" => "ÅPNET SOM ROOT",
	   "nn" => "OPNA SOM ROOT",
	   "pl" => "OTWARTO JAKO ADMINISTRATOR",
	   "pt" => "ABERTO COMO ROOT",
	   "pt_PT" => "ABERTO COMO ROOT",
	   "ru" => "Открыто как root",
	   "sr" => "ОТВОРЕНО КАО КОРЕН",
	   "sr\@latin" => "OTVORENO KAO KOREN",
	   "tr" => "YETKİLİ KULLANICI OLARAK AÇILDI",
	   "xx" => "Your string, xx is the country abbreviation"
	);
	$ROOTREMINDER = ($ROOTREMINDER{"$KDELANG"} or $ROOTREMINDER{"$KDELANGSHT"} or $ROOTREMINDER{"en_US"});
	return 0;
}


sub open_dialog_msgs {
	&get_kde_language;
	%OPENTITLE = (
	   "cs" => "Program",
	   "en_US" => "Program",
	   "de" => "Programm",
	   "es" => "Programa",
	   "fi" => "Ohjelma",
	   "fr" => "Programme",
	   "hu" => "Program",
	   "it" => "Programma",
	   "lt" => "Programa",
	   "nb" => "Program",
	   "nl" => "Programma",
	   "nn" => "Program",
	   "pl" => "Program",
	   "pt" => "Programa",
	   "pt_PT" => "Programa",
	   "ru" => "Программа",
	   "sr" => "Програм",
	   "sr\@latin" => "Program",
	   "tr" => "Program",
	   "xx" => "Your string, xx is the country abbreviation"
	);

	%OPENMSG = (
	   "cs" => "Otevřít s: ",
	   "en_US" => "Open with: ",
	   "de" => "Öffnen mit: ",
	   "es" => "Abrir con: ",
	   "fi" => "Avaa ohjelmalla: ",
	   "fr" => "Ouvrir avec : ",
	   "hu" => "Megnyitás ezzel: ",
	   "it" => "Apri con: ",
	   "lt" => "Atverti su: ",
	   "nb" => "Åpne med: ",
	   "nl" => "Openen met: ",
	   "nn" => "Opna med: ",
	   "pl" => "Otwórz z: ",
	   "pt" => "Abrir com: ",
	   "pt_PT" => "Abrir com: ",
	   "ru" => "Открыть с помощью: ",
	   "sr" => "Отвори помоћу: ",
	   "sr\@latin" => "Otvori pomoću: ",
	   "tr" => "Birlikte aç: ",
	   "xx" => "Your string, xx is the country abbreviation"
	);
	$OPENTITLE = ($OPENTITLE{"$KDELANG"} or $OPENTITLE{"$KDELANGSHT"} or $OPENTITLE{"en_US"});
	$OPENMSG = ($OPENMSG{"$KDELANG"} or $OPENMSG{"$KDELANGSHT"} or $OPENMSG{"en_US"});
	return 0;
}

sub permission_dialog_msgs {
	&get_kde_language;
	%PERMTITLE = (
	   "cs" => "Oprávnění",
	   "en_US" => "Permissions",
	   "de" => "Berechtigungen",
	   "es" => "Permisos",
	   "fi" => "Käyttöoikeudet",
	   "fr" => "Droits d'accès",
	   "hu" => "Jogosultságok",
	   "it" => "Permessi",
	   "lt" => "Leidimai",
	   "nb" => "Rettigheter",
	   "nl" => "Toegengsrechten",
	   "nn" => "Rettigheiter",
	   "pl" => "Uprawnienia",
	   "pt" => "Permissões",
	   "pt_PT" => "Permissões",
	   "ru" => "Резрешения",
	   "sr" => "Дозволе",
	   "sr\@latin" => "Dozvole",
	   "tr" => "Yetkiler",
	   "xx" => "Your string, xx is the country abbreviation"
	);

	%PERMMSG = (
	   "cs" => "Zvolit oprávnění",
	   "en_US" => "Choose permissions: ",
	   "de" => "Berechtigungen auswählen: ",
	   "es" => "Elegir permisos: ",
	   "fi" => "Valitse käyttöoikeudet: ",
	   "fr" => "Choisissez les droits d'accès : ",
	   "hu" => "Add meg a jogosultságokat: ",
	   "it" => "Permessi di accesso: ",
	   "lt" => "Pasirinkite leidimus: ",
	   "nb" => "Velg rettigheter: ",
	   "nl" => "Toegangsrechten instellen: ",
	   "nn" => "Velg rettigheiter: ",
	   "pl" => "Wybierz uprawnienia: ",
	   "pt" => "Escolher permissões: ",
	   "pt_PT" => "Escolher permissões: ",
	   "ru" => "Выбрать разрешения: ",
	   "sr" => "Изаберите дозволе: ",
	   "sr\@latin" => "Izaberite dozvole: ",
	   "tr" => "Yetkileri belirle: ",
	   "xx" => "Your string, xx is the country abbreviation"
	);

	%OWN = (
	   "cs" => "Vlastník:",
	   "en_US" => "Owner:",
	   "de" => "Besitzer:",
	   "es" => "Propietario:",
	   "fi" => "Omistaja:",
	   "fr" => "Propriétaire :",
	   "hu" => "Tulajdonos:",
	   "it" => "Proprietario:",
	   "lt" => "Savininkas:",
	   "nb" => "Eier:",
	   "nl" => "Eigenaar:",
	   "nn" => "Eigar:",
	   "pl" => "Właściciel:",
	   "pt" => "Dono:",
	   "pt_PT" => "Dono:",
	   "ru" => "Владелец:",
	   "sr" => "Власник:",
	   "sr\@latin" => "Vlasnik:",
	   "tr" => "Sahip:",
	   "xx" => "Your string, xx is the country abbreviation"
	);

	%GRP = (
	   "cs" => "Skupina:",
	   "en_US" => "Group:",
	   "de" => "Gruppe:",
	   "es" => "Grupo:",
	   "fi" => "Ryhmä:",
	   "fr" => "Groupe :",
	   "hu" => "Csoport:",
	   "it" => "Gruppo:",
	   "lt" => "Grupė:",
	   "nb" => "Gruppe:",
	   "nl" => "Groep:",
	   "nn" => "Gruppe:",
	   "pl" => "Grupa:",
	   "pt" => "Grupo:",
	   "pt_PT" => "Grupo:",
	   "ru" => "Группа:",
	   "sr" => "Група:",
	   "sr\@latin" => "Grupa:",
	   "tr" => "Grup",
	   "xx" => "Your string, xx is the country abbreviation"
	);

	%ALL = (
	   "cs" => "Ostatní:",
	   "en_US" => "Others:",
	   "de" => "Alle Benutzer:",
	   "es" => "Todos:",
	   "fi" => "Kaikki:",
	   "fr" => "Autres :",
	   "hu" => "Mindenki:",
	   "it" => "Tutti:",
	   "lt" => "Kiti:",
	   "nb" => "Andre:",
	   "nl" => "Anderen:",
	   "nn" => "Andre:",
	   "pl" => "Wszyscy:",
	   "pt" => "Todos:",
	   "pt_PT" => "Todos:",
	   "ru" => "Другие:",
	   "sr" => "Остали:",
	   "sr\@latin" => "Ostali:",
	   "tr" => "Diğerleri:",
	   "xx" => "Your string, xx is the country abbreviation"
	);

	%SPC = (
	   "cs" => "Speciální:",
	   "en_US" => "Special:",
	   "de" => "Spezial:",
	   "es" => "Especial:",
	   "fi" => "Erityiset:",
	   "fr" => "Spécial :",
	   "hu" => "Különleges:",
	   "it" => "Avanzati:",
	   "lt" => "Specialūs:",
	   "nb" => "Spesielt:",
	   "nl" => "Speciaal:",
	   "nn" => "Spesielt:",
	   "pl" => "Specjalne:",
	   "pt" => "Especial:",
	   "pt_PT" => "Especial:",
	   "ru" => "Специальный:",
	   "sr" => "Посебно:",
	   "sr\@latin" => "Posebno:",
	   "tr" => "Özel:",
	   "xx" => "Your string, xx is the country abbreviation"
	);

	%READ = (
	   "cs" => "čtení",
	   "en_US" => "readable",
	   "de" => "Lesen",
	   "es" => "Lectura",
	   "fi" => "lukuoikeus",
	   "fr" => "Lecture",
	   "hu" => "Olvasható",
	   "it" => "leggibile",
	   "lt" => "skaitomas",
	   "nb" => "lesbar",
	   "nl" => "Leesbaar",
	   "nn" => "lesbar",
	   "pl" => "tylko do odczytu",
	   "pt" => "Permissão de leitura",
	   "pt_PT" => "Permissão de leitura",
	   "ru" => "Разрешён для чтения",
	   "sr" => "читање",
	   "sr\@latin" => "čitanje",
	   "tr" => "okunabilir",
	   "xx" => "Your string, xx is the country abbreviation"
	);

	%WRITE = (
	   "cs" => "zápis",
	   "en_US" => "writable",
	   "de" => "Schreiben",
	   "es" => "Escritura",
	   "fi" => "kirjoitusoikeus",
	   "fr" => "Écriture",
	   "hu" => "Írható",
	   "it" => "scrivibile",
	   "lt" => "rašomas",
	   "nb" => "skrivbar",
	   "nl" => "Schrijfbaar",
	   "nn" => "skrivbar",
	   "pl" => "do odczytu i zapisu",
	   "pt" => "Permissão de escrita",
	   "pt_PT" => "Permissão de escrita",
	   "ru" => "Разрешён для записи",
	   "sr" => "упис",
	   "sr\@latin" => "upis",
	   "tr" => "yazılabilir",
	   "xx" => "Your string, xx is the country abbreviation"
	);

	%EXEC = (
	   "cs" => "spuštění",
	   "en_US" => "executable",
	   "de" => "Ausführen",
	   "es" => "Ejecutable",
	   "fi" => "suoritusoikeus",
	   "fr" => "Exécution",
	   "hu" => "Futtatható",
	   "it" => "eseguibile",
	   "lt" => "vykdomas",
	   "nb" => "kjørbar",
	   "nl" => "Uitvoerbaar",
	   "nn" => "køyrbar",
	   "pl" => "wykonywalny",
	   "pt" => "Executável",
	   "pt_PT" => "Executável",
	   "ru" => "Исполняемый",
	   "sr" => "извршна",
	   "sr\@latin" => "izvršna",
	   "tr" => "çalıştırılabilir",
	   "xx" => "Your string, xx is the country abbreviation"
	);

	%SUID = (
	   "cs" => "nastavit uživatelské ID",
	   "en_US" => "set user ID bit",
	   "de" => "User-ID-Bit setzen",
	   "es" => "Establecer el bit-ID de usuario",
	   "fi" => "aseta SUID-bitti",
	   "fr" => "Donner l'UID",
	   "hu" => "UID beállítása",
	   "it" => "inserisci bit UID",
	   "lt" => "nustatyti vartotojo UID bitą",
	   "nb" => "sett bruker-ID",
	   "nl" => "User ID instellen",
	   "nn" => "set brukar-ID",
	   "pl" => "ustaw ID użytkownika",
	   "pt" => "Definir o bit ID de utilizador",
	   "pt_PT" => "Definir o bit ID de utilizador",
	   "ru" => "Установить UID пользователя",
	   "sr" => "стави УИД",
	   "sr\@latin" => "stavi UID",
	   "tr" => "kullanıcı ID bitini ayarla",
	   "xx" => "Your string, xx is the country abbreviation"
	);

	%SGID = (
	   "cs" => "nastavit skupinové ID",
	   "en_US" => "set group ID bit",
	   "de" => "Gruppen-ID-Bit setzen",
	   "es" => "Establecer el bit-ID de grupo",
	   "fi" => "aseta SGID-bitti",
	   "fr" => "Donner le GID",
	   "hu" => "GID beállítása",
	   "it" => "inserisci bit GID",
	   "lt" => "nustatyti grupės GID bitą",
	   "nb" => "sett gruppe-ID",
	   "nl" => "Groep ID instellen",
	   "nn" => "set gruppe-ID",
	   "pl" => "ustaw ID grupy",
	   "pt" => "Definir o bit ID de grupo",
	   "pt_PT" => "Definir o bit ID de grupo",
	   "ru" => "Установить GID группы",
	   "sr" => "стави ГИД",
	   "sr\@latin" => "stavi GID",
	   "tr" => "grup ID bitini ayarla",
	   "xx" => "Your string, xx is the country abbreviation"
	);

	%STICK = (
	   "cs" => "Sticky",
	   "en_US" => "set sticky bit",
	   "de" => "Sticky-Bit setzen",
	   "es" => "Establecer el bit-Sticky",
	   "fi" => "aseta sticky-bitti",
	   "fr" => "Allouer le bit collant",
	   "hu" => "Sticky bit beállítása",
	   "it" => "inserisci bit Sticky",
	   "lt" => "nustatyti lipnų bitą",
	   "nb" => "klebrig",
	   "nl" => "Vastgezet",
	   "nn" => "klebrig",
	   "pl" => "ustaw parametr 'sticky'",
	   "pt" => "Definir o bit 'sticky'",
	   "pt_PT" => "Definir o bit 'sticky'",
	   "ru" => "Установить липкий бит",
	   "sr" => "стави лепљиву",
	   "sr\@latin" => "stavi lepljivu",
	   "tr" => "yapışkan biti ayarla",
	   "xx" => "Your string, xx is the country abbreviation"
	);

	%SPCTITLE = (
	   "cs" => "Varování",
	   "en_US" => "Warning",
	   "de" => "Achtung",
	   "es" => "Aviso",
	   "fi" => "Varoitus",
	   "fr" => "Attention",
	   "hu" => "Figyelem",
	   "it" => "Attenzione",
	   "lt" => "Dėmesio",
	   "nb" => "Advarsel",
	   "nl" => "Waarschuwing",
	   "nn" => "Advarsel",
	   "pl" => "Ostrzeżenie",
	   "pt" => "Atenção",
	   "pt_PT" => "Atenção",
	   "ru" => "Внимание",
	   "sr" => "Упозорење",
	   "sr\@latin" => "Upozorenje",
	   "tr" => "Dikkat",
	   "xx" => "Your string, xx is the country abbreviation"
	);

	%SPCMSG = (
	   "cs" => "Zvolili jste speciální práva, jste si jisti že chcete pokračovat?",
	   "en_US" => "You have chosen to set special permissions, are you sure you wish to continue?",
	   "de" => "Sie haben eine spezielle Berechtigung ausgewählt. Möchten Sie wirklich fortfahren?",
	   "es" => "Has seleccionado establecer permisos especiales, ¿estas seguro de continuar?",
	   "fi" => "Valitsit asetettavaksi erityisiä käyttöoikeuksia. Oletko varma, että haluat jatkaa?",
	   "fr" => "Vous avez choisi de modifier les droits étendus, êtes-vous sûr de vouloir continuer ?",
	   "hu" => "Biztos, hogy meg akarod változtatni ezeket a különleges felhasználói jogosultságokat?",
	   "it" => "Hai scelto di utilizzare dei permessi avanzati, sei sicuro di voler continuare?",
	   "lt" => "Jūs pasirinkote nustatyti ypatingus leidimus, ar tikrai norite tęsti?",
	   "nb" => "Du har valgt spesielle bits. Vil du virkelig fortsette?",
	   "nl" => "U heeft ervoor gekozen speciale toegangsrechten in te stellen, bent u zeker dat u verder wilt gaan?",
	   "nn" => "Du har valgt spesielle bits. Vil du verkeleg fortsette?",
	   "pl" => "Wybrałeś ustawienie specjalnych uprawnień. Czy na pewno kontynuować?",
	   "pt" => "Escolheu definir as permissões especiais, tem a certeza que quer continuar?",
	   "pt_PT" => "Escolheu definir as permissões especiais, tem a certeza que quer continuar?",
	   "ru" => "Вы решили установить особые разрешения, вы уверены, что хотите продолжить?",
	   "sr" => "Поставили сте посебне дозволе, желите ли заиста да наставите?",
	   "sr\@latin" => "Postavili ste posebne dozvole, želite li zaista da nastavite?",
	   "tr" => "Özel yetki ayarları yapmayı seçtiniz, devam etmek istediğinize emin misiniz?",
	   "xx" => "Your string, xx is the country abbreviation"
	);

########### DIALOG MESSAGES END #####################################

	$PERMTITLE = ($PERMTITLE{"$KDELANG"} or $PERMTITLE{"$KDELANGSHT"} or $PERMTITLE{"en_US"});
	$PERMMSG = ($PERMMSG{"$KDELANG"} or $PERMMSG{"$KDELANGSHT"} or $PERMMSG{"en_US"});
	$OWN = ($OWN{"$KDELANG"} or $OWN{"$KDELANGSHT"} or $OWN{"en_US"});
	$GRP = ($GRP{"$KDELANG"} or $GRP{"$KDELANGSHT"} or $GRP{"en_US"});
	$ALL = ($ALL{"$KDELANG"} or $ALL{"$KDELANGSHT"} or $ALL{"en_US"});
	$SPC = ($SPC{"$KDELANG"} or $SPC{"$KDELANGSHT"} or $SPC{"en_US"});
	$READ = ($READ{"$KDELANG"} or $READ{"$KDELANGSHT"} or $READ{"en_US"});
	$WRITE = ($WRITE{"$KDELANG"} or $WRITE{"$KDELANGSHT"} or $WRITE{"en_US"});
	$EXEC = ($EXEC{"$KDELANG"} or $EXEC{"$KDELANGSHT"} or $EXEC{"en_US"});
	$SUID = ($SUID{"$KDELANG"} or $SUID{"$KDELANGSHT"} or $SUID{"en_US"});
	$SGID = ($SGID{"$KDELANG"} or $SGID{"$KDELANGSHT"} or $SGID{"en_US"});
	$STICK = ($STICK{"$KDELANG"} or $STICK{"$KDELANGSHT"} or $STICK{"en_US"});
	$SPCTITLE = ($SPCTITLE{"$KDELANG"} or $SPCTITLE{"$KDELANGSHT"} or $SPCTITLE{"en_US"});
	$SPCMSG = ($SPCMSG{"$KDELANG"} or $SPCMSG{"$KDELANGSHT"} or $SPCMSG{"en_US"});
	return 0;
}


#Find out the language used in kde
sub get_kde_language {
	if ( exists $ENV{KDEHOME}) {
		$KDEGLOBALFILE = "$ENV{KDEHOME}/share/config/kdeglobals";
	}
	else {
		$KDEGLOBALFILE = "~/.kde/share/config/kdeglobals";
	}

	# use kreadconfig to get the languages set for kde. Use cut to get only the primary language and discard encoding.
	chomp($KDELANG = `$CONFIGCOMMAND --group Locale --key Language --file $KDEGLOBALFILE | cut -d ':' -f 1 | cut -d '.' -f 1`);

	# If $KDEGLOBALFILE contains no language info, kreadconfig will print nothing. Read the LANG environment variable instead.
	if( $KDELANG eq ""){
		$KDELANG = $ENV{LANG};
	}

	chomp($KDELANGSHT = substr("$KDELANG",0,2));
	return 0;
}

sub get_kde_path {
	if ( exists $ENV{KDEDIR} ) {
		$KDEBINPATH = "$ENV{KDEDIR}/bin/";
	}

	else {
		$KDEBINPATH = "";
	}
	
}

# Print error message if called without arguments (if the script is run directly)
if ( $#ARGV lt 0 ) {
   die "This script is not meant to be run directly. It will run with the necessary arguments when called from the .desktop files when a root action is selected by right-clicking item(s) in konqueror/dolphin.\n" ;
}

# Check whether kdesudo is installed, and use it instead of kdesu to get root privileges.
&get_kde_path ;

if ( `which kdesudo` ) {
	$SUCOMMAND = "$KDEBINPATH"."kdesudo -d --noignorebutton --"}
elsif ( `which kdesu` ) {
	$SUCOMMAND = "$KDEBINPATH"."kdesu -d --"}
else { $SUCOMMAND = "xdg-su -c"}

$DIALOGCOMMAND = "$KDEBINPATH"."kdialog" ;
$CONFIGCOMMAND = "$KDEBINPATH"."kreadconfig" ;


#---Start root actions---
$EXECNAME = $0 ;
$ACTION = shift @ARGV ;
$TARGET = join("' '", @ARGV) ;
&{$ACTION} or die ;

#---Root konsole subroutines---
sub root_konsole_here {
	$APPNAME = shift @ARGV ;
	$WORKDIR = shift @ARGV ;
	exec "$SUCOMMAND \"\'$EXECNAME\' do_root_konsole \'$APPNAME\' \'$WORKDIR\'\"";
	exit $?;
}

sub do_root_konsole {
	if ( $> eq 0 ) {
	   #get root reminder string
	   &root_reminder_msgs;
	   #Get the terminal and working directory
	   $APPNAME = shift @ARGV ;
	   
	   if ( -x $KDEBINPATH.$APPNAME ) {
              $TERMINAL = $KDEBINPATH.$APPNAME ; }
           else {
              $TERMINAL = $APPNAME ; }
	   
	   $APPNAME =~ tr/a-z/A-Z/ ;
	   $WORKDIR = shift @ARGV ;
	   exec "$TERMINAL --workdir \'$WORKDIR\' --caption \"$APPNAME $ROOTREMINDER\"" ;
	   exit $?;
	}
}
#---End root konsole subroutines---

#---Open with subroutines---
sub custom_open_with {
	#Get program
	&open_dialog_msgs;
	$APPNAME = `$DIALOGCOMMAND --title "$OPENTITLE" --inputbox "$OPENMSG" program` ;
	if ( $? eq 0 ) {
	   chomp $APPNAME ;
      	   exec "$SUCOMMAND \"\'$EXECNAME\' do_open_with \'$APPNAME\' \'$TARGET\'\"";
	   exit $?;
	}
}

sub open_with {
	$APPNAME = shift @ARGV ;
	$TARGET = join("' '", @ARGV) ;

	if ( $APPNAME eq "kate" ) {
	      system "which kate" ;
	      if ( $? ne 0 ) {
		  $APPNAME = "kwrite"; }
	}

	exec "$SUCOMMAND \"\'$EXECNAME\' do_open_with \'$APPNAME\' \'$TARGET\'\"";
	exit $?; 
}

sub do_open_with {
	#If running as root, open the files
	if ( $> eq 0 ) {
	   #get root reminder string
	   &root_reminder_msgs;
	   #Which program? (first argument)
	   $APPNAME = shift @ARGV ;
	   
	   if ( -x $KDEBINPATH.$APPNAME ) {
              $CPROGRAM = $KDEBINPATH.$APPNAME ; }
           else {
              $CPROGRAM = $APPNAME ;}

	   $APPNAME =~ tr/a-z/A-Z/ ;
	   shift;
	   #Create Target file string
	   $TARGET = join("' '", @ARGV) ;
	   exec "$CPROGRAM --caption \"$APPNAME $ROOTREMINDER\" \'$TARGET\'" ;
	   exit $?;
	}
}
#---End open with subroutines---

#---Copy subroutines---
sub root_copy {
	
	   &copy_dialog_msgs;
	   $OLDNAME = $ARGV[0];
	   $NEWNAME = `$DIALOGCOMMAND --title "$COPYTITLE" --inputbox "$COPYMSG" \'$OLDNAME\'` ;
	   chop $NEWNAME;
	   if ( $? eq 0 && $OLDNAME ne $NEWNAME ) {
	      exec "$SUCOMMAND \"\'$EXECNAME\' do_copy \'$OLDNAME\' \'$NEWNAME\'\"";
	      exit $?;

	   }
}

sub do_copy {
	#If running as root, rename the file
	if ( $> eq 0 ) {
	   #get the arguments)
	   $OLDNAME = $ARGV[0] ;
	   $NEWNAME = $ARGV[1] ;
	   `cp -pr \'$OLDNAME\' \'$NEWNAME\'`;
	}
}
#---End copy subroutines---

#---Rename subroutines---
sub root_rename {
	# If more than one file is selected, and a batch rename application is installed, open it
	$BATCHRENAMER = shift @ARGV ;
	$TARGET = join("' '", @ARGV) ;
	chomp($RENAMERPATH = `which $BATCHRENAMER`);	
	if ( $#ARGV > 0 && -x $RENAMERPATH ) {
	   exec "$SUCOMMAND \"\'$EXECNAME\' do_open_with \'$BATCHRENAMER\' \'$TARGET\'\"";
	   exit $?;
	}
	# else we'll use a simple rename script
	else {
	   &rename_dialog_msgs;
	   $OLDNAME = $ARGV[0];
	   $NEWNAME = `$DIALOGCOMMAND --title "$RENAMETITLE" --inputbox "$RENAMEMSG" \'$OLDNAME\'` ;
	   chop $NEWNAME;
	   if ( $? eq 0 && $OLDNAME ne $NEWNAME ) {
	      exec "$SUCOMMAND \"\'$EXECNAME\' do_rename \'$OLDNAME\' \'$NEWNAME\'\"";
	      exit $?;
	   }
	}
}

sub do_rename {
	#If running as root, rename the file
	if ( $> eq 0 ) {
	   #get the arguments)
	   $OLDNAME = $ARGV[0] ;
	   $NEWNAME = $ARGV[1] ;
	   `mv \'$OLDNAME\' \'$NEWNAME\'`;
	}
}
#---End rename subroutines---

#---Deletion subroutines---
sub root_delete {
	#Create a viewer friendly list of files to be deleted for the warning dialog
	$TARGETLIST = join("\\n", @ARGV);
	
	#Show warning dialog
	&delete_dialog_msgs;
	system "$DIALOGCOMMAND --title \'$DELETETITLE\' --warningcontinuecancel \'$DELETEMSG\\n$TARGETLIST\'" ;

	#Is deletion confirmed?
	if ( $? eq 0 ) {
	   # kdesu will run the command as regular user if 'Ignore' is chosen from kdesu dialog.
	   # To prevent unwanted deletion of files, we'll run 'do_delete' instead of 'rm -r', 'do delete'
	   # will exit if it's run as normal user, therefore the files writable for user are safe when clicking 'Ignore'
	   exec "$SUCOMMAND \"\'$EXECNAME\' do_delete \'$TARGET\'\"";
	}
}

sub do_delete {
	#If running as root, remove the files targeted
	if ( $> eq 0 ) {
	   `rm -r --preserve-root \'$TARGET\'` ;
	}
	exit 0;
}
#---End deletion subroutines---

#---Ownership subroutines---
sub root_ownership {
	#chown target files to root

	# If only one directory selected, ask whether to apply the changes recursively
	$RECURSIVE = "0" ;
	if ( $#ARGV < 1 && -d $ARGV[0]) {
		&recursion_dialog_msgs ;
	   	system "$DIALOGCOMMAND --title \'$RECURSIONTITLE\' --yesno \'$RECURSIONMSG\'";
	   	if ( $? eq 0 ) {
	   		$RECURSIVE = "1" ;
	   	}
        }

	# Same as with delete, we don't want kdesu to run 'chown' when 'Ignore' is pressed in the kdesu dialog, so we use 'do_ownership' instead
	exec "$SUCOMMAND \"\'$EXECNAME\' do_ownership \'$RECURSIVE\' 0:0 \'$TARGET\'\"";
	exit $?;
}

sub user_ownership {

	# If only one directory selected, ask whether to apply the changes recursively
	$RECURSIVE = "0" ;
	if ( $#ARGV < 1 && -d $ARGV[0]) {
		&recursion_dialog_msgs ;
	   	system "$DIALOGCOMMAND --title \'$RECURSIONTITLE\' --yesno \'$RECURSIONMSG\'";
	   	if ( $? eq 0 ) {
	   		$RECURSIVE = "1" ;
	   	}
        }

	#Create a list of user GIDs, so we can pick only the primary group
	@GROUPS = split ' ', $);
	exec "$SUCOMMAND \"\'$EXECNAME\' do_ownership \'$RECURSIVE\' $>:$GROUPS[0] \'$TARGET\'\"";
	exit $?;
}

sub custom_ownership {
	#Get custom UID:GID
	$RECURSIVE = "0" ;
	if ( $#ARGV < 1 && -d $ARGV[0]) {
		&recursion_dialog_msgs ;
	   	system "$DIALOGCOMMAND --title \'$RECURSIONTITLE\' --yesno \'$RECURSIONMSG\'";
	   	if ( $? eq 0 ) {
	   		$RECURSIVE = "1" ;
	   	}
		$? = "0" ;
        }

	&ownership_dialog_msgs;
	$UIDGID=`$DIALOGCOMMAND --title "$OWNERTITLE" --inputbox "$OWNERMSG" user:group` ;

	if ( $? eq 0 ) {
	   chop $UIDGID;
	   exec "$SUCOMMAND \"\'$EXECNAME\' do_ownership \'$RECURSIVE\' \'$UIDGID\' \'$TARGET\'\"";
	   exit $?;
	}
}

sub do_ownership {
	#If running as root, make the ownership changes to targeted files
	if ( $> eq 0 ) {
	   #get recursion choice (first argument)
	   $RECURSIVE = shift @ARGV ;
	   #get the UID:GID numbers (second argument)
	   $UIDGID = shift @ARGV ;
	   shift;
	   #Create Target list
	   $TARGET = join("' '", @ARGV) ;
	   if ( $RECURSIVE eq 1 ) {
		`chown --preserve-root -R \'$UIDGID\' \'$TARGET\'` ;
	   }
	   else {
		`chown --preserve-root \'$UIDGID\' \'$TARGET\'` ;
	   }
	}
}
#---End ownership subroutines---

#---Permissions subroutines---
sub root_permissions {
	#chmod target files to root
	$STOTAL = 0 ;
	$RECURSIVE = "0" ;
	# Get current permissions of target files
	@CURPERM = `ls -ld \'$TARGET\' | cut -d ' ' -f1`;
	$ORCUR = $OWCUR = $OXCUR = $GRCUR = $GWCUR= $GXCUR = $ARCUR = $AWCUR = $AXCUR = $SSCUR = $SGCUR = $STCUR = "on";
	# Analyze permissions, set to off if permission is not set, so only permissions that are present for all chosen files are on by default 
	foreach $CUR (@CURPERM) {
	    if (substr($CUR, 1, 1) eq "-") { $ORCUR = "off"; }
	    if (substr($CUR, 2, 1) eq "-") { $OWCUR = "off"; }
	    if (substr($CUR, 3, 1) eq "-") { $OXCUR = $SSCUR = "off"; }
	    elsif (substr($CUR, 3, 1) eq "x") { $SSCUR = "off"; }
	    elsif (substr($CUR, 3, 1) eq "S") { $OXCUR = "off"; }
	    if (substr($CUR, 4, 1) eq "-") { $GRCUR = "off"; }
	    if (substr($CUR, 5, 1) eq "-") { $GWCUR = "off"; }
	    if (substr($CUR, 6, 1) eq "-") { $GXCUR = $SGCUR = "off"; }
	    elsif (substr($CUR, 6, 1) eq "x") { $SGCUR = "off"; }
	    elsif (substr($CUR, 6, 1) eq "S") { $GXCUR = "off"; }
	    if (substr($CUR, 7, 1) eq "-") { $ARCUR = "off"; }
	    if (substr($CUR, 8, 1) eq "-") { $AWCUR = "off"; }
	    if (substr($CUR, 9, 1) eq "-") { $AXCUR = $STCUR = "off"; }
	    elsif (substr($CUR, 9, 1) eq "x") { $STCUR = "off"; }
	    elsif (substr($CUR, 9, 1) eq "T") { $AXCUR = "off"; }
	}

	#Check whether user wishes to change permissions recursively
	if ( $#ARGV < 1 && -d $ARGV[0]) {
		&recursion_dialog_msgs ;
	   	system "$DIALOGCOMMAND --title \'$RECURSIONTITLE\' --yesno \'$RECURSIONMSG\'";
	   	if ( $? eq 0 ) {
	   		$RECURSIVE = "1" ; }
	}

	if ( $RECURSIVE eq 1 ) {
		&permission_dialog_msgs;
		chomp($PERMLIST=`$DIALOGCOMMAND --title "$PERMTITLE" --checklist "$PERMMSG" u:r "$OWN $READ" $ORCUR u:w "$OWN $WRITE" $OWCUR u:X "$OWN $EXEC" $OXCUR g:r "$GRP $READ" $GRCUR g:w "$GRP $WRITE" $GWCUR g:X "$GRP $EXEC" $GXCUR o:r "$ALL $READ" $ARCUR o:w "$ALL $WRITE" $AWCUR o:X "$ALL $EXEC" $AXCUR u:s "$SPC $SUID" $SSCUR g:s "$SPC $SGID" $SGCUR o:t "$SPC $STICK" $STCUR`);

		if ( $? eq 0 ) {
		   #Calculate permission set for chmod
		   @PERMLIST = split(" ", $PERMLIST);
		   $USTR = "u=";
		   $GSTR = "g=";
		   $OSTR = "o=";
		   $STOTAL = "0" ;
		   foreach $PERM (@PERMLIST) {
			$UGO = substr($PERM, 1, 1);
			$VAL = substr($PERM, 3, 1);
			if ($VAL eq "s" || $VAL eq "t") {
				$STOTAL = "1" ; }
			if ($UGO eq "u") {
				$USTR = $USTR . $VAL; }
			elsif ($UGO eq "g") {
				$GSTR = $GSTR . $VAL; }
			else { $OSTR = $OSTR . $VAL; }
		   }
		   $CHMOD = "$USTR,$GSTR,$OSTR";
		}
	}
	else {		
		&permission_dialog_msgs;
		chomp($PERMLIST=`$DIALOGCOMMAND --title "$PERMTITLE" --checklist "$PERMMSG" u:4 "$OWN $READ" $ORCUR u:2 "$OWN $WRITE" $OWCUR u:1 "$OWN $EXEC" $OXCUR g:4 "$GRP $READ" $GRCUR g:2 "$GRP $WRITE" $GWCUR g:1 "$GRP $EXEC" $GXCUR o:4 "$ALL $READ" $ARCUR o:2 "$ALL $WRITE" $AWCUR o:1 "$ALL $EXEC" $AXCUR s:4 "$SPC $SUID" $SSCUR s:2 "$SPC $SGID" $SGCUR s:1 "$SPC $STICK" $STCUR`);

		if ( $? eq 0 ) {
		   #Calculate permission set for chmod
		   @PERMLIST = split(" ", $PERMLIST);
		   $UTOTAL = 0;
		   $GTOTAL = 0;
		   $OTOTAL = 0;
		   $STOTAL = 0;
		   foreach $PERM (@PERMLIST) {
			$UGO = substr($PERM, 1, 1);
			$VAL = substr($PERM, 3, 1);
			if ($UGO eq "u") {
			$UTOTAL = $UTOTAL + $VAL; }
			elsif ($UGO eq "g") {
			$GTOTAL = $GTOTAL + $VAL; }
			elsif ($UGO eq "o") {
			$OTOTAL = $OTOTAL + $VAL; }
			else { $STOTAL = $STOTAL + $VAL; }
		   }
		   $CHMOD = "$STOTAL$UTOTAL$GTOTAL$OTOTAL";
		}
	}

	if ($STOTAL ne 0 ) {
		system "$DIALOGCOMMAND --title \'$SPCTITLE\' --warningcontinuecancel \'$SPCMSG\'";
	}
	if ( $? eq 0 ) {
	      exec "$SUCOMMAND \"\'$EXECNAME\' do_permissions \'$RECURSIVE\' \'$CHMOD\' \'$TARGET\'\"";
	      exit $?;
	}
}
sub do_permissions {
	#If running as root, make the permission changes to targeted files
	if ( $> eq 0 ) {
	   #get the chmod number (first argument)
	   $RECURSIVE = shift @ARGV ;
	   $CHMOD = shift @ARGV ;
	   shift;
	   #Create Target list
	   $TARGET = join("' '", @ARGV) ;

	   if ( $RECURSIVE eq 1 ) {
		`chmod --preserve-root -R \'$CHMOD\' \'$TARGET\'` ;
	   }
	   else {
		`chmod --preserve-root \'$CHMOD\' \'$TARGET\'` ;
	   }
	}
}
#---End permissions subroutines---
