/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.internal.ListWithAutoConstructFlag;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class DescribeSpotFleetRequestsRequest
extends AmazonWebServiceRequest
implements Serializable {
    private Boolean dryRun;
    private ListWithAutoConstructFlag<String> spotFleetRequestIds;
    private String nextToken;
    private Integer maxResults;

    public Boolean isDryRun() {
        return this.dryRun;
    }

    public void setDryRun(Boolean dryRun) {
        this.dryRun = dryRun;
    }

    public DescribeSpotFleetRequestsRequest withDryRun(Boolean dryRun) {
        this.dryRun = dryRun;
        return this;
    }

    public Boolean getDryRun() {
        return this.dryRun;
    }

    public List<String> getSpotFleetRequestIds() {
        if (this.spotFleetRequestIds == null) {
            this.spotFleetRequestIds = new ListWithAutoConstructFlag();
            this.spotFleetRequestIds.setAutoConstruct(true);
        }
        return this.spotFleetRequestIds;
    }

    public void setSpotFleetRequestIds(Collection<String> spotFleetRequestIds) {
        if (spotFleetRequestIds == null) {
            this.spotFleetRequestIds = null;
            return;
        }
        ListWithAutoConstructFlag spotFleetRequestIdsCopy = new ListWithAutoConstructFlag(spotFleetRequestIds.size());
        spotFleetRequestIdsCopy.addAll(spotFleetRequestIds);
        this.spotFleetRequestIds = spotFleetRequestIdsCopy;
    }

    public DescribeSpotFleetRequestsRequest withSpotFleetRequestIds(String ... spotFleetRequestIds) {
        if (this.getSpotFleetRequestIds() == null) {
            this.setSpotFleetRequestIds(new ArrayList<String>(spotFleetRequestIds.length));
        }
        for (String value : spotFleetRequestIds) {
            this.getSpotFleetRequestIds().add(value);
        }
        return this;
    }

    public DescribeSpotFleetRequestsRequest withSpotFleetRequestIds(Collection<String> spotFleetRequestIds) {
        if (spotFleetRequestIds == null) {
            this.spotFleetRequestIds = null;
        } else {
            ListWithAutoConstructFlag spotFleetRequestIdsCopy = new ListWithAutoConstructFlag(spotFleetRequestIds.size());
            spotFleetRequestIdsCopy.addAll(spotFleetRequestIds);
            this.spotFleetRequestIds = spotFleetRequestIdsCopy;
        }
        return this;
    }

    public String getNextToken() {
        return this.nextToken;
    }

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    public DescribeSpotFleetRequestsRequest withNextToken(String nextToken) {
        this.nextToken = nextToken;
        return this;
    }

    public Integer getMaxResults() {
        return this.maxResults;
    }

    public void setMaxResults(Integer maxResults) {
        this.maxResults = maxResults;
    }

    public DescribeSpotFleetRequestsRequest withMaxResults(Integer maxResults) {
        this.maxResults = maxResults;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.isDryRun() != null) {
            sb.append("DryRun: " + this.isDryRun() + ",");
        }
        if (this.getSpotFleetRequestIds() != null) {
            sb.append("SpotFleetRequestIds: " + this.getSpotFleetRequestIds() + ",");
        }
        if (this.getNextToken() != null) {
            sb.append("NextToken: " + this.getNextToken() + ",");
        }
        if (this.getMaxResults() != null) {
            sb.append("MaxResults: " + this.getMaxResults());
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.isDryRun() == null ? 0 : this.isDryRun().hashCode());
        hashCode = 31 * hashCode + (this.getSpotFleetRequestIds() == null ? 0 : ((Object)this.getSpotFleetRequestIds()).hashCode());
        hashCode = 31 * hashCode + (this.getNextToken() == null ? 0 : this.getNextToken().hashCode());
        hashCode = 31 * hashCode + (this.getMaxResults() == null ? 0 : this.getMaxResults().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeSpotFleetRequestsRequest)) {
            return false;
        }
        DescribeSpotFleetRequestsRequest other = (DescribeSpotFleetRequestsRequest)obj;
        if (other.isDryRun() == null ^ this.isDryRun() == null) {
            return false;
        }
        if (other.isDryRun() != null && !other.isDryRun().equals(this.isDryRun())) {
            return false;
        }
        if (other.getSpotFleetRequestIds() == null ^ this.getSpotFleetRequestIds() == null) {
            return false;
        }
        if (other.getSpotFleetRequestIds() != null && !((Object)other.getSpotFleetRequestIds()).equals(this.getSpotFleetRequestIds())) {
            return false;
        }
        if (other.getNextToken() == null ^ this.getNextToken() == null) {
            return false;
        }
        if (other.getNextToken() != null && !other.getNextToken().equals(this.getNextToken())) {
            return false;
        }
        if (other.getMaxResults() == null ^ this.getMaxResults() == null) {
            return false;
        }
        return other.getMaxResults() == null || other.getMaxResults().equals(this.getMaxResults());
    }
}

