/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.properties;

import com.intellij.codeInsight.intention.CommonIntentionAction;
import com.intellij.codeInsight.intention.impl.BaseIntentionAction;
import com.intellij.lang.ASTNode;
import com.intellij.lang.annotation.AnnotationBuilder;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.Annotator;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.lang.properties.DuplicatePropertyKeyAnnotationSuppressor;
import com.intellij.lang.properties.IProperty;
import com.intellij.lang.properties.PropertiesBundle;
import com.intellij.lang.properties.PropertiesHighlighter;
import com.intellij.lang.properties.PropertiesQuickFixFactory;
import com.intellij.lang.properties.editor.PropertiesValueHighlighter;
import com.intellij.lang.properties.psi.PropertiesFile;
import com.intellij.lang.properties.psi.Property;
import com.intellij.lang.properties.psi.impl.PropertyImpl;
import com.intellij.lexer.Lexer;
import com.intellij.modcommand.ActionContext;
import com.intellij.modcommand.ModCommand;
import com.intellij.modcommand.ModCommandAction;
import com.intellij.modcommand.Presentation;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PropertiesAnnotator
implements Annotator,
DumbAware {
    private static final ExtensionPointName<DuplicatePropertyKeyAnnotationSuppressor> EP_NAME = ExtensionPointName.create((String)"com.intellij.properties.duplicatePropertyKeyAnnotationSuppressor");

    public void annotate(@NotNull PsiElement element, @NotNull AnnotationHolder holder) {
        if (element == null) {
            PropertiesAnnotator.$$$reportNull$$$0(0);
        }
        if (holder == null) {
            PropertiesAnnotator.$$$reportNull$$$0(1);
        }
        if (!(element instanceof Property)) {
            return;
        }
        Property property = (Property)element;
        PropertiesFile propertiesFile = property.getPropertiesFile();
        String key = property.getUnescapedKey();
        if (key == null) {
            return;
        }
        List<IProperty> others = propertiesFile.findPropertiesByKey(key);
        ASTNode keyNode = ((PropertyImpl)property).getKeyNode();
        if (keyNode == null) {
            return;
        }
        if ((!DumbService.isDumb((Project)element.getProject()) || ContainerUtil.all((Collection)EP_NAME.getExtensionList(), suppressor -> DumbService.isDumbAware((Object)suppressor))) && others.size() > 1 && EP_NAME.findFirstSafe(suppressor -> suppressor.suppressAnnotationFor(property)) == null) {
            holder.newAnnotation(HighlightSeverity.ERROR, PropertiesBundle.message("duplicate.property.key.error.message", new Object[0])).range(keyNode).withFix(PropertiesQuickFixFactory.getInstance().createRemovePropertyFix(property)).create();
        }
        PropertiesAnnotator.highlightTokens(keyNode, holder, new PropertiesHighlighter());
        ASTNode valueNode = ((PropertyImpl)property).getValueNode();
        if (valueNode != null) {
            PropertiesAnnotator.highlightTokens(valueNode, holder, new PropertiesValueHighlighter());
        }
    }

    private static void highlightTokens(ASTNode node, AnnotationHolder holder, PropertiesHighlighter highlighter) {
        Lexer lexer = highlighter.getHighlightingLexer();
        String s = node.getText();
        lexer.start((CharSequence)s);
        while (lexer.getTokenType() != null) {
            TextAttributesKey[] keys;
            IElementType elementType = lexer.getTokenType();
            for (TextAttributesKey key : keys = highlighter.getTokenHighlights(elementType)) {
                String displayName = PropertiesHighlighter.PropertiesComponent.getDisplayName(key);
                HighlightSeverity severity = PropertiesHighlighter.PropertiesComponent.getSeverity(key);
                if (severity == null || displayName == null) continue;
                int start = lexer.getTokenStart() + node.getTextRange().getStartOffset();
                int end = lexer.getTokenEnd() + node.getTextRange().getStartOffset();
                TextRange textRange = new TextRange(start, end);
                TextAttributes attributes = EditorColorsManager.getInstance().getGlobalScheme().getAttributes(key);
                AnnotationBuilder builder = holder.newAnnotation(severity, displayName).range(textRange).enforcedTextAttributes(attributes);
                if (key == PropertiesHighlighter.PropertiesComponent.PROPERTIES_INVALID_STRING_ESCAPE.getTextAttributesKey()) {
                    builder = builder.withFix((CommonIntentionAction)new UnescapeFix(textRange.getStartOffset()));
                }
                builder.create();
            }
            lexer.advance();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "element";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "holder";
                break;
            }
        }
        objectArray[1] = "com/intellij/lang/properties/PropertiesAnnotator";
        objectArray[2] = "annotate";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static final class UnescapeFix
    implements ModCommandAction,
    DumbAware {
        private final int startOffset;

        private UnescapeFix(int startOffset) {
            this.startOffset = startOffset;
        }

        @NotNull
        public String getFamilyName() {
            String string = PropertiesBundle.message("unescape", new Object[0]);
            if (string == null) {
                UnescapeFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Nullable
        public Presentation getPresentation(@NotNull ActionContext context) {
            if (context == null) {
                UnescapeFix.$$$reportNull$$$0(1);
            }
            if (!BaseIntentionAction.canModify((PsiElement)context.file())) {
                return null;
            }
            String text = context.file().getText();
            return text.length() > this.startOffset && text.charAt(this.startOffset) == '\\' ? Presentation.of((String)this.getFamilyName()) : null;
        }

        @NotNull
        public ModCommand perform(@NotNull ActionContext context) {
            if (context == null) {
                UnescapeFix.$$$reportNull$$$0(2);
            }
            ModCommand modCommand = ModCommand.psiUpdate((ActionContext)context, updater -> ((PsiFile)updater.getWritable((PsiElement)context.file())).getViewProvider().getDocument().deleteString(this.startOffset, this.startOffset + 1));
            if (modCommand == null) {
                UnescapeFix.$$$reportNull$$$0(3);
            }
            return modCommand;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/lang/properties/PropertiesAnnotator$UnescapeFix";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/lang/properties/PropertiesAnnotator$UnescapeFix";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "perform";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "getPresentation";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "perform";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2 -> new IllegalArgumentException(string);
            };
        }
    }
}

