/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.inspections;

import com.google.common.collect.ImmutableList;
import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.options.OptPane;
import com.intellij.codeInspection.options.OptRegularComponent;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.tree.IElementType;
import com.jetbrains.python.PyPsiBundle;
import com.jetbrains.python.PyTokenTypes;
import com.jetbrains.python.inspections.PyInspection;
import com.jetbrains.python.inspections.PyInspectionVisitor;
import com.jetbrains.python.inspections.quickfix.SimplifyBooleanCheckQuickFix;
import com.jetbrains.python.psi.PyBinaryExpression;
import com.jetbrains.python.psi.PyConditionalStatementPart;
import com.jetbrains.python.psi.PyElementType;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.types.TypeEvalContext;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PySimplifyBooleanCheckInspection
extends PyInspection {
    private static final List<String> COMPARISON_LITERALS = ImmutableList.of((Object)"True", (Object)"False", (Object)"[]");
    public boolean ignoreComparisonToZero = true;

    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly, @NotNull LocalInspectionToolSession session) {
        if (holder == null) {
            PySimplifyBooleanCheckInspection.$$$reportNull$$$0(0);
        }
        if (session == null) {
            PySimplifyBooleanCheckInspection.$$$reportNull$$$0(1);
        }
        return new Visitor(holder, this.ignoreComparisonToZero, PyInspectionVisitor.getContext(session));
    }

    @NotNull
    public OptPane getOptionsPane() {
        OptPane optPane = OptPane.pane((OptRegularComponent[])new OptRegularComponent[]{OptPane.checkbox((String)"ignoreComparisonToZero", (String)PyPsiBundle.message("INSP.simplify.boolean.check.ignore.comparison.to.zero", new Object[0]), (OptRegularComponent[])new OptRegularComponent[0])});
        if (optPane == null) {
            PySimplifyBooleanCheckInspection.$$$reportNull$$$0(2);
        }
        return optPane;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/inspections/PySimplifyBooleanCheckInspection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/inspections/PySimplifyBooleanCheckInspection";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getOptionsPane";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 2: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2 -> new IllegalStateException(string);
        };
    }

    private static class Visitor
    extends PyInspectionVisitor {
        private final boolean myIgnoreComparisonToZero;

        Visitor(@Nullable ProblemsHolder holder, boolean ignoreComparisonToZero, @NotNull TypeEvalContext context) {
            if (context == null) {
                Visitor.$$$reportNull$$$0(0);
            }
            super(holder, context);
            this.myIgnoreComparisonToZero = ignoreComparisonToZero;
        }

        @Override
        public void visitPyConditionalStatementPart(@NotNull PyConditionalStatementPart node) {
            if (node == null) {
                Visitor.$$$reportNull$$$0(1);
            }
            super.visitPyConditionalStatementPart(node);
            PyExpression condition = node.getCondition();
            if (condition != null) {
                condition.accept(new PyBinaryExpressionVisitor(this.getHolder(), this.myTypeEvalContext, this.myIgnoreComparisonToZero));
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "node";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/python/inspections/PySimplifyBooleanCheckInspection$Visitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitPyConditionalStatementPart";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class PyBinaryExpressionVisitor
    extends PyInspectionVisitor {
        private final boolean myIgnoreComparisonToZero;

        PyBinaryExpressionVisitor(@Nullable ProblemsHolder holder, @NotNull TypeEvalContext context, boolean ignoreComparisonToZero) {
            if (context == null) {
                PyBinaryExpressionVisitor.$$$reportNull$$$0(0);
            }
            super(holder, context);
            this.myIgnoreComparisonToZero = ignoreComparisonToZero;
        }

        @Override
        public void visitPyBinaryExpression(@NotNull PyBinaryExpression node) {
            if (node == null) {
                PyBinaryExpressionVisitor.$$$reportNull$$$0(1);
            }
            super.visitPyBinaryExpression(node);
            PyElementType operator = node.getOperator();
            PyExpression rightExpression = node.getRightExpression();
            if (rightExpression == null || rightExpression instanceof PyBinaryExpression || node.getLeftExpression() instanceof PyBinaryExpression) {
                return;
            }
            if (PyTokenTypes.EQUALITY_OPERATIONS.contains((IElementType)operator) && (PyBinaryExpressionVisitor.operandsEqualTo(node, COMPARISON_LITERALS) || !this.myIgnoreComparisonToZero && PyBinaryExpressionVisitor.operandsEqualTo(node, Collections.singleton("0")))) {
                this.registerProblem(node);
            }
        }

        private static boolean operandsEqualTo(@NotNull PyBinaryExpression expr, @NotNull Collection<String> literals) {
            if (expr == null) {
                PyBinaryExpressionVisitor.$$$reportNull$$$0(2);
            }
            if (literals == null) {
                PyBinaryExpressionVisitor.$$$reportNull$$$0(3);
            }
            String leftExpressionText = expr.getLeftExpression().getText();
            PyExpression rightExpression = expr.getRightExpression();
            String rightExpressionText = rightExpression != null ? rightExpression.getText() : null;
            for (String literal : literals) {
                if (!literal.equals(leftExpressionText) && !literal.equals(rightExpressionText)) continue;
                return true;
            }
            return false;
        }

        private void registerProblem(PyBinaryExpression binaryExpression) {
            this.registerProblem((PsiElement)binaryExpression, PyPsiBundle.message("INSP.expression.can.be.simplified", new Object[0]), new LocalQuickFix[]{new SimplifyBooleanCheckQuickFix(binaryExpression)});
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "node";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "expr";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "literals";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/python/inspections/PySimplifyBooleanCheckInspection$PyBinaryExpressionVisitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitPyBinaryExpression";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "operandsEqualTo";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

