/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.refactoring.classes.extractSuperclass;

import com.intellij.lang.Language;
import com.intellij.lang.LanguageNamesValidation;
import com.intellij.lang.refactoring.NamesValidator;
import com.intellij.notebook.editor.BackedVirtualFile;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiManager;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.classMembers.MemberInfoModel;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.PythonLanguage;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyElement;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.refactoring.classes.PyMemberInfoStorage;
import com.jetbrains.python.refactoring.classes.extractSuperclass.PyExtractSuperclassHelper;
import com.jetbrains.python.refactoring.classes.extractSuperclass.PyExtractSuperclassInfoModel;
import com.jetbrains.python.refactoring.classes.extractSuperclass.PyExtractSuperclassInitializationInfo;
import com.jetbrains.python.refactoring.classes.extractSuperclass.PyExtractSuperclassPresenter;
import com.jetbrains.python.refactoring.classes.extractSuperclass.PyExtractSuperclassView;
import com.jetbrains.python.refactoring.classes.membersManager.PyMemberInfo;
import com.jetbrains.python.refactoring.classes.membersManager.PyMembersUtil;
import com.jetbrains.python.refactoring.classes.membersManager.vp.BadDataException;
import com.jetbrains.python.refactoring.classes.membersManager.vp.MembersBasedPresenterNoPreviewImpl;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class PyExtractSuperclassPresenterImpl
extends MembersBasedPresenterNoPreviewImpl<PyExtractSuperclassView, MemberInfoModel<PyElement, PyMemberInfo<PyElement>>>
implements PyExtractSuperclassPresenter {
    private final NamesValidator myNamesValidator;

    PyExtractSuperclassPresenterImpl(@NotNull PyExtractSuperclassView view, @NotNull PyClass classUnderRefactoring, @NotNull PyMemberInfoStorage infoStorage) {
        if (view == null) {
            PyExtractSuperclassPresenterImpl.$$$reportNull$$$0(0);
        }
        if (classUnderRefactoring == null) {
            PyExtractSuperclassPresenterImpl.$$$reportNull$$$0(1);
        }
        if (infoStorage == null) {
            PyExtractSuperclassPresenterImpl.$$$reportNull$$$0(2);
        }
        super(view, classUnderRefactoring, infoStorage, new PyExtractSuperclassInfoModel(classUnderRefactoring));
        this.myNamesValidator = LanguageNamesValidation.INSTANCE.forLanguage((Language)PythonLanguage.getInstance());
    }

    @Override
    protected void validateView() throws BadDataException {
        PyFile pyFile;
        super.validateView();
        Project project = this.myClassUnderRefactoring.getProject();
        if (!this.myNamesValidator.isIdentifier(((PyExtractSuperclassView)this.myView).getSuperClassName(), project)) {
            throw new BadDataException(PyBundle.message("refactoring.extract.super.name.0.must.be.ident", ((PyExtractSuperclassView)this.myView).getSuperClassName()));
        }
        boolean rootFound = false;
        File moduleFile = new File(((PyExtractSuperclassView)this.myView).getModuleFile());
        try {
            String targetDir = FileUtil.toSystemIndependentName((String)moduleFile.getCanonicalPath());
            for (VirtualFile file : ProjectRootManager.getInstance((Project)project).getContentRoots()) {
                if (!StringUtil.startsWithIgnoreCase((String)targetDir, (String)file.getPath())) continue;
                rootFound = true;
                break;
            }
        }
        catch (IOException targetDir) {
            // empty catch block
        }
        if (!rootFound) {
            throw new BadDataException(PyBundle.message("refactoring.extract.super.target.path.outside.roots", new Object[0]));
        }
        ((PyExtractSuperclassView)this.myView).getModuleFile();
        VirtualFile moduleVirtualFile = LocalFileSystem.getInstance().findFileByIoFile(moduleFile);
        if (moduleVirtualFile != null && (pyFile = PyExtractSuperclassPresenterImpl.getPyFile(project, moduleVirtualFile)) != null && pyFile.findTopLevelClass(((PyExtractSuperclassView)this.myView).getSuperClassName()) != null) {
            throw new BadDataException(PyBundle.message("refactoring.extract.super.target.class.already.exists", ((PyExtractSuperclassView)this.myView).getSuperClassName()));
        }
    }

    @Nullable
    private static PyFile getPyFile(@NotNull Project project, @NotNull VirtualFile virtualFile) {
        if (project == null) {
            PyExtractSuperclassPresenterImpl.$$$reportNull$$$0(3);
        }
        if (virtualFile == null) {
            PyExtractSuperclassPresenterImpl.$$$reportNull$$$0(4);
        }
        VirtualFile targetFile = Arrays.stream(FileEditorManager.getInstance((Project)project).getAllEditors(virtualFile)).map(editor2 -> editor2.getFile()).filter(file -> file instanceof BackedVirtualFile).findFirst().orElse(virtualFile);
        return (PyFile)ContainerUtil.find((Iterable)Objects.requireNonNull(PsiManager.getInstance((Project)project).findFile(targetFile)).getViewProvider().getAllFiles(), file -> file instanceof PyFile);
    }

    @Override
    public void launch() {
        String defaultFilePath = FileUtil.toSystemDependentName((String)this.myClassUnderRefactoring.getContainingFile().getVirtualFile().getPath());
        VirtualFile[] roots = ProjectRootManager.getInstance((Project)this.myClassUnderRefactoring.getProject()).getContentRoots();
        Collection<PyMemberInfo<PyElement>> pyMemberInfos = PyMembersUtil.filterOutObject(this.myStorage.getClassMemberInfos(this.myClassUnderRefactoring));
        ((PyExtractSuperclassView)this.myView).configure(new PyExtractSuperclassInitializationInfo((MemberInfoModel<PyElement, PyMemberInfo<PyElement>>)this.myModel, pyMemberInfos, defaultFilePath, roots));
        ((PyExtractSuperclassView)this.myView).initAndShow();
    }

    @Override
    @NotNull
    protected String getCommandName() {
        String string = RefactoringBundle.message((String)"extract.superclass.command.name", (Object[])new Object[]{((PyExtractSuperclassView)this.myView).getSuperClassName(), this.myClassUnderRefactoring.getName()});
        if (string == null) {
            PyExtractSuperclassPresenterImpl.$$$reportNull$$$0(5);
        }
        return string;
    }

    @Override
    protected void refactorNoPreview() {
        Collection<PyMemberInfo<PyElement>> infos = ((PyExtractSuperclassView)this.myView).getSelectedMemberInfos();
        this.disableItemsCantBeAbstract(infos);
        PyExtractSuperclassHelper.extractSuperclass(this.myClassUnderRefactoring, infos, ((PyExtractSuperclassView)this.myView).getSuperClassName(), ((PyExtractSuperclassView)this.myView).getModuleFile());
    }

    @Override
    @NotNull
    protected Iterable<? extends PyClass> getDestClassesToCheckConflicts() {
        List list = Collections.emptyList();
        if (list == null) {
            PyExtractSuperclassPresenterImpl.$$$reportNull$$$0(6);
        }
        return list;
    }

    private void disableItemsCantBeAbstract(@NotNull Collection<PyMemberInfo<PyElement>> infos) {
        if (infos == null) {
            PyExtractSuperclassPresenterImpl.$$$reportNull$$$0(7);
        }
        for (PyMemberInfo<PyElement> info : infos) {
            if (!info.isToAbstract() || this.myModel.isAbstractEnabled(info)) continue;
            info.setToAbstract(false);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5, 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "view";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classUnderRefactoring";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "infoStorage";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFile";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/refactoring/classes/extractSuperclass/PyExtractSuperclassPresenterImpl";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "infos";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/refactoring/classes/extractSuperclass/PyExtractSuperclassPresenterImpl";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommandName";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getDestClassesToCheckConflicts";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getPyFile";
                break;
            }
            case 5: 
            case 6: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "disableItemsCantBeAbstract";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 5, 6 -> new IllegalStateException(string);
        };
    }
}

