/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.sdk.poetry;

import com.intellij.execution.ExecutionException;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.module.ModuleUtil;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.vfs.StandardFileSystems;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.PathUtil;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.PythonModuleTypeBase;
import com.jetbrains.python.icons.PythonIcons;
import com.jetbrains.python.sdk.BasePySdkExtKt;
import com.jetbrains.python.sdk.PySdkExtKt;
import com.jetbrains.python.sdk.poetry.PoetryCommandExecutorKt;
import com.jetbrains.python.sdk.poetry.PyPoetrySdkAdditionalData;
import com.jetbrains.python.sdk.poetry.PyProjectTomlUtilsKt;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000T\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\"\n\u0002\b\u0002\u001a\u0013\u0010\b\u001a\u00070\u0001\u00a2\u0006\u0002\b\t2\u0006\u0010\n\u001a\u00020\u000b\u001aR\u0010\f\u001a\u0004\u0018\u00010\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u00112\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\r0\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u00012\b\u0010\u0015\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0016\u001a\u00020\u00172\n\b\u0002\u0010\u0018\u001a\u0004\u0018\u00010\u0001\u001a\u0018\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00110\u00132\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0000\u001a\u001c\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00010!2\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020\r0\u0013H\u0000\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u0016\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0018\u0010\u0019\u001a\u00020\u0017*\u00020\r8@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001a\"\u0017\u0010\u001b\u001a\u0004\u0018\u00010\u001c*\u00020\u00118F\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u001e\u00a8\u0006#"}, d2={"POETRY_LOCK", "", "POETRY_DEFAULT_SOURCE_URL", "POETRY_ICON", "Ljavax/swing/Icon;", "Lorg/jetbrains/annotations/NotNull;", "getPOETRY_ICON", "()Ljavax/swing/Icon;", "suggestedSdkName", "Lcom/intellij/openapi/util/NlsSafe;", "basePath", "Ljava/nio/file/Path;", "setupPoetrySdkUnderProgress", "Lcom/intellij/openapi/projectRoots/Sdk;", "project", "Lcom/intellij/openapi/project/Project;", "module", "Lcom/intellij/openapi/module/Module;", "existingSdks", "", "newProjectPath", "python", "installPackages", "", "poetryPath", "isPoetry", "(Lcom/intellij/openapi/projectRoots/Sdk;)Z", "poetryLock", "Lcom/intellij/openapi/vfs/VirtualFile;", "getPoetryLock", "(Lcom/intellij/openapi/module/Module;)Lcom/intellij/openapi/vfs/VirtualFile;", "allModules", "sdkHomes", "", "sdks", "intellij.python.community.impl"})
@SourceDebugExtension(value={"SMAP\npoetry.kt\nKotlin\n*S Kotlin\n*F\n+ 1 poetry.kt\ncom/jetbrains/python/sdk/poetry/PoetryKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,85:1\n1#2:86\n1#2:98\n1053#3:87\n1611#3,9:88\n1863#3:97\n1864#3:99\n1620#3:100\n*S KotlinDebug\n*F\n+ 1 poetry.kt\ncom/jetbrains/python/sdk/poetry/PoetryKt\n*L\n85#1:98\n82#1:87\n85#1:88,9\n85#1:97\n85#1:99\n85#1:100\n*E\n"})
public final class PoetryKt {
    @NotNull
    public static final String POETRY_LOCK = "poetry.lock";
    @NotNull
    public static final String POETRY_DEFAULT_SOURCE_URL = "https://pypi.org/simple";
    @NotNull
    private static final Icon POETRY_ICON;

    @NotNull
    public static final Icon getPOETRY_ICON() {
        return POETRY_ICON;
    }

    @NotNull
    public static final String suggestedSdkName(@NotNull Path basePath) {
        Intrinsics.checkNotNullParameter((Object)basePath, (String)"basePath");
        return "Poetry (" + PathUtil.getFileName((String)((Object)basePath).toString()) + ")";
    }

    @Nullable
    public static final Sdk setupPoetrySdkUnderProgress(@Nullable Project project, @Nullable Module module, @NotNull List<? extends Sdk> existingSdks, @Nullable String newProjectPath, @Nullable String python, boolean installPackages2, @Nullable String poetryPath) {
        String string;
        block3: {
            Intrinsics.checkNotNullParameter(existingSdks, (String)"existingSdks");
            String string2 = newProjectPath;
            if (string2 == null) {
                Module module2 = module;
                string2 = module2 != null ? BasePySdkExtKt.getBasePath(module2) : null;
                if (string2 == null) {
                    Project project2 = project;
                    string2 = project2 != null ? project2.getBasePath() : null;
                    if (string2 == null) {
                        return null;
                    }
                }
            }
            String projectPath = string2;
            string = PyBundle.message("python.sdk.dialog.title.setting.up.poetry.environment", new Object[0]);
            Task.WithResult<String, ExecutionException> task2 = new Task.WithResult<String, ExecutionException>(project, poetryPath, projectPath, python, installPackages2, string){
                final /* synthetic */ String $poetryPath;
                final /* synthetic */ String $projectPath;
                final /* synthetic */ String $python;
                final /* synthetic */ boolean $installPackages;
                {
                    this.$poetryPath = $poetryPath;
                    this.$projectPath = $projectPath;
                    this.$python = $python;
                    this.$installPackages = $installPackages;
                    super($project, $super_call_param$1, true);
                }

                protected String compute(ProgressIndicator indicator) {
                    String string;
                    Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
                    indicator.setIndeterminate(true);
                    if (this.$poetryPath != null) {
                        string = this.$poetryPath;
                    } else {
                        Pair<Long, VirtualFile> pair;
                        VirtualFile virtualFile = StandardFileSystems.local().findFileByPath(this.$projectPath);
                        if (virtualFile != null && (virtualFile = virtualFile.findChild("pyproject.toml")) != null) {
                            VirtualFile it = virtualFile;
                            boolean bl = false;
                            pair = PyProjectTomlUtilsKt.getPyProjectTomlForPoetry(it);
                        } else {
                            pair = null;
                        }
                        boolean init2 = pair == null;
                        Path path2 = Path.of(this.$projectPath, new String[0]);
                        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"of(...)");
                        string = PoetryCommandExecutorKt.setupPoetry(path2, this.$python, this.$installPackages, init2);
                    }
                    String poetry = string;
                    return PoetryCommandExecutorKt.getPythonExecutable(poetry);
                }
            };
            Task.WithResult withResult = (Task.WithResult)task2;
            Path path2 = Path.of(projectPath, new String[0]);
            Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"of(...)");
            String $this$setupPoetrySdkUnderProgress_u24lambda_u241 = string = PySdkExtKt.createSdkByGenerateTask((Task.WithResult<String, ExecutionException>)withResult, existingSdks, null, projectPath, PoetryKt.suggestedSdkName(path2), new PyPoetrySdkAdditionalData());
            boolean bl = false;
            Module module3 = module;
            if (module3 == null) break block3;
            Module it = module3;
            boolean bl2 = false;
            PySdkExtKt.setAssociationToModule((Sdk)$this$setupPoetrySdkUnderProgress_u24lambda_u241, it);
        }
        return string;
    }

    public static /* synthetic */ Sdk setupPoetrySdkUnderProgress$default(Project project, Module module, List list, String string, String string2, boolean bl, String string3, int n, Object object) {
        if ((n & 0x40) != 0) {
            string3 = null;
        }
        return PoetryKt.setupPoetrySdkUnderProgress(project, module, list, string, string2, bl, string3);
    }

    public static final boolean isPoetry(@NotNull Sdk $this$isPoetry) {
        Intrinsics.checkNotNullParameter((Object)$this$isPoetry, (String)"<this>");
        return $this$isPoetry.getSdkAdditionalData() instanceof PyPoetrySdkAdditionalData;
    }

    @Nullable
    public static final VirtualFile getPoetryLock(@NotNull Module $this$poetryLock) {
        Intrinsics.checkNotNullParameter((Object)$this$poetryLock, (String)"<this>");
        VirtualFile virtualFile = BasePySdkExtKt.getBaseDir($this$poetryLock);
        return virtualFile != null ? virtualFile.findChild(POETRY_LOCK) : null;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static final List<Module> allModules(@Nullable Project project) {
        List list;
        if (project != null) {
            Project it = project;
            boolean bl = false;
            Collection collection = ModuleUtil.getModulesOfType((Project)it, (ModuleType)PythonModuleTypeBase.getInstance());
            if (collection != null) {
                Iterable $this$sortedBy$iv = collection;
                boolean $i$f$sortedBy = false;
                List list2 = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

                    public final int compare(T a, T b) {
                        Module it = (Module)a;
                        boolean bl = false;
                        Comparable comparable = (Comparable)((Object)it.getName());
                        it = (Module)b;
                        Comparable comparable2 = comparable;
                        bl = false;
                        return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)it.getName())));
                    }
                });
                if (list2 != null) {
                    list = list2;
                    return list;
                }
            }
        }
        list = CollectionsKt.emptyList();
        return list;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Set<String> sdkHomes(@NotNull List<? extends Sdk> sdks) {
        void $this$mapNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter(sdks, (String)"sdks");
        Iterable $this$mapNotNull$iv = sdks;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            String it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            Sdk it = (Sdk)element$iv$iv;
            boolean bl2 = false;
            if (it.getHomePath() == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
    }

    static {
        Icon icon = PythonIcons.Python.Origami;
        Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"Origami");
        POETRY_ICON = icon;
    }
}

