/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.ml.impl.tools;

import com.intellij.openapi.components.Service;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.platform.ml.impl.tools.ExtensionPointsKt;
import com.intellij.platform.ml.impl.tools.IJPlatform;
import com.intellij.platform.ml.impl.tools.KeyedMessagingProvider;
import com.intellij.platform.ml.impl.tools.MLTaskListenerTyped;
import com.intellij.platform.ml.impl.tools.MLTaskLoggingListener;
import com.intellij.platform.ml.impl.tools.MessageBusMLTaskListenerProvider;
import com.intellij.platform.ml.impl.tools.MessageBusMLTaskLoggingListenerProvider;
import com.intellij.util.ApplicationKt;
import com.intellij.util.messages.MessageBusConnection;
import com.jetbrains.ml.model.MLModel;
import com.jetbrains.ml.platform.MLApiPlatform;
import com.jetbrains.ml.platform.SystemLogger;
import com.jetbrains.ml.platform.SystemLoggerBuilder;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Service(value={Service.Level.APP})
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00062\u000e\u0010\u000e\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\bH\u0016J\u0018\u0010\u0012\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00062\u0006\u0010\u0013\u001a\u00020\u0010H\u0016R.\u0010\u0004\u001a\u001c\u0012\u0004\u0012\u00020\u0006\u0012\u0012\u0012\u0010\u0012\f\u0012\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\b0\u00070\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR&\u0010\u000f\u001a\u0014\u0012\u0004\u0012\u00020\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00100\u00070\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\nR\u0014\u0010\u0014\u001a\u00020\u0015X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017\u00a8\u0006\u0018"}, d2={"Lcom/intellij/platform/ml/impl/tools/IJPlatform;", "Lcom/jetbrains/ml/platform/MLApiPlatform;", "<init>", "()V", "taskListeners", "", "", "", "Lcom/jetbrains/ml/monitoring/MLTaskListenerTyped;", "getTaskListeners", "()Ljava/util/Map;", "addTaskListener", "Lcom/jetbrains/ml/platform/MLApiPlatform$ExtensionController;", "taskId", "taskListener", "loggingListeners", "Lcom/jetbrains/ml/monitoring/MLTaskLoggingListener;", "getLoggingListeners", "addLoggingListener", "loggingListener", "systemLoggerBuilder", "Lcom/jetbrains/ml/platform/SystemLoggerBuilder;", "getSystemLoggerBuilder", "()Lcom/jetbrains/ml/platform/SystemLoggerBuilder;", "intellij.platform.ml.impl"})
@ApiStatus.Internal
public final class IJPlatform
extends MLApiPlatform {
    @NotNull
    private final SystemLoggerBuilder systemLoggerBuilder = new SystemLoggerBuilder(){

        public SystemLogger build(Class<?> clazz) {
            Intrinsics.checkNotNullParameter(clazz, (String)"clazz");
            Logger logger = Logger.getInstance(clazz);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            return new systemLoggerBuilder.IJSystemLogger(this, logger);
        }

        public SystemLogger build(String name) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Logger logger = Logger.getInstance((String)name);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            return new systemLoggerBuilder.IJSystemLogger(this, logger);
        }
    };

    public IJPlatform() {
        super((Collection)ExtensionPointsKt.getEP_NAME_FEATURE_PROVIDER().getExtensionList(), (Collection)CollectionsKt.emptyList());
    }

    @NotNull
    public Map<String, List<com.jetbrains.ml.monitoring.MLTaskListenerTyped<?, ?>>> getTaskListeners() {
        return KeyedMessagingProvider.Companion.collect(MLTaskListenerTyped.Companion.getTOPIC());
    }

    @NotNull
    public MLApiPlatform.ExtensionController addTaskListener(@NotNull String taskId, @NotNull com.jetbrains.ml.monitoring.MLTaskListenerTyped<?, ?> taskListener) {
        Intrinsics.checkNotNullParameter((Object)taskId, (String)"taskId");
        Intrinsics.checkNotNullParameter(taskListener, (String)"taskListener");
        MessageBusConnection connection = ApplicationKt.getApplication().getMessageBus().connect();
        IJPlatform.addTaskListener$capturingType(connection, taskId, taskListener);
        return () -> IJPlatform.addTaskListener$lambda$0(connection);
    }

    @NotNull
    public Map<String, List<com.jetbrains.ml.monitoring.MLTaskLoggingListener>> getLoggingListeners() {
        return KeyedMessagingProvider.Companion.collect(MLTaskLoggingListener.Companion.getTOPIC());
    }

    @NotNull
    public MLApiPlatform.ExtensionController addLoggingListener(@NotNull String taskId, @NotNull com.jetbrains.ml.monitoring.MLTaskLoggingListener loggingListener) {
        Intrinsics.checkNotNullParameter((Object)taskId, (String)"taskId");
        Intrinsics.checkNotNullParameter((Object)loggingListener, (String)"loggingListener");
        MessageBusConnection connection = ApplicationKt.getApplication().getMessageBus().connect();
        connection.subscribe(MLTaskLoggingListener.Companion.getTOPIC(), (Object)new MessageBusMLTaskLoggingListenerProvider(loggingListener, taskId){
            final /* synthetic */ com.jetbrains.ml.monitoring.MLTaskLoggingListener $loggingListener;
            final /* synthetic */ String $taskId;
            {
                this.$loggingListener = $loggingListener;
                this.$taskId = $taskId;
            }

            public void provide(Function2<? super com.jetbrains.ml.monitoring.MLTaskLoggingListener, ? super String, Unit> collector) {
                Intrinsics.checkNotNullParameter(collector, (String)"collector");
                collector.invoke((Object)this.$loggingListener, (Object)this.$taskId);
            }
        });
        return () -> IJPlatform.addLoggingListener$lambda$1(connection);
    }

    @NotNull
    public SystemLoggerBuilder getSystemLoggerBuilder() {
        return this.systemLoggerBuilder;
    }

    private static final <M extends MLModel<? extends P>, P> void addTaskListener$capturingType(MessageBusConnection connection, String $taskId, com.jetbrains.ml.monitoring.MLTaskListenerTyped<? super M, ? super P> taskListenerTyped) {
        connection.subscribe(MLTaskListenerTyped.Companion.getTOPIC(), (Object)new MessageBusMLTaskListenerProvider<M, P>(taskListenerTyped, $taskId){
            final /* synthetic */ com.jetbrains.ml.monitoring.MLTaskListenerTyped<M, P> $taskListenerTyped;
            final /* synthetic */ String $taskId;
            {
                this.$taskListenerTyped = $taskListenerTyped;
                this.$taskId = $taskId;
            }

            public void provide(Function2<? super com.jetbrains.ml.monitoring.MLTaskListenerTyped<? super M, ? super P>, ? super String, Unit> collector) {
                Intrinsics.checkNotNullParameter(collector, (String)"collector");
                collector.invoke(this.$taskListenerTyped, (Object)this.$taskId);
            }
        });
    }

    private static final void addTaskListener$lambda$0(MessageBusConnection $connection) {
        $connection.disconnect();
    }

    private static final void addLoggingListener$lambda$1(MessageBusConnection $connection) {
        $connection.disconnect();
    }
}

