/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.html;

import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.injection.MultiHostInjector;
import com.intellij.lang.injection.MultiHostRegistrar;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.UnfairTextRange;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.templateLanguages.OuterLanguageElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.xml.XmlComment;
import com.intellij.psi.xml.XmlTokenType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HtmlConditionalCommentInjector
implements MultiHostInjector {
    public static boolean isConditionalComment(@NotNull PsiElement host) {
        if (host == null) {
            HtmlConditionalCommentInjector.$$$reportNull$$$0(0);
        }
        return HtmlConditionalCommentInjector.parseConditionalCommentBoundaries(host) != null;
    }

    @Nullable
    private static Pair<ASTNode, ASTNode> parseConditionalCommentBoundaries(@NotNull PsiElement host) {
        if (host == null) {
            HtmlConditionalCommentInjector.$$$reportNull$$$0(1);
        }
        if (!(host instanceof XmlComment)) {
            return null;
        }
        ASTNode comment = host.getNode();
        if (comment == null) {
            return null;
        }
        ASTNode conditionalStart = comment.findChildByType(TokenSet.create((IElementType[])new IElementType[]{XmlTokenType.XML_CONDITIONAL_COMMENT_START_END}));
        if (conditionalStart == null) {
            return null;
        }
        ASTNode conditionalEnd = comment.findChildByType(TokenSet.create((IElementType[])new IElementType[]{XmlTokenType.XML_CONDITIONAL_COMMENT_END_START}));
        if (conditionalEnd == null) {
            return null;
        }
        ASTNode endOfEnd = comment.findChildByType(TokenSet.create((IElementType[])new IElementType[]{XmlTokenType.XML_CONDITIONAL_COMMENT_END}));
        return endOfEnd == null ? null : Pair.create((Object)conditionalStart, (Object)conditionalEnd);
    }

    public void getLanguagesToInject(@NotNull MultiHostRegistrar registrar, @NotNull PsiElement host) {
        Pair<ASTNode, ASTNode> pair;
        if (registrar == null) {
            HtmlConditionalCommentInjector.$$$reportNull$$$0(2);
        }
        if (host == null) {
            HtmlConditionalCommentInjector.$$$reportNull$$$0(3);
        }
        if ((pair = HtmlConditionalCommentInjector.parseConditionalCommentBoundaries(host)) == null) {
            return;
        }
        TextRange textRange = host.getTextRange();
        int startOffset = textRange.getStartOffset();
        Language language = host.getParent().getLanguage();
        ASTNode conditionalStart = (ASTNode)pair.first;
        ASTNode conditionalEnd = (ASTNode)pair.second;
        UnfairTextRange range = new UnfairTextRange(conditionalStart.getTextRange().getEndOffset() - startOffset, conditionalEnd.getStartOffset() - startOffset);
        if (range.getStartOffset() < range.getEndOffset()) {
            ArrayList<TextRange> injectionsRanges = new ArrayList<TextRange>();
            for (ASTNode current = conditionalStart.getTreeNext(); current != conditionalEnd; current = current.getTreeNext()) {
                if (current.getPsi() instanceof OuterLanguageElement) continue;
                injectionsRanges.add(current.getTextRange().shiftLeft(startOffset));
            }
            if (!injectionsRanges.isEmpty()) {
                registrar.startInjecting(language);
                for (TextRange injectionsRange : injectionsRanges) {
                    registrar.addPlace(null, null, (PsiLanguageInjectionHost)host, injectionsRange);
                }
                registrar.doneInjecting();
            }
        }
    }

    @NotNull
    public List<? extends Class<? extends PsiElement>> elementsToInjectIn() {
        List<Class<PsiComment>> list2 = Collections.singletonList(PsiComment.class);
        if (list2 == null) {
            HtmlConditionalCommentInjector.$$$reportNull$$$0(4);
        }
        return list2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "host";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "registrar";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/source/html/HtmlConditionalCommentInjector";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/source/html/HtmlConditionalCommentInjector";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "elementsToInjectIn";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isConditionalComment";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "parseConditionalCommentBoundaries";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getLanguagesToInject";
                break;
            }
            case 4: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4 -> new IllegalStateException(string);
        };
    }
}

