/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tasks.impl;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonSyntaxException;
import com.intellij.ide.fileTemplates.FileTemplateUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.codeStyle.NameUtil;
import com.intellij.tasks.CommitPlaceholderProvider;
import com.intellij.tasks.LocalTask;
import com.intellij.tasks.Task;
import com.intellij.tasks.TaskRepository;
import com.intellij.tasks.impl.LocalTaskImpl;
import com.intellij.util.containers.ContainerUtil;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jdom.Element;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class TaskUtil {
    private static final Pattern ISO8601_DATE_PATTERN = Pattern.compile("(\\d{4}[/-]\\d{2}[/-]\\d{2})(?:[ T](\\d{2}:\\d{2}:\\d{2})(.\\d{3,})?(?:\\s?([+-]\\d{2}:\\d{2}|[+-]\\d{4}|[+-]\\d{2}|Z))?)?");

    private TaskUtil() {
    }

    public static String formatTask(@NotNull Task task, String format) {
        if (task == null) {
            TaskUtil.$$$reportNull$$$0(0);
        }
        Map<String, String> map = TaskUtil.formatFromExtensions(task instanceof LocalTask ? (LocalTask)task : new LocalTaskImpl(task));
        if (!task.isIssue()) {
            map.put("id", "");
        }
        format = TaskUtil.updateToVelocity(format);
        return FileTemplateUtil.mergeTemplate(map, (String)format, (boolean)false).trim();
    }

    private static Map<String, String> formatFromExtensions(@NotNull LocalTask task) {
        if (task == null) {
            TaskUtil.$$$reportNull$$$0(1);
        }
        HashMap<String, String> map = new HashMap<String, String>();
        for (CommitPlaceholderProvider extension : CommitPlaceholderProvider.EXTENSION_POINT_NAME.getExtensionList()) {
            String[] placeholders;
            for (String placeholder : placeholders = extension.getPlaceholders(task.getRepository())) {
                String value = extension.getPlaceholderValue(task, placeholder);
                if (value == null) continue;
                map.put(placeholder, value);
            }
        }
        return map;
    }

    public static String getChangeListComment(Task task) {
        return TaskUtil.getChangeListComment(task, false);
    }

    @Nullable
    public static String getChangeListComment(Task task, boolean forCommit) {
        TaskRepository repository = task.getRepository();
        if (repository == null || !repository.isShouldFormatCommitMessage()) {
            return null;
        }
        return TaskUtil.formatTask(task, repository.getCommitMessageFormat());
    }

    @Nls
    public static String getTrimmedSummary(Task task) {
        Object text = task.isIssue() ? task.getPresentableId() + ": " + task.getSummary() : task.getSummary();
        return StringUtil.first((String)text, (int)60, (boolean)true);
    }

    @Nullable
    public static Date parseDate(@NotNull String s) {
        if (s == null) {
            TaskUtil.$$$reportNull$$$0(2);
        }
        s = s.replace('/', '-');
        try {
            return Date.from(Instant.from(DateTimeFormatter.ISO_OFFSET_DATE_TIME.parse(s)));
        }
        catch (DateTimeParseException dateTimeParseException) {
            Matcher matcher = ISO8601_DATE_PATTERN.matcher(s);
            if (matcher.matches()) {
                String date = matcher.group(1).replace('/', '-');
                String time = Objects.requireNonNullElse(matcher.group(2), "00:00:00");
                String millis = Objects.requireNonNullElse(matcher.group(3), ".000").substring(1);
                Object timezone = Objects.requireNonNullElse(matcher.group(4), "Z");
                if (((String)timezone).length() == 5) {
                    timezone = ((String)timezone).substring(0, 3) + ":" + ((String)timezone).substring(3);
                }
                s = String.format("%sT%s.%s%s", date, time, millis, timezone);
                try {
                    return Date.from(Instant.from(DateTimeFormatter.ISO_OFFSET_DATE_TIME.parse(s)));
                }
                catch (DateTimeParseException dateTimeParseException2) {
                    // empty catch block
                }
            }
            return null;
        }
    }

    public static String formatDate(@NotNull Date date) {
        if (date == null) {
            TaskUtil.$$$reportNull$$$0(3);
        }
        return DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(date.toInstant().atZone(ZoneOffset.UTC));
    }

    public static boolean tasksEqual(@NotNull Task t1, @NotNull Task t2) {
        if (t1 == null) {
            TaskUtil.$$$reportNull$$$0(4);
        }
        if (t2 == null) {
            TaskUtil.$$$reportNull$$$0(5);
        }
        if (!t1.getId().equals(t2.getId())) {
            return false;
        }
        if (!t1.getSummary().equals(t2.getSummary())) {
            return false;
        }
        if (t1.isClosed() != t2.isClosed()) {
            return false;
        }
        if (t1.isIssue() != t2.isIssue()) {
            return false;
        }
        if (!Comparing.equal((Object)((Object)t1.getState()), (Object)((Object)t2.getState()))) {
            return false;
        }
        if (!Comparing.equal((Object)((Object)t1.getType()), (Object)((Object)t2.getType()))) {
            return false;
        }
        if (!Objects.equals(t1.getDescription(), t2.getDescription())) {
            return false;
        }
        if (!Comparing.equal((Object)t1.getCreated(), (Object)t2.getCreated())) {
            return false;
        }
        if (!Comparing.equal((Object)t1.getUpdated(), (Object)t2.getUpdated())) {
            return false;
        }
        if (!Objects.equals(t1.getIssueUrl(), t2.getIssueUrl())) {
            return false;
        }
        if (!Arrays.equals(t1.getComments(), t2.getComments())) {
            return false;
        }
        if (!Comparing.equal((Object)t1.getIcon(), (Object)t2.getIcon())) {
            return false;
        }
        if (!Objects.equals(t1.getCustomIcon(), t2.getCustomIcon())) {
            return false;
        }
        return Comparing.equal((Object)t1.getRepository(), (Object)t2.getRepository());
    }

    public static boolean tasksEqual(@NotNull List<? extends Task> tasks1, @NotNull List<? extends Task> tasks2) {
        if (tasks1 == null) {
            TaskUtil.$$$reportNull$$$0(6);
        }
        if (tasks2 == null) {
            TaskUtil.$$$reportNull$$$0(7);
        }
        if (tasks1.size() != tasks2.size()) {
            return false;
        }
        for (int i = 0; i < tasks1.size(); ++i) {
            if (TaskUtil.tasksEqual(tasks1.get(i), tasks2.get(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean tasksEqual(Task @NotNull [] task1, Task @NotNull [] task2) {
        if (task1 == null) {
            TaskUtil.$$$reportNull$$$0(8);
        }
        if (task2 == null) {
            TaskUtil.$$$reportNull$$$0(9);
        }
        return TaskUtil.tasksEqual(Arrays.asList(task1), Arrays.asList(task2));
    }

    public static void prettyFormatXmlToLog(@NotNull Logger logger, @NotNull String xml) {
        if (logger == null) {
            TaskUtil.$$$reportNull$$$0(10);
        }
        if (xml == null) {
            TaskUtil.$$$reportNull$$$0(11);
        }
        if (logger.isDebugEnabled()) {
            try {
                logger.debug("\n" + JDOMUtil.write((Element)JDOMUtil.load((CharSequence)xml)));
            }
            catch (Exception e) {
                logger.debug((Throwable)e);
            }
        }
    }

    public static void prettyFormatJsonToLog(@NotNull Logger logger, @NotNull String json) {
        if (logger == null) {
            TaskUtil.$$$reportNull$$$0(12);
        }
        if (json == null) {
            TaskUtil.$$$reportNull$$$0(13);
        }
        if (logger.isDebugEnabled()) {
            try {
                Gson gson = new GsonBuilder().setPrettyPrinting().create();
                logger.debug("\n" + gson.toJson((JsonElement)gson.fromJson(json, JsonElement.class)));
            }
            catch (JsonSyntaxException e) {
                logger.debug("Malformed JSON\n" + json);
            }
        }
    }

    @NotNull
    public static String encodeUrl(@NotNull String s) {
        if (s == null) {
            TaskUtil.$$$reportNull$$$0(14);
        }
        String string = URLEncoder.encode(s, StandardCharsets.UTF_8);
        if (string == null) {
            TaskUtil.$$$reportNull$$$0(15);
        }
        return string;
    }

    public static List<Task> filterTasks(String pattern, List<? extends Task> tasks) {
        com.intellij.util.text.Matcher matcher = TaskUtil.getMatcher(pattern);
        return ContainerUtil.mapNotNull(tasks, task -> matcher.matches(task.getPresentableId()) || matcher.matches(task.getSummary()) ? task : null);
    }

    private static com.intellij.util.text.Matcher getMatcher(String pattern) {
        StringTokenizer tokenizer = new StringTokenizer(pattern, " ");
        StringBuilder builder2 = new StringBuilder();
        while (tokenizer.hasMoreTokens()) {
            String word = tokenizer.nextToken();
            builder2.append('*');
            builder2.append(word);
            builder2.append("* ");
        }
        return NameUtil.buildMatcher((String)builder2.toString(), (NameUtil.MatchingCaseSensitivity)NameUtil.MatchingCaseSensitivity.NONE);
    }

    static String updateToVelocity(String format) {
        return format.replaceAll("\\{", "\\$\\{").replaceAll("\\$\\$\\{", "\\$\\{");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 15 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "task";
                break;
            }
            case 2: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "date";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "t1";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "t2";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tasks1";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tasks2";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "task1";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "task2";
                break;
            }
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "logger";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "xml";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "json";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/tasks/impl/TaskUtil";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/tasks/impl/TaskUtil";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "encodeUrl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "formatTask";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "formatFromExtensions";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "parseDate";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "formatDate";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "tasksEqual";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "prettyFormatXmlToLog";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "prettyFormatJsonToLog";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "encodeUrl";
                break;
            }
            case 15: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 15 -> new IllegalStateException(string);
        };
    }
}

