/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.actions;

import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.PlatformCoreDataKeys;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.PlainTextFileType;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.actions.AnnotateRevisionActionBase;
import com.intellij.openapi.vcs.annotate.FileAnnotation;
import com.intellij.openapi.vcs.history.VcsFileRevision;
import com.intellij.openapi.vcs.history.VcsFileRevisionEx;
import com.intellij.openapi.vcs.vfs.VcsFileSystem;
import com.intellij.openapi.vcs.vfs.VcsVirtualFile;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileSystem;
import com.intellij.vcsUtil.VcsUtil;
import java.util.function.Supplier;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

abstract class AnnotateRevisionAction
extends AnnotateRevisionActionBase
implements DumbAware {
    @NotNull
    protected final FileAnnotation myAnnotation;
    @NotNull
    private final AbstractVcs myVcs;

    AnnotateRevisionAction(@NotNull Supplier<String> dynamicText, @NotNull Supplier<String> dynamicDescription, @Nullable Icon icon, @NotNull FileAnnotation annotation, @NotNull AbstractVcs vcs) {
        if (dynamicText == null) {
            AnnotateRevisionAction.$$$reportNull$$$0(0);
        }
        if (dynamicDescription == null) {
            AnnotateRevisionAction.$$$reportNull$$$0(1);
        }
        if (annotation == null) {
            AnnotateRevisionAction.$$$reportNull$$$0(2);
        }
        if (vcs == null) {
            AnnotateRevisionAction.$$$reportNull$$$0(3);
        }
        super(dynamicText, dynamicDescription, icon);
        this.myAnnotation = annotation;
        this.myVcs = vcs;
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
        if (actionUpdateThread == null) {
            AnnotateRevisionAction.$$$reportNull$$$0(4);
        }
        return actionUpdateThread;
    }

    @Override
    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            AnnotateRevisionAction.$$$reportNull$$$0(5);
        }
        if (Boolean.TRUE.equals(e.getData(PlatformCoreDataKeys.IS_MODAL_CONTEXT))) {
            e.getPresentation().setEnabledAndVisible(false);
            return;
        }
        if (this.myAnnotation.getFile() == null) {
            e.getPresentation().setEnabledAndVisible(false);
            return;
        }
        e.getPresentation().setVisible(true);
        super.update(e);
    }

    @Override
    @Nullable
    protected AbstractVcs getVcs(@NotNull AnActionEvent e) {
        if (e == null) {
            AnnotateRevisionAction.$$$reportNull$$$0(6);
        }
        return this.myVcs;
    }

    @Override
    @Nullable
    protected VirtualFile getFile(@NotNull AnActionEvent e) {
        VcsFileRevision revision;
        if (e == null) {
            AnnotateRevisionAction.$$$reportNull$$$0(7);
        }
        if ((revision = this.getFileRevision(e)) == null) {
            return null;
        }
        FileType currentFileType = this.myAnnotation.getFile().getFileType();
        FilePath filePath = revision instanceof VcsFileRevisionEx ? ((VcsFileRevisionEx)revision).getPath() : VcsUtil.getFilePath((VirtualFile)this.myAnnotation.getFile());
        return new MyVcsVirtualFile(filePath, revision, currentFileType);
    }

    @Override
    @Nullable
    protected Editor getEditor(@NotNull AnActionEvent e) {
        if (e == null) {
            AnnotateRevisionAction.$$$reportNull$$$0(8);
        }
        return (Editor)e.getData(CommonDataKeys.EDITOR);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dynamicText";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dynamicDescription";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotation";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vcs";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vcs/actions/AnnotateRevisionAction";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vcs/actions/AnnotateRevisionAction";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdateThread";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getVcs";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getFile";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getEditor";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4 -> new IllegalStateException(string);
        };
    }

    private static class MyVcsVirtualFile
    extends VcsVirtualFile {
        @NotNull
        private final FileType myCurrentFileType;

        MyVcsVirtualFile(@NotNull FilePath filePath, @NotNull VcsFileRevision revision, @NotNull FileType currentFileType) {
            if (filePath == null) {
                MyVcsVirtualFile.$$$reportNull$$$0(0);
            }
            if (revision == null) {
                MyVcsVirtualFile.$$$reportNull$$$0(1);
            }
            if (currentFileType == null) {
                MyVcsVirtualFile.$$$reportNull$$$0(2);
            }
            super(filePath.getPath(), revision, (VirtualFileSystem)VcsFileSystem.getInstance());
            this.myCurrentFileType = currentFileType;
        }

        @NotNull
        public FileType getFileType() {
            FileType type = super.getFileType();
            if (!type.isBinary()) {
                FileType fileType = type;
                if (fileType == null) {
                    MyVcsVirtualFile.$$$reportNull$$$0(3);
                }
                return fileType;
            }
            if (!this.myCurrentFileType.isBinary()) {
                FileType fileType = this.myCurrentFileType;
                if (fileType == null) {
                    MyVcsVirtualFile.$$$reportNull$$$0(4);
                }
                return fileType;
            }
            PlainTextFileType plainTextFileType = PlainTextFileType.INSTANCE;
            if (plainTextFileType == null) {
                MyVcsVirtualFile.$$$reportNull$$$0(5);
            }
            return plainTextFileType;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 3, 4, 5 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "filePath";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "revision";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "currentFileType";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/vcs/actions/AnnotateRevisionAction$MyVcsVirtualFile";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/vcs/actions/AnnotateRevisionAction$MyVcsVirtualFile";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFileType";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 3, 4, 5 -> new IllegalStateException(string);
            };
        }
    }
}

