/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.commit;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.LocalChangeList;
import com.intellij.ui.TextAccessor;
import com.intellij.vcs.commit.AbstractCommitMessagePolicy;
import com.intellij.vcs.commit.ChangeListCommitState;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010%\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0019\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u001e\u0010\u000b\u001a\u0004\u0018\u00010\u00052\u0006\u0010\f\u001a\u00020\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fJ\u0010\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0005J\u001e\u0010\u0014\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\r2\u0006\u0010\u0016\u001a\u00020\r2\u0006\u0010\u0017\u001a\u00020\u0018J\u0016\u0010\u0019\u001a\u00020\u00122\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dJ\u000e\u0010\u001e\u001a\u00020\u00122\u0006\u0010\u001a\u001a\u00020\u001bR\u0010\u0010\b\u001a\u0004\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lcom/intellij/vcs/commit/SingleChangeListCommitMessagePolicy;", "Lcom/intellij/vcs/commit/AbstractCommitMessagePolicy;", "project", "Lcom/intellij/openapi/project/Project;", "initialCommitMessage", "", "<init>", "(Lcom/intellij/openapi/project/Project;Ljava/lang/String;)V", "lastKnownComment", "messagesToSave", "", "init", "changeList", "Lcom/intellij/openapi/vcs/changes/LocalChangeList;", "includedChanges", "", "Lcom/intellij/openapi/vcs/changes/Change;", "onCommitMessageReset", "", "text", "onChangelistChanged", "oldChangeList", "newChangeList", "currentMessage", "Lcom/intellij/ui/TextAccessor;", "onDialogClosed", "commitState", "Lcom/intellij/vcs/commit/ChangeListCommitState;", "onBeforeCommit", "", "onAfterCommit", "intellij.platform.vcs.impl"})
@SourceDebugExtension(value={"SMAP\nSingleChangeListCommitMessagePolicy.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SingleChangeListCommitMessagePolicy.kt\ncom/intellij/vcs/commit/SingleChangeListCommitMessagePolicy\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,75:1\n1#2:76\n*E\n"})
public final class SingleChangeListCommitMessagePolicy
extends AbstractCommitMessagePolicy {
    @Nullable
    private String lastKnownComment;
    @NotNull
    private final Map<String, String> messagesToSave;

    public SingleChangeListCommitMessagePolicy(@NotNull Project project, @Nullable String initialCommitMessage) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        super(project);
        this.lastKnownComment = initialCommitMessage;
        this.messagesToSave = new LinkedHashMap();
    }

    @Nullable
    public final String init(@NotNull LocalChangeList changeList, @NotNull List<? extends Change> includedChanges) {
        String commitMessage;
        String string;
        Intrinsics.checkNotNullParameter((Object)changeList, (String)"changeList");
        Intrinsics.checkNotNullParameter(includedChanges, (String)"includedChanges");
        if (this.getVcsConfiguration().CLEAR_INITIAL_COMMIT_MESSAGE) {
            return this.lastKnownComment;
        }
        if (this.lastKnownComment != null) {
            return this.lastKnownComment;
        }
        String string2 = this.getCommitMessageForList(changeList);
        if (string2 != null) {
            String string3;
            String it = string3 = string2;
            boolean bl = false;
            string = !StringsKt.isBlank((CharSequence)it) ? string3 : null;
        } else {
            string = null;
        }
        String string4 = commitMessage = string;
        if (string4 != null) {
            return string4;
        }
        this.lastKnownComment = this.getVcsConfiguration().LAST_COMMIT_MESSAGE;
        String string5 = this.getCommitMessageFromVcs(includedChanges);
        if (string5 == null) {
            string5 = this.lastKnownComment;
        }
        return string5;
    }

    public final void onCommitMessageReset(@Nullable String text) {
        this.lastKnownComment = text;
    }

    public final void onChangelistChanged(@NotNull LocalChangeList oldChangeList, @NotNull LocalChangeList newChangeList, @NotNull TextAccessor currentMessage) {
        Intrinsics.checkNotNullParameter((Object)oldChangeList, (String)"oldChangeList");
        Intrinsics.checkNotNullParameter((Object)newChangeList, (String)"newChangeList");
        Intrinsics.checkNotNullParameter((Object)currentMessage, (String)"currentMessage");
        if (this.getVcsConfiguration().CLEAR_INITIAL_COMMIT_MESSAGE) {
            return;
        }
        if (Intrinsics.areEqual((Object)oldChangeList.getName(), (Object)newChangeList.getName())) {
            return;
        }
        this.messagesToSave.put(oldChangeList.getName(), currentMessage.getText());
        String string = this.getCommitMessageForList(newChangeList);
        if (string == null) {
            string = this.lastKnownComment;
        }
        currentMessage.setText(string);
    }

    public final void onDialogClosed(@NotNull ChangeListCommitState commitState, boolean onBeforeCommit) {
        Intrinsics.checkNotNullParameter((Object)commitState, (String)"commitState");
        LocalChangeList changeList = commitState.getChangeList();
        String currentMessage = commitState.getCommitMessage();
        this.messagesToSave.put(changeList.getName(), currentMessage);
        if (onBeforeCommit) {
            boolean isChangeListFullyIncluded;
            this.getVcsConfiguration().saveCommitMessage(currentMessage);
            boolean bl = isChangeListFullyIncluded = changeList.getChanges().size() == commitState.getChanges().size();
            if (!isChangeListFullyIncluded) {
                this.messagesToSave.remove(changeList.getName());
            }
        }
        for (Map.Entry<String, String> entry : this.messagesToSave.entrySet()) {
            String changeListName = entry.getKey();
            String description = entry.getValue();
            this.getChangeListManager().editComment(changeListName, description);
        }
    }

    public final void onAfterCommit(@NotNull ChangeListCommitState commitState) {
        Intrinsics.checkNotNullParameter((Object)commitState, (String)"commitState");
        LocalChangeList changeList = commitState.getChangeList();
        boolean isChangeListFullyIncluded = changeList.getChanges().size() == commitState.getChanges().size();
        boolean isDefaultNameChangeList = changeList.hasDefaultName();
        if (isDefaultNameChangeList && isChangeListFullyIncluded) {
            ChangeListManager.getInstance((Project)this.getProject()).editComment(changeList.getName(), "");
        }
    }
}

