/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdclient.fileEditors;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.WriteIntentReadAction;
import com.intellij.openapi.client.ClientProjectSession;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.FileEditorManagerEvent;
import com.intellij.openapi.fileEditor.FileEditorManagerListener;
import com.intellij.openapi.fileEditor.FileEditorProvider;
import com.intellij.openapi.fileEditor.ex.FileEditorWithProvider;
import com.intellij.openapi.fileEditor.impl.EditorComposite;
import com.intellij.openapi.fileEditor.impl.EditorWindow;
import com.intellij.openapi.fileEditor.impl.FileEditorManagerImpl;
import com.intellij.openapi.fileEditor.impl.FileEditorOpenOptions;
import com.intellij.openapi.progress.Cancellation;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.CollectionFactory;
import com.jetbrains.ide.model.uiautomation.BeControl;
import com.jetbrains.rd.framework.IProtocol;
import com.jetbrains.rd.framework.IRdCall;
import com.jetbrains.rd.framework.impl.RpcTimeouts;
import com.jetbrains.rd.ide.editor.UtilKt;
import com.jetbrains.rd.ide.model.FileEditorCompositeModel;
import com.jetbrains.rd.ide.model.FileEditorIdAndModel;
import com.jetbrains.rd.ide.model.FileEditorManagerEventModel;
import com.jetbrains.rd.ide.model.FileEditorModel;
import com.jetbrains.rd.ide.model.FileEditorsModel;
import com.jetbrains.rd.ide.model.FileEditorsModel_GeneratedKt;
import com.jetbrains.rd.ide.model.OpenModeModel;
import com.jetbrains.rd.ide.model.OpenWithFocusRequest;
import com.jetbrains.rd.ide.model.OriginKind;
import com.jetbrains.rd.ide.model.RdFileEditorCompositeId;
import com.jetbrains.rd.ide.model.RdFileEditorId;
import com.jetbrains.rd.ide.model.RdFileId;
import com.jetbrains.rd.ide.model.Solution;
import com.jetbrains.rd.ide.model.TopBottomComponentUpdate;
import com.jetbrains.rd.ide.model.TopBottomComponentUpdateType;
import com.jetbrains.rd.platform.util.ReenterabilityKt;
import com.jetbrains.rd.platform.util.UserDataHolderKt;
import com.jetbrains.rd.platform.util.idea.LifetimedService;
import com.jetbrains.rd.protocol.SolutionExtListener;
import com.jetbrains.rd.ui.bedsl.extensions.LocalChangeKt;
import com.jetbrains.rd.ui.bedsl.extensions.UpdateFlag;
import com.jetbrains.rd.ui.bindable.UtilsKt;
import com.jetbrains.rd.ui.bindable.ViewRegistryKt;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.lifetime.LifetimeDefinition;
import com.jetbrains.rd.util.reactive.IViewableList;
import com.jetbrains.rdclient.client.FrontendSessionsUtilKt;
import com.jetbrains.rdclient.document.FrontendDocumentHost;
import com.jetbrains.rdclient.editors.FrontendTextControlHost;
import com.jetbrains.rdclient.fileEditors.FrontendFileEditorManager;
import com.jetbrains.rdclient.fileEditors.FrontendFileEditorModelHandler;
import com.jetbrains.rdclient.services.IdeBackend;
import com.jetbrains.rdclient.util.idea.ExtensionsKt;
import com.jetbrains.rdclient.vfs.FrontendVirtualFileManager;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.MutablePropertyReference2;
import kotlin.jvm.internal.MutablePropertyReference2Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.properties.ReadWriteProperty;
import kotlin.reflect.KProperty;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u00b0\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 C2\u00020\u0001:\u0004CDEFB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0002JB\u0010\u0019\u001a\u00020\u00162\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u000b2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020 2\b\u0010\"\u001a\u0004\u0018\u00010#2\u0006\u0010$\u001a\u00020 H\u0002J(\u0010%\u001a\u00020\u00162\u0006\u0010&\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u000b2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010'\u001a\u00020\bH\u0002J(\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020\u001b2\u0006\u0010-\u001a\u00020.2\u0006\u0010/\u001a\u000200H\u0002J(\u00101\u001a\u00020\u00162\u0006\u0010,\u001a\u00020\u001b2\u0006\u0010'\u001a\u00020\b2\u0006\u00102\u001a\u0002032\u0006\u00104\u001a\u000200H\u0002J8\u00105\u001a\u00020\u00162\u0006\u0010&\u001a\u00020\u001b2\u0006\u0010'\u001a\u00020\b2\u0006\u00102\u001a\u0002032\u0006\u00106\u001a\u00020\u00122\u0006\u00107\u001a\u0002082\u0006\u00109\u001a\u00020 H\u0002J(\u0010:\u001a\u00020\u00162\u0006\u0010'\u001a\u00020\b2\u0006\u00102\u001a\u0002032\u0006\u00106\u001a\u00020\u00122\u0006\u00109\u001a\u00020 H\u0002J\u0010\u0010=\u001a\u00020\u00162\u0006\u0010>\u001a\u00020?H\u0002J\u0018\u0010@\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010A\u001a\u00020BR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R3\u0010\u0006\u001a'\u0012\u000e\u0012\f0\b\u00a2\u0006\u0002\b\t\u00a2\u0006\u0002\b\n\u0012\u000e\u0012\f0\u000b\u00a2\u0006\u0002\b\t\u00a2\u0006\u0002\b\n0\u0007\u00a2\u0006\u0002\b\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\u00020\r8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00130\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00130\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010;\u001a\u00020<X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006G"}, d2={"Lcom/jetbrains/rdclient/fileEditors/FrontendFileEditorHost;", "Lcom/jetbrains/rd/platform/util/idea/LifetimedService;", "session", "Lcom/intellij/openapi/client/ClientProjectSession;", "<init>", "(Lcom/intellij/openapi/client/ClientProjectSession;)V", "compositeToId", "Ljava/util/concurrent/ConcurrentMap;", "Lcom/intellij/openapi/fileEditor/impl/EditorComposite;", "Lkotlin/jvm/internal/EnhancedNullability;", "Lorg/jetbrains/annotations/NotNull;", "Lcom/jetbrains/rd/ide/model/RdFileEditorCompositeId;", "fileEditorsModel", "Lcom/jetbrains/rd/ide/model/FileEditorsModel;", "getFileEditorsModel", "()Lcom/jetbrains/rd/ide/model/FileEditorsModel;", "topComponentsStorage", "", "", "Lcom/jetbrains/rdclient/fileEditors/FrontendFileEditorHost$ComponentInfo;", "bottomComponentsStorage", "closeFileWithCopies", "", "fileId", "Lcom/jetbrains/rd/ide/model/RdFileId;", "openComposite", "compositeModelLifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "compositeId", "compositeModel", "Lcom/jetbrains/rd/ide/model/FileEditorCompositeModel;", "requestFocus", "", "selectAsCurrent", "openMode", "Lcom/intellij/openapi/fileEditor/impl/FileEditorManagerImpl$OpenMode;", "isSingletonEditorInWindow", "bindComposite", "lifetime", "composite", "createEditorWithProvider", "Lcom/intellij/openapi/fileEditor/ex/FileEditorWithProvider;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "editorLifetime", "editorId", "Lcom/jetbrains/rd/ide/model/RdFileEditorId;", "editorModel", "Lcom/jetbrains/rd/ide/model/FileEditorModel;", "bindFileEditor", "editor", "Lcom/intellij/openapi/fileEditor/FileEditor;", "model", "addComponent", "componentId", "beControl", "Lcom/jetbrains/ide/model/uiautomation/BeControl;", "isTop", "removeComponent", "selectionChange", "Lcom/jetbrains/rd/ui/bedsl/extensions/UpdateFlag;", "sendSelection", "eventModel", "Lcom/jetbrains/rd/ide/model/FileEditorManagerEventModel;", "requestCompositeFromBackendSync", "project", "Lcom/intellij/openapi/project/Project;", "Companion", "MyProtocolListener", "MyFileEditorManagerListener", "ComponentInfo", "intellij.rd.client"})
@SourceDebugExtension(value={"SMAP\nFrontendFileEditorHost.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FrontendFileEditorHost.kt\ncom/jetbrains/rdclient/fileEditors/FrontendFileEditorHost\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,298:1\n68#2,4:299\n68#2,4:303\n68#2,4:310\n68#2,4:315\n68#2,4:319\n14#2:325\n1557#3:307\n1628#3,2:308\n1630#3:314\n13409#4,2:323\n*S KotlinDebug\n*F\n+ 1 FrontendFileEditorHost.kt\ncom/jetbrains/rdclient/fileEditors/FrontendFileEditorHost\n*L\n144#1:299,4\n148#1:303,4\n150#1:310,4\n154#1:315,4\n163#1:319,4\n59#1:325\n149#1:307\n149#1:308,2\n149#1:314\n255#1:323,2\n*E\n"})
public final class FrontendFileEditorHost
extends LifetimedService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ClientProjectSession session;
    @NotNull
    private final ConcurrentMap<EditorComposite, RdFileEditorCompositeId> compositeToId;
    @NotNull
    private final Map<String, ComponentInfo> topComponentsStorage;
    @NotNull
    private final Map<String, ComponentInfo> bottomComponentsStorage;
    @NotNull
    private final UpdateFlag selectionChange;
    @NotNull
    private static final ReadWriteProperty<? super UserDataHolder, RdFileEditorId> fileEditorId$delegate = UserDataHolderKt.userData((String)"frontendModelId");
    @NotNull
    private static final Logger LOG;

    public FrontendFileEditorHost(@NotNull ClientProjectSession session) {
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        this.session = session;
        ConcurrentMap concurrentMap = CollectionFactory.createConcurrentWeakIdentityMap();
        Intrinsics.checkNotNullExpressionValue((Object)concurrentMap, (String)"createConcurrentWeakIdentityMap(...)");
        this.compositeToId = concurrentMap;
        this.topComponentsStorage = new LinkedHashMap();
        this.bottomComponentsStorage = new LinkedHashMap();
        this.selectionChange = new UpdateFlag();
    }

    private final FileEditorsModel getFileEditorsModel() {
        return FileEditorsModel_GeneratedKt.getFileEditorsModel((Solution)FrontendSessionsUtilKt.getProtocolModel(this.session));
    }

    private final void closeFileWithCopies(RdFileId fileId) {
        VirtualFile virtualFile = FrontendVirtualFileManager.Companion.getInstance().getVirtualFile(fileId);
        if (virtualFile == null) {
            return;
        }
        VirtualFile file = virtualFile;
        FileEditorManager fileEditorManager = FileEditorManager.getInstance((Project)this.session.getProject());
        Intrinsics.checkNotNull((Object)fileEditorManager, (String)"null cannot be cast to non-null type com.intellij.openapi.fileEditor.impl.FileEditorManagerImpl");
        FileEditorManagerImpl manager = (FileEditorManagerImpl)fileEditorManager;
        manager.closeFile(file, true, true);
    }

    /*
     * WARNING - void declaration
     */
    private final void openComposite(Lifetime compositeModelLifetime, RdFileEditorCompositeId compositeId, FileEditorCompositeModel compositeModel, boolean requestFocus, boolean selectAsCurrent, FileEditorManagerImpl.OpenMode openMode, boolean isSingletonEditorInWindow) {
        Object v1;
        FrontendFileEditorManager fileEditorManager;
        VirtualFile file;
        block9: {
            VirtualFile virtualFile = FrontendVirtualFileManager.Companion.getInstance().getVirtualFile(compositeId.getFileId());
            Intrinsics.checkNotNull((Object)virtualFile);
            file = virtualFile;
            Project project = this.session.getProject();
            fileEditorManager = FrontendFileEditorManager.Companion.getInstance(project);
            List fileComposites = fileEditorManager.getAllComposites(file);
            Iterable iterable = fileComposites;
            for (Object t : iterable) {
                EditorComposite it = (EditorComposite)t;
                boolean bl = false;
                RdFileEditorCompositeId rdFileEditorCompositeId = (RdFileEditorCompositeId)this.compositeToId.get(it);
                if (!Intrinsics.areEqual((Object)rdFileEditorCompositeId, (Object)compositeId)) continue;
                v1 = t;
                break block9;
            }
            v1 = null;
        }
        EditorComposite existingComposite = v1;
        if (existingComposite != null) {
            EditorWindow editorWindow;
            block10: {
                EditorWindow[] editorWindowArray = fileEditorManager.getWindows();
                int it = editorWindowArray.length;
                for (int i = 0; i < it; ++i) {
                    EditorWindow bl;
                    EditorWindow it2 = bl = editorWindowArray[i];
                    boolean bl2 = false;
                    if (!SequencesKt.contains((Sequence)it2.composites(), (Object)existingComposite)) continue;
                    editorWindow = bl;
                    break block10;
                }
                editorWindow = null;
            }
            EditorWindow existingWindow = editorWindow;
            Logger $this$trace$iv = LOG;
            boolean $i$f$trace = false;
            if ($this$trace$iv.isTraceEnabled()) {
                Logger logger = $this$trace$iv;
                boolean bl = false;
                logger.trace("[file] openComposite: opening existing editor. file.name=" + file.getName() + ", compositeId=" + UtilKt.toDebugString((RdFileEditorCompositeId)compositeId));
            }
            fileEditorManager.openFile(file, existingWindow, new FileEditorOpenOptions(false, false, false, requestFocus, false, 0, false, null, false, false, 1015, null));
        } else {
            void $this$mapTo$iv$iv;
            Object object;
            Logger $this$trace$iv = LOG;
            boolean $i$f$trace = false;
            if ($this$trace$iv.isTraceEnabled()) {
                object = $this$trace$iv;
                boolean bl = false;
                object.trace("[file] openComposite: collect `editorsWithProviders` for " + compositeModel.getEditors().size() + " editors. file.name=" + file.getName() + ", compositeId=" + UtilKt.toDebugString((RdFileEditorCompositeId)compositeId));
            }
            Iterable $this$map$iv = compositeModel.getEditors();
            boolean $i$f$map = false;
            Iterable bl = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                FileEditorIdAndModel fileEditorIdAndModel = (FileEditorIdAndModel)item$iv$iv;
                object = destination$iv$iv;
                boolean bl3 = false;
                Logger $this$trace$iv2 = LOG;
                boolean $i$f$trace2 = false;
                if ($this$trace$iv2.isTraceEnabled()) {
                    Logger logger = $this$trace$iv2;
                    boolean bl4 = false;
                    logger.trace("[file] openComposite$map: call createEditorWithProvider(id=" + UtilKt.toDebugString((RdFileEditorId)it.getId()) + "))");
                }
                object.add(this.createEditorWithProvider(file, compositeModelLifetime, it.getId(), it.getModel()));
            }
            List editorsWithProviders = (List)destination$iv$iv;
            Logger $this$trace$iv3 = LOG;
            boolean $i$f$trace3 = false;
            if ($this$trace$iv3.isTraceEnabled()) {
                object = $this$trace$iv3;
                boolean bl5 = false;
                object.trace("[file] openComposite: call openFileFromBackend for collected `editorsWithProviders`");
            }
            fileEditorManager.openFileFromBackend$intellij_rd_client(file, editorsWithProviders, requestFocus, selectAsCurrent, openMode, isSingletonEditorInWindow, (Function1<? super EditorComposite, Unit>)((Function1)arg_0 -> FrontendFileEditorHost.openComposite$lambda$8(this, compositeModelLifetime, compositeId, compositeModel, arg_0)));
        }
    }

    private final void bindComposite(Lifetime lifetime, RdFileEditorCompositeId compositeId, FileEditorCompositeModel compositeModel, EditorComposite composite) {
        this.compositeToId.put(composite, compositeId);
        lifetime.onTermination(() -> FrontendFileEditorHost.bindComposite$lambda$11(this, composite));
        Disposer.register((Disposable)((Disposable)composite), () -> FrontendFileEditorHost.bindComposite$lambda$12(this, compositeId));
        for (Pair pair : CollectionsKt.zip((Iterable)composite.getAllEditors(), (Iterable)compositeModel.getEditors())) {
            FileEditor editor = (FileEditor)pair.component1();
            FileEditorIdAndModel editorModel = (FileEditorIdAndModel)pair.component2();
            this.bindFileEditor(lifetime, composite, editor, editorModel.getModel());
        }
        compositeModel.getDynamicallyAddedEditors().getChange().advise(lifetime, arg_0 -> FrontendFileEditorHost.bindComposite$lambda$13(this, composite, lifetime, arg_0));
        UtilsKt.showingProperty((Component)composite.getComponent()).advise(lifetime, arg_0 -> FrontendFileEditorHost.bindComposite$lambda$14(compositeModel, arg_0));
    }

    private final FileEditorWithProvider createEditorWithProvider(VirtualFile file, Lifetime editorLifetime, RdFileEditorId editorId, FileEditorModel editorModel) {
        Object object = FrontendFileEditorModelHandler.Companion.getEP().findFirstSafe(arg_0 -> FrontendFileEditorHost.createEditorWithProvider$lambda$16(arg_0 -> FrontendFileEditorHost.createEditorWithProvider$lambda$15(this, file, editorModel, arg_0), arg_0));
        Intrinsics.checkNotNull((Object)object);
        FrontendFileEditorModelHandler handler = (FrontendFileEditorModelHandler)object;
        FileEditorWithProvider editorWithProvider = handler.createEditorWithProvider(this.session.getProject(), editorLifetime, file, editorModel);
        FrontendFileEditorHost.Companion.setFileEditorId(editorWithProvider.getFileEditor(), editorId);
        editorLifetime.onTermination(() -> FrontendFileEditorHost.createEditorWithProvider$lambda$17(editorWithProvider));
        return editorWithProvider;
    }

    private final void bindFileEditor(Lifetime editorLifetime, EditorComposite composite, FileEditor editor, FileEditorModel model) {
        FileEditorModel fileEditorModel;
        FileEditorModel $this$bindFileEditor_u24lambda_u2423 = fileEditorModel = model;
        boolean bl = false;
        $this$bindFileEditor_u24lambda_u2423.getName().getChange().advise(editorLifetime, arg_0 -> FrontendFileEditorHost.bindFileEditor$lambda$23$lambda$18(composite, editor, arg_0));
        Function1 processUpdate2 = arg_0 -> FrontendFileEditorHost.bindFileEditor$lambda$23$lambda$20(this, composite, editor, editorLifetime, arg_0);
        $this$bindFileEditor_u24lambda_u2423.getTopBottomComponentsUpdates().view(editorLifetime, (arg_0, arg_1) -> FrontendFileEditorHost.bindFileEditor$lambda$23$lambda$22(processUpdate2, arg_0, arg_1));
    }

    private final void addComponent(Lifetime lifetime, EditorComposite composite, FileEditor editor, String componentId, BeControl beControl, boolean isTop) {
        LifetimeDefinition componentLifetime = lifetime.createNested();
        JComponent panel = ViewRegistryKt.getView((BeControl)beControl, (Lifetime)((Lifetime)componentLifetime));
        Map<String, ComponentInfo> storage = isTop ? this.topComponentsStorage : this.bottomComponentsStorage;
        storage.put(componentId, new ComponentInfo(panel, componentLifetime));
        EditorComposite $this$addComponent_u24lambda_u2424 = composite;
        boolean bl = false;
        if (isTop) {
            $this$addComponent_u24lambda_u2424.addTopComponent(editor, panel);
        } else {
            $this$addComponent_u24lambda_u2424.addBottomComponent(editor, panel);
        }
    }

    private final void removeComponent(EditorComposite composite, FileEditor editor, String componentId, boolean isTop) {
        Map<String, ComponentInfo> storage = isTop ? this.topComponentsStorage : this.bottomComponentsStorage;
        ComponentInfo componentInfo = storage.remove(componentId);
        if (componentInfo == null) {
            return;
        }
        ComponentInfo componentInfo2 = componentInfo;
        JComponent panel = componentInfo2.component1();
        LifetimeDefinition lifetime = componentInfo2.component2();
        EditorComposite $this$removeComponent_u24lambda_u2425 = composite;
        boolean bl = false;
        if (isTop) {
            $this$removeComponent_u24lambda_u2425.removeTopComponent(editor, panel);
        } else {
            $this$removeComponent_u24lambda_u2425.removeBottomComponent(editor, panel);
        }
        LifetimeDefinition.terminate$default((LifetimeDefinition)lifetime, (boolean)false, (int)1, null);
    }

    private final void sendSelection(FileEditorManagerEventModel eventModel) {
        LocalChangeKt.ignoreOnReentrancy((UpdateFlag)this.selectionChange, () -> FrontendFileEditorHost.sendSelection$lambda$26(this, eventModel));
    }

    @Nullable
    public final RdFileEditorCompositeId requestCompositeFromBackendSync(@NotNull RdFileId fileId, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)fileId, (String)"fileId");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        IProtocol protocol = IdeBackend.Companion.getInstance(project).getProtocol();
        return (RdFileEditorCompositeId)ExtensionsKt.callSynchronously$default((IRdCall)this.getFileEditorsModel().getRequestComposite(), fileId, protocol, null, RpcTimeouts.Companion.getDefault(), null, 20, null);
    }

    private static final Unit openComposite$lambda$8(FrontendFileEditorHost this$0, Lifetime $compositeModelLifetime, RdFileEditorCompositeId $compositeId, FileEditorCompositeModel $compositeModel, EditorComposite it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Logger $this$trace$iv = LOG;
        boolean $i$f$trace = false;
        if ($this$trace$iv.isTraceEnabled()) {
            Logger logger = $this$trace$iv;
            boolean bl = false;
            logger.trace("[file] openComposite$openFileFromBackend: call bindComposite(...)");
        }
        this$0.bindComposite($compositeModelLifetime, $compositeId, $compositeModel, it);
        return Unit.INSTANCE;
    }

    private static final void bindComposite$lambda$11$lambda$10$lambda$9(FrontendFileEditorHost this$0, EditorComposite $composite) {
        FrontendFileEditorManager.Companion.getInstance(this$0.session.getProject()).closeFile$intellij_rd_client($composite);
    }

    private static final Unit bindComposite$lambda$11$lambda$10(FrontendFileEditorHost this$0, EditorComposite $composite) {
        Cancellation.executeInNonCancelableSection(() -> FrontendFileEditorHost.bindComposite$lambda$11$lambda$10$lambda$9(this$0, $composite));
        return Unit.INSTANCE;
    }

    private static final Unit bindComposite$lambda$11(FrontendFileEditorHost this$0, EditorComposite $composite) {
        this$0.compositeToId.remove($composite);
        if (!Disposer.isDisposed((Disposable)((Disposable)$composite))) {
            FrontendTextControlHost textControlHost = FrontendTextControlHost.Companion.getInstance(this$0.session.getAppSession());
            ReenterabilityKt.noReenter((Object)textControlHost.getEditorIsReleasingLock(), () -> FrontendFileEditorHost.bindComposite$lambda$11$lambda$10(this$0, $composite));
        }
        return Unit.INSTANCE;
    }

    private static final void bindComposite$lambda$12(FrontendFileEditorHost this$0, RdFileEditorCompositeId $compositeId) {
        this$0.getFileEditorsModel().getComposites().remove((Object)$compositeId);
    }

    private static final Unit bindComposite$lambda$13(FrontendFileEditorHost this$0, EditorComposite $composite, Lifetime $lifetime, IViewableList.Event event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (!(event instanceof IViewableList.Event.Add)) {
            return Unit.INSTANCE;
        }
        RdFileEditorId editorId = ((FileEditorIdAndModel)((IViewableList.Event.Add)event).getNewValue()).getId();
        FileEditorModel editorModel = ((FileEditorIdAndModel)((IViewableList.Event.Add)event).getNewValue()).getModel();
        FileEditorWithProvider editorWithProvider = this$0.createEditorWithProvider($composite.getFile(), $lifetime, editorId, editorModel);
        FileEditor editor = editorWithProvider.getFileEditor();
        FileEditorProvider provider2 = editorWithProvider.getProvider();
        $composite.addEditor(editor, provider2);
        this$0.bindFileEditor($lifetime, $composite, editor, editorModel);
        return Unit.INSTANCE;
    }

    private static final Unit bindComposite$lambda$14(FileEditorCompositeModel $compositeModel, boolean it) {
        $compositeModel.getVisible().set((Object)it);
        return Unit.INSTANCE;
    }

    private static final boolean createEditorWithProvider$lambda$15(FrontendFileEditorHost this$0, VirtualFile $file, FileEditorModel $editorModel, FrontendFileEditorModelHandler it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.accept(this$0.session.getProject(), $file, $editorModel);
    }

    private static final boolean createEditorWithProvider$lambda$16(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final Unit createEditorWithProvider$lambda$17(FileEditorWithProvider $editorWithProvider) {
        FrontendFileEditorHost.Companion.setFileEditorId($editorWithProvider.getFileEditor(), null);
        return Unit.INSTANCE;
    }

    private static final Unit bindFileEditor$lambda$23$lambda$18(EditorComposite $composite, FileEditor $editor, String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        $composite.setDisplayName($editor, it);
        return Unit.INSTANCE;
    }

    private static final Object bindFileEditor$lambda$23$lambda$20(FrontendFileEditorHost this$0, EditorComposite $composite, FileEditor $editor, Lifetime $editorLifetime, TopBottomComponentUpdate update2) {
        Intrinsics.checkNotNullParameter((Object)update2, (String)"update");
        return switch (WhenMappings.$EnumSwitchMapping$0[update2.getUpdateType().ordinal()]) {
            case 1 -> {
                BeControl v0 = update2.getBeControl();
                if (v0 != null) {
                    BeControl var5_5;
                    BeControl beControl = var5_5 = v0;
                    boolean $i$a$-also-FrontendFileEditorHost$bindFileEditor$1$processUpdate$1$1 = false;
                    this$0.addComponent($editorLifetime, $composite, $editor, update2.getComponentId(), beControl, update2.isTop());
                    yield var5_5;
                }
                yield null;
            }
            case 2 -> {
                this$0.removeComponent($composite, $editor, update2.getComponentId(), update2.isTop());
                yield Unit.INSTANCE;
            }
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    private static final Unit bindFileEditor$lambda$23$lambda$22(Function1 $processUpdate, Lifetime lifetime, TopBottomComponentUpdate[] updates) {
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"<unused var>");
        Intrinsics.checkNotNullParameter((Object)updates, (String)"updates");
        TopBottomComponentUpdate[] $this$forEach$iv = updates;
        boolean $i$f$forEach = false;
        int n = $this$forEach$iv.length;
        for (int i = 0; i < n; ++i) {
            TopBottomComponentUpdate element$iv;
            TopBottomComponentUpdate it = element$iv = $this$forEach$iv[i];
            boolean bl = false;
            $processUpdate.invoke((Object)it);
        }
        return Unit.INSTANCE;
    }

    private static final Unit sendSelection$lambda$26(FrontendFileEditorHost this$0, FileEditorManagerEventModel $eventModel) {
        this$0.getFileEditorsModel().getSelectionChanged().fire((Object)$eventModel);
        return Unit.INSTANCE;
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(FrontendFileEditorHost.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u0016\u0010\u0012\u001a\u0004\u0018\u00010\u000b*\u00020\u00132\u0006\u0010\n\u001a\u00020\tH\u0002R3\u0010\n\u001a\u0004\u0018\u00010\t*\u00020\u000b2\b\u0010\b\u001a\u0004\u0018\u00010\t8F@BX\u0086\u008e\u0002\u00a2\u0006\u0012\n\u0004\b\u0010\u0010\u0011\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/jetbrains/rdclient/fileEditors/FrontendFileEditorHost$Companion;", "", "<init>", "()V", "getInstance", "Lcom/jetbrains/rdclient/fileEditors/FrontendFileEditorHost;", "session", "Lcom/intellij/openapi/client/ClientProjectSession;", "<set-?>", "Lcom/jetbrains/rd/ide/model/RdFileEditorId;", "fileEditorId", "Lcom/intellij/openapi/fileEditor/FileEditor;", "getFileEditorId", "(Lcom/intellij/openapi/fileEditor/FileEditor;)Lcom/jetbrains/rd/ide/model/RdFileEditorId;", "setFileEditorId", "(Lcom/intellij/openapi/fileEditor/FileEditor;Lcom/jetbrains/rd/ide/model/RdFileEditorId;)V", "fileEditorId$delegate", "Lkotlin/properties/ReadWriteProperty;", "getEditor", "Lcom/intellij/openapi/fileEditor/impl/EditorComposite;", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "intellij.rd.client"})
    @SourceDebugExtension(value={"SMAP\nFrontendFileEditorHost.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FrontendFileEditorHost.kt\ncom/jetbrains/rdclient/fileEditors/FrontendFileEditorHost$Companion\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,298:1\n31#2,2:299\n1#3:301\n*S KotlinDebug\n*F\n+ 1 FrontendFileEditorHost.kt\ncom/jetbrains/rdclient/fileEditors/FrontendFileEditorHost$Companion\n*L\n50#1:299,2\n*E\n"})
    public static final class Companion {
        static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;

        private Companion() {
        }

        @NotNull
        public final FrontendFileEditorHost getInstance(@NotNull ClientProjectSession session) {
            Intrinsics.checkNotNullParameter((Object)session, (String)"session");
            ComponentManager $this$service$iv = (ComponentManager)session;
            boolean $i$f$service = false;
            Class<FrontendFileEditorHost> serviceClass$iv = FrontendFileEditorHost.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            return (FrontendFileEditorHost)((Object)object);
        }

        @Nullable
        public final RdFileEditorId getFileEditorId(@NotNull FileEditor $this$fileEditorId) {
            Intrinsics.checkNotNullParameter((Object)$this$fileEditorId, (String)"<this>");
            return (RdFileEditorId)fileEditorId$delegate.getValue((Object)$this$fileEditorId, $$delegatedProperties[0]);
        }

        private final void setFileEditorId(FileEditor $this$fileEditorId, RdFileEditorId rdFileEditorId) {
            fileEditorId$delegate.setValue((Object)$this$fileEditorId, $$delegatedProperties[0], (Object)rdFileEditorId);
        }

        private final FileEditor getEditor(EditorComposite $this$getEditor, RdFileEditorId fileEditorId) {
            Object v0;
            block1: {
                Iterable iterable = $this$getEditor.getAllEditors();
                for (Object t : iterable) {
                    FileEditor it = (FileEditor)t;
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)Companion.getFileEditorId(it), (Object)fileEditorId)) continue;
                    v0 = t;
                    break block1;
                }
                v0 = null;
            }
            return v0;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        static {
            KProperty[] kPropertyArray = new KProperty[]{Reflection.mutableProperty2((MutablePropertyReference2)((MutablePropertyReference2)new MutablePropertyReference2Impl(Companion.class, "fileEditorId", "getFileEditorId(Lcom/intellij/openapi/fileEditor/FileEditor;)Lcom/jetbrains/rd/ide/model/RdFileEditorId;", 0)))};
            $$delegatedProperties = kPropertyArray;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\r\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0016"}, d2={"Lcom/jetbrains/rdclient/fileEditors/FrontendFileEditorHost$ComponentInfo;", "", "component", "Ljavax/swing/JComponent;", "lifetime", "Lcom/jetbrains/rd/util/lifetime/LifetimeDefinition;", "<init>", "(Ljavax/swing/JComponent;Lcom/jetbrains/rd/util/lifetime/LifetimeDefinition;)V", "getComponent", "()Ljavax/swing/JComponent;", "getLifetime", "()Lcom/jetbrains/rd/util/lifetime/LifetimeDefinition;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "intellij.rd.client"})
    private static final class ComponentInfo {
        @NotNull
        private final JComponent component;
        @NotNull
        private final LifetimeDefinition lifetime;

        public ComponentInfo(@NotNull JComponent component, @NotNull LifetimeDefinition lifetime) {
            Intrinsics.checkNotNullParameter((Object)component, (String)"component");
            Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
            this.component = component;
            this.lifetime = lifetime;
        }

        @NotNull
        public final JComponent getComponent() {
            return this.component;
        }

        @NotNull
        public final LifetimeDefinition getLifetime() {
            return this.lifetime;
        }

        @NotNull
        public final JComponent component1() {
            return this.component;
        }

        @NotNull
        public final LifetimeDefinition component2() {
            return this.lifetime;
        }

        @NotNull
        public final ComponentInfo copy(@NotNull JComponent component, @NotNull LifetimeDefinition lifetime) {
            Intrinsics.checkNotNullParameter((Object)component, (String)"component");
            Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
            return new ComponentInfo(component, lifetime);
        }

        public static /* synthetic */ ComponentInfo copy$default(ComponentInfo componentInfo, JComponent jComponent, LifetimeDefinition lifetimeDefinition, int n, Object object) {
            if ((n & 1) != 0) {
                jComponent = componentInfo.component;
            }
            if ((n & 2) != 0) {
                lifetimeDefinition = componentInfo.lifetime;
            }
            return componentInfo.copy(jComponent, lifetimeDefinition);
        }

        @NotNull
        public String toString() {
            return "ComponentInfo(component=" + this.component + ", lifetime=" + this.lifetime + ")";
        }

        public int hashCode() {
            int result2 = this.component.hashCode();
            result2 = result2 * 31 + this.lifetime.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ComponentInfo)) {
                return false;
            }
            ComponentInfo componentInfo = (ComponentInfo)other;
            if (!Intrinsics.areEqual((Object)this.component, (Object)componentInfo.component)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.lifetime, (Object)componentInfo.lifetime);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\b"}, d2={"Lcom/jetbrains/rdclient/fileEditors/FrontendFileEditorHost$MyFileEditorManagerListener;", "Lcom/intellij/openapi/fileEditor/FileEditorManagerListener;", "<init>", "()V", "selectionChanged", "", "event", "Lcom/intellij/openapi/fileEditor/FileEditorManagerEvent;", "intellij.rd.client"})
    public static final class MyFileEditorManagerListener
    implements FileEditorManagerListener {
        public void selectionChanged(@NotNull FileEditorManagerEvent event) {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            FileEditor fileEditor = event.getOldEditor();
            RdFileEditorId oldEditorId = fileEditor != null ? Companion.getFileEditorId(fileEditor) : null;
            FileEditor fileEditor2 = event.getNewEditor();
            RdFileEditorId newEditorId = fileEditor2 != null ? Companion.getFileEditorId(fileEditor2) : null;
            FileEditorManagerEventModel eventModel = new FileEditorManagerEventModel(OriginKind.Frontend, oldEditorId, newEditorId);
            Project project = event.getManager().getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            Companion.getInstance(FrontendSessionsUtilKt.getFrontendProjectSession(project)).sendSelection(eventModel);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0002H\u0016J\f\u0010\f\u001a\u00020\r*\u00020\u000eH\u0002\u00a8\u0006\u000f"}, d2={"Lcom/jetbrains/rdclient/fileEditors/FrontendFileEditorHost$MyProtocolListener;", "Lcom/jetbrains/rd/protocol/SolutionExtListener;", "Lcom/jetbrains/rd/ide/model/FileEditorsModel;", "<init>", "()V", "extensionCreated", "", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "session", "Lcom/intellij/openapi/client/ClientProjectSession;", "model", "fromModel", "Lcom/intellij/openapi/fileEditor/impl/FileEditorManagerImpl$OpenMode;", "Lcom/jetbrains/rd/ide/model/OpenModeModel;", "intellij.rd.client"})
    @SourceDebugExtension(value={"SMAP\nFrontendFileEditorHost.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FrontendFileEditorHost.kt\ncom/jetbrains/rdclient/fileEditors/FrontendFileEditorHost$MyProtocolListener\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,298:1\n68#2,4:299\n68#2,4:303\n68#2,4:307\n68#2,4:311\n*S KotlinDebug\n*F\n+ 1 FrontendFileEditorHost.kt\ncom/jetbrains/rdclient/fileEditors/FrontendFileEditorHost$MyProtocolListener\n*L\n71#1:299,4\n74#1:303,4\n93#1:307,4\n76#1:311,4\n*E\n"})
    public static final class MyProtocolListener
    implements SolutionExtListener<FileEditorsModel> {
        public void extensionCreated(@NotNull Lifetime lifetime, @NotNull ClientProjectSession session, @NotNull FileEditorsModel model) {
            Logger logger;
            Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
            Intrinsics.checkNotNullParameter((Object)session, (String)"session");
            Intrinsics.checkNotNullParameter((Object)model, (String)"model");
            Logger $this$trace$iv = LOG;
            boolean $i$f$trace = false;
            if ($this$trace$iv.isTraceEnabled()) {
                logger = $this$trace$iv;
                boolean bl = false;
                logger.trace("[service] MyProtocolListener$extensionCreated: before launchOnEdtAndStartImmediatelyIfEdt");
            }
            FrontendDocumentHost.Companion.getInstance(session.getAppSession()).ensureProtocolSubscriptionsReady();
            $this$trace$iv = LOG;
            $i$f$trace = false;
            if ($this$trace$iv.isTraceEnabled()) {
                logger = $this$trace$iv;
                boolean bl = false;
                logger.trace("[service] MyProtocolListener$extensionCreated$launchOnEdtAndStartImmediatelyIfEdt: subscribe on `fileEditorsModel.composites` model");
            }
            model.getComposites().view(lifetime, (arg_0, arg_1) -> MyProtocolListener.extensionCreated$lambda$5(session, this, arg_0, arg_1));
            $this$trace$iv = LOG;
            $i$f$trace = false;
            if ($this$trace$iv.isTraceEnabled()) {
                logger = $this$trace$iv;
                boolean bl = false;
                logger.trace("[service] MyProtocolListener$extensionCreated$launchOnEdtAndStartImmediatelyIfEdt: subscribe on `fileEditorsModel.closeFileWithCopies` model");
            }
            model.getCloseFileWithCopies().advise(lifetime, arg_0 -> MyProtocolListener.extensionCreated$lambda$7(session, arg_0));
        }

        private final FileEditorManagerImpl.OpenMode fromModel(OpenModeModel $this$fromModel) {
            return switch (WhenMappings.$EnumSwitchMapping$0[$this$fromModel.ordinal()]) {
                case 1 -> FileEditorManagerImpl.OpenMode.NEW_WINDOW;
                case 2 -> FileEditorManagerImpl.OpenMode.RIGHT_SPLIT;
                case 3 -> FileEditorManagerImpl.OpenMode.DEFAULT;
                default -> throw new NoWhenBranchMatchedException();
            };
        }

        private static final void extensionCreated$lambda$5$lambda$4$lambda$3(ClientProjectSession $session, Lifetime $compositeLifetime, RdFileEditorCompositeId $compositeId, FileEditorCompositeModel $compositeModel, OpenWithFocusRequest $it, MyProtocolListener this$0) {
            OpenModeModel openModeModel = $it.getOpenMode();
            Companion.getInstance($session).openComposite($compositeLifetime, $compositeId, $compositeModel, $it.getRequestFocus(), $it.getSelectAsCurrent(), openModeModel != null ? this$0.fromModel(openModeModel) : null, $it.isSingletonEditorInWindow());
        }

        private static final Unit extensionCreated$lambda$5$lambda$4(ClientProjectSession $session, Lifetime $compositeLifetime, RdFileEditorCompositeId $compositeId, FileEditorCompositeModel $compositeModel, MyProtocolListener this$0, OpenWithFocusRequest it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            WriteIntentReadAction.run(() -> MyProtocolListener.extensionCreated$lambda$5$lambda$4$lambda$3($session, $compositeLifetime, $compositeId, $compositeModel, it, this$0));
            return Unit.INSTANCE;
        }

        private static final Unit extensionCreated$lambda$5(ClientProjectSession $session, MyProtocolListener this$0, Lifetime compositeLifetime, Map.Entry entry) {
            Intrinsics.checkNotNullParameter((Object)compositeLifetime, (String)"compositeLifetime");
            Intrinsics.checkNotNullParameter((Object)entry, (String)"<destruct>");
            RdFileEditorCompositeId compositeId = (RdFileEditorCompositeId)entry.getKey();
            FileEditorCompositeModel compositeModel = (FileEditorCompositeModel)entry.getValue();
            Logger $this$trace$iv = LOG;
            boolean $i$f$trace = false;
            if ($this$trace$iv.isTraceEnabled()) {
                Logger logger = $this$trace$iv;
                boolean bl = false;
                logger.trace("[service] MyProtocolListener$extensionCreated$launchOnEdtAndStartImmediatelyIfEdt: subscribe on `compositeModel.openWithFocus` signal");
            }
            compositeModel.getOpenWithFocus().advise(compositeLifetime, arg_0 -> MyProtocolListener.extensionCreated$lambda$5$lambda$4($session, compositeLifetime, compositeId, compositeModel, this$0, arg_0));
            return Unit.INSTANCE;
        }

        private static final Unit extensionCreated$lambda$7(ClientProjectSession $session, RdFileId fileId) {
            Intrinsics.checkNotNullParameter((Object)fileId, (String)"fileId");
            Companion.getInstance($session).closeFileWithCopies(fileId);
            return Unit.INSTANCE;
        }

        @Metadata(mv={2, 0, 0}, k=3, xi=48)
        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[OpenModeModel.values().length];
                try {
                    nArray[OpenModeModel.NEW_WINDOW.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[OpenModeModel.RIGHT_SPLIT.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[OpenModeModel.DEFAULT.ordinal()] = 3;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[TopBottomComponentUpdateType.values().length];
            try {
                nArray[TopBottomComponentUpdateType.ADD.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TopBottomComponentUpdateType.REMOVE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

