/*
 * Decompiled with CFR 0.152.
 */
package com.openhtmltopdf.css.parser.property;

import com.openhtmltopdf.css.constants.CSSName;
import com.openhtmltopdf.css.constants.IdentValue;
import com.openhtmltopdf.css.parser.CSSParseException;
import com.openhtmltopdf.css.parser.CSSPrimitiveValue;
import com.openhtmltopdf.css.parser.PropertyValue;
import com.openhtmltopdf.css.parser.property.PropertyBuilder;
import com.openhtmltopdf.css.sheet.PropertyDeclaration;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;

public abstract class AbstractPropertyBuilder
implements PropertyBuilder {
    @Override
    public List<PropertyDeclaration> buildDeclarations(CSSName cssName, List<PropertyValue> values, int origin, boolean important) {
        return this.buildDeclarations(cssName, values, origin, important, true);
    }

    protected void checkValueCount(CSSName cssName, int expected, int found) {
        if (expected != found) {
            throw new CSSParseException("Found " + found + " value(s) for " + cssName + " when " + expected + " value(s) were expected", -1);
        }
    }

    protected void checkValueCount(CSSName cssName, int min, int max, int found) {
        if (found < min || found > max) {
            throw new CSSParseException("Found " + found + " value(s) for " + cssName + " when between " + min + " and " + max + " value(s) were expected", -1);
        }
    }

    protected void checkIdentType(CSSName cssName, CSSPrimitiveValue value2) {
        if (value2.getPrimitiveType() != 21) {
            throw new CSSParseException("Value for " + cssName + " must be an identifier", -1);
        }
    }

    protected void checkIdentOrURIType(CSSName cssName, CSSPrimitiveValue value2) {
        short type2 = value2.getPrimitiveType();
        if (type2 != 21 && type2 != 20) {
            throw new CSSParseException("Value for " + cssName + " must be an identifier or a URI", -1);
        }
    }

    protected void checkIdentOrColorType(CSSName cssName, CSSPrimitiveValue value2) {
        short type2 = value2.getPrimitiveType();
        if (type2 != 21 && type2 != 25) {
            throw new CSSParseException("Value for " + cssName + " must be an identifier or a color", -1);
        }
    }

    protected void checkIdentOrIntegerType(CSSName cssName, CSSPrimitiveValue value2) {
        short type2 = value2.getPrimitiveType();
        if (type2 != 21 && type2 != 1 || type2 == 1 && (int)value2.getFloatValue((short)1) != Math.round(value2.getFloatValue((short)1))) {
            throw new CSSParseException("Value for " + cssName + " must be an identifier or an integer", -1);
        }
    }

    protected void checkInteger(CSSName cssName, CSSPrimitiveValue value2) {
        short type2 = value2.getPrimitiveType();
        if (type2 != 1 || type2 == 1 && (int)value2.getFloatValue((short)1) != Math.round(value2.getFloatValue((short)1))) {
            throw new CSSParseException("Value for " + cssName + " must be an integer", -1);
        }
    }

    protected void checkIdentOrLengthType(CSSName cssName, CSSPrimitiveValue value2) {
        short type2 = value2.getPrimitiveType();
        if (type2 != 21 && !this.isLength(value2)) {
            throw new CSSParseException("Value for " + cssName + " must be an identifier or a length", -1);
        }
    }

    protected void checkIdentOrNumberType(CSSName cssName, CSSPrimitiveValue value2) {
        short type2 = value2.getPrimitiveType();
        if (type2 != 21 && type2 != 1) {
            throw new CSSParseException("Value for " + cssName + " must be an identifier or a length", -1);
        }
    }

    protected void checkIdentLengthOrPercentType(CSSName cssName, CSSPrimitiveValue value2) {
        short type2 = value2.getPrimitiveType();
        if (type2 != 21 && !this.isLength(value2) && type2 != 2) {
            throw new CSSParseException("Value for " + cssName + " must be an identifier, length, or percentage", -1);
        }
    }

    protected void checkLengthOrPercentType(CSSName cssName, CSSPrimitiveValue value2) {
        short type2 = value2.getPrimitiveType();
        if (!this.isLength(value2) && type2 != 2) {
            throw new CSSParseException("Value for " + cssName + " must be a length or percentage", -1);
        }
    }

    protected void checkLengthType(CSSName cssName, CSSPrimitiveValue value2) {
        if (!this.isLength(value2)) {
            throw new CSSParseException("Value for " + cssName + " must be a length", -1);
        }
    }

    protected void checkNumberType(CSSName cssName, CSSPrimitiveValue value2) {
        if (value2.getPrimitiveType() != 1) {
            throw new CSSParseException("Value for " + cssName + " must be a number", -1);
        }
    }

    protected void checkAngleType(CSSName cssName, CSSPrimitiveValue value2) {
        if (value2.getPrimitiveType() != 11 && value2.getPrimitiveType() != 12 && value2.getPrimitiveType() != 13) {
            throw new CSSParseException("Value for " + cssName + "must be an angle (degrees, radians or grads)", -1);
        }
    }

    protected void checkIdentOrString(CSSName cssName, CSSPrimitiveValue value2) {
        short type2 = value2.getPrimitiveType();
        if (type2 != 19 && type2 != 21) {
            throw new CSSParseException("Value for " + cssName + " must be an identifier or string", -1);
        }
    }

    protected void checkIdentLengthNumberOrPercentType(CSSName cssName, CSSPrimitiveValue value2) {
        short type2 = value2.getPrimitiveType();
        if (type2 != 21 && !this.isLength(value2) && type2 != 2 && type2 != 1) {
            throw new CSSParseException("Value for " + cssName + " must be an identifier, length, or percentage", -1);
        }
    }

    protected boolean isLength(CSSPrimitiveValue value2) {
        return AbstractPropertyBuilder.isLengthHelper(value2);
    }

    public static boolean isLengthHelper(CSSPrimitiveValue value2) {
        short unit = value2.getPrimitiveType();
        return unit == 3 || unit == 4 || unit == 5 || unit == 8 || unit == 6 || unit == 7 || unit == 9 || unit == 10 || unit == 26 || unit == 1 && value2.getFloatValue((short)8) == 0.0f;
    }

    protected void checkValidity(CSSName cssName, BitSet validValues, IdentValue value2) {
        if (!validValues.get(value2.FS_ID)) {
            throw new CSSParseException("Ident " + value2 + " is an invalid or unsupported value for " + cssName, -1);
        }
    }

    protected IdentValue checkIdent(CSSName cssName, CSSPrimitiveValue value2) {
        IdentValue result2 = IdentValue.valueOf(value2.getStringValue());
        if (result2 == null) {
            throw new CSSParseException("Value " + value2.getStringValue() + " is not a recognized identifier", -1);
        }
        ((PropertyValue)value2).setIdentValue(result2);
        return result2;
    }

    protected PropertyDeclaration copyOf(PropertyDeclaration decl, CSSName newName) {
        return new PropertyDeclaration(newName, decl.getValue(), decl.isImportant(), decl.getOrigin());
    }

    protected void checkInheritAllowed(CSSPrimitiveValue value2, boolean inheritAllowed) {
        if (value2.getCssValueType() == 0 && !inheritAllowed) {
            throw new CSSParseException("Invalid use of inherit", -1);
        }
    }

    protected void checkForbidInherit(CSSPrimitiveValue value2) {
        this.checkInheritAllowed(value2, false);
    }

    protected List<PropertyDeclaration> checkInheritAll(CSSName[] all, List<PropertyValue> values, int origin, boolean important, boolean inheritAllowed) {
        if (values.size() == 1) {
            CSSPrimitiveValue value2 = values.get(0);
            this.checkInheritAllowed(value2, inheritAllowed);
            if (value2.getCssValueType() == 0) {
                ArrayList<PropertyDeclaration> result2 = new ArrayList<PropertyDeclaration>(all.length);
                for (int i = 0; i < all.length; ++i) {
                    result2.add(new PropertyDeclaration(all[i], value2, important, origin));
                }
                return result2;
            }
        }
        return null;
    }
}

