/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.pdmodel.graphics.blend;

import java.util.HashMap;
import java.util.Map;
import org.apache.pdfbox.cos.COSArray;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.pdmodel.graphics.blend.NonSeparableBlendMode;
import org.apache.pdfbox.pdmodel.graphics.blend.SeparableBlendMode;

public abstract class BlendMode {
    public static final SeparableBlendMode NORMAL;
    public static final SeparableBlendMode COMPATIBLE;
    public static final SeparableBlendMode MULTIPLY;
    public static final SeparableBlendMode SCREEN;
    public static final SeparableBlendMode OVERLAY;
    public static final SeparableBlendMode DARKEN;
    public static final SeparableBlendMode LIGHTEN;
    public static final SeparableBlendMode COLOR_DODGE;
    public static final SeparableBlendMode COLOR_BURN;
    public static final SeparableBlendMode HARD_LIGHT;
    public static final SeparableBlendMode SOFT_LIGHT;
    public static final SeparableBlendMode DIFFERENCE;
    public static final SeparableBlendMode EXCLUSION;
    public static final NonSeparableBlendMode HUE;
    public static final NonSeparableBlendMode SATURATION;
    public static final NonSeparableBlendMode COLOR;
    public static final NonSeparableBlendMode LUMINOSITY;
    private static final Map<COSName, BlendMode> BLEND_MODES;
    private static final Map<BlendMode, COSName> BLEND_MODE_NAMES;

    BlendMode() {
    }

    public static BlendMode getInstance(COSBase cosBlendMode) {
        BlendMode result2 = null;
        if (cosBlendMode instanceof COSName) {
            result2 = BLEND_MODES.get(cosBlendMode);
        } else if (cosBlendMode instanceof COSArray) {
            COSArray cosBlendModeArray = (COSArray)cosBlendMode;
            for (int i = 0; i < cosBlendModeArray.size() && (result2 = BLEND_MODES.get(cosBlendModeArray.getObject(i))) == null; ++i) {
            }
        }
        if (result2 != null) {
            return result2;
        }
        return NORMAL;
    }

    public static COSName getCOSName(BlendMode bm) {
        return BLEND_MODE_NAMES.get(bm);
    }

    private static int get255Value(float val) {
        return (int)Math.floor((double)val >= 1.0 ? 255.0 : (double)val * 255.0);
    }

    private static void getSaturationRGB(float[] srcValues, float[] dstValues, float[] result2) {
        int b;
        int g;
        int maxb;
        int rd = BlendMode.get255Value(dstValues[0]);
        int gd = BlendMode.get255Value(dstValues[1]);
        int bd = BlendMode.get255Value(dstValues[2]);
        int rs = BlendMode.get255Value(srcValues[0]);
        int gs = BlendMode.get255Value(srcValues[1]);
        int bs = BlendMode.get255Value(srcValues[2]);
        int minb = Math.min(rd, Math.min(gd, bd));
        if (minb == (maxb = Math.max(rd, Math.max(gd, bd)))) {
            result2[0] = (float)gd / 255.0f;
            result2[1] = (float)gd / 255.0f;
            result2[2] = (float)gd / 255.0f;
            return;
        }
        int mins = Math.min(rs, Math.min(gs, bs));
        int y = rd * 77 + gd * 151 + bd * 28 + 128 >> 8;
        int maxs = Math.max(rs, Math.max(gs, bs));
        int scale = (maxs - mins << 16) / (maxb - minb);
        int r = y + ((rd - y) * scale + 32768 >> 16);
        if (((r | (g = y + ((gd - y) * scale + 32768 >> 16)) | (b = y + ((bd - y) * scale + 32768 >> 16))) & 0x100) == 256) {
            int min = Math.min(r, Math.min(g, b));
            int max = Math.max(r, Math.max(g, b));
            int scalemin = min < 0 ? (y << 16) / (y - min) : 65536;
            int scalemax = max > 255 ? (255 - y << 16) / (max - y) : 65536;
            scale = Math.min(scalemin, scalemax);
            r = y + ((r - y) * scale + 32768 >> 16);
            g = y + ((g - y) * scale + 32768 >> 16);
            b = y + ((b - y) * scale + 32768 >> 16);
        }
        result2[0] = (float)r / 255.0f;
        result2[1] = (float)g / 255.0f;
        result2[2] = (float)b / 255.0f;
    }

    private static void getLuminosityRGB(float[] srcValues, float[] dstValues, float[] result2) {
        int b;
        int g;
        int bs;
        int gs;
        int rd = BlendMode.get255Value(dstValues[0]);
        int gd = BlendMode.get255Value(dstValues[1]);
        int bd = BlendMode.get255Value(dstValues[2]);
        int rs = BlendMode.get255Value(srcValues[0]);
        int delta = (rs - rd) * 77 + ((gs = BlendMode.get255Value(srcValues[1])) - gd) * 151 + ((bs = BlendMode.get255Value(srcValues[2])) - bd) * 28 + 128 >> 8;
        int r = rd + delta;
        if (((r | (g = gd + delta) | (b = bd + delta)) & 0x100) == 256) {
            int min;
            int max;
            int y = rs * 77 + gs * 151 + bs * 28 + 128 >> 8;
            int scale = delta > 0 ? ((max = Math.max(r, Math.max(g, b))) == y ? 0 : (255 - y << 16) / (max - y)) : (y == (min = Math.min(r, Math.min(g, b))) ? 0 : (y << 16) / (y - min));
            r = y + ((r - y) * scale + 32768 >> 16);
            g = y + ((g - y) * scale + 32768 >> 16);
            b = y + ((b - y) * scale + 32768 >> 16);
        }
        result2[0] = (float)r / 255.0f;
        result2[1] = (float)g / 255.0f;
        result2[2] = (float)b / 255.0f;
    }

    private static Map<COSName, BlendMode> createBlendModeMap() {
        HashMap<COSName, BlendMode> map2 = new HashMap<COSName, BlendMode>(13);
        map2.put(COSName.NORMAL, NORMAL);
        map2.put(COSName.COMPATIBLE, NORMAL);
        map2.put(COSName.MULTIPLY, MULTIPLY);
        map2.put(COSName.SCREEN, SCREEN);
        map2.put(COSName.OVERLAY, OVERLAY);
        map2.put(COSName.DARKEN, DARKEN);
        map2.put(COSName.LIGHTEN, LIGHTEN);
        map2.put(COSName.COLOR_DODGE, COLOR_DODGE);
        map2.put(COSName.COLOR_BURN, COLOR_BURN);
        map2.put(COSName.HARD_LIGHT, HARD_LIGHT);
        map2.put(COSName.SOFT_LIGHT, SOFT_LIGHT);
        map2.put(COSName.DIFFERENCE, DIFFERENCE);
        map2.put(COSName.EXCLUSION, EXCLUSION);
        map2.put(COSName.HUE, HUE);
        map2.put(COSName.SATURATION, SATURATION);
        map2.put(COSName.LUMINOSITY, LUMINOSITY);
        map2.put(COSName.COLOR, COLOR);
        return map2;
    }

    private static Map<BlendMode, COSName> createBlendModeNamesMap() {
        HashMap<BlendMode, COSName> map2 = new HashMap<BlendMode, COSName>(13);
        map2.put(NORMAL, COSName.NORMAL);
        map2.put(COMPATIBLE, COSName.NORMAL);
        map2.put(MULTIPLY, COSName.MULTIPLY);
        map2.put(SCREEN, COSName.SCREEN);
        map2.put(OVERLAY, COSName.OVERLAY);
        map2.put(DARKEN, COSName.DARKEN);
        map2.put(LIGHTEN, COSName.LIGHTEN);
        map2.put(COLOR_DODGE, COSName.COLOR_DODGE);
        map2.put(COLOR_BURN, COSName.COLOR_BURN);
        map2.put(HARD_LIGHT, COSName.HARD_LIGHT);
        map2.put(SOFT_LIGHT, COSName.SOFT_LIGHT);
        map2.put(DIFFERENCE, COSName.DIFFERENCE);
        map2.put(EXCLUSION, COSName.EXCLUSION);
        map2.put(HUE, COSName.HUE);
        map2.put(SATURATION, COSName.SATURATION);
        map2.put(LUMINOSITY, COSName.LUMINOSITY);
        map2.put(COLOR, COSName.COLOR);
        return map2;
    }

    static {
        COMPATIBLE = NORMAL = new SeparableBlendMode(){

            @Override
            public float blendChannel(float srcValue, float dstValue) {
                return srcValue;
            }
        };
        MULTIPLY = new SeparableBlendMode(){

            @Override
            public float blendChannel(float srcValue, float dstValue) {
                return srcValue * dstValue;
            }
        };
        SCREEN = new SeparableBlendMode(){

            @Override
            public float blendChannel(float srcValue, float dstValue) {
                return srcValue + dstValue - srcValue * dstValue;
            }
        };
        OVERLAY = new SeparableBlendMode(){

            @Override
            public float blendChannel(float srcValue, float dstValue) {
                return (double)dstValue <= 0.5 ? 2.0f * dstValue * srcValue : 2.0f * (srcValue + dstValue - srcValue * dstValue) - 1.0f;
            }
        };
        DARKEN = new SeparableBlendMode(){

            @Override
            public float blendChannel(float srcValue, float dstValue) {
                return Math.min(srcValue, dstValue);
            }
        };
        LIGHTEN = new SeparableBlendMode(){

            @Override
            public float blendChannel(float srcValue, float dstValue) {
                return Math.max(srcValue, dstValue);
            }
        };
        COLOR_DODGE = new SeparableBlendMode(){

            @Override
            public float blendChannel(float srcValue, float dstValue) {
                if (dstValue == 0.0f) {
                    return 0.0f;
                }
                if (dstValue >= 1.0f - srcValue) {
                    return 1.0f;
                }
                return dstValue / (1.0f - srcValue);
            }
        };
        COLOR_BURN = new SeparableBlendMode(){

            @Override
            public float blendChannel(float srcValue, float dstValue) {
                if (dstValue == 1.0f) {
                    return 1.0f;
                }
                if (1.0f - dstValue >= srcValue) {
                    return 0.0f;
                }
                return 1.0f - (1.0f - dstValue) / srcValue;
            }
        };
        HARD_LIGHT = new SeparableBlendMode(){

            @Override
            public float blendChannel(float srcValue, float dstValue) {
                return (double)srcValue <= 0.5 ? 2.0f * dstValue * srcValue : 2.0f * (srcValue + dstValue - srcValue * dstValue) - 1.0f;
            }
        };
        SOFT_LIGHT = new SeparableBlendMode(){

            @Override
            public float blendChannel(float srcValue, float dstValue) {
                if ((double)srcValue <= 0.5) {
                    return dstValue - (1.0f - 2.0f * srcValue) * dstValue * (1.0f - dstValue);
                }
                float d = (double)dstValue <= 0.25 ? ((16.0f * dstValue - 12.0f) * dstValue + 4.0f) * dstValue : (float)Math.sqrt(dstValue);
                return dstValue + (2.0f * srcValue - 1.0f) * (d - dstValue);
            }
        };
        DIFFERENCE = new SeparableBlendMode(){

            @Override
            public float blendChannel(float srcValue, float dstValue) {
                return Math.abs(dstValue - srcValue);
            }
        };
        EXCLUSION = new SeparableBlendMode(){

            @Override
            public float blendChannel(float srcValue, float dstValue) {
                return dstValue + srcValue - 2.0f * dstValue * srcValue;
            }
        };
        HUE = new NonSeparableBlendMode(){

            @Override
            public void blend(float[] srcValues, float[] dstValues, float[] result2) {
                float[] temp = new float[3];
                BlendMode.getSaturationRGB(dstValues, srcValues, temp);
                BlendMode.getLuminosityRGB(dstValues, temp, result2);
            }
        };
        SATURATION = new NonSeparableBlendMode(){

            @Override
            public void blend(float[] srcValues, float[] dstValues, float[] result2) {
                BlendMode.getSaturationRGB(srcValues, dstValues, result2);
            }
        };
        COLOR = new NonSeparableBlendMode(){

            @Override
            public void blend(float[] srcValues, float[] dstValues, float[] result2) {
                BlendMode.getLuminosityRGB(dstValues, srcValues, result2);
            }
        };
        LUMINOSITY = new NonSeparableBlendMode(){

            @Override
            public void blend(float[] srcValues, float[] dstValues, float[] result2) {
                BlendMode.getLuminosityRGB(srcValues, dstValues, result2);
            }
        };
        BLEND_MODES = BlendMode.createBlendModeMap();
        BLEND_MODE_NAMES = BlendMode.createBlendModeNamesMap();
    }
}

