/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xmpbox.type;

import java.io.IOException;
import java.util.Calendar;
import org.apache.xmpbox.DateConverter;
import org.apache.xmpbox.XMPMetadata;
import org.apache.xmpbox.type.AbstractSimpleProperty;

public class DateType
extends AbstractSimpleProperty {
    private Calendar dateValue;

    public DateType(XMPMetadata metadata, String namespaceURI, String prefix, String propertyName, Object value2) {
        super(metadata, namespaceURI, prefix, propertyName, value2);
    }

    private void setValueFromCalendar(Calendar value2) {
        this.dateValue = value2;
    }

    @Override
    public Calendar getValue() {
        return this.dateValue;
    }

    private boolean isGoodType(Object value2) {
        if (value2 instanceof Calendar) {
            return true;
        }
        if (value2 instanceof String) {
            try {
                DateConverter.toCalendar((String)value2);
                return true;
            }
            catch (IOException e) {
                return false;
            }
        }
        return false;
    }

    @Override
    public void setValue(Object value2) {
        if (!this.isGoodType(value2)) {
            if (value2 == null) {
                throw new IllegalArgumentException("Value null is not allowed for the Date type");
            }
            throw new IllegalArgumentException("Value given is not allowed for the Date type: " + value2.getClass() + ", value: " + value2);
        }
        if (value2 instanceof String) {
            this.setValueFromString((String)value2);
        } else {
            this.setValueFromCalendar((Calendar)value2);
        }
    }

    @Override
    public String getStringValue() {
        return DateConverter.toISO8601(this.dateValue);
    }

    private void setValueFromString(String value2) {
        try {
            this.setValueFromCalendar(DateConverter.toCalendar(value2));
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
    }
}

