/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.hppc;

import com.carrotsearch.hppc.AbstractIterator;
import com.carrotsearch.hppc.AbstractLongCollection;
import com.carrotsearch.hppc.AbstractShortCollection;
import com.carrotsearch.hppc.LongContainer;
import com.carrotsearch.hppc.ShortCollection;
import com.carrotsearch.hppc.ShortContainer;
import com.carrotsearch.hppc.ShortLongAssociativeContainer;
import com.carrotsearch.hppc.ShortLongHashMap;
import com.carrotsearch.hppc.ShortLongMap;
import com.carrotsearch.hppc.ShortLookupContainer;
import com.carrotsearch.hppc.comparators.ShortComparator;
import com.carrotsearch.hppc.comparators.ShortLongComparator;
import com.carrotsearch.hppc.cursors.LongCursor;
import com.carrotsearch.hppc.cursors.ShortCursor;
import com.carrotsearch.hppc.cursors.ShortLongCursor;
import com.carrotsearch.hppc.predicates.LongPredicate;
import com.carrotsearch.hppc.predicates.ShortLongPredicate;
import com.carrotsearch.hppc.predicates.ShortPredicate;
import com.carrotsearch.hppc.procedures.LongProcedure;
import com.carrotsearch.hppc.procedures.ShortLongProcedure;
import com.carrotsearch.hppc.procedures.ShortProcedure;
import com.carrotsearch.hppc.sorting.QuickSort;
import java.util.Iterator;
import java.util.function.IntBinaryOperator;

public class SortedIterationShortLongHashMap
implements ShortLongMap {
    public final ShortLongHashMap delegate;
    public final int[] iterationOrder;

    public SortedIterationShortLongHashMap(ShortLongHashMap delegate2, ShortComparator comparator) {
        this.delegate = delegate2;
        this.iterationOrder = this.sortIterationOrder(this.createEntryIndexes(), comparator);
    }

    public SortedIterationShortLongHashMap(ShortLongHashMap delegate2, ShortLongComparator comparator) {
        this.delegate = delegate2;
        this.iterationOrder = this.sortIterationOrder(this.createEntryIndexes(), comparator);
    }

    private int[] createEntryIndexes() {
        short[] keys = this.delegate.keys;
        int size = this.delegate.size();
        int[] entryIndexes = new int[size];
        int entry2 = 0;
        if (this.delegate.hasEmptyKey) {
            entryIndexes[entry2++] = this.delegate.mask + 1;
        }
        int keyIndex = 0;
        while (entry2 < size) {
            if (keys[keyIndex] != 0) {
                entryIndexes[entry2++] = keyIndex;
            }
            ++keyIndex;
        }
        return entryIndexes;
    }

    protected int[] sortIterationOrder(int[] entryIndexes, ShortComparator comparator) {
        QuickSort.sort(entryIndexes, (i, j) -> {
            short[] keys = this.delegate.keys;
            return comparator.compare(keys[entryIndexes[i]], keys[entryIndexes[j]]);
        });
        return entryIndexes;
    }

    protected int[] sortIterationOrder(final int[] entryIndexes, final ShortLongComparator comparator) {
        QuickSort.sort(entryIndexes, new IntBinaryOperator(){
            final short[] keys;
            final long[] values;
            {
                this.keys = SortedIterationShortLongHashMap.this.delegate.keys;
                this.values = SortedIterationShortLongHashMap.this.delegate.values;
            }

            @Override
            public int applyAsInt(int i, int j) {
                int index1 = entryIndexes[i];
                int index2 = entryIndexes[j];
                return comparator.compare(this.keys[index1], this.values[index1], this.keys[index2], this.values[index2]);
            }
        });
        return entryIndexes;
    }

    @Override
    public Iterator<ShortLongCursor> iterator() {
        assert (this.checkUnmodified());
        return new EntryIterator();
    }

    @Override
    public boolean containsKey(short key2) {
        return this.delegate.containsKey(key2);
    }

    @Override
    public int size() {
        assert (this.checkUnmodified());
        return this.delegate.size();
    }

    @Override
    public boolean isEmpty() {
        return this.delegate.isEmpty();
    }

    @Override
    public int removeAll(ShortContainer container) {
        throw SortedIterationShortLongHashMap.readOnlyException();
    }

    @Override
    public int removeAll(ShortPredicate predicate) {
        throw SortedIterationShortLongHashMap.readOnlyException();
    }

    @Override
    public int removeAll(ShortLongPredicate predicate) {
        throw SortedIterationShortLongHashMap.readOnlyException();
    }

    @Override
    public <T extends ShortLongProcedure> T forEach(T procedure) {
        assert (this.checkUnmodified());
        int[] iterationOrder = this.iterationOrder;
        short[] keys = this.delegate.keys;
        long[] values = this.delegate.values;
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            int slot = iterationOrder[i];
            procedure.apply(keys[slot], values[slot]);
        }
        return procedure;
    }

    @Override
    public <T extends ShortLongPredicate> T forEach(T predicate) {
        int slot;
        assert (this.checkUnmodified());
        int[] iterationOrder = this.iterationOrder;
        short[] keys = this.delegate.keys;
        long[] values = this.delegate.values;
        int size = this.size();
        for (int i = 0; i < size && predicate.apply(keys[slot = iterationOrder[i]], values[slot]); ++i) {
        }
        return predicate;
    }

    @Override
    public ShortCollection keys() {
        assert (this.checkUnmodified());
        return new KeysContainer();
    }

    @Override
    public LongContainer values() {
        assert (this.checkUnmodified());
        return new ValuesContainer();
    }

    @Override
    public long get(short key2) {
        return this.delegate.get(key2);
    }

    @Override
    public long getOrDefault(short key2, long defaultValue) {
        return this.delegate.getOrDefault(key2, defaultValue);
    }

    @Override
    public long put(short key2, long value) {
        throw SortedIterationShortLongHashMap.readOnlyException();
    }

    @Override
    public int putAll(ShortLongAssociativeContainer container) {
        throw SortedIterationShortLongHashMap.readOnlyException();
    }

    @Override
    public int putAll(Iterable<? extends ShortLongCursor> iterable) {
        throw SortedIterationShortLongHashMap.readOnlyException();
    }

    @Override
    public long putOrAdd(short key2, long putValue, long incrementValue) {
        throw SortedIterationShortLongHashMap.readOnlyException();
    }

    @Override
    public long addTo(short key2, long additionValue) {
        throw SortedIterationShortLongHashMap.readOnlyException();
    }

    @Override
    public long remove(short key2) {
        throw SortedIterationShortLongHashMap.readOnlyException();
    }

    @Override
    public int indexOf(short key2) {
        return this.delegate.indexOf(key2);
    }

    @Override
    public boolean indexExists(int index) {
        return this.delegate.indexExists(index);
    }

    @Override
    public long indexGet(int index) {
        return this.delegate.indexGet(index);
    }

    @Override
    public long indexReplace(int index, long newValue) {
        throw SortedIterationShortLongHashMap.readOnlyException();
    }

    @Override
    public void indexInsert(int index, short key2, long value) {
        throw SortedIterationShortLongHashMap.readOnlyException();
    }

    @Override
    public long indexRemove(int index) {
        throw SortedIterationShortLongHashMap.readOnlyException();
    }

    @Override
    public void clear() {
        throw SortedIterationShortLongHashMap.readOnlyException();
    }

    @Override
    public void release() {
        throw SortedIterationShortLongHashMap.readOnlyException();
    }

    @Override
    public String visualizeKeyDistribution(int characters) {
        return this.delegate.visualizeKeyDistribution(characters);
    }

    private static RuntimeException readOnlyException() {
        throw new UnsupportedOperationException("Read-only view cannot be modified");
    }

    private boolean checkUnmodified() {
        assert (this.delegate.size() == this.iterationOrder.length) : "The delegate map changed; this is not supported by this read-only view";
        return true;
    }

    private final class EntryIterator
    extends AbstractIterator<ShortLongCursor> {
        private final ShortLongCursor cursor = new ShortLongCursor();
        private int index;

        private EntryIterator() {
        }

        @Override
        protected ShortLongCursor fetch() {
            if (this.index < SortedIterationShortLongHashMap.this.iterationOrder.length) {
                int slot;
                this.cursor.index = slot = SortedIterationShortLongHashMap.this.iterationOrder[this.index++];
                this.cursor.key = SortedIterationShortLongHashMap.this.delegate.keys[slot];
                this.cursor.value = SortedIterationShortLongHashMap.this.delegate.values[slot];
                return this.cursor;
            }
            return (ShortLongCursor)this.done();
        }
    }

    private final class KeysContainer
    extends AbstractShortCollection
    implements ShortLookupContainer {
        private final SortedIterationShortLongHashMap owner;

        private KeysContainer() {
            this.owner = SortedIterationShortLongHashMap.this;
        }

        @Override
        public boolean contains(short e) {
            return this.owner.containsKey(e);
        }

        @Override
        public <T extends ShortProcedure> T forEach(T procedure) {
            this.owner.forEach((k, v) -> procedure.apply(k));
            return procedure;
        }

        @Override
        public <T extends ShortPredicate> T forEach(T predicate) {
            this.owner.forEach((key2, value) -> predicate.apply(key2));
            return predicate;
        }

        @Override
        public boolean isEmpty() {
            return this.owner.isEmpty();
        }

        @Override
        public Iterator<ShortCursor> iterator() {
            return new KeysIterator();
        }

        @Override
        public int size() {
            return this.owner.size();
        }

        @Override
        public void clear() {
            throw SortedIterationShortLongHashMap.readOnlyException();
        }

        @Override
        public void release() {
            throw SortedIterationShortLongHashMap.readOnlyException();
        }

        @Override
        public int removeAll(ShortPredicate predicate) {
            throw SortedIterationShortLongHashMap.readOnlyException();
        }

        @Override
        public int removeAll(short e) {
            throw SortedIterationShortLongHashMap.readOnlyException();
        }
    }

    private final class ValuesContainer
    extends AbstractLongCollection {
        private final SortedIterationShortLongHashMap owner;

        private ValuesContainer() {
            this.owner = SortedIterationShortLongHashMap.this;
        }

        @Override
        public int size() {
            return this.owner.size();
        }

        @Override
        public boolean isEmpty() {
            return this.owner.isEmpty();
        }

        @Override
        public boolean contains(long value) {
            for (ShortLongCursor c : this.owner) {
                if (value != c.value) continue;
                return true;
            }
            return false;
        }

        @Override
        public <T extends LongProcedure> T forEach(T procedure) {
            this.owner.forEach((k, v) -> procedure.apply(v));
            return procedure;
        }

        @Override
        public <T extends LongPredicate> T forEach(T predicate) {
            this.owner.forEach((k, v) -> predicate.apply(v));
            return predicate;
        }

        @Override
        public Iterator<LongCursor> iterator() {
            return new ValuesIterator();
        }

        @Override
        public int removeAll(long e) {
            throw SortedIterationShortLongHashMap.readOnlyException();
        }

        @Override
        public int removeAll(LongPredicate predicate) {
            throw SortedIterationShortLongHashMap.readOnlyException();
        }

        @Override
        public void clear() {
            throw SortedIterationShortLongHashMap.readOnlyException();
        }

        @Override
        public void release() {
            throw SortedIterationShortLongHashMap.readOnlyException();
        }
    }

    private final class ValuesIterator
    extends AbstractIterator<LongCursor> {
        private final LongCursor cursor = new LongCursor();
        private int index;

        private ValuesIterator() {
        }

        @Override
        protected LongCursor fetch() {
            if (this.index < SortedIterationShortLongHashMap.this.iterationOrder.length) {
                int slot;
                this.cursor.index = slot = SortedIterationShortLongHashMap.this.iterationOrder[this.index++];
                this.cursor.value = SortedIterationShortLongHashMap.this.delegate.values[slot];
                return this.cursor;
            }
            return (LongCursor)this.done();
        }
    }

    private final class KeysIterator
    extends AbstractIterator<ShortCursor> {
        private final ShortCursor cursor = new ShortCursor();
        private int index;

        private KeysIterator() {
        }

        @Override
        protected ShortCursor fetch() {
            if (this.index < SortedIterationShortLongHashMap.this.iterationOrder.length) {
                int slot;
                this.cursor.index = slot = SortedIterationShortLongHashMap.this.iterationOrder[this.index++];
                this.cursor.value = SortedIterationShortLongHashMap.this.delegate.keys[slot];
                return this.cursor;
            }
            return (ShortCursor)this.done();
        }
    }
}

