/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.markdown.lang.references.paths;

import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiReference;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReferenceOwner;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.intellij.plugins.markdown.lang.psi.MarkdownElementVisitor;
import org.intellij.plugins.markdown.lang.psi.impl.MarkdownLinkDestination;
import org.intellij.plugins.markdown.lang.references.paths.github.GithubWikiLocalFileReference;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u0010\u0010\u000e\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0010\u0010\u0011\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002\u00a8\u0006\u0012"}, d2={"Lorg/intellij/plugins/markdown/lang/references/paths/MarkdownUnresolvedFileReferenceInspection;", "Lcom/intellij/codeInspection/LocalInspectionTool;", "<init>", "()V", "buildVisitor", "Lcom/intellij/psi/PsiElementVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "", "checkReference", "", "element", "Lcom/intellij/psi/PsiElement;", "isValidRange", "reference", "Lcom/intellij/psi/PsiReference;", "shouldSkip", "intellij.markdown"})
@ApiStatus.Internal
public final class MarkdownUnresolvedFileReferenceInspection
extends LocalInspectionTool {
    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        return new MarkdownElementVisitor(this, holder){
            final /* synthetic */ MarkdownUnresolvedFileReferenceInspection this$0;
            final /* synthetic */ ProblemsHolder $holder;
            {
                this.this$0 = $receiver;
                this.$holder = $holder;
            }

            public void visitLinkDestination(MarkdownLinkDestination linkDestination) {
                Intrinsics.checkNotNullParameter((Object)linkDestination, (String)"linkDestination");
                MarkdownUnresolvedFileReferenceInspection.access$checkReference(this.this$0, (PsiElement)linkDestination, this.$holder);
            }
        };
    }

    private final void checkReference(PsiElement element2, ProblemsHolder holder) {
        PsiReference[] psiReferenceArray = element2.getReferences();
        Intrinsics.checkNotNullExpressionValue((Object)psiReferenceArray, (String)"getReferences(...)");
        Sequence references = ArraysKt.asSequence((Object[])psiReferenceArray);
        Sequence fileReferences = SequencesKt.filter((Sequence)references, MarkdownUnresolvedFileReferenceInspection::checkReference$lambda$0);
        Sequence unresolvedReferences = SequencesKt.filter((Sequence)fileReferences, arg_0 -> MarkdownUnresolvedFileReferenceInspection.checkReference$lambda$1(this, arg_0));
        for (PsiReference reference : unresolvedReferences) {
            holder.registerProblem(reference, ProblemsHolder.unresolvedReferenceMessage((PsiReference)reference), ProblemHighlightType.LIKE_UNKNOWN_SYMBOL);
        }
    }

    private final boolean isValidRange(PsiReference reference) {
        TextRange elementRange = reference.getElement().getTextRange();
        return reference.getRangeInElement().getEndOffset() <= elementRange.getEndOffset() - elementRange.getStartOffset();
    }

    private final boolean shouldSkip(PsiReference reference) {
        return reference instanceof GithubWikiLocalFileReference;
    }

    private static final boolean checkReference$lambda$0(PsiReference it) {
        return it instanceof FileReferenceOwner;
    }

    private static final boolean checkReference$lambda$1(MarkdownUnresolvedFileReferenceInspection this$0, PsiReference it) {
        Intrinsics.checkNotNull((Object)it);
        return !this$0.shouldSkip(it) && this$0.isValidRange(it) && it.resolve() == null;
    }

    public static final /* synthetic */ void access$checkReference(MarkdownUnresolvedFileReferenceInspection $this, PsiElement element2, ProblemsHolder holder) {
        $this.checkReference(element2, holder);
    }
}

