/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rd.ide.document;

import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.ex.PrioritizedDocumentListener;
import com.intellij.openapi.editor.impl.DocumentImpl;
import com.intellij.openapi.editor.impl.event.DocumentEventImpl;
import com.intellij.openapi.rd.DisposableEx;
import com.intellij.openapi.util.TextRange;
import com.intellij.util.ApplicationKt;
import com.intellij.util.LocalTimeCounter;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.jetbrains.rd.ide.document.DocumentExKt;
import com.jetbrains.rd.ide.document.DocumentLog;
import com.jetbrains.rd.ide.document.DocumentLogRangeShifter;
import com.jetbrains.rd.ide.document.DocumentSynchronizer;
import com.jetbrains.rd.ide.document.DocumentSynchronizerListeners;
import com.jetbrains.rd.ide.document.DocumentVersionHolder;
import com.jetbrains.rd.ide.document.DocumentVersionsKt;
import com.jetbrains.rd.ide.document.PatchEngineDocumentSynchronizerKt;
import com.jetbrains.rd.ide.model.AbstractDocumentVersion;
import com.jetbrains.rd.ide.model.RdDocumentChange;
import com.jetbrains.rd.ide.model.RdDocumentChangeBase;
import com.jetbrains.rd.ide.model.RdDocumentId;
import com.jetbrains.rd.ide.model.RdDocumentModel;
import com.jetbrains.rd.ide.model.RdDocumentVersion;
import com.jetbrains.rd.ide.model.RdPatchDocumentVersion;
import com.jetbrains.rd.ide.model.RdResetDocumentChange;
import com.jetbrains.rd.ide.model.RdTextModificationKind;
import com.jetbrains.rd.ide.requests.ChangeScope;
import com.jetbrains.rd.ide.requests.PatchEngine;
import com.jetbrains.rd.ide.requests.RdPatchEngine;
import com.jetbrains.rd.platform.util.IDocumentRangeShifter;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.string.IPrintableKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0094\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 J2\u00020\u00012\u00020\u0002:\u0001JBG\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\u0006\u0010\u000f\u001a\u00020\u0010\u0012\u0006\u0010\u0011\u001a\u00020\u0010\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u0010\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020(H\u0016J\u001f\u0010)\u001a\u00020&2\u0006\u0010*\u001a\u00020+2\f\u0010,\u001a\b\u0012\u0004\u0012\u00020.0-H\u0082\bJ\u0010\u0010/\u001a\u00020+2\u0006\u0010'\u001a\u00020(H\u0002J\u0006\u00100\u001a\u00020&J\u0018\u00101\u001a\u00020&2\u0006\u0010*\u001a\u0002022\b\b\u0002\u00103\u001a\u00020\u0010J\u0010\u00104\u001a\u00020&2\u0006\u0010*\u001a\u000202H\u0002J\u0010\u00105\u001a\u00020&2\u0006\u0010*\u001a\u000202H\u0002J\u0018\u00106\u001a\u00020&2\u0006\u00107\u001a\u0002082\u0006\u0010*\u001a\u000209H\u0002J\u0010\u0010:\u001a\u00020&2\u0006\u0010*\u001a\u00020+H\u0002J\u0018\u0010;\u001a\u00020&2\u0006\u0010<\u001a\u0002082\u0006\u0010*\u001a\u00020+H\u0002J\u000e\u0010=\u001a\u00020&2\u0006\u0010>\u001a\u000208J\u0010\u0010?\u001a\u00020&2\u0006\u0010'\u001a\u00020(H\u0016J\b\u0010@\u001a\u00020AH\u0016J\u0010\u0010D\u001a\u00020&2\u0006\u0010E\u001a\u00020FH\u0016J\b\u0010G\u001a\u00020HH\u0016J\u0010\u0010I\u001a\u00020&2\u0006\u0010*\u001a\u000202H\u0002R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0014\u0010\u0007\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0014\u0010\t\u001a\u00020\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001d\u001a\u00020\u001eX\u0082\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\b\u001f\u0010 R\u000e\u0010!\u001a\u00020\"X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010#\u001a\u00020\u00108VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b#\u0010$R\u0014\u0010>\u001a\u0002088VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\bB\u0010C\u00a8\u0006K"}, d2={"Lcom/jetbrains/rd/ide/document/PatchEngineDocumentSynchronizer;", "Lcom/intellij/openapi/editor/ex/PrioritizedDocumentListener;", "Lcom/jetbrains/rd/ide/document/DocumentSynchronizer;", "documentLifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "document", "Lcom/intellij/openapi/editor/Document;", "modelDocument", "Lcom/jetbrains/rd/ide/model/RdDocumentModel;", "documentId", "Lcom/jetbrains/rd/ide/model/RdDocumentId;", "versionHolder", "Lcom/jetbrains/rd/ide/document/DocumentVersionHolder;", "engine", "Lcom/jetbrains/rd/ide/requests/PatchEngine;", "sendDocumentText", "", "forceWrite", "<init>", "(Lcom/jetbrains/rd/util/lifetime/Lifetime;Lcom/intellij/openapi/editor/Document;Lcom/jetbrains/rd/ide/model/RdDocumentModel;Lcom/jetbrains/rd/ide/model/RdDocumentId;Lcom/jetbrains/rd/ide/document/DocumentVersionHolder;Lcom/jetbrains/rd/ide/requests/PatchEngine;ZZ)V", "getDocumentLifetime", "()Lcom/jetbrains/rd/util/lifetime/Lifetime;", "getDocument", "()Lcom/intellij/openapi/editor/Document;", "getModelDocument", "()Lcom/jetbrains/rd/ide/model/RdDocumentModel;", "getDocumentId", "()Lcom/jetbrains/rd/ide/model/RdDocumentId;", "backendUpdateInProgressMarker", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "getLogger$annotations", "()V", "documentLog", "Lcom/jetbrains/rd/ide/document/DocumentLog;", "isReceivingChange", "()Z", "documentChanged", "", "event", "Lcom/intellij/openapi/editor/event/DocumentEvent;", "onDocumentChange", "change", "Lcom/jetbrains/rd/ide/model/RdDocumentChange;", "diagnosticData", "Lkotlin/Function0;", "", "createRdDocumentChange", "sendInitialTextChange", "receiveDocumentChange", "Lcom/jetbrains/rd/ide/model/RdDocumentChangeBase;", "forceRecordPatch", "applyChangeCheckForce", "applyChange", "applyResetDocumentChange", "nextVersion", "Lcom/jetbrains/rd/ide/model/RdDocumentVersion;", "Lcom/jetbrains/rd/ide/model/RdResetDocumentChange;", "applyDocumentChange", "ensureDocumentVersion", "expectedVersion", "updateLastKnownVersion", "version", "beforeDocumentChange", "getPriority", "", "getVersion", "()Lcom/jetbrains/rd/ide/model/RdDocumentVersion;", "resetVersion", "v", "Lcom/jetbrains/rd/ide/model/AbstractDocumentVersion;", "createRangeShifter", "Lcom/jetbrains/rd/platform/util/IDocumentRangeShifter;", "sendDocumentChange", "Companion", "intellij.rd.platform"})
@SourceDebugExtension(value={"SMAP\nPatchEngineDocumentSynchronizer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PatchEngineDocumentSynchronizer.kt\ncom/jetbrains/rd/ide/document/PatchEngineDocumentSynchronizer\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 3 PatchEngine.kt\ncom/jetbrains/rd/ide/requests/PatchEngineKt\n*L\n1#1,308:1\n69#1,7:309\n76#1,7:320\n69#1,7:343\n76#1,7:354\n68#2,4:316\n68#2,4:327\n68#2,4:331\n68#2,4:335\n68#2,4:339\n68#2,4:350\n34#3,2:361\n*S KotlinDebug\n*F\n+ 1 PatchEngineDocumentSynchronizer.kt\ncom/jetbrains/rd/ide/document/PatchEngineDocumentSynchronizer\n*L\n63#1:309,7\n63#1:320,7\n243#1:343,7\n243#1:354,7\n63#1:316,4\n75#1:327,4\n79#1:331,4\n116#1:335,4\n128#1:339,4\n243#1:350,4\n279#1:361,2\n*E\n"})
public final class PatchEngineDocumentSynchronizer
implements PrioritizedDocumentListener,
DocumentSynchronizer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Lifetime documentLifetime;
    @NotNull
    private final Document document;
    @NotNull
    private final RdDocumentModel modelDocument;
    @NotNull
    private final RdDocumentId documentId;
    @NotNull
    private final DocumentVersionHolder versionHolder;
    @NotNull
    private final PatchEngine engine;
    private final boolean sendDocumentText;
    private final boolean forceWrite;
    private boolean backendUpdateInProgressMarker;
    @NotNull
    private final Logger logger;
    @NotNull
    private final DocumentLog documentLog;
    private static int debugId;

    public PatchEngineDocumentSynchronizer(@NotNull Lifetime documentLifetime, @NotNull Document document, @NotNull RdDocumentModel modelDocument, @NotNull RdDocumentId documentId, @NotNull DocumentVersionHolder versionHolder, @NotNull PatchEngine engine, boolean sendDocumentText, boolean forceWrite) {
        Intrinsics.checkNotNullParameter((Object)documentLifetime, (String)"documentLifetime");
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        Intrinsics.checkNotNullParameter((Object)((Object)modelDocument), (String)"modelDocument");
        Intrinsics.checkNotNullParameter((Object)documentId, (String)"documentId");
        Intrinsics.checkNotNullParameter((Object)versionHolder, (String)"versionHolder");
        Intrinsics.checkNotNullParameter((Object)engine, (String)"engine");
        this.documentLifetime = documentLifetime;
        this.document = document;
        this.modelDocument = modelDocument;
        this.documentId = documentId;
        this.versionHolder = versionHolder;
        this.engine = engine;
        this.sendDocumentText = sendDocumentText;
        this.forceWrite = forceWrite;
        this.documentLog = new DocumentLog();
        String fileName = DocumentExKt.createLogCategory(this.getDocumentId());
        int n = debugId;
        debugId = n + 1;
        this.logger = Logger.getInstance((String)("#com.jetbrains.rd.ide.document.Document#" + n + "(" + fileName + ")"));
        this.getDocument().addDocumentListener((DocumentListener)this, DisposableEx.createNestedDisposable$default(this.getDocumentLifetime(), null, 1, null));
    }

    @Override
    @NotNull
    public Lifetime getDocumentLifetime() {
        return this.documentLifetime;
    }

    @Override
    @NotNull
    public Document getDocument() {
        return this.document;
    }

    @Override
    @NotNull
    public RdDocumentModel getModelDocument() {
        return this.modelDocument;
    }

    @Override
    @NotNull
    public RdDocumentId getDocumentId() {
        return this.documentId;
    }

    private static /* synthetic */ void getLogger$annotations() {
    }

    @Override
    public boolean isReceivingChange() {
        ThreadingAssertions.assertEventDispatchThread();
        return this.backendUpdateInProgressMarker;
    }

    public void documentChanged(@NotNull DocumentEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        RdDocumentChange change = this.createRdDocumentChange(event);
        PatchEngineDocumentSynchronizer this_$iv = this;
        boolean $i$f$onDocumentChange = false;
        this_$iv.versionHolder.incrementVersion(this_$iv.getDocument().getModificationStamp());
        DocumentSynchronizerListeners.Companion.getInstance(this_$iv.engine).change(change);
        this_$iv.documentLog.addOrUpdate(this_$iv.versionHolder.getVersion(), change);
        if (this_$iv.backendUpdateInProgressMarker) {
            Logger $this$trace$iv$iv = this_$iv.logger;
            boolean $i$f$trace = false;
            if ($this$trace$iv$iv.isTraceEnabled()) {
                Logger logger = $this$trace$iv$iv;
                boolean bl = false;
                boolean bl2 = false;
                logger.trace("Skip processing document change from client side. Change event = " + PatchEngineDocumentSynchronizerKt.access$printSafeData(event) + ", Version: " + this_$iv.versionHolder.getVersion());
            }
        } else {
            Logger $this$trace$iv$iv = this_$iv.logger;
            boolean $i$f$trace = false;
            if ($this$trace$iv$iv.isTraceEnabled()) {
                Logger logger = $this$trace$iv$iv;
                boolean bl = false;
                boolean bl3 = false;
                logger.trace("Document was changed from client side. Change event = " + PatchEngineDocumentSynchronizerKt.access$printSafeData(event) + ", Version: " + this_$iv.versionHolder.getVersion() + ", Document length: " + this_$iv.getDocument().getTextLength());
            }
            this_$iv.sendDocumentChange(change);
        }
    }

    private final void onDocumentChange(RdDocumentChange change, Function0<String> diagnosticData) {
        boolean $i$f$onDocumentChange = false;
        this.versionHolder.incrementVersion(this.getDocument().getModificationStamp());
        DocumentSynchronizerListeners.Companion.getInstance(this.engine).change(change);
        this.documentLog.addOrUpdate(this.versionHolder.getVersion(), change);
        if (this.backendUpdateInProgressMarker) {
            Logger $this$trace$iv = this.logger;
            boolean $i$f$trace = false;
            if ($this$trace$iv.isTraceEnabled()) {
                Logger logger = $this$trace$iv;
                boolean bl = false;
                logger.trace("Skip processing document change from client side. Change event = " + diagnosticData.invoke() + ", Version: " + this.versionHolder.getVersion());
            }
            return;
        }
        Logger $this$trace$iv = this.logger;
        boolean $i$f$trace = false;
        if ($this$trace$iv.isTraceEnabled()) {
            Logger logger = $this$trace$iv;
            boolean bl = false;
            logger.trace("Document was changed from client side. Change event = " + diagnosticData.invoke() + ", Version: " + this.versionHolder.getVersion() + ", Document length: " + this.getDocument().getTextLength());
        }
        this.sendDocumentChange(change);
    }

    private final RdDocumentChange createRdDocumentChange(DocumentEvent event) {
        CharSequence charSequence = event.getOldFragment();
        Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"getOldFragment(...)");
        RdTextModificationKind modificationSide = charSequence.length() == 0 && event instanceof DocumentEventImpl ? (((DocumentEventImpl)event).getInitialStartOffset() < ((DocumentEventImpl)event).getOffset() ? RdTextModificationKind.RightSide : (((DocumentEventImpl)event).getInitialStartOffset() + ((DocumentEventImpl)event).getInitialOldLength() > ((DocumentEventImpl)event).getOffset() ? RdTextModificationKind.LeftSide : RdTextModificationKind.NotSpecified)) : RdTextModificationKind.NotSpecified;
        return new RdDocumentChange(event.getOffset(), event.getMoveOffset(), ((Object)event.getNewFragment()).toString(), ((Object)event.getOldFragment()).toString(), modificationSide, event.getDocument().getTextLength() + event.getOldLength() - event.getNewLength(), this.sendDocumentText ? event.getDocument().getText() : null, event.isWholeTextReplaced(), this.getDocumentId());
    }

    public final void sendInitialTextChange() {
        boolean isIncremented = this.versionHolder.incrementVersion(this.getDocument().getModificationStamp());
        String string = this.getDocument().getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        RdResetDocumentChange change = new RdResetDocumentChange(string, this.versionHolder.getVersion(), this.getDocumentId());
        if (isIncremented) {
            this.documentLog.addOrUpdate(this.versionHolder.getVersion(), change);
        }
        Logger $this$trace$iv = this.logger;
        boolean $i$f$trace = false;
        if ($this$trace$iv.isTraceEnabled()) {
            Logger logger = $this$trace$iv;
            boolean bl = false;
            logger.trace("[file] sendInitialTextChange: send RdResetDocumentChange by engine. documentId=" + DocumentExKt.toDebugString(this.getDocumentId()) + ", newVersion=" + this.versionHolder.getVersion());
        }
        this.sendDocumentChange(change);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void receiveDocumentChange(@NotNull RdDocumentChangeBase change, boolean forceRecordPatch) {
        Intrinsics.checkNotNullParameter((Object)change, (String)"change");
        try {
            boolean bl = this.backendUpdateInProgressMarker = !forceRecordPatch;
            if (change instanceof RdDocumentChange && this.getDocument().getTextLength() != ((RdDocumentChange)change).getOldDocumentLength()) {
                throw new IllegalStateException(("expected document length: " + ((RdDocumentChange)change).getOldDocumentLength() + ", but actual length: " + this.getDocument().getTextLength()).toString());
            }
            Logger $this$trace$iv = this.logger;
            boolean $i$f$trace = false;
            if ($this$trace$iv.isTraceEnabled()) {
                Logger logger = $this$trace$iv;
                boolean bl2 = false;
                logger.trace("Applying client document change: " + IPrintableKt.printToString((Object)change) + ", document length: " + this.getDocument().getTextLength());
            }
            ApplicationKt.getApplication().runWriteAction(() -> PatchEngineDocumentSynchronizer.receiveDocumentChange$lambda$6(this, change, forceRecordPatch));
        }
        finally {
            this.backendUpdateInProgressMarker = false;
        }
    }

    public static /* synthetic */ void receiveDocumentChange$default(PatchEngineDocumentSynchronizer patchEngineDocumentSynchronizer, RdDocumentChangeBase rdDocumentChangeBase, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        patchEngineDocumentSynchronizer.receiveDocumentChange(rdDocumentChangeBase, bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void applyChangeCheckForce(RdDocumentChangeBase change) {
        if (this.forceWrite && !this.getDocument().isWritable()) {
            this.getDocument().setReadOnly(false);
            try {
                this.applyChange(change);
            }
            finally {
                this.getDocument().setReadOnly(true);
            }
        } else {
            this.applyChange(change);
        }
    }

    private final void applyChange(RdDocumentChangeBase change) {
        RdDocumentVersion newVersion = DocumentVersionsKt.nextVersion(this.versionHolder.getVersion());
        RdDocumentChangeBase rdDocumentChangeBase = change;
        if (rdDocumentChangeBase instanceof RdResetDocumentChange) {
            this.applyResetDocumentChange(newVersion, (RdResetDocumentChange)change);
        } else if (rdDocumentChangeBase instanceof RdDocumentChange) {
            this.applyDocumentChange((RdDocumentChange)change);
            this.ensureDocumentVersion(newVersion, (RdDocumentChange)change);
        } else {
            this.logger.error((Throwable)new IllegalStateException("Unknown document change type: " + change));
        }
    }

    private final void applyResetDocumentChange(RdDocumentVersion nextVersion, RdResetDocumentChange change) {
        if (this.isReceivingChange() && Intrinsics.areEqual((Object)nextVersion, (Object)change.getVersion()) && this.getDocument().getTextLength() == change.getText().length() && Intrinsics.areEqual((Object)this.getDocument().getText(), (Object)change.getText())) {
            this.versionHolder.incrementVersion(this.getDocument().getModificationStamp());
            this.documentLog.addOrUpdate(this.versionHolder.getVersion(), change);
        } else {
            this.getDocument().setText((CharSequence)change.getText());
            this.resetVersion(change.getVersion());
        }
    }

    private final void applyDocumentChange(RdDocumentChange change) {
        int offset = change.getOffset();
        String oldText = change.getOldText();
        String newText = change.getNewText();
        if (Intrinsics.areEqual((Object)change.isWholeTextReplaced(), (Object)true)) {
            String initialNewText = this.getDocument().getText(new TextRange(0, offset)) + newText + this.getDocument().getText(new TextRange(offset + oldText.length(), this.getDocument().getTextLength()));
            this.getDocument().setText((CharSequence)initialNewText);
            return;
        }
        if (((CharSequence)oldText).length() == 0 && change.getModificationKind() == RdTextModificationKind.LeftSide) {
            int initialEnd = Math.min(this.getDocument().getTextLength(), offset + 1);
            String initialNewText = newText + this.getDocument().getText(new TextRange(offset, initialEnd));
            this.getDocument().replaceString(offset, initialEnd, (CharSequence)initialNewText);
            return;
        }
        if (((CharSequence)oldText).length() == 0 && change.getModificationKind() == RdTextModificationKind.RightSide) {
            int initialStart = Math.max(0, offset - 1);
            String initialNewText = this.getDocument().getText(new TextRange(initialStart, offset)) + newText;
            this.getDocument().replaceString(initialStart, offset, (CharSequence)initialNewText);
            return;
        }
        if (this.getDocument() instanceof DocumentImpl) {
            Document document = this.getDocument();
            Intrinsics.checkNotNull((Object)document, (String)"null cannot be cast to non-null type com.intellij.openapi.editor.impl.DocumentImpl");
            ((DocumentImpl)document).replaceString(offset, offset + oldText.length(), change.getMoveOffset(), (CharSequence)newText, LocalTimeCounter.currentTime(), false);
            return;
        }
        this.getDocument().replaceString(offset, offset + oldText.length(), (CharSequence)newText);
    }

    private final void ensureDocumentVersion(RdDocumentVersion expectedVersion, RdDocumentChange change) {
        if (Intrinsics.areEqual((Object)this.versionHolder.getVersion(), (Object)expectedVersion)) {
            return;
        }
        if (Intrinsics.areEqual((Object)DocumentVersionsKt.nextVersion(this.versionHolder.getVersion()), (Object)expectedVersion)) {
            PatchEngineDocumentSynchronizer this_$iv = this;
            boolean $i$f$onDocumentChange = false;
            this_$iv.versionHolder.incrementVersion(this_$iv.getDocument().getModificationStamp());
            DocumentSynchronizerListeners.Companion.getInstance(this_$iv.engine).change(change);
            this_$iv.documentLog.addOrUpdate(this_$iv.versionHolder.getVersion(), change);
            if (this_$iv.backendUpdateInProgressMarker) {
                Logger $this$trace$iv$iv = this_$iv.logger;
                boolean $i$f$trace = false;
                if ($this$trace$iv$iv.isTraceEnabled()) {
                    Logger logger = $this$trace$iv$iv;
                    boolean bl = false;
                    boolean bl2 = false;
                    logger.trace("Skip processing document change from client side. Change event = " + PatchEngineDocumentSynchronizerKt.access$printSafeData(change) + ", Version: " + this_$iv.versionHolder.getVersion());
                }
            } else {
                Logger $this$trace$iv$iv = this_$iv.logger;
                boolean $i$f$trace = false;
                if ($this$trace$iv$iv.isTraceEnabled()) {
                    Logger logger = $this$trace$iv$iv;
                    boolean bl = false;
                    boolean bl3 = false;
                    logger.trace("Document was changed from client side. Change event = " + PatchEngineDocumentSynchronizerKt.access$printSafeData(change) + ", Version: " + this_$iv.versionHolder.getVersion() + ", Document length: " + this_$iv.getDocument().getTextLength());
                }
                this_$iv.sendDocumentChange(change);
            }
            return;
        }
        this.logger.error((Throwable)new IllegalStateException("Unexpected document and versions state. expectedVersion=" + expectedVersion + ", currentVersion=" + this.versionHolder.getVersion() + ", change=" + PatchEngineDocumentSynchronizerKt.access$printSafeData(change) + "."));
    }

    public final void updateLastKnownVersion(@NotNull RdDocumentVersion version) {
        Intrinsics.checkNotNullParameter((Object)version, (String)"version");
        this.documentLog.updateLastKnownVersion(version);
    }

    public void beforeDocumentChange(@NotNull DocumentEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
    }

    public int getPriority() {
        return 39;
    }

    @Override
    @NotNull
    public RdDocumentVersion getVersion() {
        return this.versionHolder.getVersion();
    }

    @Override
    public void resetVersion(@NotNull AbstractDocumentVersion v) {
        Intrinsics.checkNotNullParameter((Object)v, (String)"v");
        RdDocumentVersion cfr_ignored_0 = (RdDocumentVersion)v;
        this.versionHolder.resetVersion((RdDocumentVersion)v, this.getDocument().getModificationStamp());
        this.documentLog.rollbackHistoryToVersion((RdDocumentVersion)v);
    }

    @Override
    @NotNull
    public IDocumentRangeShifter createRangeShifter() {
        return new DocumentLogRangeShifter(this.documentLog);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final void sendDocumentChange(RdDocumentChangeBase change) {
        void $this$sendAccumulated$iv;
        PatchEngine patchEngine = this.engine;
        String description$iv = "PatchEngineDocumentSynchronizerKt.sendDocumentChange";
        boolean $i$f$sendAccumulated = false;
        AutoCloseable autoCloseable = (AutoCloseable)((Object)PatchEngine.openAccumulatingSession$default((PatchEngine)$this$sendAccumulated$iv, true, description$iv, null, 4, null));
        Throwable throwable = null;
        try {
            RdPatchEngine.ChangeAccumulatingSessionToken it$iv = (RdPatchEngine.ChangeAccumulatingSessionToken)((Object)autoCloseable);
            boolean bl = false;
            ChangeScope $this$sendDocumentChange_u24lambda_u248 = it$iv.getSession().getChangeScope();
            boolean bl2 = false;
            RdDocumentVersion oldVersion = this.versionHolder.getPreviousVersion();
            RdDocumentVersion newVersion = this.versionHolder.getVersion();
            if (!Intrinsics.areEqual((Object)oldVersion, (Object)newVersion)) {
                RdPatchDocumentVersion expectedVersion = new RdPatchDocumentVersion(oldVersion, change.getDocumentId());
                $this$sendDocumentChange_u24lambda_u248.pushExpected(expectedVersion);
                RdPatchDocumentVersion updatedVersion = new RdPatchDocumentVersion(newVersion, change.getDocumentId());
                $this$sendDocumentChange_u24lambda_u248.pushUpdated(updatedVersion);
                $this$sendDocumentChange_u24lambda_u248.pushChange(change);
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
    }

    private static final void receiveDocumentChange$lambda$6$lambda$5(PatchEngineDocumentSynchronizer this$0, RdDocumentChangeBase $change) {
        this$0.applyChangeCheckForce($change);
    }

    private static final void receiveDocumentChange$lambda$6(PatchEngineDocumentSynchronizer this$0, RdDocumentChangeBase $change, boolean $forceRecordPatch) {
        CommandProcessor instance = CommandProcessor.getInstance();
        if (instance.getCurrentCommand() != null) {
            this$0.applyChangeCheckForce($change);
        } else {
            CommandProcessor.getInstance().runUndoTransparentAction(() -> PatchEngineDocumentSynchronizer.receiveDocumentChange$lambda$6$lambda$5(this$0, $change));
        }
        if ($change instanceof RdDocumentChange && ((RdDocumentChange)$change).getText() != null && !Intrinsics.areEqual((Object)this$0.getDocument().getText(), (Object)((RdDocumentChange)$change).getText())) {
            if ($forceRecordPatch) {
                this$0.logger.warn("Not matched document text on version: " + this$0.versionHolder.getVersion().getValue() + ". Probably text was already changed during rebase.");
            } else {
                this$0.logger.error("Not matched document text on version: " + this$0.versionHolder.getVersion().getValue());
            }
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/jetbrains/rd/ide/document/PatchEngineDocumentSynchronizer$Companion;", "", "<init>", "()V", "debugId", "", "intellij.rd.platform"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

