/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rd.lang;

import com.intellij.lang.Language;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.jetbrains.rd.ide.model.RdFileType;
import com.jetbrains.rd.ide.model.RdLanguage;
import com.jetbrains.rd.lang.ProtocolLanguageAssociationBean;
import com.jetbrains.rd.lang.ProtocolLanguageManager;
import com.jetbrains.rd.ui.icons.UtilKt;
import com.jetbrains.rd.util.PlatformDependentKt;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0005\u0018\u0000 \"2\u00020\u0001:\u0001\"B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0012\u001a\u00020\t2\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0012\u0010\u0015\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0016\u001a\u00020\u000fH\u0016J\u0010\u0010\u0017\u001a\u00020\u000f2\u0006\u0010\u0018\u001a\u00020\u0011H\u0016J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0012\u0010\u001b\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u001c\u001a\u00020\tH\u0016J \u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\n2\u0006\u0010 \u001a\u00020\n2\u0006\u0010!\u001a\u00020\u001aH\u0016R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\u0007\u001a\u001e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\bj\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n`\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\f\u001a\u001e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\t0\bj\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\t`\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000f0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00110\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lcom/jetbrains/rd/lang/ProtocolLanguageManagerImpl;", "Lcom/jetbrains/rd/lang/ProtocolLanguageManager;", "<init>", "()V", "EP_NAME", "Lcom/intellij/openapi/extensions/ExtensionPointName;", "Lcom/jetbrains/rd/lang/ProtocolLanguageAssociationBean;", "backendToFrontendLanguageCache", "Ljava/util/HashMap;", "Lcom/jetbrains/rd/ide/model/RdLanguage;", "", "Lkotlin/collections/HashMap;", "frontendToBackendLanguageCache", "fileTypeToProtocolCache", "", "Lcom/jetbrains/rd/ide/model/RdFileType;", "protocolToFileTypeCache", "Lcom/intellij/openapi/fileTypes/FileType;", "toRdLanguage", "language", "Lcom/intellij/lang/Language;", "fromRdFileType", "rdFileType", "toRdFileType", "fileType", "isProtocolLanguage", "", "toIdeaLanguage", "rdLanguage", "addAssociation", "", "backendLanguageId", "frontendLanguageId", "default", "Companion", "intellij.rd.platform"})
@SourceDebugExtension(value={"SMAP\nProtocolLanguageManagerImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ProtocolLanguageManagerImpl.kt\ncom/jetbrains/rd/lang/ProtocolLanguageManagerImpl\n+ 2 util.kt\ncom/intellij/util/containers/UtilKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,112:1\n194#2,9:113\n1#3:122\n14#4:123\n14#4:124\n*S KotlinDebug\n*F\n+ 1 ProtocolLanguageManagerImpl.kt\ncom/jetbrains/rd/lang/ProtocolLanguageManagerImpl\n*L\n27#1:113,9\n79#1:123\n17#1:124\n*E\n"})
public final class ProtocolLanguageManagerImpl
implements ProtocolLanguageManager {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ExtensionPointName<ProtocolLanguageAssociationBean> EP_NAME = ExtensionPointName.Companion.create("com.intellij.rd.languageAssociation");
    @NotNull
    private final HashMap<RdLanguage, String> backendToFrontendLanguageCache = new HashMap();
    @NotNull
    private final HashMap<String, RdLanguage> frontendToBackendLanguageCache = new HashMap();
    @NotNull
    private final Map<String, RdFileType> fileTypeToProtocolCache = PlatformDependentKt.concurrentMapOf();
    @NotNull
    private final Map<RdFileType, FileType> protocolToFileTypeCache = PlatformDependentKt.concurrentMapOf();
    @NotNull
    private static final Logger LOG;

    /*
     * WARNING - void declaration
     */
    public ProtocolLanguageManagerImpl() {
        void $this$forEachLoggingErrors$iv;
        Collection collection = this.EP_NAME.getExtensionList();
        Logger logger$iv = LOG;
        boolean $i$f$forEachLoggingErrors = false;
        for (Object it$iv : $this$forEachLoggingErrors$iv) {
            try {
                ProtocolLanguageAssociationBean it = (ProtocolLanguageAssociationBean)it$iv;
                boolean bl = false;
                String string = it.getBackendLanguage();
                Intrinsics.checkNotNull((Object)string);
                String string2 = it.getFrontendLanguage();
                Intrinsics.checkNotNull((Object)string2);
                this.addAssociation(string, string2, it.isDefault());
            }
            catch (Throwable e$iv) {
                logger$iv.error(e$iv);
            }
        }
    }

    @Override
    @NotNull
    public RdLanguage toRdLanguage(@NotNull Language language) {
        Intrinsics.checkNotNullParameter((Object)language, (String)"language");
        RdLanguage rdLanguage = this.frontendToBackendLanguageCache.get(language.getID());
        if (rdLanguage == null) {
            String string = language.getID();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getID(...)");
            rdLanguage = new RdLanguage(string);
        }
        return rdLanguage;
    }

    @Override
    @Nullable
    public FileType fromRdFileType(@NotNull RdFileType rdFileType) {
        Intrinsics.checkNotNullParameter((Object)rdFileType, (String)"rdFileType");
        FileType cached = this.protocolToFileTypeCache.get(rdFileType);
        if (cached != null) {
            return cached;
        }
        FileType fileType = FileTypeManager.getInstance().findFileTypeByName(rdFileType.getName());
        if (fileType != null) {
            this.protocolToFileTypeCache.put(rdFileType, fileType);
            this.fileTypeToProtocolCache.put(fileType.getName(), rdFileType);
        }
        return fileType;
    }

    @Override
    @NotNull
    public RdFileType toRdFileType(@NotNull FileType fileType) {
        RdLanguage rdLanguage;
        RdFileType cached;
        Intrinsics.checkNotNullParameter((Object)fileType, (String)"fileType");
        RdFileType rdFileType = cached = this.fileTypeToProtocolCache.get(fileType.getName());
        if (rdFileType != null) {
            return rdFileType;
        }
        LanguageFileType languageFileType = fileType instanceof LanguageFileType ? (LanguageFileType)fileType : null;
        if (languageFileType != null && (languageFileType = languageFileType.getLanguage()) != null) {
            LanguageFileType it = languageFileType;
            boolean bl = false;
            rdLanguage = this.toRdLanguage((Language)it);
        } else {
            rdLanguage = null;
        }
        RdLanguage language = rdLanguage;
        FileType $this$toRdFileType_u24lambda_u242 = fileType;
        boolean bl = false;
        String string = $this$toRdFileType_u24lambda_u242.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        String string2 = $this$toRdFileType_u24lambda_u242.getDescription();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getDescription(...)");
        String string3 = $this$toRdFileType_u24lambda_u242.getDefaultExtension();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getDefaultExtension(...)");
        Icon icon = $this$toRdFileType_u24lambda_u242.getIcon();
        RdFileType rdFileType2 = new RdFileType(string, string2, string3, icon != null ? UtilKt.toModel(icon) : null, $this$toRdFileType_u24lambda_u242.isBinary(), $this$toRdFileType_u24lambda_u242.isReadOnly(), language);
        this.protocolToFileTypeCache.put(rdFileType2, fileType);
        this.fileTypeToProtocolCache.put(fileType.getName(), rdFileType2);
        return rdFileType2;
    }

    @Override
    public boolean isProtocolLanguage(@NotNull Language language) {
        Intrinsics.checkNotNullParameter((Object)language, (String)"language");
        return this.frontendToBackendLanguageCache.containsKey(language.getID());
    }

    @Override
    @Nullable
    public Language toIdeaLanguage(@NotNull RdLanguage rdLanguage) {
        Object v2;
        String frontendLanguageId;
        block5: {
            Intrinsics.checkNotNullParameter((Object)rdLanguage, (String)"rdLanguage");
            frontendLanguageId = this.backendToFrontendLanguageCache.get(rdLanguage);
            if (frontendLanguageId != null) {
                Language frontendLanguage = Language.findLanguageByID((String)frontendLanguageId);
                if (frontendLanguage == null) {
                    boolean $i$f$logger = false;
                    Logger logger = Logger.getInstance(ProtocolLanguageManager.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                    logger.error("Unable to find '" + frontendLanguageId + "'. Possibly it's incorrect or com.intellij.lang.Language is not initialized");
                }
                return frontendLanguage;
            }
            Collection collection = Language.getRegisteredLanguages();
            Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"getRegisteredLanguages(...)");
            Iterable iterable = collection;
            for (Object t : iterable) {
                Language it = (Language)t;
                boolean bl = false;
                if (!StringsKt.equals((String)it.getID(), (String)rdLanguage.getId(), (boolean)true)) continue;
                v2 = t;
                break block5;
            }
            v2 = null;
        }
        Language language = v2;
        if (language == null) {
            return null;
        }
        Language foundLanguage = language;
        frontendLanguageId = foundLanguage.getID();
        ((Map)this.backendToFrontendLanguageCache).put(rdLanguage, frontendLanguageId);
        if (!this.frontendToBackendLanguageCache.containsKey(frontendLanguageId)) {
            ((Map)this.frontendToBackendLanguageCache).put(frontendLanguageId, rdLanguage);
        }
        return foundLanguage;
    }

    @Override
    public void addAssociation(@NotNull String backendLanguageId, @NotNull String frontendLanguageId, boolean bl) {
        Intrinsics.checkNotNullParameter((Object)backendLanguageId, (String)"backendLanguageId");
        Intrinsics.checkNotNullParameter((Object)frontendLanguageId, (String)"frontendLanguageId");
        if (bl) {
            RdLanguage rdLanguage = new RdLanguage(backendLanguageId);
            ((Map)this.frontendToBackendLanguageCache).put(frontendLanguageId, rdLanguage);
            ((Map)this.backendToFrontendLanguageCache).put(rdLanguage, frontendLanguageId);
            return;
        }
        RdLanguage backendLanguage = new RdLanguage(backendLanguageId);
        if (!this.frontendToBackendLanguageCache.containsKey(frontendLanguageId)) {
            ((Map)this.frontendToBackendLanguageCache).put(frontendLanguageId, backendLanguage);
        }
        if (!this.backendToFrontendLanguageCache.containsKey(backendLanguage)) {
            ((Map)this.backendToFrontendLanguageCache).put(backendLanguage, frontendLanguageId);
        }
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(ProtocolLanguageManager.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/jetbrains/rd/lang/ProtocolLanguageManagerImpl$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "intellij.rd.platform"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

