/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.data.index;

import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.changes.ChangesUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.vcs.log.CommitId;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.VcsCommitMetadata;
import com.intellij.vcs.log.VcsFullCommitDetails;
import com.intellij.vcs.log.VcsLogBundle;
import com.intellij.vcs.log.VcsLogDetailsFilter;
import com.intellij.vcs.log.VcsLogStructureFilter;
import com.intellij.vcs.log.VcsLogTextFilter;
import com.intellij.vcs.log.VcsLogUserFilter;
import com.intellij.vcs.log.VcsUser;
import com.intellij.vcs.log.data.DataPack;
import com.intellij.vcs.log.data.VcsLogStorage;
import com.intellij.vcs.log.data.index.IndexDataGetter;
import com.intellij.vcs.log.data.index.IndexedDetails;
import com.intellij.vcs.log.data.index.VcsLogStorageBackend;
import com.intellij.vcs.log.graph.PermanentGraph;
import com.intellij.vcs.log.graph.api.EdgeFilter;
import com.intellij.vcs.log.graph.api.LiteLinearGraph;
import com.intellij.vcs.log.graph.api.permanent.PermanentGraphInfo;
import com.intellij.vcs.log.graph.utils.BfsWalk;
import com.intellij.vcs.log.graph.utils.IntHashSetFlags;
import com.intellij.vcs.log.graph.utils.LinearGraphUtils;
import com.intellij.vcs.log.visible.filters.VcsLogFilterObject;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.TypeIntrinsics;
import kotlin.ranges.IntProgression;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J0\u0010\b\u001a\u00020\t*\u00020\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00050\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000e0\f2\b\b\u0002\u0010\u000f\u001a\u00020\u0010J\u001e\u0010\b\u001a\u0004\u0018\u00010\t*\u00020\n2\u0006\u0010\u0011\u001a\u00020\u00052\u0006\u0010\u0012\u001a\u00020\u000eH\u0002J\u001a\u0010\u0013\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0015H\u0002J<\u0010\u0017\u001a\u00020\u0018*\u00060\u0019j\u0002`\u001a2\u0006\u0010\u001b\u001a\u00020\u00152\u0006\u0010\u001c\u001a\u00020\u00152\u0006\u0010\u001d\u001a\u00020\t2\u0012\u0010\u001e\u001a\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u00010\u001fH\u0002J\u001e\u0010 \u001a\u0004\u0018\u00010\t*\u00020\n2\u0006\u0010\u0011\u001a\u00020\u00052\u0006\u0010!\u001a\u00020\u000eH\u0002J.\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00050#*\u00020$2\u0006\u0010%\u001a\u00020&2\f\u0010'\u001a\b\u0012\u0004\u0012\u00020)0(2\u0006\u0010*\u001a\u00020\u0010J&\u0010+\u001a\b\u0012\u0004\u0012\u00020\u00050#*\u00020$2\u0006\u0010,\u001a\u00020\n2\f\u0010'\u001a\b\u0012\u0004\u0012\u00020)0(R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006-"}, d2={"Lcom/intellij/vcs/log/data/index/IndexDiagnostic;", "", "<init>", "()V", "FILTERED_PATHS_LIMIT", "", "COMMITS_TO_CHECK", "INDEXED_COMMITS_ITERATIONS_LIMIT", "getDiffFor", "", "Lcom/intellij/vcs/log/data/index/IndexDataGetter;", "commitsIdList", "", "commitDetailsList", "Lcom/intellij/vcs/log/VcsFullCommitDetails;", "checkAllCommits", "", "commitId", "commitDetails", "getCommitDetailsDiff", "expected", "Lcom/intellij/vcs/log/VcsCommitMetadata;", "actual", "reportDiff", "", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "expectedMetadata", "actualMetadata", "attributeKey", "attributeGetter", "Lkotlin/Function1;", "getFilteringDiff", "details", "pickCommits", "", "Lcom/intellij/vcs/log/data/DataPack;", "storage", "Lcom/intellij/vcs/log/data/VcsLogStorage;", "roots", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "old", "pickIndexedCommits", "dataGetter", "intellij.platform.vcs.log.impl"})
@SourceDebugExtension(value={"SMAP\nIndexDiagnostic.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IndexDiagnostic.kt\ncom/intellij/vcs/log/data/index/IndexDiagnostic\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 KtUtils.kt\ncom/intellij/util/KotlinUtils\n*L\n1#1,160:1\n183#2,2:161\n1454#3,5:163\n774#3:168\n865#3,2:169\n52#4:171\n*S KotlinDebug\n*F\n+ 1 IndexDiagnostic.kt\ncom/intellij/vcs/log/data/index/IndexDiagnostic\n*L\n74#1:161,2\n77#1:163,5\n79#1:168\n79#1:169,2\n103#1:171\n*E\n"})
public final class IndexDiagnostic {
    @NotNull
    public static final IndexDiagnostic INSTANCE = new IndexDiagnostic();
    private static final int FILTERED_PATHS_LIMIT = 15;
    private static final int COMMITS_TO_CHECK = 10;
    private static final int INDEXED_COMMITS_ITERATIONS_LIMIT = 5000;

    private IndexDiagnostic() {
    }

    @NotNull
    public final String getDiffFor(@NotNull IndexDataGetter $this$getDiffFor, @NotNull List<Integer> commitsIdList, @NotNull List<? extends VcsFullCommitDetails> commitDetailsList, boolean checkAllCommits) {
        Intrinsics.checkNotNullParameter((Object)$this$getDiffFor, (String)"<this>");
        Intrinsics.checkNotNullParameter(commitsIdList, (String)"commitsIdList");
        Intrinsics.checkNotNullParameter(commitDetailsList, (String)"commitDetailsList");
        StringBuilder report = new StringBuilder();
        for (Pair pair : CollectionsKt.zip((Iterable)commitsIdList, (Iterable)commitDetailsList)) {
            VcsFullCommitDetails commitDetails;
            int commitId = ((Number)pair.component1()).intValue();
            if (this.getDiffFor($this$getDiffFor, commitId, commitDetails = (VcsFullCommitDetails)pair.component2()) != null) {
                String commitReport;
                boolean bl = false;
                report.append(commitReport).append("\n");
            }
            if (!checkAllCommits && !StringsKt.isBlank((CharSequence)report)) {
                String string = report.toString();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
                return string;
            }
            ProgressManager.checkCanceled();
        }
        String string = report.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    public static /* synthetic */ String getDiffFor$default(IndexDiagnostic indexDiagnostic, IndexDataGetter indexDataGetter, List list, List list2, boolean bl, int n, Object object) {
        if ((n & 4) != 0) {
            bl = true;
        }
        return indexDiagnostic.getDiffFor(indexDataGetter, list, list2, bl);
    }

    private final String getDiffFor(IndexDataGetter $this$getDiffFor, int commitId, VcsFullCommitDetails commitDetails) {
        String difference;
        VcsCommitMetadata vcsCommitMetadata = (VcsCommitMetadata)commitDetails;
        VcsLogStorage vcsLogStorage = $this$getDiffFor.getLogStorage();
        Intrinsics.checkNotNullExpressionValue((Object)vcsLogStorage, (String)"getLogStorage(...)");
        String string = this.getCommitDetailsDiff(vcsCommitMetadata, (VcsCommitMetadata)new IndexedDetails($this$getDiffFor, vcsLogStorage, commitId, 0L, 8, null));
        if (string == null) {
            string = this.getFilteringDiff($this$getDiffFor, commitId, commitDetails);
        }
        if ((difference = string) == null) {
            return null;
        }
        Object[] objectArray = new Object[]{((Hash)commitDetails.getId()).asString(), difference};
        return VcsLogBundle.message("vcs.log.index.diagnostic.error.for.commit", objectArray);
    }

    private final String getCommitDetailsDiff(VcsCommitMetadata expected, VcsCommitMetadata actual) {
        StringBuilder sb = new StringBuilder();
        this.reportDiff(sb, expected, actual, "vcs.log.index.diagnostic.error.attribute.name.author", (Function1<? super VcsCommitMetadata, ? extends Object>)((Function1)IndexDiagnostic::getCommitDetailsDiff$lambda$1));
        this.reportDiff(sb, expected, actual, "vcs.log.index.diagnostic.error.attribute.name.committer", (Function1<? super VcsCommitMetadata, ? extends Object>)((Function1)IndexDiagnostic::getCommitDetailsDiff$lambda$2));
        this.reportDiff(sb, expected, actual, "vcs.log.index.diagnostic.error.attribute.name.author.time", (Function1<? super VcsCommitMetadata, ? extends Object>)((Function1)IndexDiagnostic::getCommitDetailsDiff$lambda$3));
        this.reportDiff(sb, expected, actual, "vcs.log.index.diagnostic.error.attribute.name.committer.time", (Function1<? super VcsCommitMetadata, ? extends Object>)((Function1)IndexDiagnostic::getCommitDetailsDiff$lambda$4));
        this.reportDiff(sb, expected, actual, "vcs.log.index.diagnostic.error.attribute.name.message", (Function1<? super VcsCommitMetadata, ? extends Object>)((Function1)IndexDiagnostic::getCommitDetailsDiff$lambda$5));
        this.reportDiff(sb, expected, actual, "vcs.log.index.diagnostic.error.attribute.name.parents", (Function1<? super VcsCommitMetadata, ? extends Object>)((Function1)IndexDiagnostic::getCommitDetailsDiff$lambda$6));
        if (((CharSequence)sb).length() == 0) {
            return null;
        }
        return sb.toString();
    }

    private final void reportDiff(StringBuilder $this$reportDiff, VcsCommitMetadata expectedMetadata, VcsCommitMetadata actualMetadata, String attributeKey, Function1<? super VcsCommitMetadata, ? extends Object> attributeGetter) {
        Object actualValue;
        Object expectedValue = attributeGetter.invoke((Object)expectedMetadata);
        if (Intrinsics.areEqual((Object)expectedValue, (Object)(actualValue = attributeGetter.invoke((Object)actualMetadata)))) {
            return;
        }
        Object[] objectArray = new Object[]{VcsLogBundle.message(attributeKey, new Object[0]), expectedValue, actualValue};
        $this$reportDiff.append(VcsLogBundle.message("vcs.log.index.diagnostic.error.message", objectArray)).append("\n");
    }

    /*
     * WARNING - void declaration
     */
    private final String getFilteringDiff(IndexDataGetter $this$getFilteringDiff, int commitId, VcsFullCommitDetails details) {
        void $this$filterTo$iv$iv;
        void destination$iv;
        void $this$flatMapTo$iv;
        VcsLogTextFilter vcsLogTextFilter;
        Object v2;
        Object element$iv2;
        Object $this$firstOrNull$iv;
        VcsLogUserFilter authorFilter;
        block8: {
            VcsUser vcsUser = details.getAuthor();
            Intrinsics.checkNotNullExpressionValue((Object)vcsUser, (String)"getAuthor(...)");
            authorFilter = VcsLogFilterObject.fromUser$default(vcsUser, null, 2, null);
            String string = details.getFullMessage();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getFullMessage(...)");
            $this$firstOrNull$iv = StringsKt.lineSequence((CharSequence)string);
            boolean $i$f$firstOrNull = false;
            for (Object element$iv2 : $this$firstOrNull$iv) {
                String it = (String)element$iv2;
                boolean bl = false;
                if (!(it.length() > 5)) continue;
                v2 = element$iv2;
                break block8;
            }
            v2 = null;
        }
        String string = v2;
        if (string != null) {
            String it = string;
            boolean bl = false;
            vcsLogTextFilter = VcsLogFilterObject.fromPattern(StringsKt.take((String)it, (int)25), false, true);
        } else {
            vcsLogTextFilter = null;
        }
        VcsLogTextFilter textFilter = vcsLogTextFilter;
        List list = details.getParents();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getParents(...)");
        $this$firstOrNull$iv = (Iterable)CollectionsKt.getIndices((Collection)list);
        Collection it = new LinkedHashSet();
        boolean $i$f$flatMapTo22 = false;
        element$iv2 = $this$flatMapTo$iv.iterator();
        while (element$iv2.hasNext()) {
            int element$iv3;
            int parentIndex = element$iv3 = ((IntIterator)element$iv2).nextInt();
            boolean bl = false;
            List list2 = ChangesUtil.getPaths((Collection)details.getChanges(parentIndex));
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getPaths(...)");
            Iterable list$iv = list2;
            CollectionsKt.addAll((Collection)destination$iv, (Iterable)list$iv);
        }
        Iterable $this$filter$iv = CollectionsKt.take((Iterable)((Iterable)destination$iv), (int)15);
        boolean $i$f$filter = false;
        Iterable $i$f$flatMapTo22 = $this$filter$iv;
        Object[] destination$iv$iv = (Object[])new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            FilePath it2 = (FilePath)element$iv$iv;
            boolean bl = false;
            VirtualFile virtualFile = $this$getFilteringDiff.getRoot(it2);
            if (!Intrinsics.areEqual((Object)(virtualFile != null ? virtualFile.getPath() : null), (Object)details.getRoot().getPath())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List paths = (List)destination$iv$iv;
        VcsLogStructureFilter pathsFilter = !((Collection)paths).isEmpty() ? VcsLogFilterObject.fromPaths(paths) : null;
        StringBuilder sb = new StringBuilder();
        destination$iv$iv = new VcsLogDetailsFilter[]{authorFilter, textFilter, pathsFilter};
        for (VcsLogDetailsFilter filter : CollectionsKt.listOfNotNull((Object[])destination$iv$iv)) {
            if (!$this$getFilteringDiff.filter(CollectionsKt.listOf((Object)filter)).contains(commitId)) {
                Object[] objectArray = new Object[]{filter, ((Hash)details.getId()).toShortString()};
                sb.append(VcsLogBundle.message("vcs.log.index.diagnostic.error.filter", objectArray)).append("\n");
            }
            ProgressManager.checkCanceled();
        }
        if (((CharSequence)sb).length() == 0) {
            return null;
        }
        return sb.toString();
    }

    @NotNull
    public final Set<Integer> pickCommits(@NotNull DataPack $this$pickCommits, @NotNull VcsLogStorage storage, @NotNull Collection<? extends VirtualFile> roots, boolean old) {
        IntRange intRange;
        Intrinsics.checkNotNullParameter((Object)$this$pickCommits, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)storage, (String)"storage");
        Intrinsics.checkNotNullParameter(roots, (String)"roots");
        IntOpenHashSet result = new IntOpenHashSet();
        Set rootsToCheck = CollectionsKt.toMutableSet((Iterable)roots);
        PermanentGraph<Integer> permanentGraph = $this$pickCommits.getPermanentGraph();
        PermanentGraphInfo permanentGraphInfo = permanentGraph instanceof PermanentGraphInfo ? (PermanentGraphInfo)permanentGraph : null;
        if (permanentGraphInfo == null) {
            return SetsKt.emptySet();
        }
        PermanentGraphInfo permanentGraphInfo2 = permanentGraphInfo;
        LiteLinearGraph liteLinearGraph = LinearGraphUtils.asLiteLinearGraph(permanentGraphInfo2.getLinearGraph());
        Intrinsics.checkNotNullExpressionValue((Object)liteLinearGraph, (String)"asLiteLinearGraph(...)");
        LiteLinearGraph graph = liteLinearGraph;
        IntRange $this$applyIf$iv = RangesKt.until((int)0, (int)graph.nodesCount());
        boolean $i$f$applyIf = false;
        if (old) {
            IntProgression $this$pickCommits_u24lambda_u2411 = (IntProgression)$this$applyIf$iv;
            boolean bl = false;
            intRange = RangesKt.reversed((IntProgression)$this$pickCommits_u24lambda_u2411);
        } else {
            intRange = $this$applyIf$iv;
        }
        IntProgression nodeRange = (IntProgression)intRange;
        int node = nodeRange.getFirst();
        int n = nodeRange.getLast();
        int n2 = nodeRange.getStep();
        if (n2 > 0 && node <= n || n2 < 0 && n <= node) {
            while (true) {
                if (graph.getNodes(node, old ? LiteLinearGraph.NodeFilter.DOWN : LiteLinearGraph.NodeFilter.UP).isEmpty()) {
                    VirtualFile root;
                    Object CommitId2 = permanentGraphInfo2.getPermanentCommitsInfo().getCommitId(node);
                    Intrinsics.checkNotNullExpressionValue(CommitId2, (String)"getCommitId(...)");
                    CommitId commitId = storage.getCommitId(((Number)CommitId2).intValue());
                    Object object = root = commitId != null ? commitId.getRoot() : null;
                    if (TypeIntrinsics.asMutableCollection((Object)rootsToCheck).remove(root)) {
                        new BfsWalk(node, graph, new IntHashSetFlags(graph.nodesCount()), !old).walk((Function1<? super Integer, Boolean>)((Function1)arg_0 -> IndexDiagnostic.pickCommits$lambda$12(graph, result, permanentGraphInfo2, arg_0)));
                        if (rootsToCheck.isEmpty()) break;
                    }
                }
                if (node == n) break;
                node += n2;
            }
        }
        return (Set)result;
    }

    @NotNull
    public final Set<Integer> pickIndexedCommits(@NotNull DataPack $this$pickIndexedCommits, @NotNull IndexDataGetter dataGetter, @NotNull Collection<? extends VirtualFile> roots) {
        Intrinsics.checkNotNullParameter((Object)$this$pickIndexedCommits, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)dataGetter, (String)"dataGetter");
        Intrinsics.checkNotNullParameter(roots, (String)"roots");
        if (roots.isEmpty()) {
            return SetsKt.emptySet();
        }
        IntOpenHashSet result = new IntOpenHashSet();
        PermanentGraph<Integer> permanentGraph = $this$pickIndexedCommits.getPermanentGraph();
        PermanentGraphInfo permanentGraphInfo = permanentGraph instanceof PermanentGraphInfo ? (PermanentGraphInfo)permanentGraph : null;
        if (permanentGraphInfo == null) {
            return SetsKt.emptySet();
        }
        PermanentGraphInfo permanentGraphInfo2 = permanentGraphInfo;
        for (int i = 0; i < 10; ++i) {
            CommitId root;
            int node = i * (permanentGraphInfo2.getLinearGraph().nodesCount() / 10);
            if (permanentGraphInfo2.getLinearGraph().getAdjacentEdges(node, EdgeFilter.NORMAL_DOWN).size() != 1) continue;
            Integer commit = (Integer)permanentGraphInfo2.getPermanentCommitsInfo().getCommitId(node);
            VcsLogStorageBackend vcsLogStorageBackend = dataGetter.getIndexStorageBackend();
            Intrinsics.checkNotNull((Object)commit);
            if (!vcsLogStorageBackend.containsCommit(commit)) continue;
            CommitId commitId = dataGetter.getLogStorage().getCommitId(commit);
            if (commitId == null) continue;
            if ((commitId = commitId.getRoot()) == null || !roots.contains(root = commitId)) continue;
            result.add(commit.intValue());
        }
        if (result.size() >= 10) {
            return (Set)result;
        }
        dataGetter.iterateIndexedCommits(5000, arg_0 -> IndexDiagnostic.pickIndexedCommits$lambda$13(permanentGraphInfo2, dataGetter, roots, result, arg_0));
        return (Set)result;
    }

    private static final Object getCommitDetailsDiff$lambda$1(VcsCommitMetadata it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        VcsUser vcsUser = it.getAuthor();
        Intrinsics.checkNotNullExpressionValue((Object)vcsUser, (String)"getAuthor(...)");
        return vcsUser;
    }

    private static final Object getCommitDetailsDiff$lambda$2(VcsCommitMetadata it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        VcsUser vcsUser = it.getCommitter();
        Intrinsics.checkNotNullExpressionValue((Object)vcsUser, (String)"getCommitter(...)");
        return vcsUser;
    }

    private static final Object getCommitDetailsDiff$lambda$3(VcsCommitMetadata it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getAuthorTime();
    }

    private static final Object getCommitDetailsDiff$lambda$4(VcsCommitMetadata it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getCommitTime();
    }

    private static final Object getCommitDetailsDiff$lambda$5(VcsCommitMetadata it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        String string = it.getFullMessage();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getFullMessage(...)");
        return string;
    }

    private static final Object getCommitDetailsDiff$lambda$6(VcsCommitMetadata it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        List list = it.getParents();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getParents(...)");
        return list;
    }

    private static final boolean pickCommits$lambda$12(LiteLinearGraph $graph, IntOpenHashSet $result, PermanentGraphInfo $permanentGraphInfo, int nextNode) {
        if ($graph.getNodes(nextNode, LiteLinearGraph.NodeFilter.DOWN).size() == 1) {
            Object CommitId2 = $permanentGraphInfo.getPermanentCommitsInfo().getCommitId(nextNode);
            Intrinsics.checkNotNullExpressionValue(CommitId2, (String)"getCommitId(...)");
            $result.add(((Number)CommitId2).intValue());
        }
        return $result.size() < 10;
    }

    private static final Boolean pickIndexedCommits$lambda$13(PermanentGraphInfo $permanentGraphInfo, IndexDataGetter $dataGetter, Collection $roots, IntOpenHashSet $result, int commit) {
        int node = $permanentGraphInfo.getPermanentCommitsInfo().getNodeId(commit);
        if (node >= 0 && $permanentGraphInfo.getLinearGraph().getAdjacentEdges(node, EdgeFilter.NORMAL_DOWN).size() == 1) {
            VirtualFile root;
            CommitId commitId = $dataGetter.getLogStorage().getCommitId(commit);
            Object object = root = commitId != null ? commitId.getRoot() : null;
            if (root != null && $roots.contains(root)) {
                $result.add(commit);
            }
        }
        return $result.size() < 10;
    }
}

