/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.data.index;

import com.intellij.util.ArrayUtilRt;
import com.intellij.vcs.log.data.index.SqliteVcsLogStorageBackend;
import com.intellij.vcs.log.data.index.VcsLogStorageBackend;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.intellij.lang.annotations.Language;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.sqlite.IntBinder;
import org.jetbrains.sqlite.SqlitePreparedStatement;
import org.jetbrains.sqlite.SqliteResultSet;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u00002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0015\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0016\u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bH\u0002\u001a\u0012\u0010\n\u001a\u00020\u0003*\b\u0012\u0004\u0012\u00020\u00010\u000bH\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u0010\u0010\u0002\u001a\u00020\u00038\u0002X\u0083T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0004\u001a\u00020\u0003X\u0080T\u00a2\u0006\u0002\n\u0000\"\u0018\u0010\f\u001a\u00020\r*\u00020\u000e8@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\u000f\u00a8\u0006\u0010"}, d2={"DB_VERSION", "", "TABLE_SCHEMA", "", "SQLITE_VCS_LOG_DB_FILENAME_PREFIX", "readIntArray", "", "statement", "Lorg/jetbrains/sqlite/SqlitePreparedStatement;", "Lorg/jetbrains/sqlite/IntBinder;", "toInClause", "", "isSqliteBackend", "", "Lcom/intellij/vcs/log/data/index/VcsLogStorageBackend;", "(Lcom/intellij/vcs/log/data/index/VcsLogStorageBackend;)Z", "intellij.platform.vcs.log.impl"})
@ApiStatus.Internal
public final class SqliteVcsLogStorageBackendKt {
    private static final int DB_VERSION = 2;
    @Language(value="SQLite")
    @NotNull
    private static final String TABLE_SCHEMA = "\n  begin transaction;\n  \n  create table log (\n    commitId integer primary key,\n    message text not null,\n    authorTime integer not null,\n    commitTime integer not null,\n    isCommitter integer not null\n  ) strict;\n  create virtual table fts_message_index using fts5(message, content='log', content_rowid='commitId', tokenize='trigram');\n  \n  create trigger log_ai after insert on log begin\n    insert into fts_message_index(rowid, message) values (new.commitId, new.message);\n  end;\n  create trigger log_ad after delete on log begin \n    insert into fts_message_index(fts_message_index, rowid, message) values ('delete', old.commitId, old.message);\n  end;\n  create trigger log_au after update on log begin\n    insert into fts_message_index(fts_message_index, rowid, message) values ('delete', old.commitId, old.message);\n    insert into fts_message_index(rowid, message) values (new.commitId, new.message);\n  end;\n  \n  -- one to many relation, so, commitId is not a primary key\n  create table parent (commitId integer not null, parent integer not null) strict;\n  create index parent_index on parent (commitId);\n  \n  create table rename (parent integer not null, child integer not null, rename integer not null) strict;\n  create index rename_index on rename (parent, child);\n  \n  create table user (commitId integer not null, isCommitter integer not null, name text not null, email text not null) strict;\n  create index user_index on user (name, email);\n  \n  create table path (relativePath text not null, position integer not null) strict;\n  create index path_index on path (position, relativePath);\n  create table path_change (commitId integer not null, pathId integer not null, kind integer not null) strict;\n  create index path_change_index on path_change(pathId);\n  \n  create table commit_hashes (hash text not null, position integer not null, name text null, type integer null) strict;\n  create unique index commit_hashes_index on commit_hashes (position, hash);\n  \n  commit transaction;\n";
    @NotNull
    public static final String SQLITE_VCS_LOG_DB_FILENAME_PREFIX = "vcs-log-v";

    private static final int[] readIntArray(SqlitePreparedStatement<IntBinder> statement) {
        SqliteResultSet resultSet = statement.executeQuery();
        if (!resultSet.next()) {
            Intrinsics.checkNotNullExpressionValue((Object)ArrayUtilRt.EMPTY_INT_ARRAY, (String)"EMPTY_INT_ARRAY");
            return ArrayUtilRt.EMPTY_INT_ARRAY;
        }
        int first = resultSet.getInt(0);
        if (!resultSet.next()) {
            int[] nArray = new int[]{first};
            return nArray;
        }
        IntArrayList result = new IntArrayList();
        result.add(first);
        do {
            result.add(resultSet.getInt(0));
        } while (resultSet.next());
        int[] nArray = result.toIntArray();
        Intrinsics.checkNotNullExpressionValue((Object)nArray, (String)"toIntArray(...)");
        return nArray;
    }

    private static final String toInClause(Iterable<Integer> $this$toInClause) {
        return "(" + CollectionsKt.joinToString$default($this$toInClause, (CharSequence)",", null, null, (int)0, null, SqliteVcsLogStorageBackendKt::toInClause$lambda$0, (int)30, null) + ")";
    }

    public static final boolean isSqliteBackend(@NotNull VcsLogStorageBackend $this$isSqliteBackend) {
        Intrinsics.checkNotNullParameter((Object)$this$isSqliteBackend, (String)"<this>");
        return $this$isSqliteBackend instanceof SqliteVcsLogStorageBackend;
    }

    private static final CharSequence toInClause$lambda$0(int it) {
        return "'" + it + "'";
    }

    public static final /* synthetic */ String access$toInClause(Iterable $receiver) {
        return SqliteVcsLogStorageBackendKt.toInClause($receiver);
    }

    public static final /* synthetic */ int[] access$readIntArray(SqlitePreparedStatement statement) {
        return SqliteVcsLogStorageBackendKt.readIntArray((SqlitePreparedStatement<IntBinder>)statement);
    }
}

