/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileTypes;

import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ReflectionUtil;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import java.nio.charset.CodingErrorAction;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CharsetUtil {
    private static final Map<String, Boolean> ourSupportsCharsetDetection = new ConcurrentHashMap<String, Boolean>();

    private static boolean overridesExtractCharsetFromContent(LanguageFileType fileType) {
        Class<?> ftClass = fileType.getClass();
        String methodName = "extractCharsetFromFileContent";
        Class<?> declaring1 = ReflectionUtil.getMethodDeclaringClass(ftClass, methodName, Project.class, VirtualFile.class, String.class);
        Class<?> declaring2 = ReflectionUtil.getMethodDeclaringClass(ftClass, methodName, Project.class, VirtualFile.class, CharSequence.class);
        return !LanguageFileType.class.equals(declaring1) || !LanguageFileType.class.equals(declaring2);
    }

    public static Charset extractCharsetFromFileContent(@Nullable Project project, @Nullable VirtualFile virtualFile, @Nullable FileType fileType, @NotNull CharSequence text) {
        if (text == null) {
            CharsetUtil.$$$reportNull$$$0(0);
        }
        if (fileType instanceof LanguageFileType && ourSupportsCharsetDetection.computeIfAbsent(fileType.getName(), __ -> CharsetUtil.overridesExtractCharsetFromContent((LanguageFileType)fileType)).booleanValue()) {
            return ((LanguageFileType)fileType).extractCharsetFromFileContent(project, virtualFile, text);
        }
        return null;
    }

    @Nullable
    public static TextRange findUnmappableCharacters(@Nullable CharSequence text, @NotNull Charset charset) {
        CoderResult encodeResult;
        if (charset == null) {
            CharsetUtil.$$$reportNull$$$0(1);
        }
        if (text == null || text.length() == 0) {
            return null;
        }
        CharBuffer inputBuffer = text instanceof CharBuffer ? (CharBuffer)text : CharBuffer.wrap(text);
        CharsetEncoder encoder2 = charset.newEncoder().onUnmappableCharacter(CodingErrorAction.REPORT).onMalformedInput(CodingErrorAction.REPORT);
        int remainingChars = inputBuffer.remaining();
        ByteBuffer encodedBuffer = ByteBuffer.allocate((int)(encoder2.maxBytesPerChar() * (float)remainingChars));
        inputBuffer.rewind();
        encodedBuffer.clear();
        while (true) {
            if ((encodeResult = encoder2.encode(inputBuffer, encodedBuffer, true)).isUnderflow()) {
                encodeResult = encoder2.flush(encodedBuffer);
            }
            if (!encodeResult.isOverflow()) break;
            ByteBuffer tempBuffer = ByteBuffer.allocate(2 * encodedBuffer.capacity());
            encodedBuffer.flip();
            tempBuffer.put(encodedBuffer);
            encodedBuffer = tempBuffer;
        }
        if (encodeResult.isError()) {
            return TextRange.from(inputBuffer.position(), encodeResult.length());
        }
        encodedBuffer.flip();
        CharBuffer decodedBuffer = CharBuffer.allocate(encodedBuffer.remaining());
        TextRange range = CharsetUtil.findUnmappableRange(encodedBuffer, charset, decodedBuffer);
        if (range != null) {
            return range;
        }
        if (decodedBuffer.position() != remainingChars) {
            return TextRange.from(Math.min(remainingChars, decodedBuffer.position()), 1);
        }
        inputBuffer.rewind();
        decodedBuffer.rewind();
        int commonPrefixLength = StringUtil.commonPrefixLength(inputBuffer, decodedBuffer);
        return commonPrefixLength == remainingChars ? null : TextRange.from(commonPrefixLength, 1);
    }

    @Nullable
    public static TextRange findUnmappableCharacters(@NotNull ByteBuffer byteBuffer, @NotNull Charset charset) {
        if (byteBuffer == null) {
            CharsetUtil.$$$reportNull$$$0(2);
        }
        if (charset == null) {
            CharsetUtil.$$$reportNull$$$0(3);
        }
        return CharsetUtil.findUnmappableRange(byteBuffer, charset, CharBuffer.allocate(byteBuffer.remaining()));
    }

    @Nullable
    private static TextRange findUnmappableRange(@NotNull ByteBuffer byteBuffer, @NotNull Charset charset, @NotNull CharBuffer decodedBuffer) {
        CharsetDecoder decoder;
        CoderResult result2;
        if (byteBuffer == null) {
            CharsetUtil.$$$reportNull$$$0(4);
        }
        if (charset == null) {
            CharsetUtil.$$$reportNull$$$0(5);
        }
        if (decodedBuffer == null) {
            CharsetUtil.$$$reportNull$$$0(6);
        }
        if ((result2 = (decoder = charset.newDecoder().onUnmappableCharacter(CodingErrorAction.REPORT).onMalformedInput(CodingErrorAction.REPORT)).decode(byteBuffer, decodedBuffer, false)).isError()) {
            return TextRange.from(byteBuffer.position(), result2.length());
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 1: 
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "charset";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "byteBuffer";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "decodedBuffer";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/fileTypes/CharsetUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "extractCharsetFromFileContent";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "findUnmappableCharacters";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "findUnmappableRange";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

