/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.inline.completion.impl.inline.lookup;

import com.intellij.codeInsight.completion.LookupElementListPresenter;
import com.intellij.codeInsight.completion.PrefixMatcher;
import com.intellij.codeInsight.inline.completion.InlineCompletionProvider;
import com.intellij.codeInsight.inline.completion.session.InlineCompletionSession;
import com.intellij.codeInsight.lookup.LookupEx;
import com.intellij.codeInsight.lookup.LookupManager;
import com.intellij.ml.inline.completion.impl.inline.MLInlineCompletionProvider;
import com.intellij.ml.inline.completion.impl.inline.lookup.MLCompletionLookupItemProvider;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001BC\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u0012\u0014\u0010\u000b\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010\r\u0012\u0004\u0012\u00020\u000e0\f\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u0010\u0010\u0011\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0016J\u0010\u0010\u0012\u001a\u00020\n2\u0006\u0010\u0013\u001a\u00020\u0003H\u0016J\b\u0010\u0014\u001a\u00020\u0003H\u0002J\u000e\u0010\u0015\u001a\u0004\u0018\u00010\r*\u00020\u0016H\u0002J \u0010\u0017\u001a\u00020\r*\u00020\r2\u0012\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\fH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u000b\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010\r\u0012\u0004\u0012\u00020\u000e0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/intellij/ml/inline/completion/impl/inline/lookup/MLCompletionPrefixMatcher;", "Lcom/intellij/codeInsight/completion/PrefixMatcher;", "prefix", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "project", "Lcom/intellij/openapi/project/Project;", "forceMatch", "Lkotlin/Function0;", "", "setItem", "Lkotlin/Function1;", "Lcom/intellij/ml/inline/completion/impl/inline/lookup/MLCompletionLookupItemProvider$LookupItem;", "", "<init>", "(Ljava/lang/String;Lcom/intellij/openapi/editor/Editor;Lcom/intellij/openapi/project/Project;Lkotlin/jvm/functions/Function0;Lkotlin/jvm/functions/Function1;)V", "cloneWithPrefix", "prefixMatches", "name", "getLookupPrefix", "getLookupItem", "Lcom/intellij/codeInsight/inline/completion/session/InlineCompletionSession;", "withCompletion", "transform", "intellij.ml.inline.completion"})
public final class MLCompletionPrefixMatcher
extends PrefixMatcher {
    @NotNull
    private final Editor editor;
    @NotNull
    private final Project project;
    @NotNull
    private final Function0<Boolean> forceMatch;
    @NotNull
    private final Function1<MLCompletionLookupItemProvider.LookupItem, Unit> setItem;

    public MLCompletionPrefixMatcher(@NotNull String prefix, @NotNull Editor editor, @NotNull Project project, @NotNull Function0<Boolean> forceMatch, @NotNull Function1<? super MLCompletionLookupItemProvider.LookupItem, Unit> setItem) {
        Intrinsics.checkNotNullParameter((Object)prefix, (String)"prefix");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(forceMatch, (String)"forceMatch");
        Intrinsics.checkNotNullParameter(setItem, (String)"setItem");
        super(prefix);
        this.editor = editor;
        this.project = project;
        this.forceMatch = forceMatch;
        this.setItem = setItem;
    }

    @NotNull
    public PrefixMatcher cloneWithPrefix(@NotNull String prefix) {
        Intrinsics.checkNotNullParameter((Object)prefix, (String)"prefix");
        return new MLCompletionPrefixMatcher(prefix, this.editor, this.project, this.forceMatch, this.setItem);
    }

    public boolean prefixMatches(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        if (((Boolean)this.forceMatch.invoke()).booleanValue()) {
            return true;
        }
        InlineCompletionSession session = InlineCompletionSession.Companion.getOrNull(this.editor);
        if (session != null) {
            InlineCompletionProvider currentProvider = session.getProvider();
            if (!(currentProvider instanceof MLInlineCompletionProvider)) {
                this.setItem.invoke(null);
                return false;
            }
            if (!((Collection)session.getContext().getState().getElements()).isEmpty()) {
                MLCompletionLookupItemProvider.LookupItem lookupItem = this.getLookupItem(session);
                this.setItem.invoke((Object)lookupItem);
                return lookupItem != null;
            }
        }
        MLCompletionLookupItemProvider.LookupItem lookupItem = MLCompletionLookupItemProvider.Companion.provide(this.editor, this.project);
        MLCompletionLookupItemProvider.LookupItem lookupItem2 = lookupItem != null ? this.withCompletion(lookupItem, (Function1<? super String, String>)((Function1)arg_0 -> MLCompletionPrefixMatcher.prefixMatches$lambda$0(this, arg_0))) : null;
        this.setItem.invoke((Object)lookupItem2);
        return lookupItem2 != null;
    }

    private final String getLookupPrefix() {
        LookupEx lookupEx = LookupManager.getActiveLookup((Editor)this.editor);
        LookupElementListPresenter lookupElementListPresenter = lookupEx instanceof LookupElementListPresenter ? (LookupElementListPresenter)lookupEx : null;
        if (lookupElementListPresenter == null) {
            String string = this.getPrefix();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPrefix(...)");
            return string;
        }
        LookupElementListPresenter lookup = lookupElementListPresenter;
        return this.getPrefix() + lookup.getAdditionalPrefix();
    }

    private final MLCompletionLookupItemProvider.LookupItem getLookupItem(InlineCompletionSession $this$getLookupItem) {
        MLCompletionLookupItemProvider mLCompletionLookupItemProvider = MLCompletionLookupItemProvider.Companion.getForInlineProvider($this$getLookupItem.getProvider());
        if (mLCompletionLookupItemProvider == null) {
            return null;
        }
        MLCompletionLookupItemProvider itemProvider = mLCompletionLookupItemProvider;
        Editor editor = $this$getLookupItem.getEditor();
        Project project = $this$getLookupItem.getRequest().getFile().getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        MLCompletionLookupItemProvider.LookupItem lookupItem = itemProvider.provide(editor, project);
        return lookupItem != null ? this.withCompletion(lookupItem, (Function1<? super String, String>)((Function1)arg_0 -> MLCompletionPrefixMatcher.getLookupItem$lambda$1(this, arg_0))) : null;
    }

    private final MLCompletionLookupItemProvider.LookupItem withCompletion(MLCompletionLookupItemProvider.LookupItem $this$withCompletion, Function1<? super String, String> transform2) {
        return MLCompletionLookupItemProvider.LookupItem.copy$default($this$withCompletion, (String)transform2.invoke((Object)$this$withCompletion.getCompletion()), null, null, 6, null);
    }

    private static final String prefixMatches$lambda$0(MLCompletionPrefixMatcher this$0, String completion) {
        Intrinsics.checkNotNullParameter((Object)completion, (String)"completion");
        return this$0.getLookupPrefix() + completion;
    }

    private static final String getLookupItem$lambda$1(MLCompletionPrefixMatcher this$0, String text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        return this$0.getLookupPrefix() + text;
    }
}

