/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.station.core.discovery;

import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.util.BuildNumber;
import com.intellij.station.comms.common.api.StationServicesClient;
import com.intellij.station.comms.common.api.TypedWebsocketClient;
import com.intellij.station.comms.common.discovery.DiscoveryMessage;
import com.intellij.station.comms.common.discovery.DiscoveryMetaInfo;
import com.intellij.station.comms.common.discovery.IdeHello;
import com.intellij.station.comms.common.discovery.IdeStatus;
import com.intellij.station.comms.common.discovery.IntelliJRemoteDevStatus;
import com.intellij.station.comms.common.discovery.IntellijToolInformation;
import com.intellij.station.comms.common.discovery.StationHello;
import com.intellij.station.core.IdeDiagnosticsService;
import com.intellij.station.core.IdeServicesHostApplication;
import com.intellij.station.core.discovery.DefaultDiscoveryService;
import com.intellij.station.core.discovery.DiscoveryRdInfoProviderExtension;
import com.intellij.station.core.discovery.DiscoveryService;
import com.intellij.station.core.discovery.StationConnection;
import java.lang.invoke.LambdaMetafactory;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.CancellationException;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlin.time.Duration;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import kotlinx.coroutines.DelayKt;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.JobKt;
import kotlinx.coroutines.channels.ChannelIterator;
import kotlinx.coroutines.channels.ChannelsKt;
import kotlinx.coroutines.channels.ReceiveChannel;
import kotlinx.coroutines.flow.MutableStateFlow;
import kotlinx.coroutines.flow.StateFlowKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.ide.BuiltInServerManager;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u001a2\u00020\u0001:\u0001\u001aB\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u001c\u0010\u0011\u001a\u00020\u00122\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00120\u0014H\u0082@\u00a2\u0006\u0002\u0010\u0015J\b\u0010\u0016\u001a\u00020\u0017H\u0002J\b\u0010\u0018\u001a\u00020\u0019H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\nR\u0016\u0010\u000b\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\r0\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u000e\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\r0\fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u001b"}, d2={"Lcom/intellij/station/core/discovery/DefaultDiscoveryService;", "Lcom/intellij/station/core/discovery/DiscoveryService;", "coroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "connectorProvider", "Lcom/intellij/station/comms/common/api/StationServicesClient;", "<init>", "(Lkotlinx/coroutines/CoroutineScope;Lcom/intellij/station/comms/common/api/StationServicesClient;)V", "statusPeriod", "Lkotlin/time/Duration;", "J", "stateFlow", "Lkotlinx/coroutines/flow/MutableStateFlow;", "Lcom/intellij/station/core/discovery/StationConnection;", "connectionState", "getConnectionState", "()Lkotlinx/coroutines/flow/MutableStateFlow;", "doDiscovery", "", "successReporter", "Lkotlin/Function0;", "(Lkotlin/jvm/functions/Function0;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "buildIdeHello", "Lcom/intellij/station/comms/common/discovery/IdeHello;", "buildStatus", "Lcom/intellij/station/comms/common/discovery/IdeStatus;", "Companion", "intellij.station.core"})
@SourceDebugExtension(value={"SMAP\nDefaultDiscoveryService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DefaultDiscoveryService.kt\ncom/intellij/station/core/discovery/DefaultDiscoveryService\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,131:1\n11165#2:132\n11500#2,3:133\n14#3:136\n*S KotlinDebug\n*F\n+ 1 DefaultDiscoveryService.kt\ncom/intellij/station/core/discovery/DefaultDiscoveryService\n*L\n104#1:132\n104#1:133,3\n28#1:136\n*E\n"})
public final class DefaultDiscoveryService
implements DiscoveryService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final StationServicesClient connectorProvider;
    private final long statusPeriod;
    @NotNull
    private MutableStateFlow<StationConnection> stateFlow;
    @NotNull
    private final MutableStateFlow<StationConnection> connectionState;
    @NotNull
    private static final Logger logger;

    public DefaultDiscoveryService(@NotNull CoroutineScope coroutineScope, @NotNull StationServicesClient connectorProvider) {
        Intrinsics.checkNotNullParameter((Object)coroutineScope, (String)"coroutineScope");
        Intrinsics.checkNotNullParameter((Object)connectorProvider, (String)"connectorProvider");
        this.connectorProvider = connectorProvider;
        this.statusPeriod = DurationKt.toDuration((int)5000, (DurationUnit)DurationUnit.MILLISECONDS);
        this.stateFlow = StateFlowKt.MutableStateFlow(null);
        this.connectionState = this.stateFlow;
        BuildersKt.launch$default((CoroutineScope)coroutineScope, (CoroutineContext)((CoroutineContext)Dispatchers.getIO()), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(coroutineScope, this, null){
            Object L$0;
            int label;
            final /* synthetic */ CoroutineScope $coroutineScope;
            final /* synthetic */ DefaultDiscoveryService this$0;
            {
                this.$coroutineScope = $coroutineScope;
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object var1_1) {
                var4_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)var1_1);
                        lastExceptionType = new Ref.ObjectRef();
lbl6:
                        // 3 sources

                        while (CoroutineScopeKt.isActive((CoroutineScope)this.$coroutineScope)) {
                            DefaultDiscoveryService.access$getLogger$cp().debug("Performing discovery connection to Toolbox");
                            this.L$0 = lastExceptionType;
                            this.label = 1;
                            v0 = DefaultDiscoveryService.access$doDiscovery(this.this$0, (Function0)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, invokeSuspend$lambda$0(kotlin.jvm.internal.Ref$ObjectRef ), ()Lkotlin/Unit;)((Ref.ObjectRef)lastExceptionType), (Continuation)this);
                            ** if (v0 != var4_2) goto lbl15
lbl14:
                            // 1 sources

                            return var4_2;
lbl15:
                            // 1 sources

                            ** GOTO lbl23
                        }
                        break;
                    }
                    case 1: {
                        lastExceptionType = (Ref.ObjectRef)this.L$0;
                        try {
                            ResultKt.throwOnFailure((Object)$result);
                            v0 = $result;
lbl23:
                            // 2 sources

                            DefaultDiscoveryService.access$getLogger$cp().info("Discovery disconnected normally; is Toolbox restarting?");
                        }
                        catch (Throwable t) {
                            if (t instanceof CancellationException) {
                                throw t;
                            }
                            if (Intrinsics.areEqual(t.getClass(), (Object)lastExceptionType.element)) ** GOTO lbl31
                            DefaultDiscoveryService.access$getLogger$cp().warn("Discovery connection failed with exception", t);
                            lastExceptionType.element = t.getClass();
                        }
lbl31:
                        // 3 sources

                        this.L$0 = lastExceptionType;
                        this.label = 2;
                        v1 = DelayKt.delay((long)5000L, (Continuation)((Continuation)this));
                        if (v1 != var4_2) ** GOTO lbl6
                        return var4_2;
                    }
                    case 2: {
                        lastExceptionType = (Ref.ObjectRef)this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v1 = $result;
                        ** GOTO lbl6
                    }
                }
                return Unit.INSTANCE;
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }

            private static final Unit invokeSuspend$lambda$0(Ref.ObjectRef $lastExceptionType) {
                $lastExceptionType.element = null;
                return Unit.INSTANCE;
            }
        }), (int)2, null);
    }

    @NotNull
    public MutableStateFlow<StationConnection> getConnectionState() {
        return this.connectionState;
    }

    /*
     * Unable to fully structure code
     */
    private final Object doDiscovery(Function0<Unit> var1_1, Continuation<? super Unit> $completion) {
        if (!($completion instanceof doDiscovery.1)) ** GOTO lbl-1000
        var5_3 = $completion;
        if ((var5_3.label & -2147483648) != 0) {
            var5_3.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                Object L$1;
                Object L$2;
                /* synthetic */ Object result;
                final /* synthetic */ DefaultDiscoveryService this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return DefaultDiscoveryService.access$doDiscovery(this.this$0, null, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var6_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                $continuation.L$0 = this;
                $continuation.L$1 = successReporter;
                $continuation.label = 1;
                v0 = this.connectorProvider.websocket(DiscoveryMetaInfo.INSTANCE, $continuation);
                if (v0 == var6_5) {
                    return var6_5;
                }
                ** GOTO lbl24
            }
            case 1: {
                successReporter = (Function0)$continuation.L$1;
                this = (DefaultDiscoveryService)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl24:
                // 2 sources

                ws = (TypedWebsocketClient)v0;
                $continuation.L$0 = this;
                $continuation.L$1 = successReporter;
                $continuation.L$2 = ws;
                $continuation.label = 2;
                v1 = ws.send(this.buildIdeHello(), (Continuation<Unit>)$continuation);
                if (v1 == var6_5) {
                    return var6_5;
                }
                ** GOTO lbl39
            }
            case 2: {
                ws = (TypedWebsocketClient)$continuation.L$2;
                successReporter = (Function0)$continuation.L$1;
                this = (DefaultDiscoveryService)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v1 = $result;
lbl39:
                // 2 sources

                $continuation.L$0 = null;
                $continuation.L$1 = null;
                $continuation.L$2 = null;
                $continuation.label = 3;
                v2 = CoroutineScopeKt.coroutineScope((Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>((Function0<Unit>)successReporter, (TypedWebsocketClient<DiscoveryMessage, DiscoveryMessage>)ws, this, null){
                    int label;
                    private /* synthetic */ Object L$0;
                    final /* synthetic */ Function0<Unit> $successReporter;
                    final /* synthetic */ TypedWebsocketClient<DiscoveryMessage, DiscoveryMessage> $ws;
                    final /* synthetic */ DefaultDiscoveryService this$0;
                    {
                        this.$successReporter = $successReporter;
                        this.$ws = $ws;
                        this.this$0 = $receiver;
                        super(2, $completion);
                    }

                    public final Object invokeSuspend(Object object) {
                        IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)object);
                                CoroutineScope $this$coroutineScope = (CoroutineScope)this.L$0;
                                BuildersKt.launch$default((CoroutineScope)$this$coroutineScope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.$ws, this.this$0, null){
                                    Object L$1;
                                    Object L$2;
                                    Object L$3;
                                    int label;
                                    private /* synthetic */ Object L$0;
                                    final /* synthetic */ TypedWebsocketClient<DiscoveryMessage, DiscoveryMessage> $ws;
                                    final /* synthetic */ DefaultDiscoveryService this$0;
                                    {
                                        this.$ws = $ws;
                                        this.this$0 = $receiver;
                                        super(2, $completion);
                                    }

                                    /*
                                     * WARNING - Removed try catching itself - possible behaviour change.
                                     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
                                     * Unable to fully structure code
                                     * Enabled aggressive block sorting
                                     * Enabled unnecessary exception pruning
                                     * Enabled aggressive exception aggregation
                                     */
                                    public final Object invokeSuspend(Object var1_1) {
                                        var15_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                        switch (this.label) {
                                            case 0: {
                                                ResultKt.throwOnFailure((Object)var1_1);
                                                $this$launch = (CoroutineScope)this.L$0;
                                                var3_4 = this.$ws.getIncomingMessages();
                                                var4_5 = this.this$0;
                                                $i$f$consumeEach = false;
                                                $this$consume$iv$iv = $this$consumeEach$iv;
                                                $i$f$consume = false;
                                                cause$iv$iv = null;
                                                try {
                                                    $this$consumeEach_u24lambda_u241$iv = $this$consume$iv$iv;
                                                    $i$a$-consume-ChannelsKt__Channels_commonKt$consumeEach$2$iv = false;
                                                    var11_14 = $this$consumeEach_u24lambda_u241$iv.iterator();
                                                }
                                                catch (Throwable e$iv$iv) {
                                                    try {
                                                        cause$iv$iv = e$iv$iv;
                                                        throw e$iv$iv;
                                                    }
                                                    catch (Throwable var9_12) {
                                                        ChannelsKt.cancelConsumed((ReceiveChannel)$this$consume$iv$iv, (Throwable)cause$iv$iv);
                                                        throw var9_12;
                                                    }
                                                }
lbl26:
                                                // 3 sources

                                                while (true) {
                                                    this.L$0 = $this$launch;
                                                    this.L$1 = var4_5;
                                                    this.L$2 = $this$consume$iv$iv;
                                                    this.L$3 = var11_14;
                                                    this.label = 1;
                                                    v0 = var11_14.hasNext((Continuation)this);
                                                    if (v0 == var15_2) {
                                                        return var15_2;
                                                    }
                                                    ** GOTO lbl48
                                                    break;
                                                }
                                            }
                                            case 1: {
                                                $i$f$consumeEach = false;
                                                $i$f$consume = false;
                                                $i$a$-consume-ChannelsKt__Channels_commonKt$consumeEach$2$iv = false;
                                                var11_14 = (ChannelIterator)this.L$3;
                                                cause$iv$iv = null;
                                                $this$consume$iv$iv = (ReceiveChannel)this.L$2;
                                                var4_5 = (DefaultDiscoveryService)this.L$1;
                                                $this$launch = (CoroutineScope)this.L$0;
                                                {
                                                    ResultKt.throwOnFailure((Object)$result);
                                                    v0 = $result;
lbl48:
                                                    // 2 sources

                                                    if (!((Boolean)v0).booleanValue()) ** GOTO lbl58
                                                    e$iv = var11_14.next();
                                                    it = (DiscoveryMessage)e$iv;
                                                    $i$a$-consumeEach-DefaultDiscoveryService$doDiscovery$2$1$1 = false;
                                                    if (!(it instanceof StationHello)) ** GOTO lbl55
                                                    DefaultDiscoveryService.access$getStateFlow$p(var4_5).setValue((Object)new StationConnection("", ((StationHello)it).getVersion(), ((StationHello)it).getKnownEndpoints()));
                                                    ** GOTO lbl26
lbl55:
                                                    // 1 sources

                                                    DefaultDiscoveryService.access$getLogger$cp().warn("Unexpected message from Toolbox discovery: " + it);
                                                    ** continue;
lbl58:
                                                    // 1 sources

                                                    $this$consumeEach_u24lambda_u241$iv = Unit.INSTANCE;
                                                }
                                                ChannelsKt.cancelConsumed((ReceiveChannel)$this$consume$iv$iv, (Throwable)cause$iv$iv);
                                                DefaultDiscoveryService.access$getStateFlow$p(this.this$0).setValue(null);
                                                JobKt.cancel$default((CoroutineContext)$this$launch.getCoroutineContext(), null, (int)1, null);
                                                return Unit.INSTANCE;
                                            }
                                        }
                                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                    }

                                    public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                        var var3_3 = new /* invalid duplicate definition of identical inner class */;
                                        var3_3.L$0 = value;
                                        return (Continuation)var3_3;
                                    }

                                    public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                    }
                                }), (int)3, null);
                                BuildersKt.launch$default((CoroutineScope)$this$coroutineScope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.$ws, this.this$0, null){
                                    int label;
                                    private /* synthetic */ Object L$0;
                                    final /* synthetic */ TypedWebsocketClient<DiscoveryMessage, DiscoveryMessage> $ws;
                                    final /* synthetic */ DefaultDiscoveryService this$0;
                                    {
                                        this.$ws = $ws;
                                        this.this$0 = $receiver;
                                        super(2, $completion);
                                    }

                                    /*
                                     * Unable to fully structure code
                                     */
                                    public final Object invokeSuspend(Object var1_1) {
                                        var3_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                        switch (this.label) {
                                            case 0: {
                                                ResultKt.throwOnFailure((Object)var1_1);
                                                $this$launch = (CoroutineScope)this.L$0;
lbl6:
                                                // 3 sources

                                                while (JobKt.isActive((CoroutineContext)$this$launch.getCoroutineContext())) {
                                                    DefaultDiscoveryService.access$getLogger$cp().debug("Sending status message to Toolbox");
                                                    this.L$0 = $this$launch;
                                                    this.label = 1;
                                                    v0 = this.$ws.send(DefaultDiscoveryService.access$buildStatus(this.this$0), (Continuation<Unit>)((Continuation)this));
                                                    if (v0 == var3_2) {
                                                        return var3_2;
                                                    }
                                                    ** GOTO lbl19
                                                }
                                                break;
                                            }
                                            case 1: {
                                                $this$launch = (CoroutineScope)this.L$0;
                                                ResultKt.throwOnFailure((Object)$result);
                                                v0 = $result;
lbl19:
                                                // 2 sources

                                                this.L$0 = $this$launch;
                                                this.label = 2;
                                                v1 = DelayKt.delay-VtjQ1oo((long)DefaultDiscoveryService.access$getStatusPeriod$p(this.this$0), (Continuation)((Continuation)this));
                                                if (v1 != var3_2) ** GOTO lbl6
                                                return var3_2;
                                            }
                                            case 2: {
                                                $this$launch = (CoroutineScope)this.L$0;
                                                ResultKt.throwOnFailure((Object)$result);
                                                v1 = $result;
                                                ** GOTO lbl6
                                            }
                                        }
                                        return Unit.INSTANCE;
                                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                    }

                                    public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                        var var3_3 = new /* invalid duplicate definition of identical inner class */;
                                        var3_3.L$0 = value;
                                        return (Continuation)var3_3;
                                    }

                                    public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                    }
                                }), (int)3, null);
                                DefaultDiscoveryService.access$getLogger$cp().info("Discovery connection successfully established");
                                this.$successReporter.invoke();
                                return Unit.INSTANCE;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                        var var3_3 = new /* invalid duplicate definition of identical inner class */;
                        var3_3.L$0 = value;
                        return (Continuation)var3_3;
                    }

                    public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }), (Continuation)$continuation);
                if (v2 == var6_5) {
                    return var6_5;
                }
                ** GOTO lbl50
            }
            case 3: {
                ResultKt.throwOnFailure((Object)$result);
                v2 = $result;
lbl50:
                // 2 sources

                return Unit.INSTANCE;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    private final IdeHello buildIdeHello() {
        BuildNumber buildNumber = ApplicationInfo.getInstance().getBuild();
        Intrinsics.checkNotNullExpressionValue((Object)buildNumber, (String)"getBuild(...)");
        BuildNumber build = buildNumber;
        long currentProcessId = ProcessHandle.current().pid();
        BuiltInServerManager builtinServer = BuiltInServerManager.Companion.getInstance();
        String toolboxToken = System.getProperty("toolbox.notification.token");
        CharSequence charSequence = toolboxToken;
        if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) {
            toolboxToken = UUID.randomUUID().toString();
            System.setProperty("toolbox.notification.token", toolboxToken);
        }
        IdeServicesHostApplication hostApplication = IdeServicesHostApplication.Companion.getInstance();
        String string = hostApplication.getIdeId();
        String string2 = build.getProductCode();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getProductCode(...)");
        String string3 = build.asStringWithoutProductCode();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"asStringWithoutProductCode(...)");
        Path path = hostApplication.getBindAddress().getPath();
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"getPath(...)");
        String string4 = ((Object)path).toString();
        List<String> list = hostApplication.getKnownEndpoints();
        int n = builtinServer.getPort();
        String string5 = PathManager.getHomePath();
        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"getHomePath(...)");
        return new IdeHello("1", string, string2, string3, currentProcessId, string4, list, new IntellijToolInformation(n, toolboxToken, string5));
    }

    /*
     * WARNING - void declaration
     */
    private final IdeStatus buildStatus() {
        Collection<IdeStatus.Project> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        IdeDiagnosticsService diagnosticsService = IdeDiagnosticsService.Companion.getInstance();
        boolean mainThreadFrozen = (Boolean)diagnosticsService.checkMainThreadStatus().component2();
        long l = Duration.getInWholeMilliseconds-impl((long)this.statusPeriod) * (long)2;
        boolean bl = !mainThreadFrozen && !diagnosticsService.isBackendUnresponsive();
        Project[] projectArray = ProjectManager.getInstance().getOpenProjects();
        Intrinsics.checkNotNullExpressionValue((Object)projectArray, (String)"getOpenProjects(...)");
        Object[] objectArray = projectArray;
        boolean bl2 = bl;
        long l2 = l;
        boolean $i$f$map = false;
        void var5_7 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(((void)$this$map$iv).length);
        boolean $i$f$mapTo = false;
        for (void item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Project project = (Project)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl3 = false;
            String string = it.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
            collection.add(new IdeStatus.Project(string, it.getBasePath()));
        }
        collection = (List)destination$iv$iv;
        IntelliJRemoteDevStatus intelliJRemoteDevStatus = DiscoveryRdInfoProviderExtension.Companion.getRemoteDevStatus$intellij_station_core();
        List list = collection;
        boolean bl4 = bl2;
        long l3 = l2;
        return new IdeStatus(l3, bl4, list, intelliJRemoteDevStatus);
    }

    public static final /* synthetic */ Object access$doDiscovery(DefaultDiscoveryService $this, Function0 successReporter, Continuation $completion) {
        return $this.doDiscovery((Function0<Unit>)successReporter, (Continuation<? super Unit>)$completion);
    }

    public static final /* synthetic */ MutableStateFlow access$getStateFlow$p(DefaultDiscoveryService $this) {
        return $this.stateFlow;
    }

    public static final /* synthetic */ Logger access$getLogger$cp() {
        return logger;
    }

    public static final /* synthetic */ IdeStatus access$buildStatus(DefaultDiscoveryService $this) {
        return $this.buildStatus();
    }

    public static final /* synthetic */ long access$getStatusPeriod$p(DefaultDiscoveryService $this) {
        return $this.statusPeriod;
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(DefaultDiscoveryService.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        DefaultDiscoveryService.logger = logger;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/intellij/station/core/discovery/DefaultDiscoveryService$Companion;", "", "<init>", "()V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "intellij.station.core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

