/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ssh.config;

import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.configurations.PathEnvironmentVariableUtil;
import com.intellij.execution.process.KillableProcessHandler;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.remote.SshConnectionConfigPatch;
import com.intellij.ssh.OpenSshLikeHostKeyVerifier;
import com.intellij.ssh.SshHostKeyVerifier;
import com.intellij.ssh.X11Forwarding;
import com.intellij.ssh.config.AuthMethod;
import com.intellij.ssh.config.AuthMethods;
import com.intellij.ssh.config.EnvironmentVariable;
import com.intellij.ssh.config.IdentityAgent;
import com.intellij.ssh.config.OpenSSHConfigUtil;
import com.intellij.ssh.config.OpenSshConfigForwardInfo;
import com.intellij.ssh.config.OpenSshConfigViaToolService;
import com.intellij.ssh.config.ParsingError;
import com.intellij.ssh.config.ProxyJumpOptions;
import com.intellij.ssh.config.ServerAlive;
import com.intellij.ssh.config.SshConfigParseException;
import com.intellij.ssh.config.SshConnectionConfig;
import com.intellij.ssh.config.SshConnectionConfigKt;
import com.intellij.ssh.config.SshProxyConfig;
import com.intellij.ssh.config.ToolResult;
import com.intellij.util.SmartList;
import com.intellij.util.SystemProperties;
import java.io.File;
import java.nio.file.Path;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.Grouping;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000\\\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\u001a(\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u000e\u0010\u0004\u001a\n\u0012\u0004\u0012\u00020\u0003\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0003H\u0007\u001a*\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00032\u000e\u0010\u0004\u001a\n\u0012\u0004\u0012\u00020\u0003\u0018\u00010\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0003H\u0002\u001a$\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\r2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u000e\u001a\u00020\u000fH\u0002\u001a;\u0010\u0010\u001a\u00020\u0011*\u0018\u0012\u0004\u0012\u00020\u0003\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00050\bj\u0002`\u00122\u0006\u0010\u0013\u001a\u00020\u00032\n\b\u0002\u0010\u0014\u001a\u0004\u0018\u00010\u0011H\u0002\u00a2\u0006\u0002\u0010\u0015\u001a*\u0010\u0016\u001a\u00020\u0003*\u0018\u0012\u0004\u0012\u00020\u0003\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00050\bj\u0002`\u00122\u0006\u0010\u0013\u001a\u00020\u0003H\u0002\u001a8\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005*\u0018\u0012\u0004\u0012\u00020\u0003\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00050\bj\u0002`\u00122\u0006\u0010\u0013\u001a\u00020\u00032\u0006\u0010\u0018\u001a\u00020\u0011H\u0002\u001a:\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005*\u0018\u0012\u0004\u0012\u00020\u0003\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00050\bj\u0002`\u00122\u0006\u0010\u0013\u001a\u00020\u00032\b\b\u0002\u0010\u0018\u001a\u00020\u0011H\u0002\u001a1\u0010\u001a\u001a\u0004\u0018\u00010\u001b*\u0018\u0012\u0004\u0012\u00020\u0003\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00050\bj\u0002`\u00122\u0006\u0010\u0013\u001a\u00020\u0003H\u0002\u00a2\u0006\u0002\u0010\u001c\u001a\u001a\u0010\u001d\u001a\u0004\u0018\u00010\u001e2\u0006\u0010\u001f\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u0003H\u0002\u001a\u0010\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020\u0003H\u0002\u001a\u001c\u0010#\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\r2\u0006\u0010\"\u001a\u00020\u0003H\u0002\"\u001b\u0010$\u001a\u00020%8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b(\u0010)\u001a\u0004\b&\u0010'*0\b\u0002\u0010\u0007\"\u0014\u0012\u0004\u0012\u00020\u0003\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00050\b2\u0014\u0012\u0004\u0012\u00020\u0003\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00050\b\u00a8\u0006*"}, d2={"openSshConfigViaTool", "Lcom/intellij/ssh/config/SshConnectionConfig;", "host", "", "customSshCommand", "", "userHome", "MultiMap", "", "openSshConfigViaToolImpl", "Lcom/intellij/ssh/config/ToolResult;", "initialHost", "runToolAndGetStdio", "Lkotlin/Pair;", "sshGCommandLine", "Lcom/intellij/execution/configurations/GeneralCommandLine;", "yesNo", "", "Lcom/intellij/ssh/config/MultiMap;", "key", "default", "(Ljava/util/Map;Ljava/lang/String;Ljava/lang/Boolean;)Z", "singleString", "singleCommaDelimited", "obligatory", "singleSpaceDelimited", "longOrNone", "", "(Ljava/util/Map;Ljava/lang/String;)Ljava/lang/Long;", "parsePath", "Ljava/nio/file/Path;", "path", "parseForward", "Lcom/intellij/ssh/config/OpenSshConfigForwardInfo;", "raw", "splitEq", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "getLOG", "()Lcom/intellij/openapi/diagnostic/Logger;", "LOG$delegate", "Lkotlin/Lazy;", "intellij.platform.ssh"})
@SourceDebugExtension(value={"SMAP\nOpenSshConfigViaToolService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OpenSshConfigViaToolService.kt\ncom/intellij/ssh/config/OpenSshConfigViaToolServiceKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 4 Grouping.kt\nkotlin/collections/GroupingKt__GroupingKt\n+ 5 extensions.kt\ncom/intellij/openapi/util/ExtensionsKt\n+ 6 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 7 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,493:1\n1#2:494\n1#2:525\n1#2:544\n1#2:557\n1059#3:495\n80#4,6:496\n22#5,2:502\n26#5,2:513\n61#6,5:504\n68#6,4:509\n14#6:572\n1611#7,9:515\n1863#7:524\n1864#7:526\n1620#7:527\n1010#7,2:528\n1557#7:530\n1628#7,3:531\n1611#7,9:534\n1863#7:543\n1864#7:545\n1620#7:546\n1611#7,9:547\n1863#7:556\n1864#7:558\n1620#7:559\n1557#7:560\n1628#7,3:561\n1557#7:564\n1628#7,3:565\n1557#7:568\n1628#7,3:569\n*S KotlinDebug\n*F\n+ 1 OpenSshConfigViaToolService.kt\ncom/intellij/ssh/config/OpenSshConfigViaToolServiceKt\n*L\n194#1:525\n238#1:544\n263#1:557\n154#1:495\n155#1:496,6\n379#1:502,2\n379#1:513,2\n404#1:504,5\n409#1:509,4\n491#1:572\n194#1:515,9\n194#1:524\n194#1:526\n194#1:527\n214#1:528,2\n234#1:530\n234#1:531,3\n238#1:534,9\n238#1:543\n238#1:545\n238#1:546\n263#1:547,9\n263#1:556\n263#1:558\n263#1:559\n264#1:560\n264#1:561,3\n290#1:564\n290#1:565,3\n295#1:568\n295#1:569,3\n*E\n"})
public final class OpenSshConfigViaToolServiceKt {
    @NotNull
    private static final Lazy LOG$delegate = LazyKt.lazy(OpenSshConfigViaToolServiceKt::LOG_delegate$lambda$55);

    @TestOnly
    @NotNull
    public static final SshConnectionConfig openSshConfigViaTool(@NotNull String host, @Nullable List<String> customSshCommand, @NotNull String userHome) {
        Intrinsics.checkNotNullParameter((Object)host, (String)"host");
        Intrinsics.checkNotNullParameter((Object)userHome, (String)"userHome");
        return OpenSshConfigViaToolServiceKt.openSshConfigViaToolImpl(host, customSshCommand, userHome).getResult();
    }

    /*
     * WARNING - void declaration
     */
    private static final ToolResult openSshConfigViaToolImpl(String initialHost, List<String> customSshCommand, String userHome) {
        Object v;
        CharSequence charSequence;
        Object object;
        int port;
        List<String> macs;
        List<String> kexAlgorithms;
        List<OpenSshConfigForwardInfo> initialRemoteTcpForwardings;
        List<OpenSshConfigForwardInfo> initialLocalTcpForwardings;
        SshHostKeyVerifier hostKeyVerifier;
        List<String> hostKeyAlgorithms;
        boolean forwardAgent;
        List environmentVariables;
        Duration connectTimeout;
        boolean compression;
        List<String> ciphers;
        AuthMethods authMethods;
        IdentityAgent identityAgent;
        String host;
        String user;
        SshConnectionConfig fallback;
        Set errors;
        void keyValue;
        String rawStderr;
        String rawStdout;
        GeneralCommandLine sshGCommandLine;
        block14: {
            block13: {
                IdentityAgent identityAgent2;
                void destination$iv;
                void $this$aggregateTo$iv;
                Grouping $this$groupingBy$iv;
                boolean bl = false;
                List cmd = new ArrayList();
                Collection collection = cmd;
                List<String> list = customSshCommand;
                if (list == null) {
                    List<String> list2;
                    Object object2 = PathEnvironmentVariableUtil.findInPath((String)"ssh");
                    if (object2 != null && (object2 = ((File)object2).getAbsolutePath()) != null) {
                        Object p0 = object2;
                        boolean bl2 = false;
                        boolean $i$f$openSshConfigViaToolImpl$lambda$0$stub_for_inlining = false;
                        list2 = CollectionsKt.listOf((Object)p0);
                    } else {
                        list2 = list = null;
                    }
                    if (list2 == null) {
                        throw new SshConfigParseException("Can't find 'ssh' tool");
                    }
                }
                Iterable iterable = list;
                CollectionsKt.addAll((Collection)collection, (Iterable)iterable);
                ((Collection)cmd).add("-G");
                ((Collection)cmd).add("-vvv");
                ((Collection)cmd).add(initialHost);
                sshGCommandLine = new GeneralCommandLine(cmd);
                Pair<String, String> pair = OpenSshConfigViaToolServiceKt.runToolAndGetStdio(initialHost, sshGCommandLine);
                rawStdout = (String)pair.component1();
                rawStderr = (String)pair.component2();
                Sequence bl2 = SequencesKt.mapNotNull((Sequence)StringsKt.lineSequence((CharSequence)rawStdout), OpenSshConfigViaToolServiceKt::openSshConfigViaToolImpl$lambda$1);
                boolean $i$f$groupingBy22 = false;
                $this$groupingBy$iv = (Grouping)new Grouping<Pair<? extends String, ? extends String>, String>((Sequence)$this$groupingBy$iv){
                    final /* synthetic */ Sequence $this_groupingBy;
                    {
                        this.$this_groupingBy = $receiver;
                    }

                    public Iterator<Pair<? extends String, ? extends String>> sourceIterator() {
                        return this.$this_groupingBy.iterator();
                    }

                    /*
                     * Ignored method signature, as it can't be verified against descriptor
                     */
                    public Object keyOf(Object element) {
                        Pair pair = (Pair)element;
                        boolean bl = false;
                        String key = (String)pair.component1();
                        String string = key.toLowerCase(Locale.ROOT);
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
                        return string;
                    }
                };
                Map $i$f$groupingBy22 = new HashMap();
                boolean $i$f$aggregateTo = false;
                Iterator iterator = $this$aggregateTo$iv.sourceIterator();
                while (iterator.hasNext()) {
                    void var21_27;
                    void accumulator;
                    Object e$iv = iterator.next();
                    Object key$iv = $this$aggregateTo$iv.keyOf(e$iv);
                    Object accumulator$iv = destination$iv.get(key$iv);
                    if (accumulator$iv != null || !destination$iv.containsKey(key$iv)) {
                        // empty if block
                    }
                    Pair pair2 = (Pair)e$iv;
                    SmartList smartList = (SmartList)accumulator$iv;
                    String cfr_ignored_0 = (String)key$iv;
                    Object object3 = key$iv;
                    void var33_31 = destination$iv;
                    boolean bl3 = false;
                    String element = (String)pair2.component2();
                    SmartList smartList2 = accumulator;
                    if (smartList2 == null) {
                        smartList2 = new SmartList();
                    }
                    void $this$openSshConfigViaToolImpl_u24lambda_u244_u24lambda_u243 = var21_27 = smartList2;
                    boolean bl4 = false;
                    $this$openSshConfigViaToolImpl_u24lambda_u244_u24lambda_u243.add((Object)element);
                    void var35_33 = var21_27;
                    var33_31.put(object3, var35_33);
                }
                keyValue = destination$iv;
                errors = new LinkedHashSet();
                fallback = new SshConnectionConfig(initialHost);
                user = OpenSshConfigViaToolServiceKt.openSshConfigViaToolImpl$catching(errors, fallback.getUser(), () -> OpenSshConfigViaToolServiceKt.openSshConfigViaToolImpl$lambda$5((Map)keyValue));
                host = OpenSshConfigViaToolServiceKt.openSshConfigViaToolImpl$catching(errors, fallback.getHost(), () -> OpenSshConfigViaToolServiceKt.openSshConfigViaToolImpl$lambda$6((Map)keyValue));
                Object object4 = (List)keyValue.get("identityagent");
                if (object4 != null && (object4 = (String)CollectionsKt.singleOrNull((List)object4)) != null) {
                    Object p0 = object4;
                    boolean $i$f$openSshConfigViaToolImpl$stub_for_inlining$7 = false;
                    boolean bl5 = false;
                    identityAgent2 = new IdentityAgent((String)p0);
                } else {
                    identityAgent2 = null;
                }
                identityAgent = identityAgent2;
                authMethods = OpenSshConfigViaToolServiceKt.openSshConfigViaToolImpl$catching(errors, fallback.getAuthMethods(), () -> OpenSshConfigViaToolServiceKt.openSshConfigViaToolImpl$lambda$12((Map)keyValue, identityAgent, userHome));
                ciphers = OpenSshConfigViaToolServiceKt.openSshConfigViaToolImpl$catching(errors, fallback.getCiphers(), () -> OpenSshConfigViaToolServiceKt.openSshConfigViaToolImpl$lambda$13((Map)keyValue));
                compression = OpenSshConfigViaToolServiceKt.openSshConfigViaToolImpl$catching(errors, fallback.getCompression(), () -> OpenSshConfigViaToolServiceKt.openSshConfigViaToolImpl$lambda$14((Map)keyValue));
                connectTimeout = OpenSshConfigViaToolServiceKt.openSshConfigViaToolImpl$catching(errors, fallback.getConnectTimeout(), () -> OpenSshConfigViaToolServiceKt.openSshConfigViaToolImpl$lambda$16((Map)keyValue));
                environmentVariables = OpenSshConfigViaToolServiceKt.openSshConfigViaToolImpl$catching(errors, CollectionsKt.emptyList(), () -> OpenSshConfigViaToolServiceKt.openSshConfigViaToolImpl$lambda$20((Map)keyValue, errors));
                forwardAgent = OpenSshConfigViaToolServiceKt.openSshConfigViaToolImpl$catching(errors, fallback.getForwardAgent(), () -> OpenSshConfigViaToolServiceKt.openSshConfigViaToolImpl$lambda$21((Map)keyValue));
                hostKeyAlgorithms = OpenSshConfigViaToolServiceKt.openSshConfigViaToolImpl$catching(errors, fallback.getHostKeyAlgorithms(), () -> OpenSshConfigViaToolServiceKt.openSshConfigViaToolImpl$lambda$22((Map)keyValue));
                hostKeyVerifier = OpenSshConfigViaToolServiceKt.openSshConfigViaToolImpl$catching(errors, fallback.getHostKeyVerifier(), () -> OpenSshConfigViaToolServiceKt.openSshConfigViaToolImpl$lambda$28((Map)keyValue, userHome));
                initialLocalTcpForwardings = OpenSshConfigViaToolServiceKt.openSshConfigViaToolImpl$catching(errors, fallback.getInitialLocalTcpForwardings(), () -> OpenSshConfigViaToolServiceKt.openSshConfigViaToolImpl$lambda$30((Map)keyValue));
                initialRemoteTcpForwardings = OpenSshConfigViaToolServiceKt.openSshConfigViaToolImpl$catching(errors, fallback.getInitialRemoteTcpForwardings(), () -> OpenSshConfigViaToolServiceKt.openSshConfigViaToolImpl$lambda$32((Map)keyValue));
                kexAlgorithms = OpenSshConfigViaToolServiceKt.openSshConfigViaToolImpl$catching(errors, fallback.getKexAlgorithms(), () -> OpenSshConfigViaToolServiceKt.openSshConfigViaToolImpl$lambda$33((Map)keyValue));
                macs = OpenSshConfigViaToolServiceKt.openSshConfigViaToolImpl$catching(errors, fallback.getMacs(), () -> OpenSshConfigViaToolServiceKt.openSshConfigViaToolImpl$lambda$34((Map)keyValue));
                port = ((Number)OpenSshConfigViaToolServiceKt.openSshConfigViaToolImpl$catching(errors, fallback.getPort(), () -> OpenSshConfigViaToolServiceKt.openSshConfigViaToolImpl$lambda$36((Map)keyValue))).intValue();
                boolean bl6 = false;
                object = (List)keyValue.get("proxyjump");
                if (object == null || (object = (String)CollectionsKt.singleOrNull((List)object)) == null) break block13;
                Object p0 = object;
                boolean bl7 = false;
                boolean $i$f$openSshConfigViaToolImpl$lambda$38$stub_for_inlining$37 = false;
                ProxyJumpOptions proxyJumpOptions = OpenSSHConfigUtil.parseJump((String)p0);
                object = proxyJumpOptions;
                if (proxyJumpOptions != null && (object = OpenSSHConfigUtil.toProxyCommand((ProxyJumpOptions)object)) != null) break block14;
            }
            List list = (List)keyValue.get("proxycommand");
            object = list != null ? (String)CollectionsKt.singleOrNull((List)list) : null;
        }
        SshProxyConfig.Command proxyConfig = (charSequence = (CharSequence)(v = object)) == null || charSequence.length() == 0 ? null : new SshProxyConfig.Command((String)v);
        ServerAlive serverAlive = OpenSshConfigViaToolServiceKt.openSshConfigViaToolImpl$catching(errors, fallback.getServerAlive(), () -> OpenSshConfigViaToolServiceKt.openSshConfigViaToolImpl$lambda$41((Map)keyValue));
        X11Forwarding x11Forwarding = OpenSshConfigViaToolServiceKt.openSshConfigViaToolImpl$catching(errors, fallback.getX11Forwarding(), () -> OpenSshConfigViaToolServiceKt.openSshConfigViaToolImpl$lambda$42((Map)keyValue));
        if (!((Collection)errors).isEmpty()) {
            String string = "Got errors while was parsing output of `" + sshGCommandLine.getCommandLineString() + "`\n";
            String string2 = CollectionsKt.joinToString$default((Iterable)errors, (CharSequence)"\n", (CharSequence)string, null, (int)0, null, null, (int)60, null);
            string = new Attachment[]{new Attachment("stdout.txt", rawStdout), new Attachment("stderr.txt", rawStderr)};
            OpenSshConfigViaToolServiceKt.getLOG().error(string2, (Attachment[])string);
        }
        SshConnectionConfig sshConnectionConfig = new SshConnectionConfig(authMethods, ciphers, compression, connectTimeout, forwardAgent, environmentVariables, host, hostKeyAlgorithms, hostKeyVerifier, identityAgent, initialLocalTcpForwardings, initialRemoteTcpForwardings, kexAlgorithms, macs, port, proxyConfig, serverAlive, user, x11Forwarding);
        String string = sshGCommandLine.getCommandLineString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getCommandLineString(...)");
        return new ToolResult(sshConnectionConfig, rawStdout, rawStderr, string);
    }

    static /* synthetic */ ToolResult openSshConfigViaToolImpl$default(String string, List list, String string2, int n, Object object) {
        if ((n & 4) != 0) {
            string2 = SystemProperties.getUserHome();
        }
        return OpenSshConfigViaToolServiceKt.openSshConfigViaToolImpl(string, list, string2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final Pair<String, String> runToolAndGetStdio(String host, GeneralCommandLine sshGCommandLine) {
        Pair pair;
        Disposable $this$use$iv = Disposer.newDisposable((String)("Read ssh_config for " + host + " via OpenSSH"));
        boolean $i$f$use = false;
        try {
            Integer exitCode;
            String string;
            Logger logger;
            String string2;
            Disposable disposable = $this$use$iv;
            boolean bl = false;
            StringBuilder stdoutBuilder = new StringBuilder();
            KillableProcessHandler process = new KillableProcessHandler(sshGCommandLine);
            StringBuilder stderrBuilder = new StringBuilder();
            process.addProcessListener((ProcessListener)new ProcessAdapter(stdoutBuilder, stderrBuilder){
                final /* synthetic */ StringBuilder $stdoutBuilder;
                final /* synthetic */ StringBuilder $stderrBuilder;
                {
                    this.$stdoutBuilder = $stdoutBuilder;
                    this.$stderrBuilder = $stderrBuilder;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void onTextAvailable(ProcessEvent event, Key<?> outputType) {
                    StringBuilder destination;
                    Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                    Intrinsics.checkNotNullParameter(outputType, (String)"outputType");
                    Object object = outputType;
                    StringBuilder stringBuilder = Intrinsics.areEqual(object, (Object)ProcessOutputTypes.STDOUT) ? this.$stdoutBuilder : (destination = Intrinsics.areEqual(object, (Object)ProcessOutputTypes.STDERR) ? this.$stderrBuilder : null);
                    if (destination != null) {
                        object = destination;
                        synchronized (object) {
                            boolean bl = false;
                            StringBuilder stringBuilder2 = destination.append(event.getText());
                        }
                    }
                }
            }, disposable);
            process.startNotify();
            int durationSeconds = 10;
            process.waitFor((long)durationSeconds * 1000L);
            StringBuilder stringBuilder = stderrBuilder;
            synchronized (stringBuilder) {
                boolean $i$a$-synchronized-OpenSshConfigViaToolServiceKt$runToolAndGetStdio$1$stderr$22 = false;
                String $i$a$-synchronized-OpenSshConfigViaToolServiceKt$runToolAndGetStdio$1$stderr$22 = stderrBuilder.toString();
                // MONITOREXIT @DISABLED, blocks:[0, 1, 3] lbl21 : MonitorExitStatement: MONITOREXIT : var10_11
                string2 = $i$a$-synchronized-OpenSshConfigViaToolServiceKt$runToolAndGetStdio$1$stderr$22;
            }
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"synchronized(...)");
            String stderr = string2;
            if (!StringsKt.isBlank((CharSequence)stderr)) {
                Logger $this$debug_u24default$iv = OpenSshConfigViaToolServiceKt.getLOG();
                Throwable e$iv = null;
                boolean $i$f$debug = false;
                if ($this$debug_u24default$iv.isDebugEnabled()) {
                    logger = $this$debug_u24default$iv;
                    boolean bl2 = false;
                    logger.debug("stderr of " + process.getCommandLine() + ":\n" + stderr, e$iv);
                }
            }
            StringBuilder $i$f$debug = stdoutBuilder;
            synchronized ($i$f$debug) {
                boolean $i$a$-synchronized-OpenSshConfigViaToolServiceKt$runToolAndGetStdio$1$stdout$22 = false;
                String $i$a$-synchronized-OpenSshConfigViaToolServiceKt$runToolAndGetStdio$1$stdout$22 = stdoutBuilder.toString();
                // MONITOREXIT @DISABLED, blocks:[0, 2, 4] lbl44 : MonitorExitStatement: MONITOREXIT : $i$f$debug
                string = $i$a$-synchronized-OpenSshConfigViaToolServiceKt$runToolAndGetStdio$1$stdout$22;
            }
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"synchronized(...)");
            String stdout = string;
            Logger $this$trace$iv = OpenSshConfigViaToolServiceKt.getLOG();
            boolean $i$f$trace = false;
            if ($this$trace$iv.isTraceEnabled()) {
                logger = $this$trace$iv;
                boolean bl3 = false;
                logger.trace("stdout of " + process.getCommandLine() + ":\n" + stdout);
            }
            Integer n = process.getExitCode();
            if (n != null && n == 0) {
                TuplesKt.to((Object)stdout, (Object)stderr);
            }
            Integer n2 = exitCode = process.getExitCode();
            if (n2 == null || n2 != 0) {
                if (exitCode == null) {
                    process.killProcess();
                    String string3 = process.getCommandLine();
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getCommandLine(...)");
                    throw new SshConfigParseException(string3, null, stderr);
                }
                String string4 = process.getCommandLine();
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"getCommandLine(...)");
                throw new SshConfigParseException(string4, exitCode, stderr);
            }
            pair = TuplesKt.to((Object)stdout, (Object)stderr);
        }
        finally {
            if ($this$use$iv != null) {
                Disposer.dispose((Disposable)$this$use$iv);
            }
        }
        return pair;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean yesNo(Map<String, ? extends List<String>> $this$yesNo, String key, Boolean bl) {
        String value;
        String string;
        List<String> list = $this$yesNo.get(key);
        if (list != null && (list = (String)CollectionsKt.singleOrNull(list)) != null) {
            String string2 = ((String)((Object)list)).toLowerCase(Locale.ROOT);
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
        } else {
            string = null;
        }
        String string3 = value = string;
        if (string3 != null) {
            switch (string3.hashCode()) {
                case 3521: {
                    if (value.equals("no")) return false;
                    throw new ParsingError("Value of `" + key + "` is `" + value + "`, which is neither `yes`, nor `no`");
                }
                case 119527: {
                    if (value.equals("yes")) return true;
                    throw new ParsingError("Value of `" + key + "` is `" + value + "`, which is neither `yes`, nor `no`");
                }
                case 3569038: {
                    if (value.equals("true")) return true;
                    throw new ParsingError("Value of `" + key + "` is `" + value + "`, which is neither `yes`, nor `no`");
                }
                case 97196323: {
                    if (value.equals("false")) return false;
                    throw new ParsingError("Value of `" + key + "` is `" + value + "`, which is neither `yes`, nor `no`");
                }
            }
            throw new ParsingError("Value of `" + key + "` is `" + value + "`, which is neither `yes`, nor `no`");
        }
        Boolean bl2 = bl;
        if (bl2 == null) throw new ParsingError("Value of `" + key + "` is not set, while expected `yes` or `no`");
        boolean bl3 = bl2;
        return bl3;
    }

    static /* synthetic */ boolean yesNo$default(Map map, String string, Boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = null;
        }
        return OpenSshConfigViaToolServiceKt.yesNo(map, string, bl);
    }

    private static final String singleString(Map<String, ? extends List<String>> $this$singleString, String key) {
        List<String> list = $this$singleString.get(key);
        if (list == null || (list = (String)CollectionsKt.singleOrNull(list)) == null) {
            throw new ParsingError("No single `" + key + "` in output");
        }
        return list;
    }

    private static final List<String> singleCommaDelimited(Map<String, ? extends List<String>> $this$singleCommaDelimited, String key, boolean obligatory) {
        char[] cArray;
        List<String> list = $this$singleCommaDelimited.get(key);
        if (list == null || (list = (String)CollectionsKt.singleOrNull(list)) == null || (list = StringsKt.split$default((CharSequence)((CharSequence)((Object)list)), (char[])(cArray = new char[]{','}), (boolean)false, (int)0, (int)6, null)) == null) {
            List list2;
            List it = list2 = CollectionsKt.emptyList();
            boolean bl = false;
            list = !obligatory ? list2 : null;
            if (list == null) {
                throw new ParsingError("No single `" + key + "` in output");
            }
        }
        return list;
    }

    private static final List<String> singleSpaceDelimited(Map<String, ? extends List<String>> $this$singleSpaceDelimited, String key, boolean obligatory) {
        char[] cArray;
        List<String> list = $this$singleSpaceDelimited.get(key);
        if (list == null || (list = (String)CollectionsKt.singleOrNull(list)) == null || (list = StringsKt.split$default((CharSequence)((CharSequence)((Object)list)), (char[])(cArray = new char[]{' '}), (boolean)false, (int)0, (int)6, null)) == null) {
            List list2;
            List it = list2 = CollectionsKt.emptyList();
            boolean bl = false;
            list = !obligatory ? list2 : null;
            if (list == null) {
                throw new ParsingError("No single `" + key + "` in output");
            }
        }
        return list;
    }

    static /* synthetic */ List singleSpaceDelimited$default(Map map, String string, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = true;
        }
        return OpenSshConfigViaToolServiceKt.singleSpaceDelimited(map, string, bl);
    }

    private static final Long longOrNone(Map<String, ? extends List<String>> $this$longOrNone, String key) {
        Long l;
        List<String> list;
        block7: {
            block6: {
                list = $this$longOrNone.get(key);
                if (list == null || (list = (String)CollectionsKt.singleOrNull(list)) == null) break block6;
                String string = ((String)((Object)list)).toLowerCase(Locale.ROOT);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
                list = string;
                if (string != null) break block7;
            }
            throw new ParsingError("No single `" + key + "` in output");
        }
        List<String> raw = list;
        if (Intrinsics.areEqual((Object)raw, (Object)"none")) {
            l = null;
        } else {
            Long l2 = StringsKt.toLongOrNull((String)((Object)raw));
            if (l2 == null) {
                throw new ParsingError("Key `" + key + "` doesn't contain a long");
            }
            l = (long)l2;
        }
        return l;
    }

    private static final Path parsePath(String path, String userHome) {
        Path path2;
        try {
            Object object;
            if (StringsKt.startsWith$default((String)path, (String)"~/", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)path, (String)"~\\", (boolean)false, (int)2, null)) {
                String string = path.substring(1);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                object = userHome + string;
            } else {
                object = path;
            }
            path2 = Path.of((String)object, new String[0]);
        }
        catch (IllegalArgumentException err) {
            OpenSshConfigViaToolServiceKt.getLOG().warn("Failed to parse path " + path);
            path2 = null;
        }
        return path2;
    }

    private static final OpenSshConfigForwardInfo parseForward(String raw) {
        Object object;
        try {
            OpenSshConfigForwardInfo openSshConfigForwardInfo;
            List list;
            boolean bl = false;
            MatchResult matchResult = new Regex("(?:\\[(.*)]:)?(\\d+) \\[(.*)]:?(\\d+)").matchEntire((CharSequence)raw);
            if (matchResult != null && (list = matchResult.getGroupValues()) != null) {
                String string;
                List list2 = list;
                boolean bl2 = false;
                String bindHost = (String)list2.get(1);
                String bindPort = (String)list2.get(2);
                String host = (String)list2.get(3);
                String port = (String)list2.get(4);
                String p0 = string = bindHost;
                boolean bl3 = false;
                boolean $i$f$parseForward$lambda$53$lambda$52$stub_for_inlining$50 = false;
                String string2 = ((CharSequence)p0).length() > 0 ? string : null;
                if (string2 == null) {
                    string2 = "127.0.0.1";
                }
                p0 = string = host;
                int n = Integer.parseInt(bindPort);
                String string3 = string2;
                boolean bl4 = false;
                boolean $i$f$parseForward$lambda$53$lambda$52$stub_for_inlining$51 = false;
                boolean bl5 = ((CharSequence)p0).length() > 0;
                String string4 = bl5 ? string : null;
                if (string4 == null) {
                    string4 = "127.0.0.1";
                }
                int n2 = Integer.parseInt(port);
                String string5 = string4;
                int n3 = n;
                String string6 = string3;
                openSshConfigForwardInfo = new OpenSshConfigForwardInfo(string6, n3, string5, n2);
            } else {
                openSshConfigForwardInfo = null;
            }
            object = Result.constructor-impl(openSshConfigForwardInfo);
        }
        catch (Throwable throwable) {
            object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
        OpenSshConfigForwardInfo openSshConfigForwardInfo = (OpenSshConfigForwardInfo)(Result.isFailure-impl((Object)object) ? null : object);
        if (openSshConfigForwardInfo == null) {
            throw new ParsingError("Failed to parse port forwarding `" + raw + "`");
        }
        return openSshConfigForwardInfo;
    }

    private static final Pair<String, String> splitEq(String raw) {
        Object object = new char[]{'='};
        char[] it = object = (Object)StringsKt.split$default((CharSequence)raw, (char[])object, (boolean)false, (int)2, (int)2, null);
        boolean bl = false;
        char[] cArray = it.size() == 2 ? object : null;
        if (cArray == null) {
            throw new ParsingError("Failed to find '=' in " + raw);
        }
        char[] cArray2 = cArray;
        String k = (String)cArray2.get(0);
        String v = (String)cArray2.get(1);
        return TuplesKt.to((Object)k, (Object)v);
    }

    private static final Logger getLOG() {
        Lazy lazy = LOG$delegate;
        return (Logger)lazy.getValue();
    }

    private static final Pair openSshConfigViaToolImpl$lambda$1(String line) {
        Intrinsics.checkNotNullParameter((Object)line, (String)"line");
        char[] cArray = new char[]{' '};
        List split = StringsKt.split$default((CharSequence)line, (char[])cArray, (boolean)false, (int)2, (int)2, null);
        return switch (split.size()) {
            case 0 -> null;
            case 1 -> TuplesKt.to(split.get(0), (Object)"");
            default -> TuplesKt.to(split.get(0), split.get(1));
        };
    }

    private static final <T> T openSshConfigViaToolImpl$catching(Set<String> errors, T fallbackValue, Function0<? extends T> handler) {
        Object object;
        try {
            object = handler.invoke();
        }
        catch (ParsingError err) {
            Collection collection = errors;
            String string = err.getMessage();
            Intrinsics.checkNotNull((Object)string);
            collection.add(string);
            object = fallbackValue;
        }
        return (T)object;
    }

    private static final String openSshConfigViaToolImpl$lambda$5(Map $keyValue) {
        return OpenSshConfigViaToolServiceKt.singleString($keyValue, "user");
    }

    private static final String openSshConfigViaToolImpl$lambda$6(Map $keyValue) {
        return OpenSshConfigViaToolServiceKt.singleString($keyValue, "hostname");
    }

    private static final boolean openSshConfigViaToolImpl$lambda$12$lambda$9(List $preferredAuthentications, AuthMethod it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return !$preferredAuthentications.contains(SshConnectionConfigKt.getOpenSshLabel(it));
    }

    private static final boolean openSshConfigViaToolImpl$lambda$12$lambda$10(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    /*
     * WARNING - void declaration
     */
    private static final AuthMethods openSshConfigViaToolImpl$lambda$12(Map $keyValue, IdentityAgent $identityAgent, String $userHome) {
        List<String> preferredAuthentications;
        List methods = new ArrayList();
        if (OpenSshConfigViaToolServiceKt.yesNo($keyValue, "gssapiauthentication", false)) {
            ((Collection)methods).add(AuthMethod.GssApi.INSTANCE);
        }
        if (OpenSshConfigViaToolServiceKt.yesNo$default($keyValue, "pubkeyauthentication", null, 2, null)) {
            List list;
            List list2 = (List)$keyValue.get("identityfile");
            if (list2 != null) {
                void $this$mapNotNullTo$iv$iv;
                Iterable $this$mapNotNull$iv = list2;
                boolean $i$f$mapNotNull = false;
                Iterable iterable = $this$mapNotNull$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$mapNotNullTo = false;
                void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                boolean $i$f$forEach = false;
                Iterator iterator = $this$forEach$iv$iv$iv.iterator();
                while (iterator.hasNext()) {
                    Path it$iv$iv;
                    Object element$iv$iv$iv;
                    Object element$iv$iv = element$iv$iv$iv = iterator.next();
                    boolean bl = false;
                    String it = (String)element$iv$iv;
                    boolean bl2 = false;
                    if (OpenSshConfigViaToolServiceKt.parsePath(it, $userHome) == null) continue;
                    boolean bl3 = false;
                    destination$iv$iv.add(it$iv$iv);
                }
                list = (List)destination$iv$iv;
            } else {
                list = CollectionsKt.emptyList();
            }
            List identityFiles = list;
            IdentityAgent identityAgent = $identityAgent;
            ((Collection)methods).add(new AuthMethod.PublicKey(identityFiles, (identityAgent != null ? identityAgent.getType() : null) == IdentityAgent.Type.NONE ? AuthMethod.PublicKey.Agent.NO : (OpenSshConfigViaToolServiceKt.yesNo$default($keyValue, "identitiesonly", null, 2, null) ? AuthMethod.PublicKey.Agent.ONLY_MENTIONED : AuthMethod.PublicKey.Agent.ALL)));
        }
        if (OpenSshConfigViaToolServiceKt.yesNo$default($keyValue, "passwordauthentication", null, 2, null)) {
            ((Collection)methods).add(AuthMethod.Password.INSTANCE);
        }
        if (OpenSshConfigViaToolServiceKt.yesNo$default($keyValue, "kbdinteractiveauthentication", null, 2, null)) {
            ((Collection)methods).add(AuthMethod.KeyboardInteractive.INSTANCE);
        }
        if (!((Collection)(preferredAuthentications = OpenSshConfigViaToolServiceKt.singleCommaDelimited($keyValue, "preferredauthentications", false))).isEmpty()) {
            methods.removeIf(arg_0 -> OpenSshConfigViaToolServiceKt.openSshConfigViaToolImpl$lambda$12$lambda$10(arg_0 -> OpenSshConfigViaToolServiceKt.openSshConfigViaToolImpl$lambda$12$lambda$9(preferredAuthentications, arg_0), arg_0));
            List $this$sortBy$iv = methods;
            boolean $i$f$sortBy = false;
            if ($this$sortBy$iv.size() > 1) {
                CollectionsKt.sortWith((List)$this$sortBy$iv, (Comparator)new Comparator(preferredAuthentications){
                    final /* synthetic */ List $preferredAuthentications$inlined;
                    {
                        this.$preferredAuthentications$inlined = list;
                    }

                    public final int compare(T a, T b) {
                        AuthMethod it = (AuthMethod)a;
                        boolean bl = false;
                        Comparable comparable = Integer.valueOf(this.$preferredAuthentications$inlined.indexOf(SshConnectionConfigKt.getOpenSshLabel(it)));
                        it = (AuthMethod)b;
                        Comparable comparable2 = comparable;
                        bl = false;
                        return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Integer.valueOf(this.$preferredAuthentications$inlined.indexOf(SshConnectionConfigKt.getOpenSshLabel(it))));
                    }
                });
            }
        }
        return AuthMethods.Companion.create(methods);
    }

    private static final List openSshConfigViaToolImpl$lambda$13(Map $keyValue) {
        return OpenSshConfigViaToolServiceKt.singleCommaDelimited($keyValue, "ciphers", true);
    }

    private static final boolean openSshConfigViaToolImpl$lambda$14(Map $keyValue) {
        return OpenSshConfigViaToolServiceKt.yesNo$default($keyValue, "compression", null, 2, null);
    }

    private static final Duration openSshConfigViaToolImpl$lambda$16(Map $keyValue) {
        Duration duration;
        Long l = OpenSshConfigViaToolServiceKt.longOrNone($keyValue, "connecttimeout");
        if (l != null) {
            long p0 = ((Number)l).longValue();
            boolean bl = false;
            boolean $i$f$openSshConfigViaToolImpl$lambda$16$stub_for_inlining$15 = false;
            duration = Duration.ofSeconds(p0);
        } else {
            duration = null;
        }
        return duration;
    }

    private static final EnvironmentVariable.Certain openSshConfigViaToolImpl$lambda$20$lambda$19$lambda$18(String $setEnvRaw) {
        Pair<String, String> pair = OpenSshConfigViaToolServiceKt.splitEq($setEnvRaw);
        String name = (String)pair.component1();
        String value = (String)pair.component2();
        return new EnvironmentVariable.Certain(name, value);
    }

    /*
     * WARNING - void declaration
     */
    private static final List openSshConfigViaToolImpl$lambda$20(Map $keyValue, Set $errors) {
        void $this$mapNotNullTo$iv$iv;
        void $this$mapNotNull$iv;
        Collection collection;
        Object object;
        void $this$mapTo$iv$iv;
        List list = (List)$keyValue.get("sendenv");
        if (list == null) {
            list = CollectionsKt.emptyList();
        }
        Iterable $this$map$iv = list;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void sendEnvRaw;
            object = (String)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new EnvironmentVariable.Inherit((String)sendEnvRaw));
        }
        Collection collection2 = (List)destination$iv$iv;
        List list2 = (List)$keyValue.get("setenv");
        if (list2 == null) {
            list2 = CollectionsKt.emptyList();
        }
        $this$map$iv = list2;
        collection = collection2;
        boolean $i$f$mapNotNull = false;
        $this$mapTo$iv$iv = $this$mapNotNull$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        object = $this$forEach$iv$iv$iv.iterator();
        while (object.hasNext()) {
            EnvironmentVariable.Certain it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = object.next();
            boolean bl = false;
            String setEnvRaw = (String)element$iv$iv;
            boolean bl2 = false;
            if ((EnvironmentVariable.Certain)OpenSshConfigViaToolServiceKt.openSshConfigViaToolImpl$catching($errors, null, () -> OpenSshConfigViaToolServiceKt.openSshConfigViaToolImpl$lambda$20$lambda$19$lambda$18(setEnvRaw)) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return CollectionsKt.plus((Collection)collection, (Iterable)((List)destination$iv$iv));
    }

    private static final boolean openSshConfigViaToolImpl$lambda$21(Map $keyValue) {
        return OpenSshConfigViaToolServiceKt.yesNo$default($keyValue, "forwardagent", null, 2, null);
    }

    private static final List openSshConfigViaToolImpl$lambda$22(Map $keyValue) {
        return OpenSshConfigViaToolServiceKt.singleCommaDelimited($keyValue, "hostkeyalgorithms", true);
    }

    /*
     * WARNING - void declaration
     */
    private static final SshHostKeyVerifier openSshConfigViaToolImpl$lambda$28(Map $keyValue, String $userHome) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        void $this$mapNotNullTo$iv$iv;
        Iterable $this$mapNotNull$iv;
        boolean bl = false;
        String globalKey = "globalknownhostsfile";
        String userKey = "userknownhostsfile";
        List knownHostsFiles = CollectionsKt.plus((Collection)OpenSshConfigViaToolServiceKt.singleSpaceDelimited($keyValue, userKey, false), (Iterable)OpenSshConfigViaToolServiceKt.singleSpaceDelimited($keyValue, globalKey, false));
        Iterable iterable = knownHostsFiles;
        boolean $i$f$mapNotNull = false;
        void var9_11 = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Object object = $this$forEach$iv$iv$iv.iterator();
        while (object.hasNext()) {
            Path it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = object.next();
            boolean bl2 = false;
            String it = (String)element$iv$iv;
            boolean bl3 = false;
            if (OpenSshConfigViaToolServiceKt.parsePath(it, $userHome) == null) continue;
            boolean bl4 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        $this$mapNotNull$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$mapNotNullTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void p0;
            object = (Path)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl5 = false;
            boolean $i$f$openSshConfigViaToolImpl$lambda$28$lambda$26$stub_for_inlining$24 = false;
            collection.add(p0.toFile());
        }
        Iterable it = iterable = (List)destination$iv$iv;
        boolean bl6 = false;
        Iterable iterable2 = !((Collection)it).isEmpty() ? iterable : null;
        if (iterable2 == null) {
            throw new ParsingError("Both `" + globalKey + "` and `" + userKey + "` are empty");
        }
        Iterable knownHostsFiles2 = iterable2;
        boolean bl7 = false;
        String key = "stricthostkeychecking";
        String string = OpenSshConfigViaToolServiceKt.singleString($keyValue, key).toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
        SshConnectionConfigPatch.HostKeyVerifier.StrictHostKeyChecking strictHostKeyChecking = switch (string) {
            case "yes", "true" -> SshConnectionConfigPatch.HostKeyVerifier.StrictHostKeyChecking.YES;
            case "ask" -> SshConnectionConfigPatch.HostKeyVerifier.StrictHostKeyChecking.ASK;
            case "no", "false", "off" -> SshConnectionConfigPatch.HostKeyVerifier.StrictHostKeyChecking.NO;
            case "accept-new" -> SshConnectionConfigPatch.HostKeyVerifier.StrictHostKeyChecking.ACCEPT_NEW;
            default -> {
                String v;
                throw new ParsingError("Unexpected value for `" + key + "`: `" + v + "`");
            }
        };
        return new OpenSshLikeHostKeyVerifier((List)knownHostsFiles2, strictHostKeyChecking, OpenSshConfigViaToolServiceKt.yesNo$default($keyValue, "hashknownhosts", null, 2, null), false, 8, null);
    }

    /*
     * WARNING - void declaration
     */
    private static final List openSshConfigViaToolImpl$lambda$30(Map $keyValue) {
        List list;
        List list2 = (List)$keyValue.get("localforward");
        if (list2 != null) {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = list2;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void p0;
                String string = (String)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                boolean $i$f$openSshConfigViaToolImpl$lambda$30$stub_for_inlining$29 = false;
                collection.add(OpenSshConfigViaToolServiceKt.parseForward((String)p0));
            }
            list = (List)destination$iv$iv;
        } else {
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    /*
     * WARNING - void declaration
     */
    private static final List openSshConfigViaToolImpl$lambda$32(Map $keyValue) {
        List list;
        List list2 = (List)$keyValue.get("remoteforward");
        if (list2 != null) {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = list2;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void p0;
                String string = (String)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                boolean $i$f$openSshConfigViaToolImpl$lambda$32$stub_for_inlining$31 = false;
                collection.add(OpenSshConfigViaToolServiceKt.parseForward((String)p0));
            }
            list = (List)destination$iv$iv;
        } else {
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    private static final List openSshConfigViaToolImpl$lambda$33(Map $keyValue) {
        return OpenSshConfigViaToolServiceKt.singleCommaDelimited($keyValue, "kexalgorithms", true);
    }

    private static final List openSshConfigViaToolImpl$lambda$34(Map $keyValue) {
        return OpenSshConfigViaToolServiceKt.singleCommaDelimited($keyValue, "macs", true);
    }

    private static final int openSshConfigViaToolImpl$lambda$36(Map $keyValue) {
        String it = OpenSshConfigViaToolServiceKt.singleString($keyValue, "port");
        boolean bl = false;
        Integer n = StringsKt.toIntOrNull((String)it);
        if (n == null) {
            throw new ParsingError("Value of `port` is `" + it + "`, which is not a positive integer");
        }
        return n;
    }

    private static final ServerAlive openSshConfigViaToolImpl$lambda$41(Map $keyValue) {
        ServerAlive serverAlive;
        String countMaxKey = "serveralivecountmax";
        String it = OpenSshConfigViaToolServiceKt.singleString($keyValue, countMaxKey);
        boolean bl = false;
        Integer n = StringsKt.toIntOrNull((String)it);
        if (n == null) {
            throw new ParsingError("Value of `" + countMaxKey + " is `" + it + "`, which is not an integer");
        }
        int countMax = n;
        String intervalKey = "serveraliveinterval";
        String it2 = OpenSshConfigViaToolServiceKt.singleString($keyValue, intervalKey);
        boolean bl2 = false;
        Long l = StringsKt.toLongOrNull((String)it2);
        if (l == null) {
            throw new ParsingError("Value of `" + intervalKey + " is `" + it2 + "`, which is not an integer");
        }
        long interval = l;
        if (countMax <= 0 || interval <= 0L) {
            serverAlive = null;
        } else {
            Duration duration = Duration.ofSeconds(interval);
            Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"ofSeconds(...)");
            serverAlive = new ServerAlive(duration, countMax);
        }
        return serverAlive;
    }

    private static final X11Forwarding openSshConfigViaToolImpl$lambda$42(Map $keyValue) {
        return OpenSshConfigViaToolServiceKt.yesNo$default($keyValue, "forwardx11", null, 2, null) ? new X11Forwarding(OpenSshConfigViaToolServiceKt.yesNo$default($keyValue, "forwardx11trusted", null, 2, null), OpenSshConfigViaToolServiceKt.singleString($keyValue, "xauthlocation"), null, 4, null) : null;
    }

    private static final Logger LOG_delegate$lambda$55() {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(OpenSshConfigViaToolService.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        return logger;
    }

    public static final /* synthetic */ ToolResult access$openSshConfigViaToolImpl(String initialHost, List customSshCommand, String userHome) {
        return OpenSshConfigViaToolServiceKt.openSshConfigViaToolImpl(initialHost, customSshCommand, userHome);
    }

    public static final /* synthetic */ Logger access$getLOG() {
        return OpenSshConfigViaToolServiceKt.getLOG();
    }
}

