/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.searchEverywhereMl.ranking.core.model.local;

import com.intellij.internal.ml.DecisionFunction;
import com.intellij.internal.ml.FeaturesInfo;
import com.intellij.internal.ml.ModelMetadataReader;
import com.intellij.internal.ml.models.local.LocalRandomForestModel;
import com.intellij.internal.ml.models.local.ZipModelMetadataReader;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.searchEverywhereMl.ranking.core.model.local.LocalModelProvider;
import java.io.Closeable;
import java.util.zip.ZipFile;
import kotlin.Metadata;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\nH\u0016R\u0013\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/intellij/searchEverywhereMl/ranking/core/model/local/LocalZipModelProvider;", "Lcom/intellij/searchEverywhereMl/ranking/core/model/local/LocalModelProvider;", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "loadModel", "Lcom/intellij/internal/ml/DecisionFunction;", "path", "", "intellij.searchEverywhereMl.ranking.core"})
public final class LocalZipModelProvider
implements LocalModelProvider {
    @NotNull
    private final Logger LOG;

    public LocalZipModelProvider() {
        Logger logger = Logger.getInstance(this.getClass());
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        this.LOG = logger;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public DecisionFunction loadModel(@NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        try {
            Closeable closeable = new ZipFile(path);
            Throwable throwable = null;
            try {
                ZipFile file = (ZipFile)closeable;
                boolean bl = false;
                ZipModelMetadataReader metadataReader = new ZipModelMetadataReader(file);
                FeaturesInfo metadata = FeaturesInfo.Companion.buildInfo((ModelMetadataReader)metadataReader);
                String modelText = metadataReader.resourceContent("model.txt");
                DecisionFunction decisionFunction = LocalRandomForestModel.Companion.loadModel(modelText, metadata);
                return decisionFunction;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
        catch (Throwable t) {
            this.LOG.error(t);
            return null;
        }
    }
}

