/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.terminal.block.hyperlinks;

import com.intellij.execution.filters.CompositeFilter;
import com.intellij.execution.filters.ConsoleFilterProvider;
import com.intellij.execution.impl.ConsoleViewUtil;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.project.Project;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.concurrency.AppExecutorUtil;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\u0010\u001a\u00020\u000bH\u0002J\u0014\u0010\u0011\u001a\u00020\u000b2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u000b0\nJ\b\u0010\u0013\u001a\u00020\u000bH\u0002J\b\u0010\u0014\u001a\u0004\u0018\u00010\u000fR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/plugins/terminal/block/hyperlinks/CompositeFilterWrapper;", "", "project", "Lcom/intellij/openapi/project/Project;", "disposable", "Lcom/intellij/openapi/Disposable;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/Disposable;)V", "filtersUpdatedListeners", "", "Lkotlin/Function0;", "", "filtersComputationInProgress", "Ljava/util/concurrent/atomic/AtomicBoolean;", "cachedFilter", "Lcom/intellij/execution/filters/CompositeFilter;", "scheduleFiltersComputation", "addFiltersUpdatedListener", "listener", "fireFiltersUpdated", "getFilter", "intellij.terminal"})
public final class CompositeFilterWrapper {
    @NotNull
    private final Project project;
    @NotNull
    private final Disposable disposable;
    @NotNull
    private final List<Function0<Unit>> filtersUpdatedListeners;
    @NotNull
    private final AtomicBoolean filtersComputationInProgress;
    @Nullable
    private volatile CompositeFilter cachedFilter;

    public CompositeFilterWrapper(@NotNull Project project, @NotNull Disposable disposable) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)disposable, (String)"disposable");
        this.project = project;
        this.disposable = disposable;
        this.filtersUpdatedListeners = new CopyOnWriteArrayList();
        this.filtersComputationInProgress = new AtomicBoolean(false);
        ConsoleFilterProvider.FILTER_PROVIDERS.addChangeListener(() -> CompositeFilterWrapper._init_$lambda$0(this), this.disposable);
        this.scheduleFiltersComputation();
    }

    private final void scheduleFiltersComputation() {
        if (this.filtersComputationInProgress.compareAndSet(false, true)) {
            ReadAction.nonBlocking(() -> CompositeFilterWrapper.scheduleFiltersComputation$lambda$1(this)).expireWith(this.disposable).finishOnUiThread(ModalityState.defaultModalityState(), arg_0 -> CompositeFilterWrapper.scheduleFiltersComputation$lambda$4(arg_0 -> CompositeFilterWrapper.scheduleFiltersComputation$lambda$3(this, arg_0), arg_0)).submit((Executor)AppExecutorUtil.getAppExecutorService());
        }
    }

    public final void addFiltersUpdatedListener(@NotNull Function0<Unit> listener2) {
        Intrinsics.checkNotNullParameter(listener2, (String)"listener");
        this.filtersUpdatedListeners.add(listener2);
    }

    private final void fireFiltersUpdated() {
        for (Function0<Unit> listener2 : this.filtersUpdatedListeners) {
            listener2.invoke();
        }
    }

    @Nullable
    public final CompositeFilter getFilter() {
        CompositeFilter compositeFilter = this.cachedFilter;
        if (compositeFilter != null) {
            CompositeFilter it = compositeFilter;
            boolean bl = false;
            return it;
        }
        this.scheduleFiltersComputation();
        return null;
    }

    private static final void _init_$lambda$0(CompositeFilterWrapper this$0) {
        this$0.cachedFilter = null;
        this$0.scheduleFiltersComputation();
    }

    private static final List scheduleFiltersComputation$lambda$1(CompositeFilterWrapper this$0) {
        return ConsoleViewUtil.computeConsoleFilters((Project)this$0.project, null, (GlobalSearchScope)GlobalSearchScope.allScope((Project)this$0.project));
    }

    /*
     * WARNING - void declaration
     */
    private static final Unit scheduleFiltersComputation$lambda$3(CompositeFilterWrapper this$0, List filters) {
        void it;
        CompositeFilter compositeFilter;
        Intrinsics.checkNotNullParameter((Object)filters, (String)"filters");
        this$0.filtersComputationInProgress.set(false);
        CompositeFilter compositeFilter2 = compositeFilter = new CompositeFilter(this$0.project, filters);
        CompositeFilterWrapper compositeFilterWrapper = this$0;
        boolean bl = false;
        it.setForceUseAllFilters(true);
        compositeFilterWrapper.cachedFilter = compositeFilter;
        this$0.fireFiltersUpdated();
        return Unit.INSTANCE;
    }

    private static final void scheduleFiltersComputation$lambda$4(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }
}

