/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework.utils.module;

import java.util.Collection;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.opentest4j.AssertionFailedError;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000\u001e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\u001a:\u0010\u0000\u001a\u00020\u0001\"\u0004\b\u0000\u0010\u00022\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u0002H\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u0002H\u00020\u00042\u0010\b\u0002\u0010\u0006\u001a\n\u0012\u0004\u0012\u00020\b\u0018\u00010\u0007\u001a:\u0010\t\u001a\u00020\u0001\"\u0004\b\u0000\u0010\u00022\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u0002H\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u0002H\u00020\u00042\u0010\b\u0002\u0010\u0006\u001a\n\u0012\u0004\u0012\u00020\b\u0018\u00010\u0007\u00a8\u0006\n"}, d2={"assertEqualsUnordered", "", "T", "expected", "", "actual", "messageSupplier", "Lkotlin/Function0;", "", "assertContains", "intellij.platform.testFramework"})
@ApiStatus.Internal
public final class CollectionAssertionsKt {
    public static final <T> void assertEqualsUnordered(@NotNull Collection<? extends T> expected, @NotNull Collection<? extends T> actual, @Nullable Function0<String> messageSupplier) {
        Intrinsics.checkNotNullParameter(expected, (String)"expected");
        Intrinsics.checkNotNullParameter(actual, (String)"actual");
        Set expectedSet = CollectionsKt.toSet((Iterable)expected);
        Set actualSet = CollectionsKt.toSet((Iterable)actual);
        Set notFound = SetsKt.minus((Set)expectedSet, (Iterable)actualSet);
        Set notExpected = SetsKt.minus((Set)actualSet, (Iterable)expectedSet);
        if (!((Collection)notExpected).isEmpty() && !((Collection)notFound).isEmpty()) {
            Object object = messageSupplier;
            if (object == null || (object = (String)object.invoke()) == null) {
                object = "";
            }
            String message = object + StringsKt.trimMargin$default((String)("|\n      |Expecting actual:\n      |  " + actual + "\n      |to contain exactly in any order:\n      |  " + expected + "\n      |elements not found:\n      |  " + notFound + "\n      |and elements not expected:\n      |  " + notExpected + "\n    "), null, (int)1, null);
            throw new AssertionFailedError(message, expected, actual);
        }
        if (!((Collection)notFound).isEmpty()) {
            Object object = messageSupplier;
            if (object == null || (object = (String)object.invoke()) == null) {
                object = "";
            }
            String message = object + StringsKt.trimMargin$default((String)("|\n      |Expecting actual:\n      |  " + actual + "\n      |to contain exactly in any order:\n      |  " + expected + "\n      |but could not find the following elements:\n      |  " + notFound + "\n    "), null, (int)1, null);
            throw new AssertionFailedError(message, expected, actual);
        }
        if (!((Collection)notExpected).isEmpty()) {
            Object object = messageSupplier;
            if (object == null || (object = (String)object.invoke()) == null) {
                object = "";
            }
            String message = object + StringsKt.trimMargin$default((String)("|\n      |Expecting actual:\n      |  " + actual + "\n      |to contain exactly in any order:\n      |  " + expected + "\n      |but the following elements were unexpected:\n      |  " + notExpected + "\n    "), null, (int)1, null);
            throw new AssertionFailedError(message, expected, actual);
        }
    }

    public static /* synthetic */ void assertEqualsUnordered$default(Collection collection, Collection collection2, Function0 function0, int n, Object object) {
        if ((n & 4) != 0) {
            function0 = null;
        }
        CollectionAssertionsKt.assertEqualsUnordered(collection, collection2, (Function0<String>)function0);
    }

    public static final <T> void assertContains(@NotNull Collection<? extends T> expected, @NotNull Collection<? extends T> actual, @Nullable Function0<String> messageSupplier) {
        Intrinsics.checkNotNullParameter(expected, (String)"expected");
        Intrinsics.checkNotNullParameter(actual, (String)"actual");
        Set expectedSet = CollectionsKt.toSet((Iterable)expected);
        Set actualSet = CollectionsKt.toSet((Iterable)actual);
        Set notFound = SetsKt.minus((Set)expectedSet, (Iterable)actualSet);
        if (!((Collection)notFound).isEmpty()) {
            Object object = messageSupplier;
            if (object == null || (object = (String)object.invoke()) == null) {
                object = "";
            }
            String message = object + StringsKt.trimMargin$default((String)("|\n      |Expecting actual:\n      |  " + actual + "\n      |to contain in any order:\n      |  " + expected + "\n      |but could not find the following elements:\n      |  " + notFound + "\n    "), null, (int)1, null);
            throw new AssertionFailedError(message, expected, actual);
        }
    }

    public static /* synthetic */ void assertContains$default(Collection collection, Collection collection2, Function0 function0, int n, Object object) {
        if ((n & 4) != 0) {
            function0 = null;
        }
        CollectionAssertionsKt.assertContains(collection, collection2, (Function0<String>)function0);
    }
}

