/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.osgi.core;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import org.apache.ivy.osgi.core.ExecutionEnvironmentProfile;
import org.apache.ivy.util.Message;

public class ExecutionEnvironmentProfileProvider {
    private Map profileList = ExecutionEnvironmentProfileProvider.loadDefaultProfileList();
    private static final ExecutionEnvironmentProfileProvider INSTANCE;

    public ExecutionEnvironmentProfile getProfile(String string) {
        return (ExecutionEnvironmentProfile)this.profileList.get(string);
    }

    public static Map loadDefaultProfileList() throws IOException {
        Iterator<Map.Entry<Object, Object>> iterator = ExecutionEnvironmentProfileProvider.class.getClassLoader();
        if ((iterator = ((ClassLoader)((Object)iterator)).getResourceAsStream("org/apache/ivy/osgi/core/jvm-packages.properties")) == null) {
            throw new FileNotFoundException("org/apache/ivy/osgi/core/jvm-packages.properties not found in the classpath");
        }
        Properties properties = new Properties();
        try {
            properties.load((InputStream)((Object)iterator));
        }
        finally {
            ((InputStream)((Object)iterator)).close();
        }
        HashMap hashMap = new HashMap();
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            String string;
            String string2 = (String)entry.getKey();
            if (!string2.endsWith(".pkglist") || hashMap.containsKey(string = string2.substring(0, string2.length() - 8))) continue;
            ExecutionEnvironmentProfileProvider.loadProfile(properties, hashMap, string);
        }
        return hashMap;
    }

    private static ExecutionEnvironmentProfile loadProfile(Properties properties, Map map, String string) {
        Object object;
        ExecutionEnvironmentProfile executionEnvironmentProfile = new ExecutionEnvironmentProfile(string);
        Object object2 = properties.getProperty(string + ".extends");
        if (object2 != null) {
            object = (ExecutionEnvironmentProfile)map.get(object2);
            if (object == null) {
                object = ExecutionEnvironmentProfileProvider.loadProfile(properties, map, (String)object2);
            }
            object2 = ((ExecutionEnvironmentProfile)object).getPkgNames().iterator();
            while (object2.hasNext()) {
                executionEnvironmentProfile.addPkgName((String)object2.next());
            }
        }
        object = properties.getProperty(string + ".pkglist");
        object2 = ((String)object).split(",");
        for (int i = 0; i < ((String[])object2).length; ++i) {
            object = object2[i].trim();
            if (((String)object).length() == 0) continue;
            executionEnvironmentProfile.addPkgName((String)object);
        }
        map.put(string, executionEnvironmentProfile);
        Message.verbose("Execution environment profile " + executionEnvironmentProfile.getName() + " loaded");
        return executionEnvironmentProfile;
    }

    static {
        try {
            INSTANCE = new ExecutionEnvironmentProfileProvider();
            return;
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }
}

