/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.workflow.action;

import de.rub.nds.modifiablevariable.HoldsModifiableVariable;
import de.rub.nds.tlsattacker.core.https.HttpsRequestMessage;
import de.rub.nds.tlsattacker.core.https.HttpsResponseMessage;
import de.rub.nds.tlsattacker.core.protocol.message.AlertMessage;
import de.rub.nds.tlsattacker.core.protocol.message.ApplicationMessage;
import de.rub.nds.tlsattacker.core.protocol.message.CertificateMessage;
import de.rub.nds.tlsattacker.core.protocol.message.CertificateRequestMessage;
import de.rub.nds.tlsattacker.core.protocol.message.CertificateStatusMessage;
import de.rub.nds.tlsattacker.core.protocol.message.CertificateVerifyMessage;
import de.rub.nds.tlsattacker.core.protocol.message.ChangeCipherSpecMessage;
import de.rub.nds.tlsattacker.core.protocol.message.ClientHelloMessage;
import de.rub.nds.tlsattacker.core.protocol.message.DHClientKeyExchangeMessage;
import de.rub.nds.tlsattacker.core.protocol.message.DHEServerKeyExchangeMessage;
import de.rub.nds.tlsattacker.core.protocol.message.ECDHClientKeyExchangeMessage;
import de.rub.nds.tlsattacker.core.protocol.message.ECDHEServerKeyExchangeMessage;
import de.rub.nds.tlsattacker.core.protocol.message.EmptyClientKeyExchangeMessage;
import de.rub.nds.tlsattacker.core.protocol.message.EncryptedExtensionsMessage;
import de.rub.nds.tlsattacker.core.protocol.message.EndOfEarlyDataMessage;
import de.rub.nds.tlsattacker.core.protocol.message.FinishedMessage;
import de.rub.nds.tlsattacker.core.protocol.message.GOSTClientKeyExchangeMessage;
import de.rub.nds.tlsattacker.core.protocol.message.HeartbeatMessage;
import de.rub.nds.tlsattacker.core.protocol.message.HelloRequestMessage;
import de.rub.nds.tlsattacker.core.protocol.message.HelloRetryRequestMessage;
import de.rub.nds.tlsattacker.core.protocol.message.HelloVerifyRequestMessage;
import de.rub.nds.tlsattacker.core.protocol.message.NewSessionTicketMessage;
import de.rub.nds.tlsattacker.core.protocol.message.PWDClientKeyExchangeMessage;
import de.rub.nds.tlsattacker.core.protocol.message.PWDServerKeyExchangeMessage;
import de.rub.nds.tlsattacker.core.protocol.message.ProtocolMessage;
import de.rub.nds.tlsattacker.core.protocol.message.PskClientKeyExchangeMessage;
import de.rub.nds.tlsattacker.core.protocol.message.PskDhClientKeyExchangeMessage;
import de.rub.nds.tlsattacker.core.protocol.message.PskDheServerKeyExchangeMessage;
import de.rub.nds.tlsattacker.core.protocol.message.PskEcDhClientKeyExchangeMessage;
import de.rub.nds.tlsattacker.core.protocol.message.PskEcDheServerKeyExchangeMessage;
import de.rub.nds.tlsattacker.core.protocol.message.PskRsaClientKeyExchangeMessage;
import de.rub.nds.tlsattacker.core.protocol.message.PskServerKeyExchangeMessage;
import de.rub.nds.tlsattacker.core.protocol.message.RSAClientKeyExchangeMessage;
import de.rub.nds.tlsattacker.core.protocol.message.SSL2ClientHelloMessage;
import de.rub.nds.tlsattacker.core.protocol.message.SSL2ClientMasterKeyMessage;
import de.rub.nds.tlsattacker.core.protocol.message.SSL2ServerHelloMessage;
import de.rub.nds.tlsattacker.core.protocol.message.SSL2ServerVerifyMessage;
import de.rub.nds.tlsattacker.core.protocol.message.ServerHelloDoneMessage;
import de.rub.nds.tlsattacker.core.protocol.message.ServerHelloMessage;
import de.rub.nds.tlsattacker.core.protocol.message.SrpClientKeyExchangeMessage;
import de.rub.nds.tlsattacker.core.protocol.message.SrpServerKeyExchangeMessage;
import de.rub.nds.tlsattacker.core.protocol.message.SupplementalDataMessage;
import de.rub.nds.tlsattacker.core.protocol.message.UnknownHandshakeMessage;
import de.rub.nds.tlsattacker.core.protocol.message.UnknownMessage;
import de.rub.nds.tlsattacker.core.record.AbstractRecord;
import de.rub.nds.tlsattacker.core.record.BlobRecord;
import de.rub.nds.tlsattacker.core.record.Record;
import de.rub.nds.tlsattacker.core.workflow.action.ConnectionBoundAction;
import de.rub.nds.tlsattacker.core.workflow.action.TlsAction;
import de.rub.nds.tlsattacker.core.workflow.action.executor.ReceiveMessageHelper;
import de.rub.nds.tlsattacker.core.workflow.action.executor.SendMessageHelper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlElements;
import javax.xml.bind.annotation.XmlTransient;

public abstract class MessageAction
extends ConnectionBoundAction {
    @XmlElementWrapper
    @HoldsModifiableVariable
    @XmlElements(value={@XmlElement(type=ProtocolMessage.class, name="ProtocolMessage"), @XmlElement(type=CertificateMessage.class, name="Certificate"), @XmlElement(type=CertificateVerifyMessage.class, name="CertificateVerify"), @XmlElement(type=CertificateRequestMessage.class, name="CertificateRequest"), @XmlElement(type=CertificateStatusMessage.class, name="CertificateStatus"), @XmlElement(type=ClientHelloMessage.class, name="ClientHello"), @XmlElement(type=HelloVerifyRequestMessage.class, name="HelloVerifyRequest"), @XmlElement(type=DHClientKeyExchangeMessage.class, name="DHClientKeyExchange"), @XmlElement(type=DHEServerKeyExchangeMessage.class, name="DHEServerKeyExchange"), @XmlElement(type=ECDHClientKeyExchangeMessage.class, name="ECDHClientKeyExchange"), @XmlElement(type=ECDHEServerKeyExchangeMessage.class, name="ECDHEServerKeyExchange"), @XmlElement(type=EmptyClientKeyExchangeMessage.class, name="EmptyClientKeyExchange"), @XmlElement(type=PskClientKeyExchangeMessage.class, name="PSKClientKeyExchange"), @XmlElement(type=PWDServerKeyExchangeMessage.class, name="PWDServerKeyExchange"), @XmlElement(type=PWDClientKeyExchangeMessage.class, name="PWDClientKeyExchange"), @XmlElement(type=FinishedMessage.class, name="Finished"), @XmlElement(type=RSAClientKeyExchangeMessage.class, name="RSAClientKeyExchange"), @XmlElement(type=GOSTClientKeyExchangeMessage.class, name="GOSTClientKeyExchange"), @XmlElement(type=ServerHelloDoneMessage.class, name="ServerHelloDone"), @XmlElement(type=ServerHelloMessage.class, name="ServerHello"), @XmlElement(type=AlertMessage.class, name="Alert"), @XmlElement(type=NewSessionTicketMessage.class, name="NewSessionTicket"), @XmlElement(type=ApplicationMessage.class, name="Application"), @XmlElement(type=ChangeCipherSpecMessage.class, name="ChangeCipherSpec"), @XmlElement(type=SSL2ClientHelloMessage.class, name="SSL2ClientHello"), @XmlElement(type=SSL2ServerHelloMessage.class, name="SSL2ServerHello"), @XmlElement(type=SSL2ClientMasterKeyMessage.class, name="SSL2ClientMasterKey"), @XmlElement(type=SSL2ServerVerifyMessage.class, name="SSL2ServerVerify"), @XmlElement(type=UnknownMessage.class, name="UnknownMessage"), @XmlElement(type=UnknownHandshakeMessage.class, name="UnknownHandshakeMessage"), @XmlElement(type=HelloRequestMessage.class, name="HelloRequest"), @XmlElement(type=HeartbeatMessage.class, name="Heartbeat"), @XmlElement(type=SupplementalDataMessage.class, name="SupplementalDataMessage"), @XmlElement(type=EncryptedExtensionsMessage.class, name="EncryptedExtensionMessage"), @XmlElement(type=HttpsRequestMessage.class, name="HttpsRequest"), @XmlElement(type=HttpsResponseMessage.class, name="HttpsResponse"), @XmlElement(type=PskClientKeyExchangeMessage.class, name="PskClientKeyExchange"), @XmlElement(type=PskDhClientKeyExchangeMessage.class, name="PskDhClientKeyExchange"), @XmlElement(type=PskDheServerKeyExchangeMessage.class, name="PskDheServerKeyExchange"), @XmlElement(type=PskEcDhClientKeyExchangeMessage.class, name="PskEcDhClientKeyExchange"), @XmlElement(type=PskEcDheServerKeyExchangeMessage.class, name="PskEcDheServerKeyExchange"), @XmlElement(type=PskRsaClientKeyExchangeMessage.class, name="PskRsaClientKeyExchange"), @XmlElement(type=PskServerKeyExchangeMessage.class, name="PskServerKeyExchange"), @XmlElement(type=SrpServerKeyExchangeMessage.class, name="SrpServerKeyExchange"), @XmlElement(type=SrpClientKeyExchangeMessage.class, name="SrpClientKeyExchange"), @XmlElement(type=EndOfEarlyDataMessage.class, name="EndOfEarlyData"), @XmlElement(type=EncryptedExtensionsMessage.class, name="EncryptedExtensions"), @XmlElement(type=HelloRetryRequestMessage.class, name="HelloRetryRequest")})
    protected List<ProtocolMessage> messages = new ArrayList<ProtocolMessage>();
    @HoldsModifiableVariable
    @XmlElementWrapper
    @XmlElements(value={@XmlElement(type=Record.class, name="Record"), @XmlElement(type=BlobRecord.class, name="BlobRecord")})
    protected List<AbstractRecord> records = new ArrayList<AbstractRecord>();
    @XmlTransient
    protected ReceiveMessageHelper receiveMessageHelper;
    @XmlTransient
    protected SendMessageHelper sendMessageHelper;

    public MessageAction() {
        this.receiveMessageHelper = new ReceiveMessageHelper();
        this.sendMessageHelper = new SendMessageHelper();
    }

    public MessageAction(List<ProtocolMessage> messages) {
        this.messages = new ArrayList<ProtocolMessage>(messages);
        this.receiveMessageHelper = new ReceiveMessageHelper();
        this.sendMessageHelper = new SendMessageHelper();
    }

    public MessageAction(ProtocolMessage ... messages) {
        this.messages = new ArrayList<ProtocolMessage>(Arrays.asList(messages));
        this.receiveMessageHelper = new ReceiveMessageHelper();
        this.sendMessageHelper = new SendMessageHelper();
    }

    public MessageAction(String connectionAlias) {
        super(connectionAlias);
        this.receiveMessageHelper = new ReceiveMessageHelper();
        this.sendMessageHelper = new SendMessageHelper();
    }

    public MessageAction(String connectionAlias, List<ProtocolMessage> messages) {
        super(connectionAlias);
        this.messages = new ArrayList<ProtocolMessage>(messages);
        this.receiveMessageHelper = new ReceiveMessageHelper();
        this.sendMessageHelper = new SendMessageHelper();
    }

    public MessageAction(String connectionAlias, ProtocolMessage ... messages) {
        this(connectionAlias, new ArrayList<ProtocolMessage>(Arrays.asList(messages)));
    }

    public void setReceiveMessageHelper(ReceiveMessageHelper receiveMessageHelper) {
        this.receiveMessageHelper = receiveMessageHelper;
    }

    public void setSendMessageHelper(SendMessageHelper sendMessageHelper) {
        this.sendMessageHelper = sendMessageHelper;
    }

    public String getReadableString(ProtocolMessage ... messages) {
        return this.getReadableString(Arrays.asList(messages));
    }

    public String getReadableString(List<ProtocolMessage> messages) {
        return this.getReadableString(messages, false);
    }

    public String getReadableString(List<ProtocolMessage> messages, Boolean verbose) {
        StringBuilder builder = new StringBuilder();
        if (messages == null) {
            return builder.toString();
        }
        for (ProtocolMessage message : messages) {
            if (verbose.booleanValue()) {
                builder.append(message.toString());
            } else {
                builder.append(message.toCompactString());
            }
            if (!message.isRequired()) {
                builder.append("*");
            }
            builder.append(", ");
        }
        return builder.toString();
    }

    public List<ProtocolMessage> getMessages() {
        return this.messages;
    }

    public void setMessages(List<ProtocolMessage> messages) {
        this.messages = messages;
    }

    public void setMessages(ProtocolMessage ... messages) {
        this.messages = new ArrayList<ProtocolMessage>(Arrays.asList(messages));
    }

    public List<AbstractRecord> getRecords() {
        return this.records;
    }

    public void setRecords(List<AbstractRecord> records) {
        this.records = records;
    }

    public void setRecords(AbstractRecord ... records) {
        this.records = new ArrayList<AbstractRecord>(Arrays.asList(records));
    }

    public void clearRecords() {
        this.records = null;
    }

    @Override
    public void normalize() {
        super.normalize();
        this.initEmptyLists();
    }

    @Override
    public void normalize(TlsAction defaultAction) {
        super.normalize(defaultAction);
        this.initEmptyLists();
    }

    @Override
    public void filter() {
        super.filter();
        this.stripEmptyLists();
    }

    @Override
    public void filter(TlsAction defaultAction) {
        super.filter(defaultAction);
        this.stripEmptyLists();
    }

    private void stripEmptyLists() {
        if (this.messages == null || this.messages.isEmpty()) {
            this.messages = null;
        }
        if (this.records == null || this.records.isEmpty()) {
            this.records = null;
        }
    }

    private void initEmptyLists() {
        if (this.messages == null) {
            this.messages = new ArrayList<ProtocolMessage>();
        }
        if (this.records == null) {
            this.records = new ArrayList<AbstractRecord>();
        }
    }
}

