/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.attacks.impl;

import de.rub.nds.modifiablevariable.VariableModification;
import de.rub.nds.modifiablevariable.bytearray.ByteArrayModificationFactory;
import de.rub.nds.modifiablevariable.bytearray.ModifiableByteArray;
import de.rub.nds.tlsattacker.attacks.config.TLSPoodleCommandConfig;
import de.rub.nds.tlsattacker.attacks.impl.Attacker;
import de.rub.nds.tlsattacker.core.config.Config;
import de.rub.nds.tlsattacker.core.constants.HandshakeMessageType;
import de.rub.nds.tlsattacker.core.constants.RunningModeType;
import de.rub.nds.tlsattacker.core.exceptions.WorkflowExecutionException;
import de.rub.nds.tlsattacker.core.protocol.message.FinishedMessage;
import de.rub.nds.tlsattacker.core.protocol.message.ProtocolMessage;
import de.rub.nds.tlsattacker.core.record.AbstractRecord;
import de.rub.nds.tlsattacker.core.record.Record;
import de.rub.nds.tlsattacker.core.state.State;
import de.rub.nds.tlsattacker.core.workflow.WorkflowExecutor;
import de.rub.nds.tlsattacker.core.workflow.WorkflowExecutorFactory;
import de.rub.nds.tlsattacker.core.workflow.WorkflowTrace;
import de.rub.nds.tlsattacker.core.workflow.WorkflowTraceUtil;
import de.rub.nds.tlsattacker.core.workflow.action.SendingAction;
import de.rub.nds.tlsattacker.core.workflow.factory.WorkflowConfigurationFactory;
import de.rub.nds.tlsattacker.core.workflow.factory.WorkflowTraceType;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TLSPoodleAttacker
extends Attacker<TLSPoodleCommandConfig> {
    private static final Logger LOGGER = LogManager.getLogger();

    public TLSPoodleAttacker(TLSPoodleCommandConfig config, Config baseConfig) {
        super(config, baseConfig);
    }

    @Override
    public void executeAttack() {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    @Override
    public Boolean isVulnerable() {
        Config tlsConfig = this.getTlsConfig();
        WorkflowTrace trace = new WorkflowConfigurationFactory(tlsConfig).createWorkflowTrace(WorkflowTraceType.HANDSHAKE, RunningModeType.CLIENT);
        ModifiableByteArray padding = new ModifiableByteArray();
        VariableModification modifier = ByteArrayModificationFactory.xor((byte[])new byte[]{-128}, (int)0);
        padding.setModification(modifier);
        Record finishedMessageRecord = new Record();
        finishedMessageRecord.prepareComputations();
        finishedMessageRecord.getComputations().setPadding(padding);
        this.insertModifiedFinishedMessageRecord(trace, finishedMessageRecord);
        State state = new State(tlsConfig, trace);
        try {
            WorkflowExecutor workflowExecutor = WorkflowExecutorFactory.createWorkflowExecutor(tlsConfig.getWorkflowExecutorType(), state);
            workflowExecutor.executeWorkflow();
        }
        catch (WorkflowExecutionException ex) {
            LOGGER.info("Not possible to finalize the defined workflow");
            LOGGER.debug((Object)ex);
            return null;
        }
        if (state.getTlsContext().isReceivedFatalAlert()) {
            LOGGER.info("NOT Vulnerable. The modified message padding was identified, the server correctly responds with an alert message");
            return false;
        }
        if (WorkflowTraceUtil.didReceiveMessage(HandshakeMessageType.FINISHED, trace)) {
            LOGGER.info("Vulnerable (definitely), Finished message found");
            return true;
        }
        LOGGER.info("Not vulnerable (probably), no Finished message found, yet also no alert");
        return false;
    }

    private void insertModifiedFinishedMessageRecord(WorkflowTrace trace, Record finishedMessageRecord) {
        SendingAction lastSendingAction = WorkflowTraceUtil.getLastSendingAction(trace);
        List<ProtocolMessage> sendMessages = lastSendingAction.getSendMessages();
        assert (sendMessages.get(sendMessages.size() - 1) instanceof FinishedMessage);
        List<AbstractRecord> sendRecords = lastSendingAction.getSendRecords();
        sendRecords.add(new Record());
        sendRecords.add(new Record());
        sendRecords.add(finishedMessageRecord);
    }
}

