/*
 * Decompiled with CFR 0.152.
 */
package com.almworks.tracklink.toolwindow.actions;

import com.almworks.tracker.eapi.alpha.TrackerApplication;
import com.almworks.tracker.eapi.alpha.TrackerConnectionStatus;
import com.almworks.tracker.eapi.alpha.TrackerConnector;
import com.almworks.tracklink.IssueLinkModel;
import com.almworks.tracklink.settings.TrackerInstallHelper;
import com.almworks.tracklink.toolwindow.Dashboard;
import com.almworks.tracklink.util.StringBundle;
import com.almworks.tracklink.util.Utils;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;

public class StartDeskzillaAction
extends AnAction {
    public void update(AnActionEvent e) {
        Presentation presentation = e.getPresentation();
        Dashboard dashboard = Utils.getDashboard(e.getDataContext());
        boolean active = false;
        String name = null;
        if (dashboard != null) {
            IssueLinkModel model = dashboard.getIssueModel();
            TrackerApplication application = model.getApplication();
            name = StringBundle.get("app.start", model.getApplicationDisplayNameNotNull());
            String productId = null;
            if (application == TrackerApplication.DESKZILLA) {
                productId = "deskzilla";
            } else if (application == TrackerApplication.JIRA_CLIENT) {
                productId = "jiraclient";
            }
            if (productId != null && (active = TrackerInstallHelper.isInstalled(productId))) {
                TrackerConnector connector = dashboard.getConnector();
                active = connector != null && !((TrackerConnectionStatus)connector.getTrackerStarter().getConnectionStatus().getValue()).isConnected();
            }
        }
        presentation.setEnabled(active);
        presentation.setVisible(active);
        presentation.setText(name != null ? name : StringBundle.get("app.start.any", new Object[0]));
    }

    public void actionPerformed(AnActionEvent e) {
        Utils.startDeskzilla(e);
    }
}

