/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.util.pico;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.util.pico.CachingConstructorInjectionComponentAdapter;
import org.jetbrains.kotlin.org.picocontainer.ComponentAdapter;
import org.jetbrains.kotlin.org.picocontainer.MutablePicoContainer;
import org.jetbrains.kotlin.org.picocontainer.PicoContainer;
import org.jetbrains.kotlin.org.picocontainer.PicoRegistrationException;
import org.jetbrains.kotlin.org.picocontainer.defaults.AmbiguousComponentResolutionException;

@ApiStatus.Internal
public class DefaultPicoContainer
implements MutablePicoContainer {
    private final DefaultPicoContainer parent;
    private final Map<Object, ComponentAdapter> componentKeyToAdapter = new ConcurrentHashMap<Object, ComponentAdapter>();
    private final LinkedHashSetWrapper<ComponentAdapter> componentAdapters = new LinkedHashSetWrapper();

    public DefaultPicoContainer(@Nullable DefaultPicoContainer parent2) {
        this.parent = parent2;
    }

    public DefaultPicoContainer() {
        this(null);
    }

    @Nullable
    public final ComponentAdapter getComponentAdapter(@NotNull Object componentKey) {
        ComponentAdapter adapter;
        if (componentKey == null) {
            DefaultPicoContainer.$$$reportNull$$$0(1);
        }
        if ((adapter = this.getFromCache(componentKey)) == null && this.parent != null) {
            return this.parent.getComponentAdapter(componentKey);
        }
        return adapter;
    }

    @Nullable
    private ComponentAdapter getFromCache(@NotNull Object componentKey) {
        ComponentAdapter adapter;
        if (componentKey == null) {
            DefaultPicoContainer.$$$reportNull$$$0(2);
        }
        if ((adapter = this.componentKeyToAdapter.get(componentKey)) != null) {
            return adapter;
        }
        return componentKey instanceof Class ? this.componentKeyToAdapter.get(((Class)componentKey).getName()) : null;
    }

    @Nullable
    public final ComponentAdapter getComponentAdapterOfType(@NotNull Class<?> componentType) {
        ComponentAdapter adapterByKey;
        if (componentType == null) {
            DefaultPicoContainer.$$$reportNull$$$0(3);
        }
        if ((adapterByKey = this.getComponentAdapter(componentType)) != null) {
            return adapterByKey;
        }
        List<ComponentAdapter> found2 = this.getComponentAdaptersOfType(componentType);
        if (found2.size() == 1) {
            return found2.get(0);
        }
        if (found2.isEmpty()) {
            return this.parent == null ? null : this.parent.getComponentAdapterOfType(componentType);
        }
        Object[] foundClasses = new Class[found2.size()];
        for (int i = 0; i < foundClasses.length; ++i) {
            foundClasses[i] = found2.get(i).getComponentImplementation();
        }
        throw new AmbiguousComponentResolutionException(componentType, foundClasses);
    }

    @NotNull
    public final List<ComponentAdapter> getComponentAdaptersOfType(@NotNull Class<?> componentType) {
        if (componentType == null) {
            DefaultPicoContainer.$$$reportNull$$$0(4);
        }
        if (componentType == String.class) {
            List<ComponentAdapter> list2 = Collections.emptyList();
            if (list2 == null) {
                DefaultPicoContainer.$$$reportNull$$$0(5);
            }
            return list2;
        }
        ArrayList<ComponentAdapter> result2 = new ArrayList<ComponentAdapter>();
        ComponentAdapter cacheHit = this.componentKeyToAdapter.get(componentType.getName());
        if (cacheHit != null) {
            result2.add(cacheHit);
        }
        for (ComponentAdapter adapter : this.componentKeyToAdapter.values()) {
            Class<?> descendant;
            if (adapter.getComponentKey() instanceof String || componentType != (descendant = adapter.getComponentImplementation()) && !componentType.isAssignableFrom(descendant)) continue;
            result2.add(adapter);
        }
        ArrayList<ComponentAdapter> arrayList = result2;
        if (arrayList == null) {
            DefaultPicoContainer.$$$reportNull$$$0(6);
        }
        return arrayList;
    }

    public final ComponentAdapter registerComponent(@NotNull ComponentAdapter componentAdapter) {
        if (componentAdapter == null) {
            DefaultPicoContainer.$$$reportNull$$$0(7);
        }
        if (this.componentKeyToAdapter.putIfAbsent(componentAdapter.getComponentKey(), componentAdapter) != null) {
            throw new PicoRegistrationException("Key " + componentAdapter.getComponentKey() + " duplicated");
        }
        this.componentAdapters.add(componentAdapter);
        return componentAdapter;
    }

    @Override
    @Nullable
    public final ComponentAdapter unregisterComponent(@NotNull Object componentKey) {
        ComponentAdapter adapter;
        if (componentKey == null) {
            DefaultPicoContainer.$$$reportNull$$$0(8);
        }
        if ((adapter = this.componentKeyToAdapter.remove(componentKey)) == null) {
            return null;
        }
        this.componentAdapters.remove(adapter);
        return adapter;
    }

    @Nullable
    public Object getComponentInstance(@NotNull Object componentKey) {
        ComponentAdapter adapter;
        if (componentKey == null) {
            DefaultPicoContainer.$$$reportNull$$$0(9);
        }
        if ((adapter = this.getFromCache(componentKey)) != null) {
            return adapter.getComponentInstance(this);
        }
        return this.parent == null ? null : this.parent.getComponentInstance(componentKey);
    }

    @Nullable
    public final <T> T getService(@NotNull Class<T> serviceClass) {
        ComponentAdapter adapter;
        if (serviceClass == null) {
            DefaultPicoContainer.$$$reportNull$$$0(10);
        }
        if ((adapter = this.componentKeyToAdapter.get(serviceClass.getName())) == null) {
            return null;
        }
        return (T)adapter.getComponentInstance(this);
    }

    @Override
    public final ComponentAdapter registerComponentInstance(@NotNull Object componentKey, @NotNull Object componentInstance) {
        if (componentKey == null) {
            DefaultPicoContainer.$$$reportNull$$$0(14);
        }
        if (componentInstance == null) {
            DefaultPicoContainer.$$$reportNull$$$0(15);
        }
        return this.registerComponent(new InstanceComponentAdapter(componentKey, componentInstance));
    }

    @Override
    public final ComponentAdapter registerComponentImplementation(@NotNull Object componentKey, @NotNull Class<?> componentImplementation) {
        if (componentKey == null) {
            DefaultPicoContainer.$$$reportNull$$$0(16);
        }
        if (componentImplementation == null) {
            DefaultPicoContainer.$$$reportNull$$$0(17);
        }
        return this.registerComponent(new CachingConstructorInjectionComponentAdapter(componentKey, componentImplementation));
    }

    public final DefaultPicoContainer getParent() {
        return this.parent;
    }

    public final String toString() {
        DefaultPicoContainer parent2 = this.parent;
        return "DefaultPicoContainer" + (parent2 == null ? " (root)" : " (parent=" + parent2 + ")");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/com/intellij/util/pico/DefaultPicoContainer";
                break;
            }
            case 1: 
            case 2: 
            case 8: 
            case 9: 
            case 14: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "componentKey";
                break;
            }
            case 3: 
            case 4: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "componentType";
                break;
            }
            case 7: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "componentAdapter";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "serviceClass";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "componentInstance";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "componentImplementation";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponentAdapters";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/com/intellij/util/pico/DefaultPicoContainer";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponentAdaptersOfType";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getComponentAdapter";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getFromCache";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getComponentAdapterOfType";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getComponentAdaptersOfType";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "registerComponent";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "unregisterComponent";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getComponentInstance";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getService";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getServiceAdapter";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getComponentInstanceOfType";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "registerComponentInstance";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "registerComponentImplementation";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    public static final class InstanceComponentAdapter
    implements ComponentAdapter {
        private final Object componentKey;
        private final Object componentInstance;

        public InstanceComponentAdapter(@NotNull Object componentKey, @NotNull Object componentInstance) {
            if (componentKey == null) {
                InstanceComponentAdapter.$$$reportNull$$$0(0);
            }
            if (componentInstance == null) {
                InstanceComponentAdapter.$$$reportNull$$$0(1);
            }
            this.componentKey = componentKey;
            this.componentInstance = componentInstance;
        }

        @Override
        public Object getComponentInstance(PicoContainer container) {
            return this.componentInstance;
        }

        @Override
        public Object getComponentKey() {
            return this.componentKey;
        }

        @Override
        public Class<?> getComponentImplementation() {
            return this.componentInstance.getClass();
        }

        public String toString() {
            return this.getClass().getName() + "[" + this.getComponentKey() + "]";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "componentKey";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "componentInstance";
                    break;
                }
            }
            objectArray[1] = "org/jetbrains/kotlin/com/intellij/util/pico/DefaultPicoContainer$InstanceComponentAdapter";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static final class LinkedHashSetWrapper<T> {
        private final Object lock = new Object();
        private volatile Set<T> immutableSet;
        private LinkedHashSet<T> synchronizedSet = new LinkedHashSet();

        private LinkedHashSetWrapper() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void add(@NotNull T element) {
            if (element == null) {
                LinkedHashSetWrapper.$$$reportNull$$$0(0);
            }
            Object object = this.lock;
            synchronized (object) {
                if (!this.synchronizedSet.contains(element)) {
                    this.copySyncSetIfExposedAsImmutable().add(element);
                }
            }
        }

        private LinkedHashSet<T> copySyncSetIfExposedAsImmutable() {
            if (this.immutableSet != null) {
                this.immutableSet = null;
                this.synchronizedSet = new LinkedHashSet<T>(this.synchronizedSet);
            }
            return this.synchronizedSet;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void remove(@Nullable T element) {
            Object object = this.lock;
            synchronized (object) {
                this.copySyncSetIfExposedAsImmutable().remove(element);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string2;
            switch (n) {
                default: {
                    string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string2 = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/kotlin/com/intellij/util/pico/DefaultPicoContainer$LinkedHashSetWrapper";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/kotlin/com/intellij/util/pico/DefaultPicoContainer$LinkedHashSetWrapper";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getImmutableSet";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "add";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string3 = String.format(string2, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string3);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string3);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

