/*
 * Decompiled with CFR 0.152.
 */
package jadx.gui.device.debugger;

public class ArtAdapter {
    public static Debugger getAdapter(int androidReleaseVer) {
        if (androidReleaseVer <= 8) {
            return new AndroidOreoAndBelow();
        }
        return new AndroidPieAndAbove();
    }

    public static class AndroidPieAndAbove
    implements Debugger {
        @Override
        public int getRuntimeRegNum(int smaliNum, int regCount, int paramStart) {
            return smaliNum;
        }

        @Override
        public boolean readNullObject() {
            return false;
        }

        @Override
        public String typeForNull() {
            return "zero value";
        }
    }

    public static class AndroidOreoAndBelow
    implements Debugger {
        @Override
        public int getRuntimeRegNum(int smaliNum, int regCount, int paramStart) {
            int localRegCount = regCount - paramStart;
            return (smaliNum + localRegCount) % regCount;
        }

        @Override
        public boolean readNullObject() {
            return true;
        }

        @Override
        public String typeForNull() {
            return "";
        }
    }

    public static interface Debugger {
        public int getRuntimeRegNum(int var1, int var2, int var3);

        public boolean readNullObject();

        public String typeForNull();
    }
}

