/* [config]
 * expect_result: pass
 * glsl_version: 1.50
 * [end config]
 *
 * Check that the following test vectors are constant folded correctly:
 * (12 + ivec2(38, 35)) => ivec2(50, 47)
 * (12 + ivec2(64, -9)) => ivec2(76, 3)
 * (12 + ivec2(64, 9)) => ivec2(76, 21)
 * (-6 + ivec2(38, 35)) => ivec2(32, 29)
 * (-6 + ivec2(64, -9)) => ivec2(58, -15)
 * (-6 + ivec2(64, 9)) => ivec2(58, 3)
 * (76 + ivec2(38, 35)) => ivec2(114, 111)
 * (76 + ivec2(64, -9)) => ivec2(140, 67)
 * (76 + ivec2(64, 9)) => ivec2(140, 85)
 * (-32 + ivec2(38, 35)) => ivec2(6, 3)
 * (-32 + ivec2(64, -9)) => ivec2(32, -41)
 * (-32 + ivec2(64, 9)) => ivec2(32, -23)
 * (0 + ivec2(38, 35)) => ivec2(38, 35)
 * (0 + ivec2(64, -9)) => ivec2(64, -9)
 * (0 + ivec2(64, 9)) => ivec2(64, 9)
 */
#version 150

void main()
{
  float[all(equal((12 + ivec2(38, 35)), ivec2(50, 47))) ? 1 : -1] array0;
  float[all(equal((12 + ivec2(64, -9)), ivec2(76, 3))) ? 1 : -1] array1;
  float[all(equal((12 + ivec2(64, 9)), ivec2(76, 21))) ? 1 : -1] array2;
  float[all(equal((-6 + ivec2(38, 35)), ivec2(32, 29))) ? 1 : -1] array3;
  float[all(equal((-6 + ivec2(64, -9)), ivec2(58, -15))) ? 1 : -1] array4;
  float[all(equal((-6 + ivec2(64, 9)), ivec2(58, 3))) ? 1 : -1] array5;
  float[all(equal((76 + ivec2(38, 35)), ivec2(114, 111))) ? 1 : -1] array6;
  float[all(equal((76 + ivec2(64, -9)), ivec2(140, 67))) ? 1 : -1] array7;
  float[all(equal((76 + ivec2(64, 9)), ivec2(140, 85))) ? 1 : -1] array8;
  float[all(equal((-32 + ivec2(38, 35)), ivec2(6, 3))) ? 1 : -1] array9;
  float[all(equal((-32 + ivec2(64, -9)), ivec2(32, -41))) ? 1 : -1] array10;
  float[all(equal((-32 + ivec2(64, 9)), ivec2(32, -23))) ? 1 : -1] array11;
  float[all(equal((0 + ivec2(38, 35)), ivec2(38, 35))) ? 1 : -1] array12;
  float[all(equal((0 + ivec2(64, -9)), ivec2(64, -9))) ? 1 : -1] array13;
  float[all(equal((0 + ivec2(64, 9)), ivec2(64, 9))) ? 1 : -1] array14;
  gl_Position = vec4(array0.length() + array1.length() + array2.length() + array3.length() + array4.length() + array5.length() + array6.length() + array7.length() + array8.length() + array9.length() + array10.length() + array11.length() + array12.length() + array13.length() + array14.length());
}
